// Glenn's POV-Ray Environments File
// created 20-June-96
// last update 12-Jul-98
// copyright 1996-1998 Glenn McCarter

// This file requires the following files to be included first:
// GConstants.inc
// colors.inc
// GTextures.inc or GTextures31.inc
/*
// using English coordinate system -- basic unit is Inches
#declare Foot = 12
#declare Feet = 12
#declare Mile = 12*5280
#declare Miles = 12*5280
*/
#declare LightFog =
  fog {
    fog_type 1
    distance 180*Feet
    colour rgbt<.72,.64,.91,.2> //transmittance
    turbulence .1
  }

#declare GroundFog =
  fog {
    fog_type 2
    distance 6*Feet
    colour rgbt<.6,.7,.74,.4>
    fog_offset 5
    fog_alt 5
    turbulence .1
  }

#macro CheckTex(Color1,Color2,Scale)
	texture {
		pigment {
			checker
				color Color1
				color Color2
				scale Scale
		}
		finish { ambient .12 specular .8 roughness .012 }
	}
#end
#macro GroundPlaneCheck(Color1,Color2,Scale)
  plane { z, 0
//    texture {
      CheckTex(Color1,Color2,Scale)
//    }
    hollow
  }
#end

#declare GroundPlaneGreen =
  plane { z, 0
    texture {
      pigment { color rgb<.14,.57,.14>}
    }
    hollow
  }
#declare GroundPlaneWhite =
  plane { z, 0
    texture {
      pigment{White}
    }
    hollow
  }
#declare GroundPlaneTan =
  plane { z, 0
    texture {
      pigment{ color rgb<.4,.4,.2>}
    }
    hollow
  }
#declare GroundPlaneWood =
	plane { z, 0
		texture { GWood scale 2 rotate <0,88,0> }
		hollow
	}

#declare BasicRoom =
  box {
		<-8*Feet,-6*Feet,0>,<8*Feet,6*Feet,8*Feet>
		texture {
			pigment { color <1,1,1> }
			finish { ambient .3 phong .6 }
		}
		hollow
	}

#declare BasicGarage =
  box {
		<-16*Feet,-16*Feet,0>,<16*Feet,16*Feet,10*Feet>
		texture {pigment { color White}}
		hollow
	}
