
// Glenn's POV-Ray Object File - Chairs
// created 17-Aug-98
// last update 30-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Chairs.inc" in another .pov file
//
// Objects:
// SChair -- simple version
// MChair -- more complex backrest
// SDinerStool -- simple version
//
// All chairs are centered on XY plane, face -X, and extend upwards into +Z
//
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// For POV-Ray version 3.1+


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

#declare ChairPaint =
	texture {
		pigment { rgb<.80,.67,.54> }
		finish { ambient .2 specular .7 roughness .005 }
	}

#declare ShinyVinyl =
	texture {
		pigment { rgb<.16,.26,.48> }
		normal { bumps .2 scale <1,1,1.4> }
		finish { ambient .06 specular .93 roughness .008 }
	}

#declare SeatCheckTex =
	texture {
		pigment {
			checker
				color rgb<.34,.34,1.0>
				color rgb<.97,.97,1.0>
				scale 1
		}
		finish { ambient .08 specular .9 roughness .005 }
	}

/*
#declare BrightSteel = // table edge
	texture {
		pigment { color rgb<.56,.67,.88> }
		finish { ambient .02 metallic specular .8 roughness .005               } // test
//		finish { ambient .02 metallic specular .8 roughness .005 reflection .5 } // render
	}
*/
/*
#declare BlackLucite =
	texture {
		pigment { color rgb<.097,.096,.093> } // black
		normal {
			average
			normal_map {
				[ 1.0 bumps .1 scale 4 turbulence .08 ] // slight overall waviness
				[ 1.0 bumps .005 scale .04 turbulence .11 ] // tiny irregularities
			}
		}
//		finish { phong .6 phong_size 200               } // test
		finish { phong .6 phong_size 200 reflection .3 } // render
	}
*/

#declare DeepChrome =
	texture {
		pigment { color rgb <0.39, 0.41, 0.43> }
		finish {
			ambient 0.1
			brilliance 6
			diffuse 0.7
			metallic
			specular 0.80
			roughness .01
			reflection 0.6
		}
	}


//===============================================
//             Objects
//===============================================

#declare SBackAssy =
	union {
		box { <-.7,-.7,0>,<.7,.7,25> translate < 0,-8,0> } // left
		box { <-.7,-.7,0>,<.7,.7,25> translate < 0, 8,0> } // right
		box { <-.3,-7.5,0>,<.3,7.5,5> translate <0,0,19.5> } // back
	}
#declare SChair =
	union {
		box { <-8,-8,0>,<8,8,2.5> translate <0,0,15> } // seat
		box { <-.7,-.7,0>,<.7,.7,15> translate < 8, 8,0> } // leg
		box { <-.7,-.7,0>,<.7,.7,15> translate < 8,-8,0> } // leg
		box { <-.7,-.7,0>,<.7,.7,15> translate <-8, 8,0> } // leg
		box { <-.7,-.7,0>,<.7,.7,15> translate <-8,-8,0> } // leg
		object { SBackAssy rotate <0,6,0> translate <8,0,15> }
		texture { ChairPaint }
	}

#declare ScrewBracket =
	union {
		difference { // bracket
			object { RoundedBox(.3) scale <.14,.7,1.7> translate <.07,0,1.7/2-.5> }
			cylinder { <-1,0,0>,<0.15,0,0>,.195 } // screw hole
		} // end difference
		difference { // screwhead
			sphere { <0,0,0>,.175 scale <.3,1,1> }
			box { <-1,-.04,-.12>,<.06,.04,.12> rotate x*28 }
			box { <-1,-.04,-.12>,<.06,.04,.12> rotate x*28+90 }
			translate <.08,0,0>
		} // end difference
		texture { DeepChrome }
	}


#declare MBackAssy =
	union {
		object { RoundedBox(.25) scale <.6,17,5> translate <-.3,0,22> texture { ShinyVinyl } } // back
		difference { // left curve
			torus { 2.7,.4 rotate <0,0,90> translate <.43,2.3,20> }
			box { <-1,-6,-4>,<1,6,0> translate <.43,0,20> } // cutoff bottom
			box { <-1,0,-4>,<1,-6,4> translate <.43,2.3,20> } // cutoff right
		} // end difference
		difference { // right curve
			torus { 2.7,.4 rotate <0,0,90> translate <.43,-2.3,20> }
			box { <-1,-6,-4>,<1,6,0> translate <.43,0,20> } // cutoff bottom
			box { <-1, 6,-4>,<1,0,4> translate <.43,-2.3,20> } // cutoff right
		} // end difference
		cylinder { <0,-2.3,0>,<0,2.3,0>,.4 translate <.43,0,20+2.7> } // top bar
		cylinder { <0,0,0>,<0,0,20>,.4 translate <.43,-5,0> } // left inner
		cylinder { <0,0,0>,<0,0,20>,.4 translate <.43, 5,0> } // right inner
		cylinder { <0,0,0>,<0,0,26.5>,.4 translate <.43,-5.8,-3> } // left outer
		sphere { <0,0,0>,.4 scale <1,1,.6> translate <.43,-5.8,23.5> } // left outer
		cylinder { <0,0,0>,<0,0,26.5>,.4 translate <.43,5.8,-3> } // right outer
		sphere { <0,0,0>,.4 scale <1,1,.6> translate <.43,5.8,23.5> } // right outer
//		box { <-.7,-.7,0>,<.7,.7,25> translate < 0,-8,0> } // left
//		box { <-.7,-.7,0>,<.7,.7,25> translate < 0, 8,0> } // right
		object { ScrewBracket rotate z*180 translate <.13,-2.3,21.6> } // left top
		object { ScrewBracket rotate z*180 translate <.13, 2.3,21.6> } // right top
		texture { DeepChrome }
	}
#declare MChair =
	union {
		box { <-8,-8,0>,<8,8,2.5> translate <0,0,15> } // seat
		box { <-.7,-.7,0>,<.7,.7,15> translate < 8, 8,0> } // leg
		box { <-.7,-.7,0>,<.7,.7,15> translate < 8,-8,0> } // leg
		box { <-.7,-.7,0>,<.7,.7,15> translate <-8, 8,0> } // leg
		box { <-.7,-.7,0>,<.7,.7,15> translate <-8,-8,0> } // leg
		object { MBackAssy rotate <0,6,0> translate <8,0,15> }
		texture { ChairPaint }
	}

#declare SDinerStool =
	union {
		cylinder { // main pedestal
			<0,0,0>,<0,0,30>,2.2
			texture { DeepChrome }
		}
		cylinder { // base
			<0,0,0>,<0,0,1.6>,9
			texture { BlackPaint }
		}
		cylinder { // seat
			<0,0,0>,<0,0,3>,7.6
			translate <0,0,30>
			texture { SeatCheckTex }
		}
		box { // back support
			<0.2,-2,0>,<.6,2,12>
			translate <8,0,30>
			texture { DeepChrome }
		}
		box { // back
			<0,-5,0>,<1,5,5>
			translate <8,0,40>
			texture { SeatCheckTex }
		}
	}


