
// Glenn's POV-Ray Object File - Cafe
// created 17-Aug-98
// last update 26-Aug-98
// copyright 1998 Glenn McCarter
// This file does not render.  #include "Cafe.inc" in another .pov file
//
// Objects:
// SRoom - simple version
// Room - detailed west wall
//
// Associated files: "CafeObjects.inc"
// Intended scale is English system (inches)
// Uses RH coordinate reference system (Z=up)
// The north wall is in +X direction
// For POV-Ray version 3.1+


//===============================================
//             Variables
//===============================================



//===============================================
//             Textures
//===============================================

/*
#declare WallTex =
	texture {
		pigment { color rgb<1,1,1> }
		normal { bumps .2 scale .3 }
		finish { ambient .4 specular .3 roughness .005 }
	}
*/
#declare WallTex =
	texture {
		pigment {
			gradient z
			color_map {
				[ 0.0 rgb<.13,.13,.13> ]
				[ 0.18 rgb<.13,.13,.13> ] // grey-out the bottom
				[ 0.28 rgb<1,1,1> ]
			}
			scale <1,1,10*Feet>
//			translate <0,0,-4*Feet>
		}
		normal { bumps .2 scale .3 }
		finish { ambient .4 specular .3 roughness .005 }
	}

#declare FloorTex =
	texture {
		pigment {
			checker color rgb<0,0,0> color rgb<1,1,1>
			scale 1*Feet
			rotate z*45
		}
		finish { ambient .2 specular .5 roughness .005 }
	}
#declare CeilingTex =
	texture {
		pigment { color rgb<1,1,1> }
		normal { bumps .2 scale .3 }
		finish { ambient .65 specular .2 roughness .005 }
	}
#declare WindowFrameTex =
	texture {
		pigment { color rgb<.55,.48,.44> }
//		normal { crackle .2 scale .3 }
		finish { ambient .15 specular .6 roughness .005 }
	}


//===============================================
//             Objects
//===============================================

//--------------- Windows -----------------------

#macro RoundWood(X,Y,Z,CornerRadius) // like a 2x4 lumber in +X
	#local CR = CornerRadius;
	union {
		box {	<0,0,CR>,<X,Y,Z-CR> }
		box {	<0,CR,0>,<X,Y-CR,Z> }
		cylinder { <0,CR,CR>,<X,CR,CR>,CR }
		cylinder { <0,CR,Z-CR>,<X,CR,Z-CR>,CR }
		cylinder { <0,Y-CR,CR>,<X,Y-CR,CR>,CR }
		cylinder { <0,Y-CR,Z-CR>,<X,Y-CR,Z-CR>,CR }
	}
#end

#macro Window(XLength,YFrameWidth,ZHeight,Quality)
	union {
		difference {
			union { // frame
				object { RoundWood(XLength,YFrameWidth,.85,.2) }
				object { RoundWood(XLength,YFrameWidth,.85,.2) translate <0,0,ZHeight> }
				object { RoundWood(ZHeight,YFrameWidth,.85,.2) rotate y*-90 }
				object { RoundWood(ZHeight,YFrameWidth,.85,.2) rotate y*-90 translate <XLength,0,0> }
				texture { WindowFrameTex }
			} // end union
			box { // glass cutout
				<0.5,-0.14,0.5>,<XLength-.5,0.14,ZHeight-.5>
				translate <0,YFrameWidth/2,0>
				texture { WindowFrameTex }
			}
		} // end difference
		box { // glass
			<0.5,-0.1,0.5>,<XLength-.5,0.1,ZHeight-.5>
			translate <0,YFrameWidth/2,0>
			texture { pigment { color rgbt<1,1,1,0.97> } finish { reflection Quality*.3 } }
		}
	}
#end


//--------------- Walls -------------------------

#declare SRoom = // simple version
	difference {
		box { // main outer walls
			<-14*Feet,-14*Feet,-8>,<14*Feet,14*Feet,10*Feet>
		}
		box { // inner space
			<-13.5*Feet,-13.5*Feet,-8>,<13.5*Feet,13.5*Feet,9*Feet>
		}
		box { // window opening
			<-3*Feet,10*Feet,37>,<3*Feet,20*Feet,7*Feet>
		}
		texture { WhitePaint }
	}

#declare NorthWall =
	box {
		<13.5*Feet,-14*Feet,-8>,<14*Feet,14*Feet,10*Feet>
		texture { WallTex }
	}
#declare SouthWall =
	box {
		<-13.5*Feet,-14*Feet,-8>,<-14*Feet,14*Feet,10*Feet>
		texture { WallTex }
	}
#declare EastWall =
	box {
		<-14*Feet,-13.5*Feet,-8>,<-14*Feet,-14*Feet,10*Feet>
		texture { WallTex }
	}
#declare WestWall =
	union {
		difference {
			box {
				<-14*Feet,13.5*Feet,-8>,<14*Feet,14*Feet,10*Feet>
			}
			box { // main window opening
				<-3*Feet,12*Feet,36>,<3*Feet,16*Feet,7*Feet>
			}
			box { // far window opening
				<-3*Feet,12*Feet,36>,<3*Feet,16*Feet,7*Feet>
				translate <6.5*Feet,0,0>
			}
		} // end difference
		object { Window(6*Feet,.6*Feet,7*Feet-36,0) translate <-3*Feet,13.4*Feet,36> }
		object { Window(6*Feet,.6*Feet,7*Feet-36,0) translate <3.5*Feet,13.4*Feet,36> }
		object { WindowLettering translate <7*Feet,13.7*Feet,56> }
		box { // floor molding
			<-14*Feet,13.4*Feet,-8>,<14*Feet,13.6*Feet,10>
		}
		cylinder { // floor molding top
			<-14*Feet,13.5*Feet,10>,<14*Feet,13.5*Feet,10>,.1*Feet
		}
		texture { WallTex }
	}
#declare Floor =
	box {
		<-14*Feet,-14*Feet,-8>,<14*Feet,14*Feet,0>
		texture { FloorTex }
	}
#declare Ceiling =
	box {
		<-14*Feet,-14*Feet,9.5*Feet>,<14*Feet,14*Feet,10*Feet>
		texture { CeilingTex }
	}


#macro Cafe(Quality) // Quality = 0 (simple) or 1 (complex west wall)
	#switch(Quality)
	#case (0)
		object { SRoom }
	#break
	#case (1)
		union {
			object { NorthWall }
			object { SouthWall }
			object { EastWall }
			object { WestWall }
			object { Floor }
			object { Ceiling }
		}
	#break
	#end
#end

