//
//    EMAIL: castlewrks@aol.com
//    NAME: Robert J Becraft
//    TOPIC:  Nature
//    COPYRIGHT: I SUBMIT TO THE STANDARD RAYTRACING COMPETITION COPYRIGHT.
//    TITLE: "The Garden"
//    COUNTRY: USA
//    WEBPAGE: http://www.geocities.com/siliconvalley/labs/6080
//    RENDERER USED:  Povray for DOS 3.01 running under OS/2
//    TOOLS USED: Povray (image creation), I_view32 (TGA>JPG conversion), PaintShop Pro (add copyright)
//    RENDER TIME: 5 hours, 48 meg
//    HARDWARE USED: Pentium 233
//    IMAGE DESCRIPTION:
//    
//  This picture is composed of several elements that are intended to represent the theme of "Nature". 
//
//  Comp 1:   Nature: the 4 elements of Air, Water, Fire and Earth.  Nature is further presented through the panels
//                     of pictures representing elements of nature on Earth.
//  Comp 2:   Man, man is represented by the blueprint of Leonardo's Vitruvian man in the background, manna or
//                     corn in the center and Earth rotated to the African/Euphrate's region thought to be the site of
//                     man's origins on Earth.  Man is represented by a blue-print because his origins came well after
//                     the elements and the rules by which those elements interacted... in representing the base elements,
//                     man is an image of what is to come.
//  Comp 3:   Earth and man become a central element in the garden of planets in our solar system.  Earth is 
//                     surrounded by the elements of nature that blended together make it a unique place in our solar 
//                     system.  The other three places represented are our moon, Mars and Jupiter... all of which hang
//                     desolate and unaccompanied in the bottomless sky behind the main display.
//  Comp 4:   The edge of the world... as in Columbus's time, the edge of the world was thought to end in a
//                      precipace off which ships could sail and never return.  The precipace is represented in this picture
//                      as the edge of man's world, but also as a reference back to that time when the age of discovery
//                      brought man ever closer to understanding the Earth and world upon which we depend for life.
//                      So while man in Comp 2 is represented as a blue-print, not yet here, his perception of the world in
//                      an age gone recently by is also represented without the precipitious drop into infinity and oblivion,
//                      but instead as a sweeping gallery of images of the real world as it exists today.  Revelation and
//                      discovery, man's never ending quest to understand the world and universe in which we live.
//  Comp 5:   Heart-beat, the ripples in the water  are like the pattern of a heart beating.  All higher life on Earth
//                      have some kind of heart-beat that is necessary for them to be alive.
//
//  This image would not be complete without a discussion of the animation of the objects in the image.
//  
//                 - The flames would be leaping (of course)
//                 -  All of the planets would be spinning, slowly, very elegantly
//                 -  The image of vitrovian man would be tumbling slowly.
//                 -  The images on the panels would rotate from one panel to the next around the panels.
//                 -  The ripples on the water would slowly move outwards from the center point, new ripples would start
//                 -  The clouds would move lazily by.
//                 -  The sun would move around giving the image morning, noon, evening and darkness... a note about
//                    darkness, all the panels are lit with spot-lights.
//                 -  The earth and its platform and the Fire cauldron would gently bounce up and down creating the
//                     ripples on the water, and the heartbeat of life in the image. 
//
//    DESCRIPTION OF HOW THIS IMAGE WAS CREATED:
//    This image was created using straight POVRAY primatives with image maps (gifs) applied to the spheres
//    and panels.   A heightfield was used to create the earth under the earth globe.  There are also heightfields at
//    the base of the first few corn-stalks.  Only the ones in view were given lumps as the memory required to put
//    them on all of the bases was exhorbinant and it wouldn't render.
//     
//    Switches are available in the source to turn on and off features of the render.  The source is divided into 
//    three areas, 1st is the control area with the switches, lights and camera postition.  2nd is the CSG objects and 
//    3rd is the actual objects.  Note that the switch to turn off an object is reflected in the CSG section as well as the
//    object section.  Rendering with alot of CSG objects that are never used as in the cornfield object can extend the
//    overall parse time of the entire image.  By cutting out the parsing of sections that aren't used as well as the
//    objects, some sections of the render can be viewed very quickly.
//    
//    In addition, the global settings below were found to be necessary to eliminate shadows in the flames that
//   created cone shaped black objects.

 global_settings {
                                    max_trace_level 12          // default POV setting is 5
                                    max_intersections 256    // default POV setting is 64... istack_overflows not= 0 increase
                                  }

#include "colors.inc"    // The include files contain
#include "textures.inc"
#include "glass.inc"
#include "finish.inc"
#include "stones1.inc"
//#include "flames.inc"

//----------------- Turn off features switches
//#declare nomoon=yes //uncomment to turn off moon
//#declare nopictures=yes // uncomment to turn off picture gallery
//#declare norocks=yes //uncomment to turn off rocks
//#declare nogarden=yes //uncomment to turn off corn-stalk garden
//#declare noflames=yes // uncomment to turn off flames

//------------------ Select Detail levels
#declare skytext=2        //1=clouds for blue sky, white clouds; 2=second sky type
#declare Waterbase=2      //1= plain of water 2=cylinder pool w/ columns
#declare halocloud=1      // disable second halo cloud

camera {
    location <0,15,-60> look_at <0,0,0>
}

light_source{<1500,10000,-20000> color White}  // BIG light

// itty bitty lights.
//light_source{<15,15,15> color Orange/5}  // Flames light

//light_source{<0,55,120> color White  spotlight radius 8 falloff 70 tightness 6 point_at <-35,25,150>}  // vitrovian
//light_source{<-20,30,-60> color White  spotlight radius 8 falloff 30 tightness 4 point_at <-15,15,-15>}  // earth light

//light_source{<0,20,-35> color White  spotlight radius 3 falloff 40 tightness 6 point_at <0,0,-39>}  // corn
//light_source{<5,20,35> color Red  spotlight radius 3 falloff 40 tightness 6 point_at <5,0,35>}  // corn
//light_source{<-5,20,0> color Blue  spotlight radius 3 falloff 40 tightness 6 point_at <-5,0,0>}  // corn

//light_source{<100,250,-150> color White  spotlight radius 12 falloff 100000 tightness 25 point_at <33000,7500,60000>}    // planets


#ifndef(nopictures)  // turn on only if pictures are included
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,-45,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,-15,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,-5,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,5,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,15,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,25,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,35,0>}
light_source{<0,15,90> color White  spotlight radius 12 falloff 70 tightness 20 point_at <0,10,100> rotate<0,45,0>}
#end
//------------------------------------------------------------------------
// BACKGROUND
#if (skytext=1)
   sky_sphere {pigment {wrinkles
      color_map {[.4 rgb <0, .4, .8>] [.9 rgb <.8, .8, .8>]}
      scale <.06,.1,.06>
//      scale <.13, .1, .13>
      translate x * 45}}

#else
#if (skytext=2)
/*******************************
 * THE SKY
 *******************************/
#declare SkyBlue = rgb <0.15, 0.4, 0.7>
#declare P_Clouds =
pigment {
  wrinkles
  turbulence 0.1
  lambda 2.2
  omega 0.707
  color_map {
    [0.60 SkyBlue ]
    [0.80 White ]
    [1.00 Gray90 ]
  }
  scale <0.5, 0.15, 1>
  rotate  z*180
  rotate  y*60
}
sky_sphere {
  pigment {
    gradient y
    pigment_map {
      [0.00 rgb <0.847, 0.749, 0.847> ] // horizon
      [0.05 SkyBlue ]                   // horizon
      [0.15 P_Clouds ]
      [1.00 SkyBlue ]
    }
  }
}

/*******************************
 * THE HALO CLOUDS
 *******************************/
#if(halocloud=1)
// -----------------
// The distant cloud
// -----------------
sphere { 0, 1.5
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1,  1> ]
      [ 1 color rgbt <1, 1, 1, 0.5> ]
    }
    samples 5
    scale <0.75, 0.5, 1>
    translate <-0.4, 0, 0>
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1,  1> ]
      [ 1 color rgbt <1, 1, 1, 0.5> ]
    }
    samples 5
    scale <0.75, 0.5, 1>
    translate <0.4, 0, 0>
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1,  1> ]
      [ 1 color rgbt <1, 1, 1, -1.0> ]
    }
    samples 5
    scale 0.5
    translate <0, 0.2, 0>
  }
  hollow
  scale <130, 100, 50>
  rotate -z*30
  translate <50, 100, 90>
}
#end // halocloud

// --------------------
// The foreground cloud
// --------------------
sphere { 0, 1.5
  pigment { color rgbt <1, 1, 1, 1> }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1,  1> ]
      [ 1 color rgbt <1, 1, 1, 0.5> ]
    }
    samples 5
    scale <0.75, 0.5, 1>
    translate <-0.4, 0, 0>
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1,  1> ]
      [ 1 color rgbt <1, 1, 1, 0.5> ]
    }
    samples 5
    scale <0.75, 0.5, 1>
    translate <0.4, 0, 0>
  }
  halo {
    attenuating
    spherical_mapping
    linear
    turbulence 1
    color_map {
      [ 0 color rgbt <1, 1, 1,  1> ]
      [ 1 color rgbt <1, 1, 1, -1.0> ]
    }
    samples 5
    scale 0.5
    translate <0, -0.2, 0>
  }
  hollow
  scale 1.5*<150, 100, 50>
  rotate z*150
  translate <-100, 130, 200>
}
#end
#end

#declare GroundC =
  texture {
  pigment { granite
  color_map {
    [0.5 color Clear]
    [0.6 color MediumForestGreen]
    [0.9 color DarkGreen]
    [1.0 color Green]  } }
  normal { bumps 0.5 }
  scale <.01,.01,.01>
  }
#declare Corn =
  texture {
  pigment {  wrinkles        // granite
  color_map {
    [0.05 color Yellow]
    [0.4 color DarkGreen]
    [0.45 color Green]
    [1.0 color MediumForestGreen]  } }
  normal { bumps 0.8 }
  scale <.05,.05,.05>
  }
#declare White_Brick=texture{
               pigment{brick Grey, White brick_size <1,.5,.5>    mortar 0.075}
}
#declare Red_Brick=texture{
               pigment{brick Grey, Tan brick_size <1,.5,.5>    mortar 0.075}
}
#declare White_Block=texture{
               pigment{brick Grey, White brick_size <2,1,1>    mortar 0.1}
}
#declare Trim_Stone=texture{T_Stone5}
#declare Roof_Text=texture{pigment{color OrangeRed}}   //MediumSlateBlue}}
#declare Deck_Tile=texture{checker texture{pigment{color Wheat}}
                                   texture{pigment{color White}}
                                   scale 2 rotate <0,45,0>
                         }
#declare Glass_Text=texture{checker texture{T_Ruby_Glass}
                                    texture{T_Green_Glass}
                                    scale 1 rotate <45,45,45>
                           }

#declare CornTops =
  texture {
  pigment { granite
  color_map {
    [0.5 color Clear]
    [0.6 color Tan]
    [0.9 color Wheat]
    [1.0 color Yellow]  } }
  normal { bumps 0.5 }
  scale <.01,.01,.01>
  }

#declare WaterText=texture {
                  pigment { color rgb< 0.0, 0.1, 0.2 > }
                  normal { bumps 0.2  scale < 1, 0.5, 0.5 > }
                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 }

#if (Waterbase=1)
//**************************
// Water Plain
  plane {
               < 0,.8,0 >, 0
                texture {WaterText
//                  pigment { color rgb< 0.0, 0.1, 0.2 > }
//                  normal { bumps 0.2  scale < 1, 0.5, 0.5 > }
//                  finish { phong 1  reflection 0.5  ambient 0.1  diffuse 0.2 }
                 }
               translate < 0, 0.2 , 0 >
  }
#else
#if (Waterbase=2)

//----------------------------------------- POOL Water objects
#declare TheEdge=difference{
  cylinder{<0,-.1,0><0,1,0> 110 texture{Red_Brick}}
  cylinder{<0,-.11,0><0,01.1,0> 100 texture{Red_Brick}}
}

#declare TheColumns=union{
    #declare Count=0
    #while (Count<360)
      cylinder{<0,14.5,-105><0,15,-105> 1.3 rotate<0,Count,0> texture{T_Stone5}}
      cylinder{<0,0,-105><0,15,-105> 1 rotate<0,Count,0> texture{T_Stone5}}
      cylinder{<0,0,-105><0,.8,-105> 1.3 rotate<0,Count,0> texture{T_Stone5}}
      cylinder{<0,0,-105><0,.7,-105> 1.4 rotate<0,Count,0> texture{T_Stone6}}
      #declare Count=Count+10
    #end
}
#declare TheRailing=union{
     torus{109.9,.08 translate<0,17,0> texture{Bright_Bronze}}
     torus{109.9,.08 translate<0,18,0> texture{Bright_Bronze}}
     torus{100.1,.08 translate<0,17,0> texture{Bright_Bronze}}
     torus{100.1,.08 translate<0,18,0> texture{Bright_Bronze}}
    #declare Count=0
    #while (Count<360)
      cylinder{<0,16,100.1> <0,18,100.1>,.08 rotate<0,Count,0> texture{Bright_Bronze}}
      cylinder{<0,16,109.9><0,18,109.9>,.08 rotate<0,Count,0> texture{Bright_Bronze}}
      #declare Count=Count+5
    #end
}

#declare ThePool=union{
  object{TheEdge translate<0,-1,0>}
  object{TheColumns}
  object{TheRailing}
  object{TheEdge translate<0,15,0>}
  cylinder{<0,-.1,0><0,0,0> 100 texture{WaterText}}
}

object{ThePool translate<0,.2,0>}
#end // if
#end // else

// TEMP
//     box{<-40,0,-4><40,.1,4> texture{pigment{color Tan}}finish{crand .1} rotate<0,90,0>  translate<0,3,10>}
//     box{<-40,-.5,-4><40,0,4> texture{Bright_Bronze} rotate<0,90,0>  translate<0,3,10>}

//---------------------------------------------------- GARDEN Objects
#ifndef(nogarden)
//---------defs for garden -------------
#declare S1=seed(123)
#declare Garden1=union{
     box{<-40,0,-4><40,.1,4> texture{pigment{color Tan}}finish{crand .4}}  // dirt
     box{<-41.8,-.5,-5.8><41.8,0,5.8> texture{Bright_Bronze}}      // base
     box{<-41.9,-.2,-5.9><41.9,-.05,5.9> texture{Bright_Bronze}}   // edge
     #declare County=-3
     #while (County<=3)
       #declare Countx=-38
       #while (Countx<36)
           #declare RD=rand(S1)*.2-.1       // Offset in Row
           #declare SH=rand(S1)*3+3        // Stem height

           cone{<Countx,0,County+RD>,.04<Countx,SH,County+RD>,.02  texture{Corn}}
          
           #if(Countx<-33)
                object {
                     height_field { gif  "rock.ghf" }
                     texture { pigment { color Tan } finish{crand .4}  }
                     scale <1, .3, .4 > translate<Countx-.5,0,County-.2>
                 }
            #end

           #if (SH>5)
                 cone{<Countx,SH,County+RD>,.06 <Countx,SH+.5,County+RD>,.03 texture{CornTops}}
           #end
           #declare LC=rand(S1)*8+8        // Leaf Count
           #declare LCount=1
           #while (LCount <=LC)
               #declare BH=rand(S1)*1.2     // Blade Height
               #declare BW=rand(S1)*1+.5  // Blade Width
               #declare BO=rand(S1)*SH    // Blade Origin on Stem
               #declare BR=rand(S1)*360   // Rotate Blade around stem
               triangle{<0,BO,0>
                               <-.1+(BW/2),BH+BO,BW/2><BW/2+.2,BH+BO,(BW/2)>
                         rotate<0,BR,0> translate<Countx,0,County+RD>
                         texture{Corn}}
               triangle{<-.1+(BW/2),BH+BO,(BW/2)><(BW/2)+.2,BH+BO,(BW/2)>
                               <BW,BO+(BH/2),BW>
                          rotate<0,BR,0> translate<Countx,0,County+RD>
                          texture{Corn}}
               #declare LCount=LCount+1
           #end  // while
           #declare Countx=Countx+(rand(S1)*1.5)
        #end // while
       #declare County=County+2
     #end //while
}
#end


//------------------------------------------ FIRE Objects
#ifndef(noflames)
#declare Flame1=cone{<0,0,0> 1.2 <0,2,0> .2
  pigment{color Clear}
//  Flame_D3
   halo {
      linear
      max_value 1.0
      planar_mapping
      emitting
      turbulence 0.3
      colour_map {
         [0.00 color rgbt <0.8,0.8,0.0,0.9>]
         [0.30 color rgbt <0.8,0.8,0.0,0.7>]
         [0.50 color rgbt <0.8,0.8,0.8,0.5>]
         [0.60 color rgbt <1.0 1.0,0.0,0.3>]
         [0.80 color rgbt <1.0,0.5,0.0,0.3>]
         [0.89 color rgbt <1.0,0.8,0.6,0.2>]
         [0.90 color rgbt <1.0,1.0,0.3,1.0>]
         [0.92 color rgbt <1.0,1.0,0.0,1.0>]
         [1.00 color rgbt <1.0,1.0,0.0,-2.0>]
      }
      samples 20
   }
//-----------------------
//  halo  {
//    attenuating
//    spherical_mapping
//    linear
//    max_value 1
//    turbulence<.5,1.5,.7>
//    colour_map{
//      [0 rgbt<1,1,1,1>]
//      [.7 rgbt<1,.4,.3,0>]
//      [1 rgbt<1,1,1,0>]
//     } // color_map
//   }  // halo
  hollow
 }

#declare Flame2=cone{ <0,0,0> 1.2 <0,2,0> .2
  pigment{color Clear}
//  Flame_D2
   halo {
      linear
      max_value 1.0
      planar_mapping
      emitting
      turbulence 0.2
      colour_map {
         [0.00 color rgbt <0.8,0.8,0.0,0.9>]
         [0.30 color rgbt <0.8,0.8,0.0,0.7>]
         [0.50 color rgbt <0.8,0.8,0.8,0.5>]
         [0.60 color rgbt <1.0 1.0,0.0,0.3>]
         [0.80 color rgbt <1.0,0.5,0.0,0.3>]
         [0.89 color rgbt <1.0,0.8,0.6,0.2>]
         [0.90 color rgbt <1.0,1.0,0.3,1.0>]
         [0.92 color rgbt <1.0,1.0,0.0,1.0>]
         [1.00 color rgbt <1.0,1.0,0.0,-2.0>]
      }
      samples 20
   }
//----------------------------------
//  halo{
//    attenuating
//    spherical_mapping
//    linear
//    max_value 1
//    turbulence<.5,1.5,.7>
//    colour_map{
//      [0 rgbt<1,1,1,1>]
//      [.7 rgbt<.1,.5,1,0>]
//      [1 rgbt<1,1,1,0>]
//     }  // color_map
//   } // halo
  hollow
 }

#declare Smoke1=cone
 {
  <0,0,0> 1.2  <0,2,0> .2
  pigment{color Clear}
  halo
   {
    attenuating
    spherical_mapping
    linear
    max_value 1
    turbulence<.5,2.5,.7>
    colour_map
     {
      [0 rgbt<1,1,1,1>]
      [.7 rgbt<1,1,1,0>]
      [1 rgbt<1,1,1,0>]
     }
   }
  hollow
 }

#declare Bowl=difference{
    union{
      sphere{<0,0,0>,6 texture{Bright_Bronze}}
      cylinder{<0,-.2,0><0,0,0>,6.2 texture{Bright_Bronze}}
   }
   sphere{<0,0,0>,5.8 texture{Bright_Bronze}}
   box{<-6.1,0,-6.1><6.1,6.1,6.1> texture{Bright_Bronze}}
   cylinder{<0,-5,0><0,-4.5,0>,6 texture{Bright_Bronze}}
   cylinder{<0,-4,0><0,-3.5,0>,6 texture{Bright_Bronze}}
   #declare Count=0
   #while (Count<360)
       sphere{<0,-2,-6>,1 texture{Bright_Bronze} rotate<0,Count,0>}
       #declare Count=Count+30
   #end
}

#declare Flames=union{
object{Flame1 scale <2,8,2> rotate<0,-45,0> translate<0,1,0>}
object{Flame1 scale <2,5,2> translate<3,0,3>}
object{Flame1 scale <2,8,2> translate<-3,0,3>}
object{Flame1 scale <2,8.5,2> translate<-2.5,0,-3>}
object{Flame1 scale <2,6.5,2> translate<2,0,-3>}

object{Flame2 scale <.75,3,.75> translate<0,1,0>}
object{Flame2 scale<.75,3,.75> translate<-2.8,0,-3>}
object{Flame2 scale<.75,3,.75> translate<2.2,0,-3>}

object{Smoke1 rotate<0,-45,0> scale<3,20,3> translate<1,0,1>}  // try for smoke
}

#end

//--------------------------------------------------- EARTH Objects
#ifndef(norocks)
#declare GroundC =
  texture {
   pigment { granite
   color_map {
     [0.1 color Clear]
     [0.5 color Clear]
     [0.7 color MediumForestGreen]
     [0.9 color DarkGreen] } }
   normal { bumps 0.3 }
   scale <.01,.01,.01>
 }

#declare  RockPlate=union{
     cylinder{<0,0,0><0,.5,0>,6 texture{Bright_Bronze}}
     cylinder{<0,.2,0><0,.3,0>,6.2 texture{pigment{color Gold}}}  // band
     cylinder{<0,-.5,0><0,0,0>,5 texture{Bright_Bronze}}
     cylinder{<0,-1,0><0,-.5,0>,4 texture{Bright_Bronze}}
     cylinder{<0,-2,0><0,-1,0>,3 texture{Bright_Bronze}}
}

#declare Rocks=difference{
   union{
      object {
                height_field { gif  "rock.ghf" }
                texture { pigment { color Gray40 }  }
                 scale < 12, 3, 12 > translate<-8,0,-4>
        }
     object {
                height_field { gif  "rock.ghf" }
                texture {GroundC }
                 scale < 12, 3.2,12 >  translate<-8,0,-4>
        }
    } // union
    box{<-14,-1,-14><14,0.1,14>}
} // Rocks

#declare Earth = object { union {
   object { sphere { 0,1 texture {
      pigment { image_map { gif "Earth.gif" map_type 1 } }
      finish { ambient .001 diffuse .998 }
       }
      texture { pigment { bozo colour_map {
         [ .9 color rgbf 1 ]
         [ 1  color rgb 1 ] }
         turbulence 1 octaves 20 omega .7 scale <.5,.2,.5> }
         finish { ambient .000002 diffuse .999998 } rotate 220*y }
      texture { pigment { bozo colour_map {
         [ .8 colour rgbf 1 ]
         [ .95 colour rgb 1 ] }
         turbulence 1.0 scale <.7, .2, .7> }
      finish { ambient .000002 diffuse .999998 } rotate 220*y }
} }
} }


#declare Rocks=union{
      object{RockPlate}
      object{Rocks}
      object{Earth scale 6 rotate<0,-50,0> translate<0,10,0>}
//      sphere{<0,0,0>,4 texture{pigment{color Blue}} translate<0,8,0>}
}

#end

#declare Ripple1=torus{5,.5}

#declare Ripples=union{
  object{Ripple1 texture{WaterText} translate<0,-.1,0>}
  object{Ripple1 scale<1.8,1,1.8> texture{WaterText} translate<0,-.1,0>}
  object{Ripple1 scale<2.8,1,2.8> texture{WaterText} translate<0,-.2,0>}
  object{Ripple1 scale<5,1,7> texture{WaterText} translate<0,-.25,0>}
}

//----------------------------------------- Moon object def
#ifndef(nomoon)
#declare moon = object { union {
   object { sphere { 0,1 texture {
      pigment { image_map { gif "moon.gif" map_type 1 } }
      finish { ambient .001 diffuse .998 }
       }
} }
} }

#declare mars = object { union {
   object { sphere { 0,1 texture {
      pigment { image_map { gif "mars.gif" map_type 1 } }
      finish { ambient .001 diffuse .998 }
       }
} }
} }

#declare jupiter = object { union {
   object { sphere { 0,1 texture {
      pigment { image_map { gif "jupiter.gif" map_type 1 } }
      finish { ambient .001 diffuse .998 }
       }
} }
} }

#end

//----------------------------------------- Picture Gallery
#ifndef(nopictures)
// control all picture sizes here
#declare Px=13
#declare Py=13

#declare P1 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "daisy_1.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P2 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "RM_1.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P3 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "RM_2.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P4 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "RM_3.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P5 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "RM_4.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P6 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "RM_5.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P7 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "orion.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P8 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "trifid.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare P9 = object {
    box {<0,0,-.1><1,1,.1>
      texture {
        pigment { image_map { gif "kahanstt.gif" map_type 0 } }
      }
      scale <Px,Py,1>
    } // box
} // object

#declare ManPic = object {
    box {<0,0,-.0001><1,1,.0001>
      texture {
        pigment { image_map { gif "v2n.gif" map_type 0
         // filter 1, 1.0
         // filter 2, 1.0
         // filter 3, 1.0
         // filter 4, 1.0
         // filter 5, 1.0
         // filter 6, 1.0
         // filter 7, 1.0
         // filter 8, 1.0
         // filter 9, 1.0
         // filter 10, 1.0
         // filter 11, 1.0
         // filter 12, 1.0
         // filter 13, 1.0
         // filter 14, 1.0
         // filter 15, 1.0
         // filter 16, 1.0
          } }
      }
      scale <20,25,1>
    } // box
} // object

#end // nopictures
//---------------------------------------OBJECTS

#ifndef(nogarden)
  object{Garden1 rotate<0,-90,0> translate<0,3,0>}
#end

// box{<0,0,.2><1,1,.21>
//     texture{pigment{image_map{gif "self.gif" map_type 0}}}
//     rotate<90,0,0>
//     rotate<0,30,0>
//     scale<5,1,5>
//     translate<0,0,-35>}     // sheet under water, front edge

#ifndef(noflames)
  object{Bowl      translate<15,8,-15>}
  object{Flames translate<15,7,-15>}
  object{Ripples translate<15,0,-15>}
#end

#ifndef(norocks)
  object{Rocks translate<-15,5,-15>}
  object{Ripples translate<-15,0,-15>}
#end

#ifndef(nomoon)
object { moon scale <2000,2000,2000> rotate -90*y rotate -18*x rotate 0*z translate<33000,7500,60000>}
object { mars  scale <2000,2000,2000>  translate<25000, 5500, 75000>}
object { jupiter rotate<0,0,10> scale<3000,3000,3000>  translate<23000, 11500, 100000>}
#end

#ifndef(nopictures)
 object{P1 translate<3,1.5,103>}
 object{P2 translate<3,1.5,103> rotate<0,40,0>}
 object{P3 translate<3,1.5,103> rotate<0,-10,0>}
 object{P4 translate<3,1.5,103> rotate<0,-20,0>}
 object{P5 translate<3,1.5,103> rotate<0,-30,0>}
 object{P6 translate<3,1.5,103> rotate<0,-50,0>}
 object{P7 translate<3,1.5,103> rotate<0,30,0>}
 object{P8 translate<3,1.5,103> rotate<0,10,0>}
 object{P9 translate<3,1.5,103> rotate<0,20,0>}

// objects exist to provide small slivers in final render.

 object{P9 translate<3,1.5,103> rotate<0,60,0>}
 object{P9 translate<3,1.5,103> rotate<0,-30,0>}
 object{P9 translate<3,1.5,103> rotate<0,-40,0>}
 object{P9 translate<3,1.5,103> rotate<0,-60,0>}
 
 object{ManPic rotate<35,0,0> rotate<0,15,0> translate<-37.5,25,150>}
#end

//*END
