// ----------------------------------------------------------------
//
// Author: Mauro Pierluigi (pm@usa.net)
//
// Feel free to use any object in this file for
// non commercial purpose, otherwise you may ask for permission,
// and in any case I would appreciate a mention of the author.
//
// ----------------------------------------------------------------



#include "colors.inc"
#include "textures.inc"
#include "golds.inc"
#include "benediti.map"
#include "pinkmarb.map"

camera {
  location <0, -5, -40>
  look_at <0, -5, 0>
}

light_source {
  <0, 50, 0>
  color White
  shadowless
}

light_source {
  <10, 50, -50>
  color White
  shadowless
}

#declare Quad = union {
  #declare TextTex = pigment { Black }
  #declare Val1 = 0.1
  #declare Val2 = 0
  #declare TransVal = -0.1
  cylinder { <0, 0, 0>, <0, 0, -0.1>, 5
    pigment { White }
  }
  text { ttf "times.ttf", "XII", Val1, Val2
    scale 2
    translate <-1.4, 2.6, TransVal>
    texture { TextTex }
  }
  text { ttf "times.ttf", "VI", Val1, Val2
    scale 2
    translate <-1.1, -4.2, TransVal>
    texture { TextTex }
  }
  text { ttf "times.ttf", "III", Val1, Val2
    scale 2
    translate <2.2, -0.7, TransVal>
    texture { TextTex }
  }
  text { ttf "times.ttf", "IX", Val1, Val2
    scale 2
    translate <-4, -0.7, TransVal>
    texture { TextTex }
  }
  #declare Punto = cylinder { <0, 0, 0>, <0, 0, -0.11>, 0.2 }
  #declare Counter = 0
  #while (Counter <= 360)
    object { Punto
      translate 4.5*y
      rotate Counter*z
      texture { TextTex }
    }
    #declare Counter = Counter + 30
  #end
  #declare Punto = cylinder { <0, 0, 0>, <0, 0, -0.11>, 0.05 }
  #declare Counter = 0
  #while (Counter <= 360)
    object { Punto
      translate 4.5*y
      rotate Counter*z
      texture { TextTex }
    }
    #declare Counter = Counter + 6
  #end
  #declare GoldTex = texture { T_Gold_1C }
  torus { 5, 0.15
    texture { GoldTex }
    rotate 90*x
  }
  torus { 5.3, 0.4
    texture { GoldTex }
    rotate 90*x
    translate 0.25*z
  }
  torus { 5.6, 0.5
    texture { GoldTex }
    rotate 90*x
    translate 0.5*z
  }
  cylinder { <0, 0, 0.5>, <0, 0, 5>, 6.1
    texture { GoldTex }
  }
}

#declare HourL = union {
  cylinder { <0, 0, 0>, <0, 0, 0.01>, 0.6 }
  box { <0, -0.3, 0>, <2.6, 0.3, 0.01> }
  box { <-0.5, -0.5, 0>, <0.5, 0.5, 0.05>
    rotate 45*z
    translate 2.6*x
    scale 0.7*y
  }
}

#declare MinutesL = union {
  cylinder { <0, 0, 0>, <0, 0, 0.01>, 0.45 }
  box { <0, -0.2, 0>, <3.4, 0.2, 0.01> }
  box { <-0.5, -0.5, 0>, <0.5, 0.5, 0.05>
    rotate 45*z
    translate 3.4*x
    scale 0.5*y
  }
}

#declare SecondsL = union {
  cylinder { <0, 0, 0>, <0, 0, 0.01>, 0.3 }
  box { <0, -0.1, 0>, <3.4, 0.1, 0.01> }
  box { <-0.5, -0.5, 0>, <0.5, 0.5, 0.05>
    rotate 45*z
    translate 3.4*x
    scale 0.3*y
  }
}

#declare Lanc = union {
  object { HourL
    rotate 90*z
    pigment { Black }
  }
  object { MinutesL
    translate -0.2*z
    pigment { Black }
  }
  object { SecondsL
    translate -0.4*z
    rotate -130*z
    pigment { Black }
  }
  sphere { <0, 0, -0.4>, 0.2
    texture { GoldTex }
  }
  cylinder { <0, 0, 0>, <0, 0, -0.4>, 0.2
    pigment { Black }
  }
}

#declare Ring = torus { 2, 0.25 rotate 90*x }
#declare Rings = union {
  object { Ring translate <2, 2, 0> }
  object { Ring translate <-2, 2, 0> }
  object { Ring translate <-2, -2, 0> }
  object { Ring translate <2, -2, 0> }
}

#declare IntRings = union {
  object { Rings }
  object { Rings
    rotate 90*y
  }
}

#declare IntRingsExt = intersection {
  object { IntRings }
  box { <2, 2, 2>, <-2, -2, -2> }
}

#declare IntRingsExtBalls = union {
  object { IntRingsExt }
  sphere { <-3, 0, 0>, 1 }
  sphere { <3, 0, 0>, 1 }
  sphere { <0, 0, 3>, 1 }
  sphere { <0, 0, -3>, 1 }
}

#declare ClockStruct = union {
  #declare StructTex = texture { T_Gold_1C }
  object { Lanc
    translate -0.2*z
    rotate -30*z
  }
  object { Quad }
  sphere { <7, 0, 2.5>, 1.2
    texture { StructTex }
  }
  box { <-0.4, 0, -0.4>, <0.4, -12, 0.4>
    rotate 45*y
    translate <7, 0, 2.5>
    texture { StructTex }
  }
  sphere { <-7, 0, 2.5>, 1.2
    texture { StructTex }
  }
  box { <-0.4, 0, -0.4>, <0.4, -12, 0.4>
    rotate 45*y
    translate <-7, 0, 2.5>
    texture { StructTex }
  }
  object { IntRingsExtBalls
    rotate 30*y
    texture { StructTex }
    translate <0, -8.5, 2.5>
  }
  cylinder { <0, 0, 2.5>, <0, -12, 2.5>, 0.25
    texture { StructTex }
  }
  difference {
    cylinder { <-8, -15, 2.5>, <8, -15, 2.5>, 3 }
    box { <-10, -15, -10>, <10, -25, 10> }
    texture { StructTex }
  }
  union {
    cylinder { <0, -12, 2.5>, <0, -15, 2.5>, 9.5 }
    cylinder { <0, -12.5, 2.5>, <0, -15, 2.5>, 10 }
    torus { 9.5, 0.5
      translate <0, -12.5, 2.5>
    }
    texture { StructTex }
  }
}

#declare Thing = blob { threshold 0.5
  cylinder { <0, 0, 0>, <0, 10, 0>, 5 , 2 }
}

#declare Thing2 = blob { threshold 0.5
  cylinder { <0, 0, 0>, <0, 10, 0>, 4.9 , 2 }
}

#declare Thing3 = difference {
  object { Thing }
  object { Thing2 }
  cylinder { <0, 0, 0>, <0, -10, 0>, 20 }
}

#declare TranspGlass = texture {
  pigment { color Clear }
    finish  {
      ambient 0.1
      diffuse 0.1
      reflection 0.1
      refraction 1
      ior 1.45
      specular 0.8
      roughness 0.003
      phong 1
      phong_size 400
  }
}

object { Thing3
  texture { TranspGlass }
  scale <2.4, 1.7, 2.4>
  translate <0, -13, 2>
}

#declare TablePart = difference {
  union {
    torus { 6, 1 }
    torus { 5, 1
      translate 3*y
    }
    cylinder { <0, 0, 0>, <0, 2, 0>, 6 }
    cylinder { <0, 0, 0>, <0, -1, 0>, 6 }
    cylinder { <0, 3, 0>, <0, 4, 0>, 5 }
  }
  torus { 6, 1
    translate 2*y
  }
}

#declare Table = union {
  object { TablePart
    translate 4*z
  }
  object { TablePart
    translate -4*z
  }
  object { TablePart
    translate 4*x
  }
  object { TablePart
    translate -4*x
  }
  cylinder { <0, 0, 0>, <0, -30, 0>, 3 }
}

#declare TableTex = texture {
  pigment {
    crackle
    turbulence 0.8
    octaves 5
    lambda 2.25
    omega 0.707
    color_map { M_Benediti }
    phase 0.97
    scale 1.3
  }
  finish {
    reflection 0.2
    specular 0.85
    roughness 0.0015
  }
}

#declare BackGTex = texture {
  pigment {
    granite
    color_map { M_PinkMarb }
    scale 2
  }
  finish {
    specular 0.35
    roughness 0.015
    ambient 0
  }
}

#declare BackG = difference {
  cylinder { <0, -50, 0>, <0, 50, 0>, 20 }
  cylinder { <0, -51, 0>, <0, 51, 0>, 19 }
  box { <-100, 100, -100>, <100, -100, 0> }
}

object { Table
  texture { TableTex scale 3 }
  rotate 45*y
  scale <1.5, 1, 1.5>
  translate -20*y
}

object { BackG
  scale <2, 2, 1>
  texture { BackGTex scale 10 }
}

object { ClockStruct }

plane { <0, 0, 1>, -100
  texture { BackGTex scale 50 }
}
