//
// APERIODIC TILINGS
//

#include "colors.inc"
#include "povlab.inc"
#include "stones.inc"

//---------------------------------------------------------
// Commutateurs
//---------------------------------------------------------

#declare tiling_com = on
#declare sky_com = off
#declare choixTiling = 1  // 1 = Penrose's Tiling
#declare textu_tiling = 2 // 1 = couleurs, 2 = bois

//---------------------------------------------------------
// generation du tiling
//---------------------------------------------------------

#declare texture_tile1 = texture {
  #switch (textu_tiling)
  #case (1)
    pigment {
      gradient x
      color_map {
        [0  color Turquoise]
        [1  color NavyBlue]
      }
    }
  #break
  #case (2)
    T_Stone23
    scale 2.4
    rotate <0, 70, 0>
    translate <0, 0.1, 0>
  #break
  #end
}

#declare texture_tile2 = texture {
  #switch (textu_tiling)
  #case (1)
    pigment {
      gradient x
      color_map {
        [0  color Firebrick]
        [1  color Flesh]
      }
    }
  #break
  #case (2)
    plab_EWReds
    scale 1.1
    rotate <0, 0, 5>
  #break
  #end
}

#declare ang = 36
#declare ang_ = ang*pi/180;
#include "paralelo.inc"
#declare paralelo1 = paralelo

#declare ang = 2*36
#declare ang_ = ang*pi/180;
#include "paralelo.inc"
#declare paralelo2 = paralelo

#declare nb_tiles = 0
#if (choixTiling = 1)
  #declare ang36 = 36
  #declare ang36_ = 36*pi/180
  #include "paralelo.inc"
  #declare tile = 1
  #declare uav = 2
  #declare uap = uav / (2*cos(ang36_))
  #declare tiling =  union {
    #declare jour = 5
    #include "penrose.inc"
    #debug concat("\n>> Number of caculed tiles = ", str(nb_tiles, 9, 0), " <<\n\n")
  }
#end

//---------------------------------------------------------
// SCENE
//---------------------------------------------------------

#if (tiling_com = on)
  object {
    tiling
    rotate <0, 0, -36/2>
//    rotate <90, 0, 0>
  }
#end
#if (sky_com = on)
  sky_sphere {
    S_Cloud1
  }
#end

background {
  White
}

//---------------------------------------------------------
// LUMIERES
//---------------------------------------------------------

light_source {
  <500, 800, -1000>
//  <0, 0, -1000>
  color White * 2
}

//---------------------------------------------------------
// CAMERA
//---------------------------------------------------------

camera {
  location  <0, 0, -1.128>
  up <0, 1, 0>
  right <1.22222222222222222 , 0, 0>
  look_at  <0, 0, 0>
}
