#include "finish.inc"

#declare plaque = difference {
  union {
    box {
      <-0.5, 0, 0>, <long_mecano + 0.5, epaisseur_mecano, larg_mecano>
    }
    box {
      <0, 0, -0.5>, <long_mecano, epaisseur_mecano, larg_mecano + 0.5>
    }
    cylinder {
      <0, 0, 0>, <0, epaisseur_mecano, 0>, 0.5
    }
    cylinder {
      <0, 0, larg_mecano>, <0, epaisseur_mecano, larg_mecano>, 0.5
    }
    cylinder {
      <long_mecano, 0, 0>, <long_mecano, epaisseur_mecano, 0>, 0.5
    }
    cylinder {
      <long_mecano, 0, larg_mecano>, <long_mecano, epaisseur_mecano, larg_mecano>, 0.5
    }
  }
  union {
    #declare i_mecano = 0
    #while (i_mecano <= long_mecano)
      cylinder {
        <i_mecano, -epaisseur_mecano - 0.2, 0>, <i_mecano, epaisseur_mecano + 0.2, 0>, r_trous_mecano
      }
      cylinder {
        <i_mecano, -epaisseur_mecano - 0.2, larg_mecano>, <i_mecano, epaisseur_mecano + 0.2, larg_mecano>, r_trous_mecano
      }
      #declare i_mecano = i_mecano + 1
    #end
    #declare i_mecano = 0
    #while (i_mecano <= larg_mecano)
      #declare x_oblon = 0
      #declare z_oblon = i_mecano
      #include "oblon.inc"
      object {
        oblon
      }
      #declare x_oblon = long_mecano
      #declare z_oblon = i_mecano
      #include "oblon.inc"
      object {
        oblon
      }
      #declare i_mecano = i_mecano + 1
    #end
  }
  texture {
    pigment {
      //color rgb <1, 0.7, 0.4>
      color rgb <0.4, 1, 0.7>
    }
    finish {
      Phong_Dull
    }
  }
}

#declare tige = difference {
  union {
    box {
      <0, 0, -0.5>, <long_mecano, epaisseur_mecano, 0.5>
    }
    cylinder {
      <0, 0, 0>, <0, epaisseur_mecano, 0>, 0.5
    }
    cylinder {
      <long_mecano, 0, 0>, <long_mecano, epaisseur_mecano, 0>, 0.5
    }
  }
  #if (long_mecano > 0)
  union {
  #else
  object {
  #end
    #declare i_mecano = 0
    #while (i_mecano <= long_mecano)
      cylinder {
        <i_mecano, -epaisseur_mecano - 0.2, 0>, <i_mecano, epaisseur_mecano + 0.2, 0>, r_trous_mecano
      }
      #declare i_mecano = i_mecano + 1
    #end
  }
  texture {
    pigment {
      color <1, 1, 0.35>
    }
    finish {
      Phong_Dull
    }
  }
}

#declare equerre = difference {
  union {
    box {
      <-0.5, 0, 0>, <0.5, epaisseur_mecano, 2>
    }
    box {
      <-0.5-epaisseur_mecano, 0, -0.5>, <0, epaisseur_mecano, 2.5>
    }
    cylinder {
      <0, 0, 0>, <0, epaisseur_mecano, 0>, 0.5
    }
    cylinder {
      <0, 0, 2>, <0, epaisseur_mecano, 2>, 0.5
    }
    box {
      <-0.5 - epaisseur_mecano, 0, -0.5>, <-0.5, 0.5-r_trous_mecano, 2.5>
    }
    box {
      <-0.5 - epaisseur_mecano, 0, 0.5>, <-0.5, 1.5 + epaisseur_mecano, 1.5>
    }
    cylinder {
      <-0.5 - epaisseur_mecano, 1.5 + epaisseur_mecano, 1>, <-0.5, 1.5 + epaisseur_mecano, 1>, 0.5
    }

    box {
      <-0.5 - epaisseur_mecano, 0, -0.5>, <-0.5, 0.5 + epaisseur_mecano, 0>
    }
    cylinder {
      <-0.5 - epaisseur_mecano, 0.5 + epaisseur_mecano, 0>, <-0.5, 0.5 + epaisseur_mecano, 0>, 0.5
      clipped_by {
        plane {
          <0, -1, 0>, 0
          rotate <-10, 0, 0>
          translate <-0.5 - epaisseur_mecano/2, 0.5 + epaisseur_mecano, 0>
        }
      }
      clipped_by {
        plane {
          <0, 1, 0>, 0
          rotate <55, 0, 0>
          translate <-0.5 - epaisseur_mecano/2, 0.5 + epaisseur_mecano, 0>
        }
      }
    }
    box {
      <-0.5 - epaisseur_mecano, 0, -0.5>, <-0.5, 2, 0>
      rotate <45, 0, 0>
      translate <0, 0.5 + epaisseur_mecano, 0>
      clipped_by {
        plane {
          <0, 0, 1>, 0
          rotate <-45, 0, 0>
          translate <-0.5 - epaisseur_mecano/2, 1.5 + epaisseur_mecano, 1>
        }
      }
    }

    box {
      <-0.5 - epaisseur_mecano, 0, 2>, <-0.5, 0.5 + epaisseur_mecano, 2.5>
    }
    cylinder {
      <-0.5 - epaisseur_mecano, 0.5 + epaisseur_mecano, 2>, <-0.5, 0.5 + epaisseur_mecano, 2>, 0.5
      clipped_by {
        plane {
          <0, -1, 0>, 0
          rotate <10, 0, 0>
          translate <-0.5 - epaisseur_mecano/2, 0.5 + epaisseur_mecano, 2>
        }
      }
      clipped_by {
        plane {
          <0, 1, 0>, 0
          rotate <-55, 0, 0>
          translate <-0.5 - epaisseur_mecano/2, 0.5 + epaisseur_mecano, 2>
        }
      }
    }
    box {
      <-0.5 - epaisseur_mecano, 0, 0>, <-0.5, 2, 0.5>
      rotate <-45, 0, 0>
      translate <0, 0.5 + epaisseur_mecano, 2>
      clipped_by {
        plane {
          <0, 0, -1>, 0
          rotate <45, 0, 0>
          translate <-0.5 - epaisseur_mecano/2, 1.5 + epaisseur_mecano, 1>
        }
      }
    }
  }
  union {
    #declare i_mecano = 0
    #while (i_mecano <= 2)
      cylinder {
        <0, -epaisseur_mecano - 0.2, i_mecano>, <0, epaisseur_mecano + 0.2, i_mecano>, r_trous_mecano
      }
      #declare i_mecano = i_mecano + 1
    #end
    cylinder {
      <-0.5 - epaisseur_mecano - 0.2, 0.5 + epaisseur_mecano, 1>, <-0.5 + 0.2, 0.5 + epaisseur_mecano, 1>, r_trous_mecano
    }
    cylinder {
      <-0.5 - epaisseur_mecano - 0.2, 1.5 + epaisseur_mecano, 1>, <-0.5 + 0.2, 1.5 + epaisseur_mecano, 1>, r_trous_mecano
    }
  }
  translate <0, -epaisseur_mecano, 0>
  texture {
    pigment {
      color <1, 0.35, 0.3>
    }
    finish {
      Phong_Dull
    }
  }
}

#declare boulon = difference {
  #declare larg_boulon = r_trous_mecano * 1.3
  torus {
    r_trous_mecano * 1.5,
    larg_boulon
    rotate <-90, 0, 0>
  }
  union {
    cylinder {
      <0, 0, -5>, <0, 0, 5>, r_trous_mecano
    }
    #declare i_mecano = 0
    #while (i_mecano<6)
      box {
        <r_trous_mecano * (1.5 + 1.2 - 0.47), -1, -1>, <10, 1, 1>
        rotate <0, 0, i_mecano * 360/6>
      }
      #declare i_mecano = i_mecano + 1
    #end
  }
  rotate <90, 0, 0>
  scale <0.7, 0.4, 0.7>
  rotate <0, pif, 0>
  texture {
    T_Chrome_3C
  }
}

#declare vis = difference {
  #declare hauteur_tete_vis = r_trous_mecano * 1.2
  union {
    cylinder {
      <0, -hauteur_tete_vis, 0>, <0, 0, 0>, r_trous_mecano * (1.5 + 1.2 - 0.47)
    }
    cylinder {
      <0, 0, 0>, <0, 3 * epaisseur_mecano + r_trous_mecano * 1.3, 0>, r_trous_mecano
    }
  }
  box {
    <-r_trous_mecano/4, -10, -10>, <r_trous_mecano/4, -r_trous_mecano / 2, 10>
    rotate <0, pif, 0>
  }
  scale 0.8
  texture {
    T_Chrome_4A
  }
}

#declare vis_boulon = union {
  object {
    vis
  }
  object {
    boulon
    translate <0, 2*epaisseur_mecano, 0>
  }
}
