#declare index_angle = 45
#declare middle_angle = 45
#declare ring_angle = 45
#declare pinky_angle = 45
#declare thumb_angle = 45

#declare indexb =
union { cylinder { 0, 2*cm*y, 1.125*cm } sphere { 2*cm*y, 1.125*cm } }

#declare indexa =
union {
    object { indexb rotate -index_angle*x translate 2.5*cm*y }
    cylinder { 0, 2.5*cm*y, 1.125*cm }
    sphere { 2.5*cm*y, 1.125*cm }
}

#declare index =
union {
    object { indexa rotate -index_angle*x translate 3*cm*y }
    cylinder { 0, 3*cm*y, 1.125*cm }
    sphere { 3*cm*y, 1.125*cm }
    sphere { 0, 1.125*cm }
}

#declare middleb =
union { cylinder { 0, 2*cm*y, 1.125*cm } sphere { 2*cm*y, 1.125*cm } }

#declare middlea =
union {
    object { middleb rotate -middle_angle*x translate 2.5*cm*y }
    cylinder { 0, 2.5*cm*y, 1.125*cm }
    sphere { 2.5*cm*y, 1.125*cm }
}

#declare middle =
union {
    object { middlea rotate -middle_angle*x translate 3*cm*y }
    cylinder { 0, 3*cm*y, 1.125*cm }
    sphere { 3*cm*y, 1.125*cm }
    sphere { 0, 1.125*cm }
}

#declare ringb =
union { cylinder { 0, 2*cm*y, 1.125*cm } sphere { 2*cm*y, 1.125*cm } }

#declare ringa =
union {
    object { ringb rotate -ring_angle*x translate 2.5*cm*y }
    cylinder { 0, 2.5*cm*y, 1.125*cm }
    sphere { 2.5*cm*y, 1.125*cm }
}

#declare ring =
union {
    object { ringa rotate -ring_angle*x translate 3*cm*y }
    cylinder { 0, 3*cm*y, 1.125*cm }
    sphere { 3*cm*y, 1.125*cm }
    sphere { 0, 1.125*cm }
}

#declare pinkyb =
union { cylinder { 0, 2*cm*y, 1.125*cm } sphere { 2*cm*y, 1.125*cm } }

#declare pinkya =
union {
    object { pinkyb rotate -pinky_angle*x translate 2.5*cm*y }
    cylinder { 0, 2.5*cm*y, 1.125*cm }
    sphere { 2.5*cm*y, 1.125*cm }
}

#declare pinky =
union {
    object { pinkya rotate -pinky_angle*x translate 3*cm*y }
    cylinder { 0, 3*cm*y, 1.125*cm }
    sphere { 3*cm*y, 1.125*cm }
    sphere { 0, 1.125*cm }
}

#declare thumba =
union { cylinder { 0, 3.5*cm*y, 1.25*cm } sphere { 3.5*cm*y, 1.25*cm } }

#declare thumb =
union {
    object { thumba rotate -thumb_angle*x translate 4*cm*y }
    cylinder { 0, 4*cm*y, 1.25*cm }
    sphere { 4*cm*y, 1.25*cm }
    sphere { 0, 1.25*cm }
}

#declare spacesuit_hand =
union {
    sphere { 0 1 scale <5*cm, 6*cm, 2*cm> }
    object { index rotate -index_angle*x translate <-3.375*cm, 4.25*cm, 0> }
    object { middle rotate -middle_angle*x translate <-1.125*cm, 4.75*cm, 0> }
    object { ring rotate -ring_angle*x translate <1.125*cm, 4.5*cm, 0> }
    object { pinky rotate -pinky_angle*x translate <3.375*cm, 3.5*cm, 0> }
    object {
        thumb
        rotate -45*y rotate 45*z
        rotate -thumb_angle*x
        translate <-3*cm, -3*cm, 0>
    }
    texture { pigment { color White } }
}

#declare spacesuit_arm =
union {
    object { spacesuit_hand }
    box {
        <-2.5, -1.25, 0>, <2.5, 1.25, 2.1>
        pigment {
            image_map {
                gif "spacekid.gif"
                map_type 0
                interpolate 2
            }
            translate -0.5
            scale <-2, 1, 1>
            scale 2.5
        }
        scale cm
    }
    cone {
        -30*cm*y, 1, 0, 0.75 scale <4*cm, 1, 2*cm>
        texture { pigment { color White } }
    }
}

