// Persistence of Vision Ray Tracer Scene Description File
// File: Snoopy.pov
// Vers: 3
// Desc: Snoopy
// Date: 11/27/1997
// Auth: Steve Sloan II

#version 3

#include "colors.inc"

#declare meters = 1
#declare cm = meters/100

/*
Here are some updated/additional Starfield textures which you can include
in distribution with POVRAY 3.0.  These textures use some of the new
features in POVRAY 3.0.  The starfields become more "dense" as you progress
from Starfield1 to Starfield6 and add a little color since all stars are not
white but light shades of white, blue, red, and yellow.

Respectfully;

Jeff Burton
jburton@apex.net
http://www.geocities.com/SoHo/2365
*/

#declare Starfield1 =
pigment {
    granite
    color_map {
        [ 0.000  0.270 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        [ 0.270  0.280 color rgb <.5,.5,.4> color rgb <.8,.8,.4> ]
        [ 0.280  0.470 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        [ 0.470  0.480 color rgb <.4,.4,.5> color rgb <.4,.4,.8> ]
        [ 0.480  0.680 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        [ 0.680  0.690 color rgb <.5,.4,.4> color rgb <.8,.4,.4> ]
        [ 0.690  0.880 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
        [ 0.880  0.890 color rgb <.5,.5,.5> color rgb < 1, 1, 1> ]
        [ 0.890  1.000 color rgb < 0, 0, 0> color rgb < 0, 0, 0> ]
    }
    turbulence 1
    sine_wave
    scale .5
}

global_settings { assumed_gamma 1.0 }

// ----------------------------------------
camera {
    // Front View
//    location  <0, 16, 30>*cm
//    look_at   <0, 16,  0>*cm

    location  <0, 0, 30>*cm
    look_at   <0, 0,  0>*cm
}

//sky_sphere { pigment { color Black } }
sky_sphere { pigment { Starfield1 } }

light_source { <-30, 30, -30> color White }
light_source { <30, 30, 30> color White }

#include "Snoopy.inc"
object { Snoopy rotate 30*x rotate 225*z translate <3*cm, 10*cm, -20*cm> }

#include "spc_hand.inc"
object {
    spacesuit_arm
    rotate -30*y
    rotate -45*z
    translate <-10*cm, -7*cm, 0>
}
