/***************************************************************************/
#declare R_Arm_Rotation = transform{ rotate z*50 rotate x*-80 rotate y*-30 }
#declare R_Elbow_Rotation = transform{ rotate z*-20 rotate x*-25 rotate y*5 }
#declare R_Hand_Rotation = transform{ rotate y*-80 rotate x*-35 }
#declare R_Hand_Position = ""//"relaxed"

#declare L_Arm_Rotation = transform{ rotate z*-15 rotate x*-20 rotate y*-10 }
#declare L_Elbow_Rotation = transform{ rotate z*-25 rotate x*-90 rotate y*10 }
#declare L_Hand_Rotation = transform{ rotate y*-20 }
#declare L_Hand_Position = ""//"fist"

#declare R_Leg_Rotation = transform{ rotate z*5 rotate x*-10 rotate y*10 }
#declare R_Shin_Rotation = transform{ rotate z*-5 rotate x*10 }
#declare L_Leg_Rotation = transform{ rotate z*0 rotate x*5 }
#declare L_Shin_Rotation = transform{ rotate x*10 }


#declare Height = 32
#declare Breasts = 10/16
#declare Gender = 1
#declare Suit_Color = 5
#declare Suit_Pigment = White
#declare Foot_Texture =
texture{
  pigment{ DarkBrown }
  finish{
    ambient 0.075
    diffuse 0.85
    roughness 0.03
  }
  normal{ bumps 0.1 scale (Height/8)*0.1 }
}

#declare R_Index_Curve = transform{ rotate x*20 }
#declare R_Index_Rotation = transform{ rotate x*10 }
#declare R_Middle_Curve = transform{ rotate x*20 }
#declare R_Middle_Rotation = transform{ rotate x*10 }
#declare R_Ring_Curve = transform{ rotate x*20 }
#declare R_Ring_Rotation = transform{ rotate x*10 }
#declare R_Pinky_Curve = transform{ rotate x*20 }
#declare R_Pinky_Rotation = transform{ rotate x*10 }
#declare R_Thumb_Curve = 20
#declare R_Thumb_Rotation = transform{ rotate z*50 rotate y*0 }

#declare L_Index_Curve = transform{ rotate x*60 }
#declare L_Index_Rotation = transform{ rotate x*60 }
#declare L_Middle_Curve = transform{ rotate x*60 }
#declare L_Middle_Rotation = transform{ rotate x*60 }
#declare L_Ring_Curve = transform{ rotate x*60 }
#declare L_Ring_Rotation = transform{ rotate x*60 }
#declare L_Pinky_Curve = transform{ rotate x*60 }
#declare L_Pinky_Rotation = transform{ rotate x*60 }
#declare L_Thumb_Curve = 60
#declare L_Thumb_Rotation = transform{ rotate -z*60 rotate -y*80 }

#include "person.inc"
/***************************************************************************/


#declare Fireball = union
{
union
{
    sphere
    {
        0,1
        texture
        {
            pigment
            {
                gradient y
                color_map
                {
                    [0 color <0.5,0.16,0> transmit 0]
                    [0.2 color <0.58,0.22,0> transmit 0]
                    [0.5 color <0.68,0.3,0> transmit 0]
                    [0.8 color <0.58,0.22,0> transmit 0]
                    [1 color <0.5,0.16,0> transmit 0]
                }
                turbulence 1.5
            }
            normal { bumps 0.8 scale 0.4 }
            finish { ambient 0.3 diffuse 0.7 phong 0 specular 0.1 roughness 0.9 }
        }
        hollow
        scale 0.5
        translate x*0.1
    }
    scale 0.35
    translate x*0.5
    no_shadow
}
sphere
    {
        0, 1
        pigment { color rgbt <1, 1, 1, 1> }
        hollow
        halo { Fireball_Halo1 }
        scale 0.75
    }
#ifndef (TEST)
sphere
    {
        0, 1
        pigment { color rgbt <1, 1, 1, 1> }
        hollow
        halo { Fireball_Halo2 }
        scale 0.5
        translate x*0
    }
    light_source { <0.535,0,0> color Orange fade_distance 0.75 fade_power 3 }
#end
    scale 0.25
    rotate y*20
    translate x*0.5
    translate y*0.5
    translate z*-2.25
}

#declare Crystal = object
{
    Octahedron
    hollow
    texture
    {
    pigment { color rgbt <1,1,1,1> }
#ifndef (TEST)
    halo
    {
        emitting
        spherical_mapping
        turbulence 1.5
        linear
        color_map
        {
           [0 color LimeGreen * 0.75]
           [1 color LimeGreen * 0.65]
        }
        samples 50
    }
#end
    }
    scale 0.0175
    translate y*0.247
}

#ifndef (TEST)
    #declare effect_location = <0,0.247,0>
    #declare effect_location = effect_location + <-0.14,0,0.12>
    #declare effect_location = vrotate (effect_location, y*115)
    #declare effect_location = effect_location + <0,0.285,-2>
    #declare effect_colour = <0.2,0.8,0.2>
    #declare effect_scale = 0.5
    #declare source_colour = <0.2,0.8,0.2>
    #declare effect_type = "Sparkle2"
    #include "Lens.inc"
#end


#declare StaffArc = difference
{
    torus { 0.011, 0.0025 }
    box { <-1,-1,-1>,<1,1,-0.005> }
}

#declare MageStaff = union
{
    cylinder
    {
        <0,-0.35,0>,<0,0.2,0>,0.0075
        texture { T_Wood8 pigment { turbulence 1.5 } rotate x*90 scale 0.001 }
    }
    union
    {
        cylinder { <0,0.19,0>,<0,0.205,0>,0.00751 }
        sphere { <0,0.205,0>,0.00751 }
        union
        {
            torus { 0.03, 0.0035 }
            object { StaffArc rotate y*45 translate x*0.01 translate z*0.01 }
            object { StaffArc rotate y*135 translate x*0.01 translate z*-0.01 }
            object { StaffArc rotate y*225 translate x*-0.01 translate z*-0.01 }
            object { StaffArc rotate y*315 translate x*-0.01 translate z*0.01 }
            rotate x*90
            scale 1.2
            translate y*0.247
        }
        texture { T_Silver_3B }
    }
    object { Crystal }
}



/***************************************************************************/

#declare Mage = union
{
object { Person scale 0.02 }
object { MageCape scale <0.4,0.52,0.4> translate x*-0.05 translate y*0.225 translate z*-0.099 }
object { MageStaff rotate y*55 translate x*-0.14 translate z*0.12 }
rotate y*115
translate x*0 translate y*0.285 translate z*-2
}
