/***************************************************************************/
#declare Head_Rotation = transform { rotate y*40 rotate x*-10 }
#declare Torso_Rotation = transform { rotate y*-30 rotate x*20 }

#declare L_Arm_Rotation = transform{ rotate z*-25 rotate x*-30 rotate y*0 }
#declare L_Elbow_Rotation = transform{ rotate z*-0 rotate x*-120 rotate y*20 }
#declare L_Hand_Rotation = transform{ rotate y*-105 rotate x*20 rotate z*0 }
#declare L_Hand_Position = ""

#declare R_Arm_Rotation = transform{ rotate z*30 rotate x*-30 rotate y*-0 }
#declare R_Elbow_Rotation = transform{ rotate z*-0 rotate x*-90 rotate y*-0 }
#declare R_Hand_Rotation = transform{ rotate y*-51 rotate x*-0 } //y*-30
#declare R_Hand_Position = ""

#declare L_Leg_Rotation = transform{ rotate z*-20 rotate y*-30 rotate x*-30 }
#declare L_Shin_Rotation = transform{ rotate x*40 }
#declare L_Foot_Rotation = transform{ rotate x*-20 }

#declare R_Leg_Rotation = transform{ rotate z*10 rotate x*-40 rotate y*10 }
#declare R_Shin_Rotation = transform{ rotate z*-10 rotate x*50 }
#declare R_Foot_Rotation = transform{ rotate z*-0 rotate x*-10 }

#declare R_Index_Curve = transform{ rotate x*60 }
#declare R_Index_Rotation = transform{ rotate x*60 }
#declare R_Middle_Curve = transform{ rotate x*60 }
#declare R_Middle_Rotation = transform{ rotate x*60 }
#declare R_Ring_Curve = transform{ rotate x*60 }
#declare R_Ring_Rotation = transform{ rotate x*60 }
#declare R_Pinky_Curve = transform{ rotate x*40 }
#declare R_Pinky_Rotation = transform{ rotate x*40 }
#declare R_Thumb_Curve = 60
#declare R_Thumb_Rotation = transform{ rotate -z*60 rotate -y*80 }

#declare L_Index_Curve = transform{ rotate x*60 }
#declare L_Index_Rotation = transform{ rotate x*60 }
#declare L_Middle_Curve = transform{ rotate x*60 }
#declare L_Middle_Rotation = transform{ rotate x*60 }
#declare L_Ring_Curve = transform{ rotate x*60 }
#declare L_Ring_Rotation = transform{ rotate x*60 }
#declare L_Pinky_Curve = transform{ rotate x*30 }
#declare L_Pinky_Rotation = transform{ rotate x*20 }
#declare L_Thumb_Curve = 60
#declare L_Thumb_Rotation = transform{ rotate -z*60 rotate -y*80 }


#declare Height = 32
#declare Breasts = 10/16
#declare Gender = 1
#declare Suit_Color = 5
#declare Suit_Pigment = White
#declare Suit_Texture = texture { KnightArmor_T }
#declare Pants_Texture = texture { KnightArmor_T }
#declare Hand_Texture = texture { Skin_Texture } texture { ChainMail_T }
#declare Foot_Texture =
texture{
  pigment{ DarkBrown }
  finish{
    ambient 0.075
    diffuse 0.85
    //specular 0.1
    roughness 0.03
  }
  normal{ bumps 0.1 scale (Height/8)*0.1 }
}
texture { ChainMail_T }

#include "person.inc"
/***************************************************************************/

#declare Blade = difference
{
    cylinder
    {
        <-0.045,0.16,-0.005>,<-0.045,0.16,0.005>,0.06
    }
    cone
    {
        <-0.045,0.16,-0.015>,0,<-0.045,0.16,0.2>,0.8
        open
        inverse
    }
    cone
    {
        <-0.045,0.16,0.015>,0,<-0.045,0.16,-0.2>,0.8
        open
        inverse
    }
    cylinder
    {
        <-0,0,-0.2>,<-0,0,0.2>,0.05
        scale <1,0.8,1>
        translate y*0.1
    }
    cylinder
    {
        <-0,0,-0.2>,<-0,0,0.2>,0.05
        scale <1,0.8,1>
        translate y*0.22
    }
    translate x*0.01
}

#declare Helmet = difference
{
    union
    {
        sphere { <0,0,0>,0.5 }
        cone { <0,0,0>,0.5,<0,-0.5,0>,0.6 }
    }
    union
    {
        sphere { <0,0,0>,0.45 }
        cone { <0,0,0>,0.45,<0,-0.5002,0>,0.55 }
    }
    difference
    {
        box { <-0.25,-0.2,-0.6>,<0.25,-0.05,-0.3> }
        box { <-0.05,-0.15,-0.7>,<0.05,-0.,-0.2> }
    }
    texture { KnightArmor_T }
    rotate y*5
    rotate x*-15
    scale <0.1,0.09,0.1>
    scale 1
    translate <0,0.2,-0.095>
}

#declare BattleAxe = union
{
    union
    {
        cylinder { <0,-0.14,0>,<0,0.25,0>,0.0065 }
        box { <-0.04,0.14,-0.005>,<0.04,0.18,0.005> }
        object { Blade }
        object { Blade rotate y*180 }
        texture { BattleAxe_T }
        scale <1,1.2,1>
    }
    cylinder
    {
        <0,-0.1395,0>,<0,0.05,0>,0.008
        texture { BattleAxeGrip_T }
    }
    rotate y*40
    rotate z*-70
    rotate y*-35
    translate <0.05,0.08,-0.16>
}

#ifndef (TEST)
#declare Beard=
object {
	#declare HR=seed(6)
	#declare X1=-.3
	union {
		#while (X1<=.3)
			#debug str(X1,0,1)
			#debug " - "
			#declare Z1=-.1
			union {
				#while (Z1<=.2)
					#debug str(Z1,0,2)
					#debug " "
					union {
						#declare HStart=<0,0,0>
						#declare HSegment=1
						#while (HSegment<=10)
							#declare HFx=HStart.x+(((-.01+(rand(HR)*.02))+(HSegment*0.005*X1*10))-(X1*0.2))
							#declare HFy=HStart.y-((rand(HR)*.3)-(abs(X1)*0.1))
							#declare HFz=HStart.z+((-.05+(rand(HR)*.1))) //+(0.1-(abs(X1)*.3)))
							#declare CLR=.75+(.05*HSegment)
							cylinder {
								HStart,<HFx,HFy,HFz>,.0075
                                texture { HairRed_T }
							}
							#declare HStart=<HFx,HFy,HFz>
							#declare HSegment=HSegment+1
						#end
						rotate x*(rand(HR)*-5)
						rotate y*(rand(HR)*360)
						translate <X1,0,Z1>
					}
					#declare Z1=Z1+.025
				#end
			}
			#declare X1=X1+.025
			#debug "\n"
		#end
	}
	rotate x*10
    scale 0.1
    translate x*0.005
    translate y*0.17
    translate z*-0.11
}
#end


#declare Knight = union
{
    object { Person rotate y*180 scale <0.02, 0.016, 0.02> }
    object
    {
        Armor
        texture { KnightArmor_T }
        scale 0.185
        rotate y*-30
        rotate x*-20  //NOT
        translate <-0.01,-0.01,0.01>
    }
    object { BattleAxe }
    object { Helmet }
#ifndef (TEST)
    object { Beard }
#end
    rotate y*-10
    translate y*0.185
    translate <1,-0.02,-2> //-0.015
}

