// ** Gun

// laaf

#declare laaf =
union {
  difference {
    cylinder {
      <0, 0, 0>, <-2, 0, 0>, .15
    }

    cylinder {
      <.1, 0, 0>, <-2.1, 0, 0>, .05
    }
  } // end difference

  box {
    -.08, .08
    scale <1, 1, .3>
    rotate z*45
    translate <-1.8, .15, 0>
  }

  cylinder {
    <0, 0, 0>, <-1, 0, 0>, .03
    translate -y*.19
  }

  cylinder {
    <0, 0, 0>, <-.1, 0, 0>, .05
    translate -y*.19
    translate -x*1
  }
translate -y*.05
} // end union laaf


// barrel

#declare barrel_diff =
  union {
    cylinder {
      <-.01, 0, 0>, <.4, 0, 0>, .1
    }

    sphere {
      <.4, 0, 0>, .1
    }
  scale <1, 1, .7>
  } // end union barrel_diff

#declare cnt=0

#declare gun_barrel =
  difference {
    cylinder {
      <0, 0, 0>, <.7, 0, 0>, .3
    }

    union {
      #while (cnt<6)
        object { barrel_diff translate -z*.33 rotate x*cnt*60 }
        #declare cnt = cnt + 1
      #end
    } // end union
  translate <0, -.17, 0>
  } // end difference



// Butt

#declare butt =
union {
  difference {
    torus {
      .7, .3
      rotate x*90
      scale <1, 1, .5>
    }

    box {
      <.2, -1.5, -.5>, <-1, 1, .5>
    }

    box {
      <-.01, 0, -.5>, <1, -1.5, .5>
    }

  } // end difference

  cylinder {
    <0, 0, 0>, <0, -.3, 0>, .3
    scale <1, 1, .5>
    translate <.7, 0, 0>
  }

translate <.5, -1, 0>
pigment { Brown }
} // end union butt


// Hammer

#declare hammer =
union {
  box {
    <0, 0, -.03>, <.2, .2, .03>
    rotate z*50
  }

  box {
    <0, 0, -.035>, <.1, .1, .035>
    rotate z*50
    translate <.06, .22, 0>
  }

translate <.75, -.1, 0>
} // end union hammer


// Trigger

#declare trigger =
  difference {
    cylinder {
      <0, 0, -.06>, <0, 0, .06>, .3
    }

    cylinder {
      <0, 0, -.11>, <0, 0, .11>, .25
    }

    box {
      <-1, .2, -.5>, <1, 1, .5>
    }

  scale <1, .7, 1>
  translate <.35, -.6, 0>
  } // end difference


#declare gun =
union {
  object { laaf }
  object { gun_barrel }
  object { butt }
  object { hammer }
  object { trigger }

pigment { Silver*2 }
finish { specular .3 roughness .005 metallic }
} // end union



// ** Arm & Hand


// Arm

#declare arm =
union {
  blob { // hand out of POV manual, changed into fist
    threshold .65

    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel

    cylinder { <-.65,-.28,0>, <-.65,0,-.5>, .26, 1 }    //lower pinky
    cylinder { <-.65,0,-.5>, <-.65, -.3,-.5>, .26, 1 }  //upper pinky
    sphere { <-.65,0,-.5>, .26, -1 } //counteract pinky knuckle bulge
    sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge


    cylinder { <-.3,-.28,0>, <-.3,0,-.6>, .26, 1 }      //lower ring
    cylinder { <-.3,0,-.6>, <-.3, -.4,-.6>, .26, 1 }     //upper ring
    sphere { <-.3,0,-.6>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge

    cylinder { <.05,-.28,0>, <.05, 0,-.7>, .26, 1 }     //lower middle
    cylinder { <.05,0,-.7>, <.05, -.5,-.7>, .26, 1 }    //upper middle
    sphere { <.05,0,-.7>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge


    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .512, -.4>, .26, 1 }    //upper index
    sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge

    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <.75, -.4, -.4>, .25, 1 }  //upper thumb
    sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
    sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge

    pigment { Flesh }
    scale <.7, .8, .7>
    rotate z*90
    translate <.7, -.85, .15>
  }

  sphere {
    0, .5
    scale <1, .6, .3>
    pigment { Flesh }
    translate <2, -.9, .2>
  }
} // end union arm



#declare gunhand =
union {
  object { gun }//  rotate -y*10}
  object { arm }
} // end union gunhand


