// Persistence of Vision Ray Tracer Scene Description File
// File: .pov
// Vers: 3
// Desc: Quantum Theory (Never ending flow of life)
// Date: 05-22-97
// Auth: Marty White
//
// World definition file.
//
//  Contains 2 lights, 2 textures and 4 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 05/22/1997    (22.05.1997)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//
#include "colors.inc"
#include "textures.inc"

// Lightning Texture by Andy Wardley
#declare Flash = color red 0.1 green 0.1 blue 0.4
#declare MBlue = color red 0 green 0 blue 0.2
#declare Bolt = color red 0.6 green 0.6 blue 0.8
#declare Lightning_Sky = pigment {
	marble
	turbulence 2.3
	color_map {
		[0.65, 0.85	color Black  color MBlue]
		[0.85, 0.92	color MBlue	color Flash]
		[0.92, 0.99	color Flash	color Bolt]
		[0.99, 1.001	color Bolt	color White]
	}
}

// A lightning sky
sphere {
	<0.0, 0.0, 0.0>, 3000.000000
	texture {Lightning_Sky scale 5000.000000}
	rotate <45, 0, 25>
	scale <1, 4, 1>
}





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera StdCam
  location  <-2.597, -104.596, 92.126>
  direction <0.0,     0.0,  1.9398>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <0.337, 0.164, 1.210>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <-2.230, -0.001, 68.113> // Attached to SpotL001
  direction <0.0,     0.0,  1.8665>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-2.230, 0.000, 67.113> // Following SpotL001
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight SpotL001
  <-2.230, 0.000, 68.113>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-2.230, 0.000, 67.113>
    falloff   15.0  // outer radius (in deg)
      radius    7.5  // inner radius
}

light_source {   // Light1
  <17.864, -0.215, 2.944>
  color rgb <1.000, 1.000, 1.000>
}


// ********  TEXTURES  *******
//

#include "Q-theory.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******



#include "Q-theor2.inc"

#declare qthe01_Ref = object {
  qthe01
}
#declare qthe02_Ref = object {
  qthe02
}
union { // qthe_obj
  object { qthe01_Ref }
  object { qthe02_Ref }
  texture {
    Glass4
  }
}




