// Persistence of Vision Ray Tracer Scene Description File
// File: poolball.inc
// Vers: 3.01
// Desc: use to create a single solid or striped pool ball
// Date: 06/29/97
// Auth: Bob Franke


#include "colors.inc"
#include "finish.inc"


#declare OneBall=
#if (solidBall = True)
  union{
    difference{
      sphere { <0,0,0>, 1.125   }
      cylinder{ <0,0,.5>, <0,0,-2>, .4 }
      texture{pigment {color rgb <bRed,bGreen,bBlue>} finish{Shiny reflection .1}}
    }
    object{
      sphere { <0,0,0>, 1.125  }
      clipped_by{ cylinder{ <0,0,2>, <0,0,-2>, .4 }}
      texture{pigment {color rgb <1,1,0.75>} finish{Shiny reflection .1} }
    }

    intersection{
      text { ttf "cyrvetic.ttf" BallNumber  1, 0  scale .65 translate<TextX,-.225,-1.2> }
      sphere { <0,0,0>, 1.1255 }
      texture{pigment {color rgb <0,0,0>} finish{Shiny reflection .1} }
    }
  }
#else
  union{
    difference{
      sphere { <0,0,0>, 1.125   }
      cylinder{ <0,0,.5>, <0,0,-2>, .4 }
      plane {y,-0.5625 }
      plane {y,0.5625 inverse}
      texture{pigment {color rgb <bRed,bGreen,bBlue>} finish{Shiny reflection .1}}
    }

    object{
      sphere { <0,0,0>, 1.125  }
      clipped_by{ cylinder{ <0,0,2>, <0,0,-2>, .4 }}
      texture{pigment {color rgb <1,1,0.75>} finish{Shiny reflection .1} }
    }

    object{
      difference{
        sphere { <0,0,0>, 1.125  }
        plane {y,-0.5625 inverse}
        texture{pigment {color rgb <1,1,0.75>} }
      }
    }
    object{
      difference{
        sphere { <0,0,0>, 1.125  }
        plane {y,0.5625 }
        texture{pigment {color rgb <1,1,0.75>} }
      }
    }

    intersection{
      text { ttf "cyrvetic.ttf" BallNumber  1, 0  scale .65 translate<TextX,-.225,-1.2> }
      sphere { <0,0,0>, 1.1255 }
      texture{pigment {color rgb <0,0,0>} finish{Shiny reflection .1} }
    }
  }
#end
