
// Persistence of Vision Ray Tracer Scene Description File
// File: 9ball.pov
// Vers: 3.01
// Desc: 9ball and Physics
// Date: 06/29/97
// Auth: Bob Franke


#version 3

#include "colors.inc"
#include "finish.inc"
#include "textures.inc"
#include "woods.inc"
#include "skies.inc"

global_settings
{
  assumed_gamma 2.4
}

// ----------------------------------------
#declare True = 1
#declare False = 0
#declare testing = False



#declare final=0
#declare cornerView=1
#declare test=2
#declare TheQueRack=3
//#declare viewPoint = cornerView
//#declare viewPoint = TheQueRack
#declare viewPoint = final
//#declare viewPoint = test


#declare lightMult=1.26
#if (viewPoint = cornerView)
  camera
  {
    location  <21,11,35>
    direction 1.25*z
    right     4/3*x
    look_at   <23.5,0,40>
  }
#end

#if (viewPoint = final)
  camera
  {
    location  <-1,12,-10>
    direction 1.5*z
    right     4/3*x
    look_at   <6,7,10>
  }
#end

#if (viewPoint = test)
  camera
  {
    location  <21,1.375,21>
    direction 1*z
    right     4/3*x
    look_at   <22,1.375,44>
  }
#end
#if (viewPoint = TheQueRack)
  camera
  {
    location  <-1,12,-10>
    direction 6*z
    right     4/3*x
    look_at   <84,-10,100>
  }
#end


#if (testing = True)
  light_source
  {
    0*x // light's position (translated below)
    color White*1.25 // light's color
    translate <-10, 60, -50>
  }
#else
  // create a point "spotlight" (conical directed) light source
  light_source
  {
    0*x                            // light's position (translated below)
    color rgb<1,1,1>*lightMult  // light's color
    spotlight                      // this kind of light source
    translate <0,90,48>            // <x y z> position of light
    point_at <5, 0, 40>            // direction of spotlight
    radius 80                      // hotspot (inner, in degrees)
    tightness 10                   // tightness of falloff (1...100) lower is softer, higher is tighter
    falloff 89                     // intensity falloff radius (outer, in degrees)
  }

  light_source
  {
    0*x
    color rgb<.22,.22,.22>*lightMult/1.4
    spotlight
    translate <0,90,0>
    point_at <5, 0, 0>
    radius 80
    tightness 10
    falloff 89
  }


  light_source
  {
    0*x
    color rgb<1,1,1>*lightMult
    spotlight
    translate <0,90,-48>
    point_at <5, 0, -40>
    radius 80
    tightness 10
    falloff 89
  }

  light_source{
    0*x                              // light's position (translated below)
    color rgb<.22,.22,.22>*lightMult // light's color
    area_light
    <9, 0, 0> <0, 0, 9>              // lights spread out across this distance (x * z)
    4, 4                             // total number of lights in grid (4x*4z = 16 lights)
    adaptive 1                       // 0,1,2,3...
    jitter                           // adds random softening of light
    translate <60,66,72>
  }
  light_source{
    0*x
    color rgb<.22,.22,.22>*lightMult
    area_light
    <9, 0, 0> <0, 0, 9>
    4, 4
    adaptive 1
    jitter
    translate <60,66,-72>
  }
  light_source{
    0*x
    color rgb<.22,.22,.22>*lightMult
    area_light
    <9, 0, 0> <0, 0, 9>
    4, 4
    adaptive 1
    jitter
    translate <-60,66,-72>
  }

  light_source{
    0*x
    color rgb<.22,.22,.22>*lightMult
    area_light
    <9, 0, 0> <0, 0, 9>
    4, 4
    adaptive 1
    jitter
    translate <-60,66,72>
  }
  light_source{
    0*x
    color rgb<.22,.22,.22>*lightMult
    area_light
    <9, 0, 0> <0, 0, 9>
    4, 4
    adaptive 1
    jitter
    translate <0,66,-120>
  }
 #end

// ----------------------------------------

#declare xx = seed(12345)
#declare yy = seed(321)
#declare zz = seed(82541)


#declare dullAluminum  =
texture {
    pigment { color rgb <0.55, 0.5, 0.45>*1.2 }
    finish {
        metallic
        ambient 0.1
        diffuse 0.65
        specular 0.85
        roughness 0.01
        reflection 0.15
        brilliance 1.4
    }
}

#declare oakMult=.65
#declare rackOak =
texture {
  pigment{
    wood
    scale <0.075, 0.075, 1>
    turbulence 0.065
    omega 0.45
    lambda 2.3
    color_map {
      [0.00 color rgb <0.5, 0.25, 0.125>]
      [0.40 color rgb <1.0, 0.50, 0.250>*oakMult ]
      [0.60 color rgb <1.0, 0.50, 0.250>*oakMult ]
      [1.00 color rgb <0.5, 0.25, 0.125>]
    }
    rotate x*4
  }
  finish{Shiny}
}
texture {
  pigment{
    bozo
    color_map {
      [0.00 0.30 color rgb <0.35, 0.175, 0.0875>
                 color rgb <1.00, 0.500, 0.2500>*oakMult ]
      [0.30 1.00 color Clear color Clear]
    }
    scale <0.013, 0.013, 0.75>
  }
  finish{Shiny}
}

#declare PineMult = 1.25
#declare Light_Yellow_Pine =
texture {
    pigment {
        wood
        turbulence 0.02
        color_map {
            [0.000, 0.222 color rgb <0.808, 0.671, 0.451>*PineMult
                          color rgb <0.808, 0.671, 0.451>*PineMult]
            [0.222, 0.342 color rgb <0.808, 0.671, 0.451>
                          color rgb <0.600, 0.349, 0.143>*PineMult]
            [0.342, 0.393 color rgb <0.600, 0.349, 0.143>*PineMult
                          color rgb <0.808, 0.671, 0.451>*PineMult]
            [0.393, 0.709 color rgb <0.808, 0.671, 0.451>*PineMult
                          color rgb <0.808, 0.671, 0.451>*PineMult]
            [0.709, 0.821 color rgb <0.808, 0.671, 0.451>*PineMult
                          color rgb <0.533, 0.298, 0.127>*PineMult]
            [0.821, 1.000 color rgb <0.533, 0.298, 0.127>*PineMult
                          color rgb <0.808, 0.671, 0.151>*PineMult]
        }
    scale 0.1
    translate <10, 0, 0>
    }
}
// light_Yellow_Pine layer 2
texture {
    pigment {
        wood
        turbulence 0.01
        color_map {
            [0.000, 0.120 color rgbf <1.000, 1.000, 1.000, 1.000>
                          color rgbf <0.702, 0.412, 0.318, 0.608>*PineMult]
            [0.120, 0.231 color rgbf <0.702, 0.412, 0.318, 0.608>*PineMult
                          color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult]
            [0.231, 0.496 color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult
                          color rgbf <1.000, 1.000, 1.000, 1.000>]
            [0.496, 0.701 color rgbf <1.000, 1.000, 1.000, 1.000>
                          color rgbf <1.000, 1.000, 1.000, 1.000>]
            [0.701, 0.829 color rgbf <1.000, 1.000, 1.000, 1.000>
                          color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult]
            [0.829, 1.000 color rgbf <0.702, 0.467, 0.318, 0.608>*PineMult
                          color rgbf <1.000, 1.000, 1.000, 1.000>]
        }
    scale 0.5
    translate <10, 0, 0>
    }
}



#declare woodPanel=
difference{
  box{<0,-30,0>,<6,-30+24,.5>}
  object{plane {x,0 } rotate<0,45,0> translate<0,0,.25>}
  object{plane {x,0 inverse} rotate<0,-45,0>translate<6,0,.25>}
  rotate<0,180,0>
}


#declare tableCloth =
texture{
  pigment {color rgb <.173,.392,.184>*.9}
  normal{
    bumps 0.15
    scale 0.05
  }
  finish {crand 0.07}
}


//===================<< start rackRack >>==================
#declare rackRack=
union{
  difference{
    box{<-12,-1.5,0>,<12,1.5,-1>}
    cylinder{<-15,-1.5,-1>,<15,-1.50,-1>,.375}
    cylinder{<-15,1.5,-1>,<15,1.50,-1>,.375}
    cylinder{<-12,-2,-1>,<-12,2,-1>,.375}
    cylinder{<12,-2,-1>,<12,2,-1>,.375}
    texture{rackOak  rotate<1,89.5,1>}
  }
  cylinder{<5,-.12,-4>,<5,-.12,0>,.25
    texture{rackOak    rotate<1,89.5,3>}
    rotate<7,0,0>
  }
  cylinder{<-5,-.12,-4>,<-5,-.120,0>,.25
    texture{rackOak scale .15 rotate<1,89.5,3>}
    rotate<7,0,0>
  }
}

//===================<< end RackRack   >>==================



//===================<< start triangleRack >>==================

#declare topReinf=
  difference{
    box{<-.97428,-.5625,.5625>,<.97428,.5625,2.25>}
    cylinder {<0,2,0>, <0,-2,0>, 1.125}
    object{plane {z,0 inverse} rotate<0,-60,0> translate<0,0,2.25>}
    object{plane {z,0 inverse} rotate<0,60,0> translate<0,0,2.25>}
    texture{pigment{DMFDarkOak scale .15}}
  }


#declare oneSide =
  difference{
    box{<-4,.5625,0>,<16,-.5625,-.5>
      texture{Light_Yellow_Pine scale .25 rotate<0,88,0>}
      rotate<0,-60,0> translate<-7.02591,0,0>
    }
    object{plane {z,0 } rotate<0,-30,0> translate<-4.5,0,1.125>}
    object{plane {x,0  inverse}}
  }
#declare bottomSide =
  difference{
    box{<-8,.5625,0>,<8,-.5625,-.5>
      texture{Light_Yellow_Pine scale .25 rotate<0,88,0>}
    }
    object{plane {z,0 inverse} rotate<0,-30,0> translate<-4.5,0,1.125>}
    object{plane {z,0 inverse} rotate<0,30,0> translate<4.5,0,1.125>}
  }

#declare triangleRack=
union{
  object{bottomSide }
  object{oneSide}
  object{oneSide rotate<0,0,180>}
  object{topReinf translate<0,0,8.91923>}
  object{topReinf rotate<0,-120,0> translate<-4.50,0,1.125>}
  object{topReinf rotate<0,120,0> translate<4.50,0,1.125>}
}
//===================<< end triangleRack >>==================



//===================<< start rack >>==================

#declare topReinf=
  difference{
    box{<-.97428,-.5625,.5625>,<.97428,.5625,2.25>}
    cylinder {<0,2,0>, <0,-2,0>, 1.125}
    object{plane {z,0 inverse} rotate<0,-60,0> translate<0,0,2.25>}
    object{plane {z,0 inverse} rotate<0,60,0> translate<0,0,2.25>}
    texture{pigment{DMFDarkOak scale .15}}
  }


#declare oneSide =
  difference{
    box{<0,-.5625,0>,<9,.5625,-.5>
      texture{Light_Yellow_Pine scale .25 rotate<0,88,0>
        finish{Shiny}
      }
      rotate<0,-60,0>
      translate<-2.25 -(1/cos(radians(30))*1.625),0,0>
    }
    object{plane {z,0 }}
    object{plane {x,0  inverse}}
  }

#declare Rack=
union{
  object{oneSide}
  object{oneSide rotate<0,0,180>}
  object{oneSide rotate<180,0,0>}
  object{oneSide rotate<180,0,180>}
  object{topReinf translate <0,0,3.89711>}
  object{topReinf rotate<180,0,0> translate <0,0,-3.89711>}
}
//===================<< end rack >>==================

#declare rackAssy=
union{
  object{rackRack}
  object{Rack  rotate<90,0,0> translate<-5,-4.6875,-1.5625>}
  object{triangleRack rotate<90,0,60> translate<1.75,-4.1875,-1.5625>}
}


#declare queRack =
union{
  union{
     box { <-9.5,-1.50,0>, <9.5,1.5,-.5> }
     cylinder {<-9.5,0,0>, <-9.5,0,-.5>, 1.5}
     cylinder {<9.5,0,0>, <9.5,0,-.5>, 1.5}
     texture{T_Wood1 rotate<1,91,0> finish{Shiny}}
  }
  box { <-10.5,-.25,-.5>, <10.5,.25,-3.0>
    texture{T_Wood1 rotate<0,89,1>  finish{Shiny}}
  }
}

//===================<< Start BlackBoard >>==================
#declare blackBoard=
union{
  union{
    box{<1,-.088,-.088>,<59,.088,.088> rotate<45,0,0> translate<0,.125,-1>}
    box{<1,-.088,-.088>,<59,.088,.088> rotate<45,0,0> translate<0,.125,-2>}
    box{<1,0,0>,<59,.5,-.125,>}
    box{<1,0,0>,<59,.125,-3.0,>}
    box{<1,0,-2.875>,<59,.625,-3.0,>}
    cylinder {<1,.625,-2.875>, <59,.625,-2.75>, .125}
    texture{dullAluminum  }
    translate<0,0,-1>
  }

  difference{
    box{<0,0,-1>,<60,1.5,0>}
    box{<-10,-10,-5>,<0,10,5>  rotate<0,0,-45> }
    box{<0,-10,-5>,<10,10,5>  rotate<0,0,45> translate<60,0,0> }
    texture{rackOak rotate<0,90,0>}
  }

  difference{
    box{<0,0,-1>,<60,1.5,0>}
    box{<-10,-10,-5>,<0,10,5>  rotate<0,0,-45> }
    box{<0,-10,-5>,<10,10,5>  rotate<0,0,45> translate<60,0,0> }
    rotate<180,0,0>
    translate<0,36,0>
    translate<0,0,-1>
    texture{rackOak rotate<0,90,0>}
  }

  difference{
    box{<0,0,-1>,<1.5,36,0>}
    box{<-10,0,-5>,<10,-20,5>  rotate<0,0,45>}
    box{<-10,0,-5>,<10,25,5>  rotate<0,0,-45> translate<0,36,0>}
    texture{rackOak rotate<90,0,0>}
  }
  difference{
    box{<0,0,-1>,<1.5,36,0>}
    box{<-10,0,-5>,<10,-20,5>  rotate<0,0,45>}
    box{<-10,0,-5>,<10,25,5>  rotate<0,0,-45> translate<0,36,0>}
    rotate<0,180,0>
    translate<60,0,-1>
    texture{rackOak rotate<90,0,0>}
  }

  box{<1,1,0>,<59,35,-.5>
    texture{
      pigment{rgb<.2,.45,.20>}finish{ Shiny}
    }
    texture{
      pigment {
        image_map {
          tga "d:\POV-Ray for Windows\math\willie4.tga"
          interpolate 2
          once
          filter 0 1.0
          filter 1 1.0
          filter 2 1.0
          filter 3 1.0
          filter 4 1.0
          filter 5 1.0
          filter 6 1.0
          filter 7 1.0
          filter 8 1.0
          filter 9 1.0
          filter 10 1.0
          filter 11 1.0
          filter 12 1.0
          filter 13 1.0
          filter 14 1.0
          filter 15 1.0
          filter 16 1.0
          filter 17 1.0
          filter 18 1.0
          filter 19 1.0
          filter 20 1.0
          filter 21 1.0
          filter 22 1.0
          filter 23 1.0
          filter 24 1.0
          filter 25 1.0
          filter 26 1.0
          filter 27 1.0
          filter 28 1.0
          filter 29 1.0
        }
      }
      scale 12
      translate<45,2,0>
    }
    texture{
      pigment {
        image_map {
          tga "d:\POV-Ray for Windows\math\title2.tga"
          interpolate 2
          once
          filter 0 1.0
          filter 1 1.0
          filter 2 1.0
          filter 3 1.0
          filter 4 1.0
          filter 5 1.0
          filter 6 1.0
          filter 7 1.0
          filter 8 1.0
          filter 9 1.0
          filter 10 1.0
          filter 11 1.0
          filter 12 1.0
          filter 13 1.0
          filter 14 1.0
          filter 15 1.0
          filter 16 1.0
          filter 17 1.0
          filter 18 1.0
          filter 19 1.0
          filter 20 1.0
          filter 21 1.0
          filter 22 1.0
          filter 23 1.0
          filter 24 1.0
          filter 25 1.0
          filter 26 1.0
          filter 27 1.0
          filter 28 1.0
          filter 29 1.0
        }
      }
      scale <48,4,1>
      translate<5,19,0>
    }
    texture{
      pigment {
        image_map {
          tga "d:\POV-Ray for Windows\math\ke.tga"
          interpolate 2
          once
          filter 0 1.0
          filter 1 1.0
          filter 2 1.0
          filter 3 1.0
          filter 4 1.0
          filter 5 1.0
          filter 6 1.0
          filter 7 1.0
          filter 8 1.0
          filter 9 1.0
          filter 10 1.0
          filter 11 1.0
          filter 12 1.0
          filter 13 1.0
          filter 14 1.0
          filter 15 1.0
          filter 16 1.0
          filter 17 1.0
          filter 18 1.0
          filter 19 1.0
          filter 20 1.0
          filter 21 1.0
          filter 22 1.0
          filter 23 1.0
          filter 24 1.0
          filter 25 1.0
          filter 26 1.0
          filter 27 1.0
          filter 28 1.0
          filter 29 1.0
        }
      }
      scale <15,5,1>
      translate<4,13,0>
    }
    texture{
      pigment {
        image_map {
          tga "d:\POV-Ray for Windows\math\diagram.tga"
          interpolate 2
          once
          filter 0 1.0
          filter 1 1.0
          filter 2 1.0
          filter 3 1.0
          filter 4 1.0
          filter 5 1.0
          filter 6 1.0
          filter 7 1.0
          filter 8 1.0
          filter 9 1.0
          filter 10 1.0
          filter 11 1.0
          filter 12 1.0
          filter 13 1.0
          filter 14 1.0
          filter 15 1.0
          filter 16 1.0
          filter 17 1.0
          filter 18 1.0
          filter 19 1.0
          filter 20 1.0
          filter 21 1.0
          filter 22 1.0
          filter 23 1.0
          filter 24 1.0
          filter 25 1.0
          filter 26 1.0
          filter 27 1.0
          filter 28 1.0
          filter 29 1.0
        }
      }
      scale <12,16,1>
      translate<23,2.5,0>
    }
  }
}
//===================<< End BlackBoard >>==================


#declare queChalk=
object{
  union{
    box { <-.5,0,-.5>, <.5,1,.5> texture{pigment{Red}}}
    difference{
      box { <-.5,1,-.5>, <.5,1.1875,.5>  }
      sphere { <0,1.375,0>, .375}
      texture{pigment{rgb<.35,.35,1.0>}}
    }
    text { ttf "cyrvetic.ttf" "ACE Chalk Co"  1, 0  scale .125 translate<-.45,.75,-.51> texture{pigment{White}} no_shadow}
    text { ttf "cyrvetic.ttf" "A Division of.."  1, 0  scale .125 translate<-.45,.60,-.51> texture{pigment{White}} no_shadow}
    text { ttf "cyrvetic.ttf" "We Own It All"  1, 0  scale .125 translate<-.45,.45,-.51> texture{pigment{White}} no_shadow}
    text { ttf "cyrvetic.ttf" "Patent No. 9862"  1, 0  scale .125 translate<-.45,.30,-.51> texture{pigment{White}} no_shadow}

    text { ttf "cyrvetic.ttf" "ACE Chalk Co"  1, 0  scale .125  rotate<0,90,0> translate<-.51,.75,.45> texture{pigment{White}} no_shadow}
    text { ttf "cyrvetic.ttf" "A Division of.."  1, 0  scale .125 rotate<0,90,0> translate<-.51,.60,.45> texture{pigment{White}} no_shadow}
    text { ttf "cyrvetic.ttf" "We Own It All"  1, 0  scale .125 rotate<0,90,0> translate<-.51,.45,.45> texture{pigment{White}} no_shadow}
    text { ttf "cyrvetic.ttf" "Patent No. 9862"  1, 0  scale .125 rotate<0,90,0> translate<-.51,.30,.45> texture{pigment{White}} no_shadow}
  }
}

#declare ballSpot =
union{
  cylinder{<0,0,0>,<0,.01,0>,.125 pigment{Red}}
  difference{
    cylinder{<0,0,0>,<0,.01,0>,.25}
    cylinder{<0,-1,0>,<0,1,0>,.125}
    pigment{White}
  }
  difference{
    cylinder{<0,0,0>,<0,.01,0>,.5}
    cylinder{<0,-1,0>,<0,1,0>,.25}
    pigment{Black}
  }
}

#declare diamond=
  box { <-0.1875,1.3752,-0.1875> <0.1875,0,0.1875>
    #if (testing = True)
      pigment{color rgb<1,1,.75>*.9}
    #else
      texture{
        pigment{color rgb<1,1,.75>}
        finish{Shiny}
      }
    #end
    rotate<0,45,0>
    scale<1.5,1,1>
  }


#declare longWoodSide=
union{
  box { <-1.50,1.375,-42.5625>, <1.5,.5,42.5625>
    #if (testing = True)
        pigment{color DarkBrown}
    #else
      texture{ Rosewood
        finish{Shiny}
        rotate<2,0,89> scale<.5,1,1>
      }
    #end
  }
  object{diamond  rotate<0,90,0> translate <0,0,41.7228-9.86>}
  object{diamond  rotate<0,90,0> translate <0,0,41.7228-(9.86*2)>}
}


#declare shortWoodSide=
union{
  box { <-20.5625,1.375,-1.5>, <20.5625,.5,1.5>
    #if (testing = True)
        pigment{color DarkBrown}
    #else
      texture{ Rosewood
        finish{Shiny}
        rotate<0,0,87> scale 2
        rotate<0,84,0> scale<1,1,.5>
        translate<0,0,.25>
      }
    #end
  }
  object{diamond translate<20.5625-9.86,0,0>}
  object{diamond}
  object{diamond translate<-9.86,0,0>}
}

#declare longCushion =
difference{
  box{ <-.59375, .59375, -42.5625>, < .59375,  -.59375,  42.5625>}
  object{ plane {x,0 inverse} rotate<0,0, 45>}
  object{ plane {x,0 inverse} translate<.53,0,0>}
  #if (testing = True)
    pigment{color rgb <.188,.408,.200>*1.35}
  #else
    texture {tableCloth}
  #end
}

#declare shortCushion =
difference{
  box{ <-.59375, .59375, -20.5625>, < .59375,  -.59375,  20.5625>}
  object{plane {x,0 inverse} rotate<0,0, 45>}
  object{ plane {x,0 inverse} translate<.53,0,0>}
  #if (testing = True)
    pigment{color rgb <.188,.408,.200>*1.35}
  #else
    texture {tableCloth}
  #end
}

#declare cornerPocket=
union{
  object{
    difference{
      superellipsoid{ <0.1,.35> scale<5.75,.2,5.75>}
      plane {y,0}
      plane {x,0 inverse}
      plane {z,0}
      box{ <-2.8284, -1, -1.875>, < 2.8284, 1, 1.875> rotate<0,45,0>}
      cylinder {<-2,-2,2>, <-2,1,2>, 1.875 }
    }
    #if (testing = True)
      pigment{color White*.75}
    #else
      texture{dullAluminum}
    #end
  }

  object{
    union{
      difference{
        torus {1.875,.25}
        plane {z,0}
        plane {y,0 }
        cylinder {<0,-1,0>, <0,1,0>, 1.8125 }
      }

      difference{
        cylinder { <0,0,0>, <0,0,-2>, .25  }
        plane {x,0.0625 inverse }
        plane {y,0 }
        plane {z,-0.65625 rotate <0,45,0> }
        translate<-1.875,0,0>
      }
      difference{
        cylinder { <0,0,0>, <0,0,-2>, .25  }
        plane {x,-0.0625 }
        plane {y,0 }
        plane {z,-0.65625 rotate <0,-45,0> }
        translate<1.875,0,0>
      }
    }
    texture{pigment{color rgb <0.6,0.16,0.16>*1.3} }
    rotate<0,-45,0>
    translate<-2,-.03125,2>
  }

  object{
    difference{
      box{ <-2.6, -1.5, -2.6>, < 2.6,  -5,  2.6>}
      box{ <-2.5, 10, -2.5>, < 2.5,  -5,  2.5>}
      pigment{color Red*.25}
    }
    translate<-2,0,2>
  }
  box{ <-2.6, -5, -2.6>, < 2.6, 0,  -2.5>  rotate<0,90,0>translate<-2,0,2> pigment{color Red*.25} }
  box{ <-2.6, -5, -2.6>, < 2.6, 0,  -2.5>  rotate<0,180,0>translate<-2,0,2> pigment{color Red*.25} }
} // end cornerPocket

#declare table=
union{
  union{
    box{ <-20.5625, 0, 45.1875>, < 20.5625,  1,  45.2>}
    box{ <23.1875, 0, -42.5625>, < 23.2,  1,  42.5625>}

    difference{
      box{ <-23.1875, 0,-45.1875>, < 23.1875, -1,  45.1875>}
      cylinder {<23.1875-1.25,1,45.1875-1.25>, <23.1875-1.25,-2,45.1875-1.25>, 2.05}
    }
    #if (testing = True)
      pigment{color rgb <.188,.408,.200>*1.35}
    #else
      texture {tableCloth}
    #end
  }

  difference{
    object{longCushion  rotate<0,0,-180>translate<22.59375,.75,0>}
    object{plane {x,0 } rotate<0,45,0> translate<23.1875,0,42.5625>  }
  }

  object{longCushion  rotate<0,180,-180>translate<-22.59375,.75,0>}
  difference{
    object{shortCushion rotate<0,90,180>translate<0,.75,44.59375>}
    object{plane {x,0 inverse} rotate<0,45,0> translate<20.5625,0,45.1875>  }
  }
  object{shortCushion rotate<0,-90,180>translate<0,.75,-44.59375>}
  object{longWoodSide translate<24.6875,0,0>}
  object{longWoodSide translate<-24.6875,0,0>}
  object{shortWoodSide translate<0,0,46.6875>}
  object{cornerPocket rotate<0,90,0>translate<20.5625,1.25,42.5625>}
}
//==============================================================



//===================<< start wall Plug >>==================
#declare plugHole=
union{
  difference{
    cylinder{<0,0,.5>,<0,0,-.5>,.65625  }
    object{plane {y,.5625 inverse } }
    object{plane {y,-.5625 } }
  }
  scale <1.05,1.05,1.5>
}

#declare onePlug=
union{
  difference{
    cylinder{<0,0,0>,<0,0,-.3125>,.65625  }
    object{plane {y,.5625 inverse } }
    object{plane {y,-.5625 } }
    cylinder{<0,-.37375,.5>,<0,-.34375,-.5>,.09375}
    box{<-.09375,-.37375,.5>,<.09375,-.46875,-.5>}
    box{<-.2,-.0625,.5>,<-.29,.3125,-.5>}
    box{<.2,-.0625,.5>,<.29,.25,-.5>}
    texture{pigment{rgb<1,1,.75>}finish{ Shiny}}
  }
}

#declare wallPlug=
union{
  union{
    difference{
      difference{
        superellipsoid{ <.1,.25> scale <1.375,2.25,.25>}
        object{ plane {z,0 inverse}}
      }
      object{ plugHole translate<0,.75,0> }
      object{ plugHole translate<0,-.75,0>}
      texture{pigment{rgb<1,1,.75>}finish{ Shiny}}
    }
  }
  object{ onePlug translate<0,.75,.0>}
  object{ onePlug translate<0,-.75,0>}
}
//===================<< end wall Plug >>==================








//===================<<< assemble scene >>>============================

object{blackBoard translate<-8,0,120>}

object{wallPlug rotate<0,90,0> translate<83.5,-18,98>}


// make the back and right wall
union{
  box{<-240,-30,120>,<84,-30+108,121>}
  box{<84,-30,120>,<85,-30+108,-120>}
  texture{
    pigment {color rgb<1,1,.75 >}
    normal{
      wrinkles 0.3
      scale 0.5
    }
    normal{
      bumps 0.2
      scale 0.2
    }
    finish{crand 0.05}
  }
}


// add trim above the wood panels
box{<-240,-30+24,119>,<84,-30+25,120> pigment{DMFDarkOak rotate<0,90,0>}}
box{<83,-30+24,119>,<84,-30+25,0> pigment{DMFDarkOak rotate<0,90,0>}}


//add the wood panels on the back wall
#declare xLoc = -30
#while (xLoc < 114)
  object{
    woodPanel
    texture{
      Yellow_Pine
      translate <0,0,0>
      rotate <88,0,0>
      scale 1
      finish{Shiny}
    }
    translate<xLoc,0,120>
  }
  #declare xLoc = xLoc + 6
#end

//add the wood panels on the right wall
#declare zLoc = 119
#while (zLoc > 0)
  object{
    woodPanel
    texture{
      Yellow_Pine
      translate <0,0,0>
      rotate <1,0,0>
      scale 1
      finish{Shiny}
    }
    rotate<0,90,0>
    translate<84,0,zLoc>
  }
  #declare zLoc = zLoc - 6
#end

object{table}


object{queRack rotate<0,90,0> translate<84,-2,100>}
object{rackAssy translate<67,22,120>}



object{queChalk scale .75 rotate<0,15,0> translate <24.25,1.375,20> }
object{ballSpot translate<0,0,22>}

//add the stools
#include "d:\pov-ra~1\math\stool.inc"
object{stool rotate<0,20,0> translate<72,-30,69>}
#include "d:\pov-ra~1\math\stool.inc"
object{stool  rotate<0,20,0> translate<60,-30,112>}
#include "d:\pov-ra~1\math\stool.inc"
object{stool  rotate<0,15,0> translate<20,-30,109>}

//add beer bottles
#include "d:\pov-ra~1\math\beerbott.inc"
object{beerBottle rotate<0,-55,0> translate<58.4,-.063,112> }
#include "d:\pov-ra~1\math\beerbott.inc"
object{beerBottle rotate<0,180,0> translate<61.6,-.063,112> }
#include "d:\pov-ra~1\math\beerbott.inc"
object{beerBottle  translate<60.75,-.063,108.5> }
#include "d:\pov-ra~1\math\beerbott.inc"
object{beerBottle  rotate<0,160,0> translate<68,-.063,69> }


//add the que sticks
#declare HandleColor = Black
#include "d:\pov-ra~1\math\questick.inc"
object{queStick rotate<95,10.40,0> translate<7-.45,1.5,15-2.45>}


#declare HandleColor = SteelBlue
#include "d:\pov-ra~1\math\questick.inc"
object{queStick rotate<5,0,-5> translate<83.75,23,119.75>}

#declare HandleColor = DkGreenCopper
#include "d:\pov-ra~1\math\questick.inc"
object{queStick translate<82.5,58.5,108>}

#declare HandleColor = SteelBlue
#include "d:\pov-ra~1\math\questick.inc"
object{queStick translate<82.5,58.35,104.75> scale<1,.90,1>}

#declare HandleColor = Maroon
#include "d:\pov-ra~1\math\questick.inc"
object{queStick translate<82.5,58.5,100.5>}

#declare HandleColor = Firebrick
#include "d:\pov-ra~1\math\questick.inc"
object{queStick translate<82.5,58.5,92>}


object{queRack rotate<0,90,0> translate<84,-2,100>}
object{rackAssy translate<67,22,120>}

#declare solidBall = True
#declare bRed   = 0.694*1.2
#declare bGreen = 0.576*1.2
#declare bBlue  = 0.024
#declare BallNumber = "1"
#declare TextX = -.15
#include "d:\pov-ra~1\math\poolball.inc"
object{OneBall rotate<rand(xx)*90,rand(yy)*360,rand(zz)*90> translate<11,1.25,34>}


#declare solidBall = True
#declare bRed   = 0.02
#declare bGreen = 0.075
#declare bBlue  = 0.400
#declare BallNumber = "2"
#declare TextX = -.18
#include "d:\pov-ra~1\math\poolball.inc"
object{OneBall rotate<rand(xx)*90,rand(yy)*270,rand(zz)*90> rotate<0,30,0> translate<2.5,1.125,15>}


#declare solidBall = False
#declare bRed   = 1.0
#declare bGreen = 1.0
#declare bBlue  = 0.75
#declare BallNumber = ""
#declare TextX = -.31
#include "d:\pov-ra~1\math\poolball.inc"
object{OneBall translate<7,1.125,15>}


#declare solidBall = True
#declare bRed   = .636*.7
#declare bGreen = 0.157*.7
#declare bBlue  = 0.118*.7
#declare BallNumber = "7"
#declare TextX = -.2
#include "d:\pov-ra~1\math\poolball.inc"
object{OneBall rotate<rand(xx)*90,rand(yy)*360,rand(zz)*90> translate<-2.5,1.125,-2.5+30>}

#declare solidBall = True
#declare bRed   = 0.75
#declare bGreen = 0.1
#declare bBlue  = 0.0
#declare BallNumber = "3"
#declare TextX = -.18
#include "d:\pov-ra~1\math\poolball.inc"
object{OneBall rotate<0,10,160> translate<15,1.125,10>}

#declare solidBall = False
#declare bRed   = 0.694*1.2
#declare bGreen = 0.576*1.2
#declare bBlue  = 0.024
#declare BallNumber = "9"
#declare UnderLine = "_"
#declare TextX = -.18
#include "d:\pov-ra~1\math\poolball.inc"
object{OneBall rotate<10,15,60> translate<20,1.125,42>}



// Floor plane
plane { y, -30
   texture {
      pigment {color rgb <.188,.408,.200>*1.35}
      finish {
        roughness .9
        crand 0.075       }
   }
}

//anti

