//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  ---------------------------------------------------------
//
//  Scene    : Reflections
//  Author   : Nathan Kopp
//  Date     : February 22, 1997
//  Filename : NKReflct.pov
//
//  ---------------------------------------------------------
//
//  Contains 3 lights, 29 textures and 157 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 02/22/1997    (22.02.1997)
//




global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

camera {  //  Camera Camera01
  location  <1.460, -10.500, -2.550>
  direction <0.0,     0.0,  2.1351>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-0.447, -0.316, -4.328>
}

// *******  L I G H T S *******
light_source {   // Light001
  <3.218, -111.883, 129.924>
  color rgb <0.698, 0.698, 0.698>
}

light_source {   // InsideLight1
  <-9.500, 37.500, -1.000>
  color rgb <1.000, 1.000, 0.898>
  fade_distance  10.0
  fade_power 2.0
}

light_source {   // LightInsideLamp
  <0.795, 3.239, -4.864>
  color rgb <1.655, 1.655, 1.349>
  fade_distance  3.0
  fade_power 2.0
}


// ********  TEXTURES  *******
//

#include "reflect.inc"



// ********  REFERENCED OBJECTS  *******

#declare Shingle1 = union { // Shingle1
  cylinder { // Cyl25
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.98>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.946579, 2.5, 0.0>
  }
  cylinder { // Cyl24
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.75, 2.5, 0.0>
  }
  cylinder { // Cyl1
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-3.0, 2.5, 0.0>
  }
  cylinder { // Cyl2
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.05>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.785614, 2.5, 0.0>
  }
  cylinder { // Cyl3
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.5, 2.5, 0.0>
  }
  cylinder { // Cyl4
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.25, 2.5, 0.0>
  }
  cylinder { // Cyl5
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.99>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.0, 2.5, 0.0>
  }
  cylinder { // Cyl6
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.75, 2.5, 0.0>
  }
  cylinder { // Cyl7
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.99>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.5, 2.5, 0.0>
  }
  cylinder { // Cyl8
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.01>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.285614, 2.5, 0.0>
  }
  cylinder { // Cyl9
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.02>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.0, 2.5, 0.0>
  }
  cylinder { // Cyl10
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.75, 2.5, 0.0>
  }
  cylinder { // Cyl11
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.517807, 2.5, 0.0>
  }
  cylinder { // Cyl12
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.02>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.25, 2.5, 0.0>
  }
  cylinder { // Cyl13
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.02>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.035614, 2.5, 0.0>
  }
  cylinder { // Cyl14
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.25, 2.5, 0.0>
  }
  cylinder { // Cyl15
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.03>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.482193, 2.5, 0.0>
  }
  cylinder { // Cyl16
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.75, 2.5, 0.0>
  }
  cylinder { // Cyl17
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.99>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.0, 2.5, 0.0>
  }
  cylinder { // Cyl18
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.98>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.196579, 2.5, 0.0>
  }
  cylinder { // Cyl19
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.5, 2.5, 0.0>
  }
  cylinder { // Cyl20
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.75, 2.5, 0.0>
  }
  cylinder { // Cyl21
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.03>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.964386, 2.5, 0.0>
  }
  cylinder { // Cyl22
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.25, 2.5, 0.0>
  }
  cylinder { // Cyl23
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.482193, 2.5, 0.0>
  }
  texture {
    ShingleTexture
  }
  scale <0.5, 0.35, 0.5>
  rotate 85.5*x
  translate  <-3.75, -0.15, -7.5>
}


#declare WindowFrame1 = object { 
  height_field {
    tga "D:\POV\MORAY25\..\WINDOW\WINDOW4B.TGA"
    water_level 0.0099
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <1.75, 2.25, 0.3>
  rotate 90.0*x
  texture {
    WindowTex1
  }
}
#declare WindowFrame2 = object { 
  height_field {
    tga "D:\POV\MORAY25\..\WINDOW\WINDOW5.TGA"
    water_level 0.0099
    smooth
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  texture {
    InsideWindow
  }
  scale <1.75, 2.25, 0.272>
  rotate 90.0*x
}
#declare WindowGroup = union {
  object { WindowFrame1 }
  object { WindowFrame2 }
  scale <1.0, 0.5, 1.0>
}
#declare Side3 = object { 
  height_field {
    tga "D:\POV\MORAY25\..\WINDOW\SIDE1.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <0.473116, 1.7, 0.1>
  rotate -90.0*z
  translate  <0.0, 0.047243, -6.600826>
  texture {
    WindowTex1
  }
}
#declare Side1 = object { 
  height_field {
    tga "D:\POV\MORAY25\..\WINDOW\SIDE1.TGA"
    water_level 0.0
  }
  rotate    <-90, 0, 0> // Turn onto XY plane. Now points along -Z
  scale     <  2, 2,-2> // Scale to Cube size. Now points along +Z
  translate < -1,-1,-1> // Center around origin
  scale <0.25, 4.6, 0.15>
  rotate 90.0*x
  translate  <-1.95, -0.28, -2.1>
}
#declare CSG001 = union {
  object { Side1 }
  box { // Side_b1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.25, 0.4, 4.6>
    translate  <-1.95, 0.2, -2.1>
  }
  texture {
    WindowTex1
  }
}
object { WindowFrame1 }
object { WindowFrame2 }




// ********  OBJECTS  *******

blob {   // Icecicle4
  threshold 0.6
  component 1.0, 0.707459, <0.0763, 0.045627, -0.10687>
  component 1.0, 0.518516, <-0.20523, 0.007605, -0.380055>
  component 1.0, 0.678041, <-0.01526, -0.060837, -0.763359>
  component 1.0, 0.331042, <0.03052, 0.045627, -1.526718>
  component 1.0, 0.366637, <0.01526, -0.060837, -1.832061>
  component 1.0, 0.316687, <0.0763, 0.0, -2.015267>
  component 1.0, 0.84163, <-0.3052, 0.0, 0.229008>
  component 1.0, 0.115928, <0.09156, 0.0, -2.229008>
  component 1.0, 0.614229, <0.12208, 0.0, -1.19084>
  component 1.0, 0.84163, <0.3815, 0.0, 0.290076>
  texture {
    IceTexture2
  }
  scale <0.2, 0.1, 0.28>
  translate  <0.434828, -0.229886, -2.328863>
}



blob {   // Icecicle3
  threshold 0.6
  component 1.0, 0.707459, <-0.01526, 0.045627, 0.0>
  component 1.0, 0.518516, <-0.19075, -0.045627, -0.380055>
  component 1.0, 0.678041, <0.01526, -0.060837, -0.671756>
  component 1.0, 0.331042, <-0.00763, 0.045627, -1.581028>
  component 1.0, 0.366637, <0.12208, -0.060837, -1.839465>
  component 1.0, 0.316687, <0.10682, 0.0, -2.152672>
  component 1.0, 0.84163, <-0.3052, 0.0, 0.229008>
  component 1.0, 0.115928, <0.10682, 0.0, -2.381679>
  component 1.0, 0.614229, <-0.06104, 0.0, -1.19084>
  component 1.0, 0.84163, <0.21364, 0.0, 0.198473>
  scale <0.15, 0.1, 0.46>
  translate  <-1.260751, -0.229886, -2.335324>
  texture {
    IceTexture2
  }
}



#declare Ice1 = blob {
  threshold 0.6
  component 1.0, 0.490691, <-1.777789, 0.0, -0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-0.630891, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.17549, 0.0, 0.091603>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  
sturm
  scale <1.0, 0.3, 0.3>
  translate  <-3.476862, -0.22119, -1.628852>
}

#declare Icecicle2 = blob {
  threshold 0.6
  component 1.0, 0.707459, <0.0763, 0.045627, -0.10687>
  component 1.0, 0.518516, <-0.20523, 0.007605, -0.380055>
  component 1.0, 0.678041, <-0.01526, -0.060837, -0.763359>
  component 1.0, 0.331042, <0.03052, 0.045627, -1.526718>
  component 1.0, 0.366637, <0.01526, -0.060837, -1.832061>
  component 1.0, 0.316687, <0.0763, 0.0, -2.015267>
  component 1.0, 0.84163, <-0.3052, 0.0, 0.229008>
  component 1.0, 0.115928, <0.09156, 0.0, -2.229008>
  component 1.0, 0.614229, <0.12208, 0.0, -1.19084>
  component 1.0, 0.84163, <0.3815, 0.0, 0.290076>
  scale <0.2, 0.15, 0.2>
  translate  <-3.696384, -0.214714, -1.676245>
}

merge { // IceChunk2
  object { Ice1 }
  object { Icecicle2 }
  translate  -1.680928*z
  texture {
    IceTexture
  }
}


blob {   // Ice8
  threshold 0.6
  component 1.0, 0.490691, <-1.777789, 0.0, -0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-0.630891, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.17549, 0.0, 0.091603>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  component 1.0, 0.406741, <-0.84693, 0.0, -0.259542>
  component 1.0, 0.296395, <0.60277, 0.0, -0.244275>
  component 1.0, 0.195515, <0.54173, 0.0, -0.458015>
  component 1.0, 0.215636, <0.63329, 0.0, -0.564885>
  component 1.0, 0.160759, <1.289469, 0.0, -0.167939>
  component 1.0, 0.173102, <-1.640449, 0.0, -0.244275>
  component 1.0, 0.143757, <-0.89271, 0.0, -0.473282>
  
sturm
  texture {
    IceTexture
  }
  scale <1.0, 0.3, 0.3>
  translate  <4.134102, -0.238243, -1.626929>
}



blob {   // Ice7
  threshold 0.6
  component 1.0, 0.490691, <-1.777789, 0.0, -0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-0.630891, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.17549, 0.0, 0.091603>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  
sturm
  texture {
    IceTexture
  }
  scale <1.0, 0.3, 0.3>
  translate  <4.134102, -0.237118, -3.313587>
}



blob {   // Ice6
  threshold 0.6
  component 1.0, 0.490691, <-0.60277, 0.0, 0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-1.762529, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.19075, 0.0, 0.061069>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  component 1.0, 0.406741, <-0.84693, 0.0, -0.259542>
  component 1.0, 0.296395, <-0.09919, 0.0, -0.259542>
  component 1.0, 0.195515, <-0.09919, 0.0, -0.458015>
  component 1.0, 0.215636, <-1.365769, 0.0, -0.274809>
  component 1.0, 0.160759, <0.41965, 0.0, -0.198473>
  component 1.0, 0.173102, <-0.08393, 0.0, -0.625954>
  component 1.0, 0.143757, <0.81641, 0.0, -0.320611>
  
sturm
  texture {
    IceTexture
  }
  scale <1.0, 0.3, 0.3>
  translate  <4.134102, -0.238243, -5.014563>
}



blob {   // Ice5
  threshold 0.6
  component 1.0, 0.490691, <-1.777789, 0.0, -0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-0.630891, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.17549, 0.0, 0.091603>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  component 1.0, 0.406741, <-0.84693, 0.0, -0.259542>
  component 1.0, 0.296395, <0.60277, 0.0, -0.244275>
  component 1.0, 0.195515, <0.54173, 0.0, -0.458015>
  component 1.0, 0.215636, <0.63329, 0.0, -0.564885>
  component 1.0, 0.160759, <1.289469, 0.0, -0.167939>
  component 1.0, 0.173102, <-1.640449, 0.0, -0.244275>
  component 1.0, 0.143757, <-0.89271, 0.0, -0.473282>
  
sturm
  texture {
    IceTexture
  }
  scale <1.0, 0.3, 0.3>
  translate  <-3.476862, -0.242416, -5.010253>
}



blob {   // Ice4
  threshold 0.6
  component 1.0, 0.490691, <-0.60277, 0.0, 0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-1.762529, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.19075, 0.0, 0.061069>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  component 1.0, 0.406741, <-0.84693, 0.0, -0.259542>
  component 1.0, 0.296395, <-0.09919, 0.0, -0.259542>
  component 1.0, 0.195515, <-0.09919, 0.0, -0.458015>
  component 1.0, 0.215636, <-1.365769, 0.0, -0.274809>
  component 1.0, 0.160759, <0.41965, 0.0, -0.198473>
  component 1.0, 0.173102, <-0.08393, 0.0, -0.625954>
  component 1.0, 0.143757, <0.81641, 0.0, -0.320611>
  
sturm
  texture {
    IceTexture
  }
  scale <1.0, 0.3, 0.3>
  translate  <-3.476862, -0.233422, -6.705611>
}



#declare Icecicle = blob {
  threshold 0.6
  component 1.0, 0.707459, <-0.01526, 0.045627, 0.0>
  component 1.0, 0.518516, <-0.19075, -0.045627, -0.380055>
  component 1.0, 0.678041, <0.01526, -0.060837, -0.671756>
  component 1.0, 0.331042, <-0.00763, 0.045627, -1.581028>
  component 1.0, 0.366637, <0.12208, -0.060837, -1.839465>
  component 1.0, 0.316687, <0.10682, 0.0, -2.152672>
  component 1.0, 0.84163, <-0.3052, 0.0, 0.229008>
  component 1.0, 0.115928, <0.10682, 0.0, -2.381679>
  component 1.0, 0.614229, <-0.06104, 0.0, -1.19084>
  component 1.0, 0.84163, <0.21364, 0.0, 0.198473>
  scale <0.3, 0.2, 0.5>
  translate  <-1.260751, -0.229886, -2.335324>
}

#declare Ice2 = blob {
  threshold 0.6
  component 1.0, 0.490691, <-1.777789, 0.0, -0.015267>
  component 1.0, 0.447871, <-1.375798, -0.022814, 0.0>
  component 1.0, 0.346203, <-1.014789, 0.0, -0.030534>
  component 1.0, 0.468013, <-0.630891, 0.038023, 0.015267>
  component 1.0, 0.463627, <-0.28231, 0.0, -0.015267>
  component 1.0, 0.437314, <0.17549, 0.0, 0.091603>
  component 1.0, 0.274638, <-0.02289, 0.0, -0.030534>
  component 1.0, 0.523348, <0.539678, -0.022814, 0.061069>
  component 1.0, 0.422768, <0.90797, 0.0, -0.061069>
  component 1.0, 0.449989, <1.182649, 0.0, 0.10687>
  component 1.0, 0.406741, <-0.84693, 0.0, -0.259542>
  component 1.0, 0.296395, <0.60277, 0.0, -0.244275>
  component 1.0, 0.195515, <0.54173, 0.0, -0.458015>
  component 1.0, 0.215636, <0.63329, 0.0, -0.564885>
  component 1.0, 0.160759, <1.289469, 0.0, -0.167939>
  component 1.0, 0.173102, <-1.640449, 0.0, -0.244275>
  component 1.0, 0.143757, <-0.89271, 0.0, -0.473282>
  
sturm
  scale <1.0, 0.2, 0.25>
  translate  <0.242985, -0.250426, -2.236965>
}

#declare Icecicle1 = blob {
  threshold 0.6
  component 1.0, 0.707459, <0.0763, 0.045627, -0.10687>
  component 1.0, 0.518516, <-0.20523, 0.007605, -0.380055>
  component 1.0, 0.678041, <-0.01526, -0.060837, -0.763359>
  component 1.0, 0.331042, <0.03052, 0.045627, -1.526718>
  component 1.0, 0.366637, <0.01526, -0.060837, -1.832061>
  component 1.0, 0.316687, <0.0763, 0.0, -2.015267>
  component 1.0, 0.84163, <-0.3052, 0.0, 0.229008>
  component 1.0, 0.115928, <0.09156, 0.0, -2.229008>
  component 1.0, 0.614229, <0.12208, 0.0, -1.19084>
  component 1.0, 0.84163, <0.3815, 0.0, 0.290076>
  scale <0.3, 0.2, 0.3>
  translate  <0.434828, -0.229886, -2.328863>
}

merge { // IceOnWindow
  object { Icecicle }
  object { Ice2 }
  object { Icecicle1 }
  texture {
    IceTexture
  }
}


box { // WindowPane2
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WindowPaneTex
    scale <1.8, 1.9, 1.0>
    rotate 90.0*x
  translate <-0.900000, 0.000000, -0.950000>
  }
  scale <1.74, 0.01, 2.175>
  rotate -180.0*z
  translate  -0.25*y
}


box { // WindowPane1
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WindowPaneTex
    scale <1.8, 1.9, 1.0>
    rotate 90.0*x
  translate <-0.900000, 0.000000, -0.950000>
  }
  scale <1.74, 0.01, 2.175>
  translate  <0.0, 0.05, -4.25>
}


union { // Shingle3
  cylinder { // Cyl26
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.98>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.946579, 2.5, 0.0>
  }
  cylinder { // Cyl27
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.75, 2.5, 0.0>
  }
  cylinder { // Cyl28
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-3.0, 2.5, 0.0>
  }
  cylinder { // Cyl29
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.05>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.785614, 2.5, 0.0>
  }
  cylinder { // Cyl30
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.5, 2.5, 0.0>
  }
  cylinder { // Cyl31
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.272939, 2.5, 0.0>
  }
  cylinder { // Cyl32
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.99>
    rotate <-90.0, 0.0, 180.0>
    translate  <-2.022939, 2.5, 0.0>
  }
  cylinder { // Cyl33
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.75, 2.5, 0.0>
  }
  cylinder { // Cyl34
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.99>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.5, 2.5, 0.0>
  }
  cylinder { // Cyl35
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.01>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.262675, 2.5, 0.0>
  }
  cylinder { // Cyl36
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.02>
    rotate <-90.0, 0.0, 180.0>
    translate  <-1.0, 2.5, 0.0>
  }
  cylinder { // Cyl37
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.75, 2.5, 0.0>
  }
  cylinder { // Cyl38
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.471929, 2.5, 0.0>
  }
  cylinder { // Cyl39
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.02>
    rotate <-90.0, 0.0, 180.0>
    translate  <-0.25, 2.5, 0.0>
  }
  cylinder { // Cyl40
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.02>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.035614, 2.5, 0.0>
  }
  cylinder { // Cyl41
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.204122, 2.5, 0.0>
  }
  cylinder { // Cyl42
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.03>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.482193, 2.5, 0.0>
  }
  cylinder { // Cyl43
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.75, 2.5, 0.0>
  }
  cylinder { // Cyl44
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.99>
    rotate <-90.0, 0.0, 180.0>
    translate  <0.977061, 2.5, 0.0>
  }
  cylinder { // Cyl45
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 4.98>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.265396, 2.5, 0.0>
  }
  cylinder { // Cyl46
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.5, 2.5, 0.0>
  }
  cylinder { // Cyl47
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.818817, 2.5, 0.0>
  }
  cylinder { // Cyl48
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.03>
    rotate <-90.0, 0.0, 180.0>
    translate  <1.964386, 2.5, 0.0>
  }
  cylinder { // Cyl49
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.25, 2.5, 0.0>
  }
  cylinder { // Cyl50
    <0,0,1>, <0,0,0>, 1 
    scale <0.15, 0.15, 5.0>
    rotate <-90.0, 0.0, 180.0>
    translate  <2.436315, 2.5, 0.0>
  }
  texture {
    ShingleTexture
  }
  scale <0.5, 0.35, 0.5>
  rotate 85.5*x
  translate  <-3.75, -0.15, -4.1>
}




object { // Shingle11->Shingle1
  Shingle1
  translate  <7.5, 0.0, 6.8>
}


object { // Shingle10->Shingle1
  Shingle1
  translate  <7.55, 0.0, 5.1>
}


object { // Shingle9->Shingle1
  Shingle1
  translate  <7.5, 0.0, 3.4>
}


object { // Shingle8->Shingle1
  Shingle1
  translate  <7.53, 0.0, 1.7>
}


object { // Shingle7->Shingle1
  Shingle1
  translate  <6.2, 0.0, 0.0>
}


object { // Shingle6->Shingle1
  Shingle1
  translate  <3.1, 0.0, 0.0>
}


object { // Shingle5->Shingle1
  Shingle1
  translate  <-0.05, 0.0, 6.8>
}


object { // Shingle4->Shingle1
  Shingle1
  translate  <0.0, 0.0, 5.1>
}


object { // Shingle2->Shingle1
  Shingle1
  translate  <0.05, 0.0, 1.7>
}


object { Shingle1 }


difference { // WallMinusWindow
  box { // Wall
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WallTex1
    }
    scale <100.0, 0.1, 100.0>
    translate  0.1*y
  }
  box { // Wall1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WallTex1
    }
    scale <2.0, 0.4, 4.5>
    translate  -2.138471*z
  }
}


union { // Window
  object { // WindowGroup1->WindowGroup
    WindowGroup
    rotate <180.0, 0.0, 180.0>
    translate  <0.0, 0.284775, -4.250915>
  }
  object { Side3 }
  object { // Side4->Side3
    Side3
    rotate <180.0, 0.0, 0.0>
    translate  <0.0, 0.09428, -4.249716>
  }
  object { CSG001 }
  object { // CSG2->CSG001
    CSG001
    translate  3.9*x
  }
  object { WindowGroup }
  translate  -0.25*y
}


box { // SnowLayers
  <-1, -1, -1>, <1, 1, 1>
  no_shadow
  scale <20.0, 1.0, 20.0>
  translate  -2.0*y
  texture {
    FallingSnowTex
  }
}




union { // BicPen
  cone { // Pen_3
    <0,0,0>, 0.2, <0,0,1>, 1.0
    texture {
      PenBlack
    }
    scale <0.05, 0.05, 0.3>
    translate  -0.3*z
  }
  sphere { // Pen_2
    <0,0,0>,1
    texture {
      PenBlack
    }
    scale <0.05, 0.05, 0.02>
    translate  1.5*z
  }
  cylinder { // Pen_1
    <0,0,1>, <0,0,0>, 1 
    texture {
      PenWhite
    }
    scale <0.05, 0.05, 1.5>
  }
  rotate <-35.137936, 85.643822, -90.0>
  translate  <-0.194635, 3.320508, -6.55>
}


object { // Paper
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-2.000000, -2.000000, 0.000000>, <-1.000000, -2.000000, 0.000000>, <0.000000, -2.000000, 0.000000>, <1.000000, -2.000000, 0.000000>, 
      <-2.000000, -1.000000, 0.000000>, <-1.000000, -1.000000, 0.000000>, <0.000000, -1.000000, 0.000000>, <1.000000, -1.000000, 0.000000>, 
      <-2.000000, 0.000000, 0.000000>, <-1.000000, 0.000000, 0.000000>, <0.000000, 0.000000, 0.000000>, <1.000000, 0.000000, 0.000000>, 
      <-2.000000, 1.000000, 0.044539>, <-1.000000, 1.000000, 0.000000>, <0.000000, 1.000000, 0.000000>, <1.000000, 1.000000, 0.000000>
    }
  }
  texture {
    PaperTex
    scale <3.0, 3.0, 1.0>
    rotate -180.0*z
  translate <1.000000, 1.000000, 0.000000>
  }
  scale <0.5, 0.7, 1.0>
  rotate 11.057751*z
  translate  <0.329719, 5.283493, -6.599>
}


lathe {
  cubic_spline
  17  // control points
  <0.0, -1.15>,
  <0.0, -1.1>,
  <0.61, -1.11>,
  <0.61, -0.81>,
  <0.67, -0.31>,
  <0.6, 0.24>,
  <0.7, 0.68>,
  <0.62, 1.19>,
  <0.61, 1.49>,
  <0.54, 1.49>,
  <0.55, 1.18>,
  <0.65, 0.68>,
  <0.55, 0.23>,
  <0.61, -0.31>,
  <0.5, -0.92>,
  <0.0, -0.99>,
  <0.0, -0.91>
  rotate <90,0,90>
  texture {
    WaterGlassTex
  }
  scale 0.5
  translate  <-1.389193, 3.964583, -6.034428>
}


#declare LidCSG = difference {
  superellipsoid { // DayPlanner2
    <0.1, 0.1>
    scale <0.5, 0.3, 0.05>
    rotate -8.672441*x
    translate  <0.0, -0.585347, 0.044831>
  }
  superellipsoid { // DayPlanner3
    <0.1, 0.1>
    scale <0.51, 0.31, 0.05>
    rotate -8.672441*x
    translate  <0.0, -0.576042, 0.088252>
  }
}
union { // DayPlannerUnion
  object { LidCSG }
  superellipsoid { // DayPlanner1
    <0.1, 0.1>
    scale <0.5, 0.3, 0.05>
  }
  texture {
    DayPlanTex
    scale <1.061442, 1.244899, 1.0>
    rotate 180.0*z
  translate <0.528925, 0.332517, 0.000000>
  }
  scale <1.2, 1.2, 1.0>
  rotate <0.0, 0.0, -20.223885>
  translate  <1.116874, 2.703105, -6.55>
}


cone { // LampShade
  <0,0,0>, 1.0, <0,0,1>, 0.5
  open
  texture {
    LampShadeTex
  }
  no_shadow
  scale <2.0, 2.0, 3.0>
  translate  <-9.5, 37.5, -2.5>
}


union { // Chair
  superellipsoid { // ChairBack
    <0.2, 0.2>
    scale <3.2, 3.5, 1.0>
    rotate 73.647026*x
    translate  <-4.0, 37.803458, -7.736904>
  }
  superellipsoid { // Arm2
    <0.3, 0.2>
    scale <0.8, 3.0, 1.5>
    translate  <-0.5, 35.0, -9.2>
  }
  superellipsoid { // Arm1
    <0.3, 0.25>
    scale <0.8, 3.0, 1.5>
    translate  <-7.5, 35.0, -9.2>
  }
  superellipsoid { // ChairSeat
    <0.3, 0.1>
    scale <2.7, 2.3, 0.5>
    translate  <-4.0, 34.11964, -9.263036>
  }
  superellipsoid { // ChairBase
    <0.1, 0.1>
    scale <4.0, 3.0, 1.5>
    translate  <-4.0, 35.0, -11.2>
  }
  translate  0.2*x
  texture {
    ChairTexture
  }
}


#declare WallMinus8 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 8.5, -13.0>
}
#declare WallMinus9 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 5.5, -13.0>
}
#declare WallMinus10 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 2.5, -13.0>
}
#declare WallMinus11 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 11.5, -13.0>
}
#declare WallMinus12 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 14.5, -13.0>
}
difference { // BackWallCSG
  box { // BackWall
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 20.0, 10.0>
    translate  <-12.0, 20.5, -3.5>
  }
  object { WallMinus8 }
  object { WallMinus9 }
  object { WallMinus10 }
  object { WallMinus11 }
  object { WallMinus12 }
  texture {
    DMFWood5
    scale 5.0
  translate <-12.907632, 18.248352, 0.000000>
  }
  rotate -90.0*z
  translate  <-12.5, 28.0, 0.0>
}


#declare WallMinus1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 29.0, -13.0>
}
#declare WallMinus2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 32.0, -13.0>
}
#declare WallMinus3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 35.0, -13.0>
}
#declare WallMinus4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 38.0, -13.0>
}
#declare WallMinus5 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.0, -0.111837>,
  <0.202014, -0.191881>,
  <0.619753, -0.659574>,
  <0.619753, 0.659574>,
  <0.202014, 0.209837>,
  <-1.0, 0.111837>,
  <-1.0, -0.111837>
  rotate -x*90
  scale <0.2, 0.2, 18.0>
  translate  <-11.9, 26.0, -13.0>
}
difference { // SideWallCSG
  box { // SideWall
    <-1, -1, -1>, <1, 1, 1>
    scale <0.2, 20.0, 10.0>
    translate  <-12.0, 20.5, -3.5>
  }
  object { WallMinus1 }
  object { WallMinus2 }
  object { WallMinus3 }
  object { WallMinus4 }
  object { WallMinus5 }
  texture {
    DMFWood5
    scale 5.0
  translate <-12.907632, 18.248352, 0.000000>
  }
}


cylinder { // FloorLampStan2
  <0,0,1>, <0,0,0>, 1 
  texture {
    LampSilver2
  }
  scale <1.0, 1.0, 0.2>
  translate  <-9.5, 37.5, -12.8>
}


cylinder { // FloorLampStand1
  <0,0,1>, <0,0,0>, 1 
  texture {
    LampSilver
  }
  scale <0.12, 0.12, 11.0>
  translate  <-9.5, 37.5, -12.8>
}


box { // Ceiling
  <-1, -1, -1>, <1, 1, 1>
  scale <20.0, 20.0, 0.2>
  translate  <7.8, 20.5, 3.5>
  texture {
    FloorTexture
  }
}


box { // Floor
  <-1, -1, -1>, <1, 1, 1>
  scale <20.0, 20.0, 0.2>
  translate  <7.8, 20.5, -13.0>
  texture {
    FloorTexture
  }
}


box { // DeskTop
  <-1, -1, -1>, <1, 1, 1>
  texture {
    DMFWood4
    scale <0.5, 15.0, 0.2>
    rotate <-90.0, 0.0, -5.760888>
  translate <1.102195, 0.630413, -2.803534>
  }
  scale <5.0, 3.0, 0.2>
  translate  <0.0, 3.5, -6.8>
}


#declare LampArmPiece1 = union {
  superellipsoid { // ArmPiece1
    <0.2, 0.02>
    scale <0.05, 0.07, 2.5>
    translate  2.4*z
    texture {
      WhiteMetalTex
    }
  }
  cylinder { // Pin1
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  0.1*x
  }
  cylinder { // Pin_b_1
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  <0.1, 0.0, 4.8>
  }
  rotate -15.0*x
  translate  <0.0, 0.15, 0.5>
}
#declare LampArmPiece2 = union {
  superellipsoid { // ArmPiece2
    <0.2, 0.02>
    scale <0.05, 0.07, 2.5>
    translate  2.4*z
    texture {
      WhiteMetalTex
    }
  }
  cylinder { // Pin2
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  0.1*x
  }
  cylinder { // Pin_b_2
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  <0.1, 0.0, 4.8>
  }
  rotate -15.0*x
  translate  <0.0, -0.15, 0.5>
}
#declare LampArmPiece3 = union {
  superellipsoid { // ArmPiece3
    <0.2, 0.02>
    scale <0.05, 0.07, 2.5>
    translate  2.4*z
    texture {
      WhiteMetalTex
    }
  }
  cylinder { // Pin3
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  0.1*x
  }
  cylinder { // Pin_b_3
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  <0.1, 0.0, 4.8>
  }
  rotate 106.0*x
  translate  <0.0, 1.2, 5.65>
}
#declare LampArmPiece4 = union {
  superellipsoid { // ArmPiece4
    <0.2, 0.02>
    scale <0.05, 0.07, 2.5>
    translate  2.4*z
    texture {
      WhiteMetalTex
    }
  }
  cylinder { // Pin4
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  0.1*x
  }
  cylinder { // Pin_b_4
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  <0.1, 0.0, 4.8>
  }
  rotate 106.0*x
  translate  <0.0, 1.0, 5.4>
}
#declare SwivelPiece1 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.707973, -0.867365>,
  <-0.503434, -1.000392>,
  <0.902872, -0.375767>,
  <0.988865, -0.161777>,
  <0.854277, 0.425292>,
  <0.696783, 0.570294>,
  <-0.803733, 0.900607>,
  <-0.968268, 0.76698>,
  <-0.707973, -0.867365>
  rotate -x*90
  texture {
    WhiteMetalTex
  }
  scale <0.3, 0.4, 0.01>
  rotate <90.0, 30.184561, -90.0>
  translate  <-0.06, 1.2, 5.35>
}
#declare SwivelPiece2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.707973, -0.867365>,
  <-0.503434, -1.000392>,
  <0.902872, -0.375767>,
  <0.988865, -0.161777>,
  <0.854277, 0.425292>,
  <0.696783, 0.570294>,
  <-0.803733, 0.900607>,
  <-0.968268, 0.76698>,
  <-0.707973, -0.867365>
  rotate -x*90
  texture {
    WhiteMetalTex
  }
  scale <0.3, 0.4, 0.01>
  rotate <90.0, 30.184561, -90.0>
  translate  <0.07, 1.2, 5.35>
}
#declare SwivelPiece3 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.655641, -0.589946>,
  <-0.472039, -0.733441>,
  <0.465414, -0.426647>,
  <0.624684, -0.270232>,
  <0.625447, 0.299435>,
  <0.467953, 0.444437>,
  <-0.458393, 0.794116>,
  <-0.659566, 0.676191>,
  <-0.655641, -0.589946>
  rotate -x*90
  texture {
    WhiteMetalTex
  }
  scale <0.3, 0.4, 0.01>
  rotate <90.0, -40.475006, -90.0>
  translate  <0.07, -3.64, 4.24>
}
#declare SwivelPiece4 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-0.655641, -0.589946>,
  <-0.472039, -0.733441>,
  <0.465414, -0.426647>,
  <0.624684, -0.270232>,
  <0.625447, 0.299435>,
  <0.467953, 0.444437>,
  <-0.458393, 0.794116>,
  <-0.659566, 0.676191>,
  <-0.655641, -0.589946>
  rotate -x*90
  texture {
    WhiteMetalTex
  }
  scale <0.3, 0.4, 0.01>
  rotate <90.0, -40.475006, -90.0>
  translate  <-0.06, -3.64, 4.24>
}
#declare LampShadeU = union {
  cone { // LampCone1
    <0,0,0>, 0.5, <0,0,1>, 0.4
    translate  -0.5*z
  }
  cone { // LampCone2
    <0,0,0>, 1.0, <0,0,1>, 0.5
    translate  -1.52*z
  }
  sphere { // LampShadeSph1
    <0,0,0>,1
    scale <0.5, 0.5, 0.1>
    translate  -0.5*z
  }
  sphere { // LampShadeSph2
    <0,0,0>,1
    scale <0.4, 0.4, 0.1>
    translate  0.5*z
  }
  cylinder { // Pin_b_5
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.2>
    rotate <0.0, -90.0, 0.0>
    translate  <0.1, 0.8, 0.0>
  }
  cylinder { // Pin_b_6
    <0,0,1>, <0,0,0>, 1 
    texture {
      PinTex
    }
    scale <0.03, 0.03, 0.4>
    rotate 90.0*x
    translate  0.8*y
  }
  cylinder { // Switch2
    <0,0,1>, <0,0,0>, 1 
    texture {
      Switch2Tex
    }
    scale <0.03, 0.03, 0.3>
    translate  0.55*z
  }
  cylinder { // Switch1
    <0,0,1>, <0,0,0>, 1 
    texture {
      Switch1Tex
    }
    scale 0.1
    translate  0.55*z
  }
  translate  -0.8*y
}
#declare LampShadeDif = difference {
  object { LampShadeU }
  cylinder { // HoleChop1
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    translate  <0.2, -0.8, 0.3>
  }
  cylinder { // HoleChop2
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate -45.0*z
    translate  <0.141421, -0.941421, 0.3>
  }
  cylinder { // HoleChop3
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate -90.0*z
    translate  <0.0, -1.0, 0.3>
  }
  cylinder { // HoleChop4
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate -135.0*z
    translate  <-0.141421, -0.941421, 0.3>
  }
  cylinder { // HoleChop5
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate -180.0*z
    translate  <-0.2, -0.8, 0.3>
  }
  cylinder { // HoleChop6
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate 135.0*z
    translate  <-0.141421, -0.658579, 0.3>
  }
  cylinder { // HoleChop7
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate 90.0*z
    translate  <0.0, -0.6, 0.3>
  }
  cylinder { // HoleChop8
    <0,0,1>, <0,0,0>, 1 
    scale <0.05, 0.05, 0.35>
    rotate 45.0*z
    translate  <0.141421, -0.658579, 0.3>
  }
  cone { // LampCone3
    <0,0,0>, 1.0, <0,0,1>, 0.5
    scale <0.99, 0.99, 1.0>
    translate  <0.0, -0.8, -1.6>
  }
  cone { // LampCone4
    <0,0,0>, 0.4, <0,0,1>, 0.45
    scale <0.95, 0.95, 1.5>
    rotate -180.0*x
    translate  <0.0, -0.8, 0.5>
  }
  texture {
    WhiteMetalTex
  }
}
#declare LampWithLight = union {
  object { LampShadeDif }
  rotate -5.0*x
  translate  <0.0, -3.726909, 4.317887>
}
union { // DeskLamp
  box { // BasePiece1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WhiteMetalTex
    }
    scale <0.01, 0.4, 0.3>
    translate  <-0.08, 0.0, 0.3>
  }
  box { // BasePiece2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WhiteMetalTex
    }
    scale <0.01, 0.4, 0.3>
    translate  <0.08, 0.0, 0.3>
  }
  box { // BasePiece3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WhitePlastic
    }
    scale <0.2, 0.45, 0.1>
    translate  0.1*z
  }
  object { LampArmPiece1 }
  object { LampArmPiece2 }
  object { LampArmPiece3 }
  object { LampArmPiece4 }
  object { SwivelPiece1 }
  object { SwivelPiece2 }
  object { SwivelPiece3 }
  object { SwivelPiece4 }
  object { LampWithLight }
  scale 0.6
  rotate 140.0*z
  translate  <-1.0, 1.1, -6.6>
}


sphere { // SnowOnWindow
  <0,0,0>,1
  texture {
    WindowSnowTex
  }
  hollow
  scale <2.0, 0.4, 0.1>
  translate  <0.0, -0.258814, -6.496253>
}


box { // Background
  <-1, -1, -1>, <1, 1, 1>
  texture {
    BackgroundTex
    scale <2.0, 2.0, 1.0>
  translate <-1.000000, -1.000000, 0.000000>
  }
  no_shadow
  scale <20.0, 17.0, 0.1>
  rotate <90.0, 0.0, -180.0>
  translate  <-0.977339, -61.482246, -12.221174>
}


