#declare Down_Lights = on
#declare Show_Sierp = on
#declare Show_Dust = on

#include "shapes.inc"
#include "colors.inc"
#include "textures.inc"
#include "stones1.inc"
#include "metals.inc"

global_settings{ max_trace_level 20 adc_bailout 0.12}

#declare ft=12

#include "candle.inc"
#include "sierp.inc"

background{ color rgb<0.7,0.7,0.8> };

camera
    {
    location <-30*ft, -30*ft, 6*ft>
    direction <0,0,0.8>
    sky <0,0,1>
    look_at <0,0,6*ft>
    }

light_source{ <0,250*ft,150*ft> color White }
//light_source{ <0,0,49*ft> color White/2 atmosphere off }


atmosphere
    {
    type 1
    samples 50
    distance 200*ft
    scattering 0.0005
    //aa_level 4
    //aa_threshold 0.1
    jitter 0.02
    }

// Hollow room 100' x 100' x 50'
#declare room = difference
    {
    box {<-(50*ft+1),-(50*ft+1),-1><50*ft+1,50*ft+1,50*ft+1>}
    box {<-(50*ft),  -(50*ft),   0><50*ft,  50*ft,  50*ft>}
    // Window cutout
    box {<-20*ft,50*ft-1,10*ft><20*ft,50*ft+2,40*ft>}
    texture{ T_Stone17 finish{reflection 0} }
    hollow
    }

#if (Show_Dust = on)
box {
    -1 1
    hollow
    texture
        {
        pigment { color Clear }
        finish { ambient 0 diffuse 0 refraction 1 }
    
        halo 
            {
            poly
            //attenuating
            dust 
            box_mapping
            max_value 1
            exponent 0.3
            color_map
                {
                [0.0  color rgbft<0,0,0,0,1> ]
                //[0.7  color rgbft<0,0,0,0,1> ]
                //[1.0 color rgbft <0.9, 0.9, 0.9, 0.5, 0.995>]
                [1 color rgbft<0.9,0.9,0.9,1,0.3> ]
                }
            turbulence 1.5
            octaves 6
            lambda 1
            omega 1/4
            samples 50
            //aa_level 0
            //aa_threshold 0.3
            }
        }
    scale <50*ft,50*ft,25*ft>
    translate z*25*ft
    finish{ ambient 1 }
    }
#end

object {room}


//sphere{<-20*ft,50*ft,10*ft> 1*ft texture{T_Grnt25}}
//sphere{<20*ft,50*ft,10*ft> 1*ft texture{T_Grnt25}}
//sphere{<-20*ft,50*ft,40*ft> 1*ft texture{T_Grnt25}}
//sphere{<20*ft,50*ft,40*ft> 1*ft texture{T_Grnt25}}

box 
    {
    <-20*ft,50*ft+0.25,10*ft><20*ft,50*ft+0.255,40*ft>
    texture
        {
        pigment
            {
            image_map
                { 
                gif "crystal.gif" 
                filter all 1
                transmit all 0.2
                once 
                }
            rotate y*90
            translate z
            rotate z*-90
            scale <40*ft,1,30*ft>
            translate<-20*ft,50*ft+0.25,10*ft>
            }
        finish{ ambient 2 refraction 1 }
        }
    }

// All the stuff around the perimeter
#declare Column = union
    {
    cylinder { 0  z*50*ft 1*ft }
    torus{ 1*ft 3 rotate x*90 translate z*6 }
    torus{ 1*ft 3 rotate x*90 translate z*2 }
    torus{ 1*ft 3 rotate x*90 translate z*(50*ft-6) }
    torus{ 1*ft 3 rotate x*90 translate z*(50*ft-2) }
    texture{ T_Stone14 }
    }


#declare i = -45*ft
#while( i < 45*ft )
#if (Down_Lights=on)
light_source 
    { 
    <i+5*ft,40*ft,48*ft> 
    color Orange+White/4
    spotlight
    point_at <i+5*ft,40*ft,0*ft> 
    radius 5
    falloff 10
    fade_distance 10*ft fade_power 2
    }
//light_source 
//    { 
//    <i+5*ft,-40*ft,48*ft> 
//    color Orange+White/4
//    spotlight
//    point_at <i+5*ft,-40*ft,0*ft> 
//    radius 5
//    falloff 10
//    fade_distance 10*ft fade_power 2
//    }
light_source 
    { 
    <40*ft,i+5*ft,48*ft> 
    color Orange+White/4
    spotlight
    point_at <40*ft,i+5*ft,0*ft> 
    radius 5
    falloff 10
    fade_distance 10*ft fade_power 2
    }
//light_source 
//    { 
//    <-40*ft,i+5*ft,48*ft> 
//    color Orange+White/4
//    spotlight
//    point_at <-40*ft,i+5*ft,0*ft> 
//    radius 5
//    falloff 10
//    fade_distance 10*ft fade_power 2
//    }
#end
object {Column translate<i,50*ft,0> }
//object {Column translate<i,-50*ft,0> }
object {Column translate< 50*ft,i,0> }
//object {Column translate<-50*ft,i,0> }
object {Candle scale 2*ft translate<i,48*ft,12*ft> }
object {Candle scale 2*ft translate<48*ft,i,12*ft> }
#declare i = i + 10*ft
#end

#if (Show_Sierp=on)


union{
object {
    sierpinski
    texture { Green_Glass }
    finish{ ambient 0.15 }
    }
    
//    sphere { <  1.0000,  0.0000,  0.0000> 0.03  }
//    sphere { < -1.0000,  0.0000,  0.0000> 0.03  }
//    sphere { <  0.0000,  0.8660,  1.0000> 0.03  }
//    sphere { <  0.0000,  1.7321,  0.0000> 0.03  }
    
#declare top_point = <  0.0000,  0.8660,  1.0000>

    light_source 
        { 
        <0.5,0.5,0.1> 
        color Orange+White/4
        spotlight
        point_at top_point
        radius 10
        falloff 20
        fade_distance 10*ft fade_power 2
        }
    light_source 
        { 
        <-0.5,0.5,0.1> 
        color Orange+White/4
        spotlight
        point_at top_point
        radius 10
        falloff 20
        fade_distance 10*ft fade_power 2
        }
    light_source 
        { 
        <0,(sqrt(3)/2)*0.75,0.1> 
        color Orange+White/4
        spotlight
        point_at top_point
        radius 10
        falloff 20
        fade_distance 10*ft fade_power 2
        }
    light_source 
        { 
        <0,top_point.y,0.1> 
        color Orange+White/4
        spotlight
        point_at top_point
        radius 30
        falloff 35
        fade_distance 15*ft fade_power 2
        }
    rotate x*180
    scale 15*ft
    translate <15*ft,25*ft,40*ft>
    }

#end
