//  Persistance of Vision Raytracer V2.0
//  World definition file.
//
//  Date : 02/16/1997    (16.02.1997)
//


#include "colors.inc"
#include "textures.inc"
#include "glass.inc"
#include "shapes.inc"

#declare DETAIL=1

camera {  //  Camera camera1
  location  <-10, -25, 5>
  direction <0.0,     0.0,  5.9980>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.3333,  0.0,  0.0>
  look_at   <-0.000, -4.000, .5>
}

// *******  L I G H T S *******
  light_source {
    <16.107, -3.188, 9.122>
    color  red 1.000 green 1.000 blue 1.000
  }

  light_source {
    <18.500, 39.000, 14.000>
    color  red 1.000 green 1.000 blue 1.000
  }

  light_source {
    <-20, -20, 20>
    color  White
  }




// *******  T E X T U R E S  *******
#declare txtRivet =
texture{
	Rust
	finish {
		crand 0.05
		ambient   0.40
		diffuse   0.50
		brilliance   1.00
		phong   0.70
		phong_size  20.00
		metallic
		reflection  0.100
 		}
	}



// ********  O B J E C T S *******

cylinder{ // Axe X
		<1, 0, 0>, <0, 0, 0>,1
		texture {
			pigment {color Blue}
			finish{ambient 1.0}
			}
		scale <20,.01,.01>
		translate<-10,0,0>
		}

cylinder{ // axe Y
		<0, 1, 0>, <0, 0, 0>,1
		texture {
			pigment {color Red}
			finish{ambient 1.0}
			}
		scale <.01,20,.01>
		translate<0,-10,0>
		}
/*
plane{y,0
		translate <0,20,0>
		pigment{checker color Red color Blue}
		}
*/
// Plan
plane{z,-0.00000001
	pigment{checker color White color Green}
	}


// ********  O B J E C T S *******


// ********  V E R R E   A   F A C E T T E S *******
#if (DETAIL=1)
	#declare Facette01=
	intersection{
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <1.4,2,2>
			translate<0,-1,0>
			}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,22.5>
			}
		plane{z,0
			}
		}

	#declare Facette02_01=
	difference{
		box{
			<0,-.25, -.5>, <.5, .25, .5>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.2,1.2,.2>
			translate<.5,-.6,.5>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.2,1.2,.2>
			translate<.5,-.6,-.5>
			}
		}

		#declare Facette02=
		intersection{
			object{
				Facette02_01
				}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,+22.5>
			}
		}

	#declare Facette03_01=
	difference{
		box{
			<0,-.25, -1>, <.5, .25, 1>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.3,1.2,.2>
			translate<.5,-.6,1>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.25,1.2,2>
			translate<.5,-.6,-1>
			}
		}

	#declare Facette03=
	intersection{
		object{
			Facette03_01
			}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,+22.5>
			}
		}

	#declare Facette04_01=
	difference{
		box{
			<0,-.5, 0>, <1, .5, .5>
			}
		cylinder{
			<0, 1, 0>, <0, 0, 0>,1
			scale <.8,1.2,.4>
			translate<1,-.6,.45>
			}
		}

	#declare Facette04=
	intersection{
		object{
			Facette04_01
			}
		plane{y,0 inverse
			rotate <0,0,-22.5>
			}
		plane{y,0
			rotate <0,0,+22.5>
			}
		}
#end

#declare VERRE01_SUB=	// ** Vasque pleine
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette01
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	intersection{
		sphere{
			<0, 0, 0>,1
			scale <1.4,1.4,2>
			//translate<0,-1,0>
			}
		plane{z,0
			}
		}
#end


#declare VERRE02_SUB= // ** Base/Pied
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette02
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	box{
		<-.5,-.5, -.5>, <.5, .5, .5>
		}
#end

#declare VERRE03_SUB= // ** Pied
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette03
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	box{
		<-.25,-.25, -1>, <.25, .25, 1>
		}
#end

#declare VERRE04_SUB= // ** Base
#if (DETAIL=1)
	merge{
		#declare NbMarcheMax=8
		#declare NbMarche=0
		#while (NbMarche <=NbMarcheMax-1)
			object {
				Facette04
				rotate<0,0,NbMarche*45>
				}
			#declare NbMarche=NbMarche+1
		#end
	}
#else
	cylinder{
		<0,0,1>, <0, 0,0>,1
		scale <1,1,.5>
		}
#end

#declare VERRE01=	// ** Vasque du verre
object{	VERRE01_SUB
	clipped_by{
		object{
			VERRE01_SUB inverse
			translate <0,0,0.1>
			}
		}
	}

#declare VERRE= // ** Assemblage du verre
merge{
	object {
		VERRE03_SUB
		scale <.7,.7,.7>
		translate <0,0,1.4>
		}
	object {
		VERRE04_SUB
		}
	object {
		VERRE01
		scale <.9,.9,.9>
		translate <0,0,3.9>
		}
	object {VERRE02_SUB  // Facette02
		scale <.6,.6,.6>
		translate <0,0,.7>
		}
//		texture{T_Glass3}
		texture{pigment{color Yellow}}
	}

// ********  P O S I T I O N N E M E N T   D E S   O B J E C T S *******

object {VERRE} 					// ** Verre debout
object {VERRE					// ** Verre Renvers
		rotate <86,0,-45>
		translate <4,-2,1>
		}


// ********** FLAQUE
 blob {
    threshold 0.6
    sphere { <0, -4, 0>, 1.2, 1 }
    sphere { <0, -5, 0>, 1.5, 1 }
    sphere { <.5, -6, 0>, 2, 1 }
	sphere { <-1, -6.5, 0>, 1, 1 }
    scale <1,1,.2>
	pigment{color Blue}
    finish { ambient 0.3 diffuse 0.7 phong 1.0 phong_size 90 }
	}

 blob {
    threshold 0.6
    sphere { <0, -4, 0>, 1.1, 1 }
    sphere { <0, -5, 0>, 1.2, 1 }
	sphere { <-1, -6.5, 0>, 1, 1 }
    scale <1,1,.2>
	pigment{color Blue}
    finish { ambient 0.3 diffuse 0.7 phong 1.0 phong_size 90 }
	translate <-3,-2,0>
	}


/*
sphere{<0,0,0>,1
		scale<1,1.2,.2>
		rotate <0,0,45>
		translate<0,-4,.05>
		pigment{color Red}
		}
sphere{<0,0,0>,1
		scale<1.2,1.5,.2>
		rotate <0,0,-45>
		translate<0,-5,.05>
		pigment{color Red}
		}
sphere{<0,0,0>,1
		scale<1.2,2,.2>
		rotate <0,0,40>
		translate<.5,-6,.05>
		pigment{color Red}
		}

*/












