//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 12 lights, 31 textures and 856 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 12/22/1996    (22.12.1996)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray V2.0 exports for POV-Ray.
//





global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.6
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 30
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }

atmosphere {
  type 1    // Isotropic
  distance     20.0
  color <0.0,0.0,0.0,0.0,1.0>
  scattering   0.05
  samples      20
  jitter       0.0
  aa_threshold 1.0
  aa_level     3.0
}

camera {  //  Camera StdCam
  location  <-30.594, -27.067, 12.305>
  direction <0.0,     0.0,  1.6807>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <12.179, -0.312, 6.557>
}

//    Other cameras are commented out.
/*
camera {  //  Camera SpotCam001
  location  <163.137, 101.936, -7.834> // Attached to SpotL001
  direction <0.0,     0.0,  0.8662>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <163.527, 101.711, -7.574> // Following SpotL001
}

*/

/*
camera {  //  Camera SpotCam02
  location  <232.479, 132.760, -7.732> // Attached to SpotL2
  direction <0.0,     0.0,  0.8662>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <232.560, 132.364, -7.405> // Following SpotL2
}

*/

/*
camera {  //  Camera SpotCam03
  location  <282.792, 76.776, -7.939> // Attached to SpotL3
  direction <0.0,     0.0,  1.8665>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <282.328, 76.914, -7.750> // Following SpotL3
}

*/

/*
camera {  //  Camera SpotCam04
  location  <244.769, 10.870, -7.879> // Attached to SpotL4
  direction <0.0,     0.0,  1.3741>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <244.428, 11.188, -7.649> // Following SpotL4
}

*/

/*
camera {  //  Camera SpotCam05
  location  <171.122, 26.624, -7.834> // Attached to SpotL5
  direction <0.0,     0.0,  1.3741>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <171.510, 26.853, -7.575> // Following SpotL5
}

*/

/*
camera {  //  Camera TestCam
  location  <-20.505, -13.826, 10.025>
  direction <0.0,     0.0,  5.4631>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  look_at   <-13.909, -7.785, 5.424>
}

*/

// *******  L I G H T S *******
light_source {   // Spotlight Sw_Licht2
  <-15.406, -19.216, 22.892>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-15.256, -18.924, 22.683>
    falloff   20.0  // outer radius (in deg)
      radius    12.5  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight Sw_Licht3
  <-2.488, -19.678, 22.669>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-2.488, -19.678, 22.269>
    falloff   23.0  // outer radius (in deg)
      radius    17.0  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight Sw_Licht4
  <13.546, -19.213, 22.894>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <13.496, -18.953, 22.599>
    falloff   20.0  // outer radius (in deg)
      radius    11.0  // inner radius
  atmospheric_attenuation on
}

light_source { // AreaL001
  <-28.801, -5.374, 22.406>
  color  rgb<0.796, 0.796, 0.592>
  area_light <2.000, 0.000, 0.000>, <0.000, 40.696, 0.000>, 2, 2
  adaptive 1
  jitter
  atmosphere off
}


light_source {   // Spotlight SpotL001
  <163.137, 101.936, -7.834>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <163.527, 101.711, -7.574>
    falloff   30.0  // outer radius (in deg)
      radius    15.0  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL2
  <232.479, 132.760, -7.732>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <232.560, 132.364, -7.405>
    falloff   30.0  // outer radius (in deg)
      radius    15.0  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL3
  <282.792, 76.776, -7.939>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <282.328, 76.914, -7.750>
    falloff   15.0  // outer radius (in deg)
      radius    10.0  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL4
  <244.769, 10.870, -7.879>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <244.428, 11.188, -7.649>
    falloff   20.0  // outer radius (in deg)
      radius    10.0  // inner radius
  atmosphere off
}

light_source {   // Spotlight SpotL5
  <171.122, 26.624, -7.834>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <171.510, 26.853, -7.575>
    falloff   20.0  // outer radius (in deg)
      radius    10.0  // inner radius
  atmosphere off
}

light_source {   // Spotlight Sw_Licht1
  <1.138, 0.948, 0.091>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <1.413, 0.827, 0.355>
    falloff   35.0  // outer radius (in deg)
      radius    22.5  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight Sw_Licht
  <-4.914, -7.740, 0.338>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <-5.028, -7.646, 0.709>
    falloff   25.0  // outer radius (in deg)
      radius    17.5  // inner radius
  atmospheric_attenuation on
}

light_source {   // Spotlight Sw_Licht5
  <4.377, 7.487, 0.197>
  color  rgb <1.000, 1.000, 1.000>
  spotlight
    point_at  <4.380, 7.775, 0.474>
    falloff   25.0  // outer radius (in deg)
      radius    17.5  // inner radius
  atmospheric_attenuation on
}


// ********  TEXTURES  *******
//

#include "tkp2f.inc"
#include "flhalos.pov"



// ********  REFERENCED OBJECTS  *******

#declare Ring = object {
  torus { // Ring
    4.75, 0.25  rotate -x*90
    texture {
      Polished_Chro2
    }
    rotate <-90.0, 0.0, -45.0>
    translate  <168.843941, 19.773914, -9.959508>
  }
}
#declare Landelicht = object {
  sphere { // Landelicht
    <0,0,0>,1
    texture {
      LandelichtBlau_Tex
    }
    scale 0.5
    translate  <0.0, 60.0, 2.0>
  }
}
#declare LandelichtGrpN = union {
  object { Landelicht }
  object { // Landelicht1->Landelicht
    Landelicht
    translate  -20.0*y
  }
  object { // Landelicht2->Landelicht
    Landelicht
    translate  -40.0*y
  }
  object { // Landelicht4->Landelicht
    Landelicht
    translate  -80.0*y
  }
  object { // Landelicht5->Landelicht
    Landelicht
    translate  -100.0*y
  }
  object { // Landelicht6->Landelicht
    Landelicht
    translate  -120.0*y
  }
}
#declare Landelicht3 = object {
  sphere { // Landelicht3
    <0,0,0>,1
    texture {
      LandelichtOrange_Tex
    }
    scale 0.5
    translate  <0.0, 67.0, 2.0>
  }
}

#declare Querstrebe1 = object {
  cylinder { // Querstrebe1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 12.140728>
    rotate 90.0*y
    translate  <-6.0, 0.0, -9.7>
  }
}
#declare Seil1 = object {
  cylinder { // Seil1
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 18.0>
    rotate -53.0*x
    translate  <0.0, 7.5, -9.7>
    texture {
      SeilTex
    }
  }
}
#declare FluegelStoff = difference {
  box { // Schraubenteil
    <-1, -1, -1>, <1, 1, 1>
    scale <3.5, 10.0, 0.12>
    translate  <3.4, 10.0, 0.3>
  }
  plane { // CutTeil
    z,0
    rotate <90.0, 0.0, -10.0>
    translate  20.0*y
  }
  plane { // CutTeil1
    z,0
    rotate <90.0, 0.0, -100.0>
    translate  <3.781204, 19.650882, -0.042866>
  }
  texture {
    LeatherTex1
  }
}
#declare FluegelTeil = union {
  cylinder { // Rohr
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFLightOak3
    }
    scale <0.3, 0.3, 22.0>
    rotate -90.0*x
    translate  -2.0*y
  }
  object { FluegelStoff }
  rotate <-7.0, 0.0, 0.0>
  translate  <0.674586, 2.161792, 3.5>
}


#declare ParaRohr = object {
  cylinder { // ParaRohr
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFDarkOak3
    }
    scale <0.1, 0.1, 4.9>
    rotate <-150.77417, 20.836861, -167.506409>
  }
}
#declare ParaSeil = object {
  cylinder { // ParaSeil
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFLightOak3
    }
    scale <0.02, 0.02, 4.8>
    rotate <-150.77417, 20.836861, -167.506409>
  }
}


#declare Lehne = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.700000, 0.400000, 0.200000>, <-0.600000, 0.300000, 0.200000>, <-0.600000, 0.200000, 0.000000>, <0.000000, 0.200000, 0.000000>,
      <-1.000000, 0.450000, 0.500000>, <-1.000000, 0.300000, 0.500000>, <-0.600000, 0.200000, 0.500000>, <0.000000, 0.200000, 0.500000>,
      <-1.000000, 0.450000, 1.000000>, <-1.000000, 0.300000, 1.000000>, <-0.600000, 0.200000, 1.000000>, <0.000000, 0.200000, 1.000000>,
      <-0.700000, 0.400000, 1.200000>, <-0.700000, 0.300000, 1.200000>, <-0.600000, 0.200000, 1.500000>, <0.000000, 0.200000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.200000, 0.000000>, <0.600000, 0.200000, 0.000000>, <0.600000, 0.300000, 0.200000>, <0.700000, 0.400000, 0.200000>,
      <0.000000, 0.200000, 0.500000>, <0.600000, 0.200000, 0.500000>, <1.000000, 0.300000, 0.500000>, <1.000000, 0.450000, 0.500000>,
      <0.000000, 0.200000, 1.000000>, <0.600000, 0.200000, 1.000000>, <1.000000, 0.300000, 1.000000>, <1.000000, 0.450000, 1.000000>,
      <0.000000, 0.200000, 1.500000>, <0.600000, 0.200000, 1.500000>, <0.700000, 0.300000, 1.200000>, <0.700000, 0.400000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.700000, 0.400000, 0.200000>, <0.800000, 0.500000, 0.200000>, <0.600000, 0.198695, 0.000000>, <0.000000, 0.198695, 0.000000>,
      <1.000000, 0.450000, 0.500000>, <1.000000, 0.600000, 0.500000>, <0.600000, 0.300000, 0.500000>, <0.000000, 0.300000, 0.500000>,
      <1.000000, 0.450000, 1.000000>, <1.000000, 0.600000, 1.000000>, <0.600000, 0.300000, 1.000000>, <0.000000, 0.300000, 1.000000>,
      <0.700000, 0.400000, 1.200000>, <0.700000, 0.500000, 1.200000>, <0.600000, 0.201675, 1.500000>, <0.000000, 0.201675, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.198695, 0.000000>, <-0.600000, 0.198695, 0.000000>, <-0.800000, 0.500000, 0.200000>, <-0.700000, 0.400000, 0.200000>,
      <0.000000, 0.300000, 0.500000>, <-0.600000, 0.300000, 0.500000>, <-1.000000, 0.600000, 0.500000>, <-1.000000, 0.450000, 0.500000>,
      <0.000000, 0.300000, 1.000000>, <-0.600000, 0.300000, 1.000000>, <-1.000000, 0.600000, 1.000000>, <-1.000000, 0.450000, 1.000000>,
      <0.000000, 0.201675, 1.500000>, <-0.600000, 0.201675, 1.500000>, <-0.700000, 0.500000, 1.200000>, <-0.700000, 0.400000, 1.200000>
    }
  }
  texture {
    Seat_Tex
  }
  scale 0.9
  rotate 180.0*z
  translate  0.362728*y
}
#declare Sitzflaeche = union {
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <-0.700000, 0.400000, 0.200000>, <-0.600000, 0.300000, 0.200000>, <-0.600000, 0.200000, 0.000000>, <0.000000, 0.200000, 0.000000>,
      <-1.000000, 0.450000, 0.500000>, <-1.000000, 0.300000, 0.500000>, <-0.600000, 0.200000, 0.500000>, <0.000000, 0.200000, 0.500000>,
      <-1.000000, 0.450000, 1.000000>, <-1.000000, 0.300000, 1.000000>, <-0.600000, 0.200000, 1.000000>, <0.000000, 0.200000, 1.000000>,
      <-0.700000, 0.400000, 1.200000>, <-0.700000, 0.300000, 1.200000>, <-0.600000, 0.200000, 1.500000>, <0.000000, 0.200000, 1.500000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.200000, 0.000000>, <0.600000, 0.200000, 0.000000>, <0.600000, 0.300000, 0.200000>, <0.700000, 0.400000, 0.200000>,
      <0.000000, 0.200000, 0.500000>, <0.600000, 0.200000, 0.500000>, <1.000000, 0.300000, 0.500000>, <1.000000, 0.450000, 0.500000>,
      <0.000000, 0.200000, 1.000000>, <0.600000, 0.200000, 1.000000>, <1.000000, 0.300000, 1.000000>, <1.000000, 0.450000, 1.000000>,
      <0.000000, 0.200000, 1.500000>, <0.600000, 0.200000, 1.500000>, <0.700000, 0.300000, 1.200000>, <0.700000, 0.400000, 1.200000>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.700000, 0.400000, 0.200000>, <0.800000, 0.500000, 0.200000>, <0.600000, 0.192375, 0.000000>, <0.000000, 0.192375, 0.000000>,
      <1.000000, 0.450000, 0.500000>, <1.000000, 0.600000, 0.500000>, <0.600000, 0.300000, 0.500000>, <0.000000, 0.300000, 0.500000>,
      <1.000000, 0.450000, 1.000000>, <1.000000, 0.600000, 1.000000>, <0.600000, 0.300000, 1.000000>, <0.000000, 0.300000, 1.000000>,
      <0.700000, 0.400000, 1.200000>, <0.700000, 0.500000, 1.200000>, <0.600000, 0.201343, 1.491031>, <0.000000, 0.201343, 1.491031>
    }
  }
  object {
    bicubic_patch { type 1 flatness 0.0100 u_steps 3 v_steps 3,
      <0.000000, 0.192375, 0.000000>, <-0.600000, 0.192375, 0.000000>, <-0.800000, 0.500000, 0.200000>, <-0.700000, 0.400000, 0.200000>,
      <0.000000, 0.300000, 0.500000>, <-0.600000, 0.300000, 0.500000>, <-1.000000, 0.600000, 0.500000>, <-1.000000, 0.450000, 0.500000>,
      <0.000000, 0.300000, 1.000000>, <-0.600000, 0.300000, 1.000000>, <-1.000000, 0.600000, 1.000000>, <-1.000000, 0.450000, 1.000000>,
      <0.000000, 0.201343, 1.491031>, <-0.600000, 0.201343, 1.491031>, <-0.700000, 0.500000, 1.200000>, <-0.700000, 0.400000, 1.200000>
    }
  }
  texture {
    Seat_Tex
  }
  rotate 90.0*x
  translate  <0.0, -0.026717, -0.333961>
}
// Include contains 'TraSwp001'
#include "tkp2f.in3"

#declare TraSwp001 = object {
  TraSwp001_Raw
}
#declare Sitzhalter = difference {
  object { TraSwp001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <0.132668, 0.132668, 0.2>
    translate  <0.706834, 1.307309, -0.049847>
  }
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    scale <0.08, 0.08, 0.2>
    translate  <0.86193, 1.093935, -0.053434>
  }
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    scale <0.07, 0.07, 0.2>
    translate  <0.449788, 1.365453, -0.049847>
  }
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    scale <0.04, 0.04, 0.2>
    translate  <0.25367, 1.383282, -0.049847>
  }
  texture {
    Polished_Chro2
  }
  scale 0.6
  rotate <90.0, 0.0, 90.0>
  translate  <-0.010069, -0.264072, -1.013735>
}
// Include contains 'TraSwp2'
#include "tkp2f.in4"

#declare TraSwp2 = object {
  TraSwp2_Raw
}
#declare Lehnehalter = difference {
  object { TraSwp2 }
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    scale 0.2
    translate  <0.733652, 1.208278, -0.049847>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <0.1, 0.1, 0.2>
    translate  <0.305663, 1.311518, -0.049847>
  }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.2>
    translate  <-0.033088, 1.347176, -0.049847>
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    scale <0.05, 0.05, 0.2>
    translate  <0.840626, 0.81604, -0.049847>
  }
  texture {
    Polished_Chro2
  }
  scale 0.3
  rotate <-180.0, 90.0, 0.0>
  translate  <0.020137, 0.637205, 0.270743>
}
#declare Sitz = union {
  cylinder { // Bein2
    <0,0,1>, <0,0,0>, 1
    texture {
      Polished_Chro2
    }
    scale <0.07, 0.07, 1.0>
    translate  <0.009452, 0.395316, -1.124341>
  }
  object { Lehne }
  object { Sitzflaeche }
  object { Sitzhalter }
  object { Lehnehalter }
}
#declare Sitzgruppe = union {
  object { Sitz }
  cylinder { // Sitzgruppenstreb
    <0,0,1>, <0,0,0>, 1
    texture {
      Polished_Chro2
    }
    scale <0.1, 0.1, 10.0>
    rotate 90.0*y
    translate  <-1.112517, 0.395226, -0.126123>
  }
  object { // Sitz1->Sitz
    Sitz
    translate  2.0*x
  }
  object { // Sitz2->Sitz
    Sitz
    translate  4.0*x
  }
  object { // Sitz3->Sitz
    Sitz
    translate  6.0*x
  }
  object { // Sitz4->Sitz
    Sitz
    translate  8.0*x
  }
  scale 2.0
  rotate 180.0*z
  translate  <24.956619, -20.835343, 2.515521>
}




// ********  OBJECTS  *******

#declare Scheinwerfer2 = union {
  cylinder { // SGehaeuse22
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse23
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse24
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse25
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse26
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse27
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse28
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse29
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse30
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse31
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse32
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas2
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <128.942383, 0.870349, 172.93811>
  translate  <-7.986525, -22.250188, 23.268854>
}
#declare Scheinwerfer3 = union {
  cylinder { // SGehaeuse33
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse34
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse35
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse36
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse37
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse38
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse39
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse40
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse41
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse42
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse43
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas3
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <180.0, 0.0, 140.0>
  translate  <4.994621, -22.250188, 23.268854>
}
#declare Scheinwerfer4 = union {
  cylinder { // SGehaeuse44
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse45
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse46
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse47
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse48
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse49
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse50
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse51
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse52
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse53
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse54
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas4
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <-134.028336, -25.884544, 29.439226>
  translate  <21.081696, -22.250188, 23.268854>
}
union { // Deckenlicht
  object { Scheinwerfer2 }
  object { Scheinwerfer3 }
  object { Scheinwerfer4 }
  translate  <-7.482235, 2.572018, 0.0>
}


box { // Blende
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WandTex
  }
  scale <0.142472, 30.0, 0.864601>
  translate  <-20.630109, -4.487472, 22.083193>
}




plane { // Starfield
  z,0
  texture {
    Starfield_Tex
    scale <2.0, 2.0, 154.903381>
  translate <-0.997952, -1.002247, -0.724737>
  }
  no_shadow
  hollow
  scale <130.0, 100.0, 1.0>
  rotate <-90.0, -180.0, -45.0>
  translate  <378.593863, 134.190856, 0.0>
}


#declare CSW01 = union {
  cylinder { // SGehaeuse66
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse67
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse68
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse69
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse70
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse71
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse72
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse73
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse74
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse75
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse76
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas6
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate 60.0*y
  translate  <-65.0, 0.0, -0.363997>
}
#declare CSW2 = union {
  cylinder { // SGehaeuse77
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse78
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse79
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse80
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse81
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse82
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse83
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse84
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse85
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse86
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse87
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas7
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <-5.929344, 50.737141, -56.111786>
  translate  <-20.086105, 61.818674, -0.363997>
}
#declare CSW3 = union {
  cylinder { // SGehaeuse88
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse89
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse90
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse91
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse92
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse93
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse94
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse95
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse96
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse97
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse98
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas8
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <6.640656, 68.474655, -159.45578>
  translate  <52.586105, 38.206041, -0.363997>
}
#declare CSW4 = union {
  cylinder { // SGehaeuse99
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse100
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse101
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse102
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse103
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse104
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse105
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse106
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse107
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse108
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse109
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas9
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <-10.924983, 63.275372, 154.882751>
  translate  <52.586105, -38.206041, -0.363997>
}
#declare CSW5 = union {
  cylinder { // SGehaeuse110
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse111
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse112
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse113
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse114
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse115
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse116
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse117
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse118
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse119
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse120
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas10
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <2.284212, 60.055202, 63.189056>
  translate  <-20.086105, -61.818674, -0.363997>
}
#declare CSWGroup = union {
  object { CSW01 }
  object { CSW2 }
  object { CSW3 }
  object { CSW4 }
  object { CSW5 }
  rotate <0.0, 0.0, -30.0>
  translate  2.1*z
}
#declare GangDachCSG = difference {
  cylinder { // GangDach
    <0,0,1>, <0,0,0>, 1 open
    scale <4.0, 4.0, 135.0>
    rotate <-90.0, 0.0, -45.0>
    translate  <75.843941, -73.226086, -9.959508>
  }
  cylinder { // GangDach1
    <0,0,1>, <0,0,0>, 1 open
    scale <3.8, 3.8, 135.0>
    rotate <-90.0, 0.0, -45.0>
    translate  <75.843941, -73.226086, -9.959508>
  }
  texture {
    Glass1
  }
}
#declare GangRoehreCSG = union {
  object { Ring }
  object { GangDachCSG }
  object { // Ring1->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-7.0, -7.0, 0.0>
  }
  object { // Ring2->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-14.0, -14.0, 0.0>
  }
  object { // Ring3->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-21.0, -21.0, 0.0>
  }
  object { // Ring4->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-28.0, -28.0, 0.0>
  }
  object { // Ring5->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-35.0, -35.0, 0.0>
  }
  object { // Ring6->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-42.0, -42.0, 0.0>
  }
  object { // Ring7->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-49.0, -49.0, 0.0>
  }
  object { // Ring8->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-56.0, -56.0, 0.0>
  }
  object { // Ring9->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-63.0, -63.0, 0.0>
  }
  object { // Ring10->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-70.0, -70.0, 0.0>
  }
  object { // Ring11->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-77.0, -77.0, 0.0>
  }
  object { // Ring12->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-84.0, -84.0, 0.0>
  }
  object { // Ring13->Ring
    Ring
    rotate <0.0, 0.0, 0.0>
    translate  <-91.0, -91.0, 0.0>
  }
}
#declare GangTopCSG = difference {
  object { GangRoehreCSG }
  plane { // GangCut
    z,0
    texture {
      Polished_Chro2
    }
    translate  <77.664179, -68.913481, -10.0>
  }
  translate  <-218.843941, -69.773914, 9.959508>
}
#declare StartbaseGrp = union {
  cylinder { // Startbase
    <0,0,1>, <0,0,0>, 1
    texture {
      HullSphere_Tex
    }
    scale <70.0, 70.0, 2.0>
  }
  object { CSWGroup }
  torus { // CSWRing
    64.75, 0.25  rotate -x*90
    texture {
      Polished_Chro2
    }
    rotate <0.0, 0.0, -30.0>
    translate  2.0*z
  }
  box { // Gangboden
    <-1, -1, -1>, <1, 1, 1>
    texture {
      HullSphere_Tex
    }
    scale <5.0, 70.0, 1.0>
    rotate -45.0*z
    translate  <-95.0, -95.0, 0.0>
  }
  object { GangTopCSG }
  object { LandelichtGrpN }
  object { // LandelichtGrp1->LandelichtGrpN
    LandelichtGrpN
    rotate -90.0*z
  }
  object { Landelicht3 }
  object { // Landelicht7->Landelicht3
    Landelicht3
    rotate -30.0*z
  }
  object { // Landelicht8->Landelicht3
    Landelicht3
    rotate -60.0*z
  }
  object { // Landelicht9->Landelicht3
    Landelicht3
    rotate -90.0*z
    translate  0.0*y
  }
  object { // Landelicht10->Landelicht3
    Landelicht3
    rotate -120.0*z
    translate  0.0*y
  }
  object { // Landelicht11->Landelicht3
    Landelicht3
    rotate -150.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Landelicht12->Landelicht3
    Landelicht3
    rotate 180.0*z
    translate  0.0*x
  }
  object { // Landelicht13->Landelicht3
    Landelicht3
    rotate 150.0*z
  }
  object { // Landelicht14->Landelicht3
    Landelicht3
    rotate 120.0*z
    translate  0.0*y
  }
  object { // Landelicht15->Landelicht3
    Landelicht3
    rotate 90.0*z
    translate  0.0*y
  }
  object { // Landelicht16->Landelicht3
    Landelicht3
    rotate 60.0*z
    translate  <0.0, 0.0, 0.0>
  }
  object { // Landelicht17->Landelicht3
    Landelicht3
    rotate 30.0*z
    translate  <0.0, 0.0, 0.0>
  }
  translate  <137.295588, 50.955064, -9.959508>
}

//
// This was the place of the Comet.
//

// ---
// Halos here
// ---

#declare InnerDust = union {
  sphere { // Dust01
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.0, 1.53994, 1.896008>
    translate  <1.795858, 0.171159, 0.986727>
  }
  sphere { // Dust2
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.00075, 1.881815, 1.0>
    rotate -45.0*z
    translate  <1.627301, -1.611496, 0.986727>
  }
  sphere { // Dust3
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.166135, 1.381132, 1.448004>
    rotate -90.0*z
    translate  <-0.155991, -2.66826, 0.986727>
  }
  sphere { // Dust4
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.033956, 1.435945, 2.568015>
    rotate -135.0*z
    translate  <-1.938647, -1.853552, 0.986727>
  }
  sphere { // Dust5
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <0.920209, 1.498406, 1.336003>
    rotate 180.0*z
    translate  <-2.232059, -0.171159, 0.986727>
  }
  sphere { // Dust6
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.132535, 1.308748, 1.524604>
    rotate 135.0*z
    translate  <-2.071652, 1.720546, 0.986727>
  }
  sphere { // Dust7
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.661276, 1.496802, 1.336003>
    rotate 90.0*z
    translate  <-0.49831, 2.77731, 0.986727>
  }
  sphere { // Dust8
    <0,0,0>,1
    pigment { dPig }
    halo { InnerDustHalo }
    hollow
    scale <1.12463, 1.345271, 1.0>
    rotate 45.0*z
    translate  <1.938647, 2.180703, 0.986727>
  }
}
#declare MiddleDust = union {
  sphere { // Dust9
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <1.046956, 1.600018, 1.0>
    translate  <1.795858, 0.171159, 0.986727>
  }
  sphere { // Dust10
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <1.139724, 1.457931, 1.0>
    rotate -45.0*z
    translate  <1.853552, -1.611496, 0.986727>
  }
  sphere { // Dust11
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <0.962499, 1.606703, 1.80366>
    rotate -90.0*z
    translate  <0.549699, -2.161902, 0.986727>
  }
  sphere { // Dust12
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <1.377928, 1.311522, 0.799085>
    rotate -135.0*z
    translate  <-1.361264, -2.142899, 0.986727>
  }
  sphere { // Dust13
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <0.765219, 1.300009, 1.870631>
    rotate 180.0*z
    translate  <-2.232059, -0.171159, 0.986727>
  }
  sphere { // Dust14
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <1.126352, 1.33849, 1.468801>
    rotate 135.0*z
    translate  <-2.071652, 1.720546, 0.986727>
  }
  sphere { // Dust15
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <1.112503, 1.700615, 1.669716>
    rotate 90.0*z
    translate  <-0.177542, 3.066657, 0.986727>
  }
  sphere { // Dust16
    <0,0,0>,1
    pigment { dPig }
    halo { MiddleDustHalo }
    hollow
    scale <1.059269, 1.524112, 1.0>
    rotate 45.0*z
    translate  <1.682032, 2.542387, 0.986727>
  }
  scale <1.763352, 1.763352, 1.672365>
}
#declare OuterDust = union {
  sphere { // Dust17
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <0.879792, 1.307569, 1.0>
    translate  <1.65555, 0.762482, 0.986727>
  }
  sphere { // Dust18
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <1.244254, 2.404168, 1.552075>
    rotate -45.0*z
    translate  <1.292321, -1.738208, 0.986727>
  }
  sphere { // Dust19
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <1.0, 1.901559, 1.22083>
    rotate -90.0*z
    translate  <-0.155991, -2.66826, 0.986727>
  }
  sphere { // Dust20
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <0.818272, 1.616696, 1.36805>
    rotate -135.0*z
    translate  <-1.5528, -1.346704, 0.986727>
  }
  sphere { // Dust21
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <1.0, 1.666399, 1.772905>
    rotate 180.0*z
    translate  <-2.232059, -0.171159, 0.986727>
  }
  sphere { // Dust22
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <1.206247, 1.133752, 1.0>
    rotate 135.0*z
    translate  <-2.001499, 1.889496, 0.986727>
  }
  sphere { // Dust23
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <0.948739, 1.407895, 1.699295>
    rotate 90.0*z
    translate  <-0.49831, 2.77731, 0.986727>
  }
  sphere { // Dust24
    <0,0,0>,1
    pigment { dPig }
    halo { OuterDustHalo }
    hollow
    scale <0.88999, 1.399989, 1.22083>
    rotate 45.0*z
    translate  <1.307262, 2.518601, 0.986727>
  }
  scale <3.225065, 3.019963, 3.043092>
}
#declare AllDust = union {
  object { InnerDust }
  object { MiddleDust }
  object { OuterDust }
  scale <1.892715, 3.031991, 1.288157>
  translate  <-0.17124, 6.678376, 0.0>
}
#declare Strahlen1 = union {
  cylinder { // Strahl4
    <0,0,1>, <0,0,0>, 1
    pigment { dPig }
    halo { EngineHalo }
    hollow
    scale <0.3, 0.3, 7.0>
    rotate -180.0*y
    translate  <-0.195011, 1.5, 7.0>
  }
  cylinder { // Strahl5
    <0,0,1>, <0,0,0>, 1
    pigment { dPig }
    halo { EngineHalo }
    hollow
    scale <0.3, 0.3, 7.0>
    rotate -180.0*y
    translate  <-0.189305, 7.510744, 7.2>
  }
  cylinder { // Strahl6
    <0,0,1>, <0,0,0>, 1
    pigment { dPig }
    halo { EngineHalo }
    hollow
    scale <0.3, 0.3, 7.0>
    rotate -180.0*y
    translate  <-0.189305, 13.513522, 7.2>
  }
}
#declare CometMitStaub = union {
  object { AllDust }
  object { Strahlen1 }
  scale 3.0
  rotate -30.0*z
  translate  <130.399005, 37.291064, -10.0>
}
union { // StartingShip
  object { StartbaseGrp }
  object { CometMitStaub }
  translate  <81.548353, 18.818851, 0.0>
}


difference { // NordwandCsg
  box { // NordWand
    <-1, -1, -1>, <1, 1, 1>
    scale <32.215595, 0.8, 15.0>
    translate  <-0.706034, 20.316514, 13.438237>
  }
  plane { // FrontCut
    z,0
    rotate <0.0, -82.5, 0.0>
    translate  <31.577599, 20.151565, 22.26179>
  }
  box { // NordWand1
    <-1, -1, -1>, <1, 1, 1>
    scale <30.0, 0.8, 15.0>
    rotate -90.0*z
    translate  <-32.444852, -9.093998, 13.438237>
  }
  texture {
    WandTex
  }
}


union { // Glasfront
  box { // Aussenwand
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WandTex
    }
    scale <0.5, 30.0, 1.8>
    translate  <29.462625, -5.0, 0.0>
  }
  box { // Aussenwand1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      SpecialGlass
    }
    scale <0.1, 30.0, 12.0>
    rotate 7.5*y
    translate  <30.720463, -4.731312, 11.398075>
  }
  translate  <-0.521736, 0.0, 0.260868>
}


#declare SaeuleCSG = difference {
  box { // Saeule
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 20.0>
  }
  plane { // SaeuleCut
    z,0
    rotate 135.0*y
    translate  19.0*z
  }
}
#declare Infohalterholz = union {
  box { // Halter
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 7.0, 0.3>
    rotate -45.0*y
    translate  <-4.836632, 0.0, 14.794233>
  }
  box { // Platte
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 0.2>
    rotate -45.0*y
    translate  19.0*z
  }
  object { SaeuleCSG }
  texture {
    EMBWood3
    scale <1.826513, 5.02925, 1.0>
  }
}
#declare Heliskizze = union {
  box { // Blatt
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WhiteTex1
    }
    scale <6.341897, 3.827319, 0.001>
    rotate -45.0*y
    translate  <-0.10632, 0.0, 19.244>
  }
  box { // Heliskizzenblatt
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Heliskizze_Te1
      scale <2.0, 2.0, 0.00001>
      rotate -90.0*z
  translate <-1.000000, 1.000000, -3.000000>
    }
    scale <5.490084, 2.734144, 0.001>
    rotate -45.0*y
    translate  <-0.134593, 0.0, 19.3>
  }
  translate  <0.108135, 0.0, 0.142295>
}
#declare Infohalterheli = union {
  object { Infohalterholz }
  object { Heliskizze }
  scale 0.15
  rotate 41.304363*z
  translate  <12.274954, -13.837713, 2.991317>
}
#declare Scheinwerfer1 = union {
  cylinder { // SGehaeuse11
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse12
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse13
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse14
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse15
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse16
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse17
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse18
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse19
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse20
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse21
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas1
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <6.17998, -48.447289, 147.915314>
  translate  <9.804226, -2.857453, -0.304635>
}
#declare Bodenring = difference {
  cylinder { // Bodenplatte
    <0,0,1>, <0,0,0>, 1
    scale <12.0, 12.0, 1.0>
  }
  cylinder { // Bodenloch
    <0,0,1>, <0,0,0>, 1
    scale <8.0, 8.0, 2.0>
    translate  -0.5*z
  }
  scale 0.7
  translate  -10.0*z
}
#declare Bodenring1 = difference {
  cylinder { // Bodenplatte1
    <0,0,1>, <0,0,0>, 1
    scale <12.0, 12.0, 1.0>
  }
  cylinder { // Bodenloch1
    <0,0,1>, <0,0,0>, 1
    scale <8.0, 8.0, 2.0>
    translate  -0.5*z
  }
  scale 0.35
  translate  <0.0, 0.0, -2.316659>
}
#declare Gestaenge = union {
  object { Bodenring }
  object { Bodenring1 }
  cylinder { // Holzstab
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 8.0>
    rotate -30.0*x
    translate  <0.0, -6.77491, -9.407869>
  }
  cylinder { // Holzstab1
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 8.0>
    rotate <-30.0, 0.0, -90.0>
    translate  <-6.77491, 0.0, -9.407869>
  }
  cylinder { // Holzstab2
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 8.0>
    rotate <-30.0, 0.0, 180.0>
    translate  <0.0, 6.77491, -9.407869>
  }
  cylinder { // Holzstab3
    <0,0,1>, <0,0,0>, 1
    scale <0.3, 0.3, 8.0>
    rotate <-30.0, 0.0, 90.0>
    translate  <6.77491, 0.0, -9.407869>
  }
  cylinder { // MittelStange
    <0,0,1>, <0,0,0>, 1
    texture {
      DMFLightOak3
    }
    scale <0.5, 0.5, 30.0>
    translate  -10.0*z
  }
  object { Querstrebe1 }
  object { // Querstrebe2->Querstrebe1
    Querstrebe1
    rotate -90.0*z
  }
  texture {
    DMFLightOak3
  }
}
#declare Rotor = union {
  object { FluegelTeil }
  object { // FluegelTeil1->FluegelTeil
    FluegelTeil
    scale <1.0, 0.990149, 0.999849>
    rotate <0.369995, 0.0, -10.0>
    translate  <0.006152, 0.034891, 0.136723>
  }
  object { // FluegelTeil2->FluegelTeil
    FluegelTeil
    scale <1.0, 0.980398, 0.999696>
    rotate <0.740676, 0.0, -20.0>
    translate  <0.024204, 0.0665, 0.273741>
  }
  object { // FluegelTeil3->FluegelTeil
    FluegelTeil
    scale <1.0, 0.970747, 0.999539>
    rotate <1.112048, 0.0, -30.0>
    translate  <0.053007, 0.09181, 0.41105>
  }
  object { // FluegelTeil4->FluegelTeil
    FluegelTeil
    scale <1.0, 0.961193, 0.999379>
    rotate <1.484118, 0.0, -40.0>
    translate  <0.09074, 0.10814, 0.548649>
  }
  object { // FluegelTeil5->FluegelTeil
    FluegelTeil
    scale <1.0, 0.951736, 0.999216>
    rotate <1.856893, 0.0, -50.0>
    translate  <0.134998, 0.113277, 0.686535>
  }
  object { // FluegelTeil6->FluegelTeil
    FluegelTeil
    scale <1.0, 0.942376, 0.999049>
    rotate <2.230379, 0.0, -60.0>
    translate  <0.182899, 0.105597, 0.824706>
  }
  object { // FluegelTeil7->FluegelTeil
    FluegelTeil
    scale <1.0, 0.933111, 0.99888>
    rotate <2.604582, 0.0, -70.0>
    translate  <0.231227, 0.08416, 0.963159>
  }
  object { // FluegelTeil8->FluegelTeil
    FluegelTeil
    scale <1.0, 0.923939, 0.998707>
    rotate <2.979509, 0.0, -80.0>
    translate  <0.276579, 0.048768, 1.101892>
  }
  object { // FluegelTeil9->FluegelTeil
    FluegelTeil
    scale <1.0, 0.914862, 0.998531>
    rotate <3.355166, 0.0, -90.0>
    translate  <0.31553, 0.0, 1.240904>
  }
  object { // FluegelTeil10->FluegelTeil
    FluegelTeil
    scale <1.0, 0.905876, 0.998351>
    rotate <3.73156, 0.0, -100.0>
    translate  <0.344799, -0.060797, 1.380191>
  }
  object { // FluegelTeil11->FluegelTeil
    FluegelTeil
    scale <1.0, 0.896982, 0.998167>
    rotate <4.108698, 0.0, -110.0>
    translate  <0.361417, -0.131545, 1.519751>
  }
  object { // FluegelTeil12->FluegelTeil
    FluegelTeil
    scale <1.0, 0.888179, 0.99798>
    rotate <4.486587, 0.0, -120.0>
    translate  <0.362872, -0.209504, 1.659583>
  }
  object { // FluegelTeil13->FluegelTeil
    FluegelTeil
    scale <1.0, 0.879465, 0.99779>
    rotate <4.865231, 0.0, -130.0>
    translate  <0.347255, -0.291382, 1.799683>
  }
  object { // FluegelTeil14->FluegelTeil
    FluegelTeil
    scale <1.0, 0.87084, 0.997595>
    rotate <5.24464, 0.0, -140.0>
    translate  <0.313368, -0.373457, 1.940051>
  }
  object { // FluegelTeil15->FluegelTeil
    FluegelTeil
    scale <1.0, 0.862303, 0.997397>
    rotate <5.624819, 0.0, -150.0>
    translate  <0.26081, -0.451737, 2.080683>
  }
  object { // FluegelTeil16->FluegelTeil
    FluegelTeil
    scale <1.0, 0.853853, 0.997195>
    rotate <6.005776, 0.0, -160.0>
    translate  <0.190037, -0.522122, 2.221578>
  }
  object { // FluegelTeil17->FluegelTeil
    FluegelTeil
    scale <1.0, 0.845489, 0.996989>
    rotate <6.387517, 0.0, -170.0>
    translate  <0.102373, -0.580585, 2.362733>
  }
  object { // FluegelTeil18->FluegelTeil
    FluegelTeil
    scale <1.0, 0.837211, 0.996778>
    rotate <6.770049, 0.0, 180.0>
    translate  <0.0, -0.623356, 2.504147>
  }
  object { // FluegelTeil19->FluegelTeil
    FluegelTeil
    scale <1.0, 0.829017, 0.996564>
    rotate <7.15338, 0.0, 170.0>
    translate  <-0.114099, -0.647088, 2.645817>
  }
  object { // FluegelTeil20->FluegelTeil
    FluegelTeil
    scale <1.0, 0.820907, 0.996345>
    rotate <7.537515, 0.0, 160.0>
    translate  <-0.236229, -0.649034, 2.787741>
  }
  object { // FluegelTeil21->FluegelTeil
    FluegelTeil
    scale <1.0, 0.81288, 0.996123>
    rotate <7.922463, 0.0, 150.0>
    translate  <-0.362102, -0.627179, 2.929918>
  }
  object { // FluegelTeil22->FluegelTeil
    FluegelTeil
    scale <1.0, 0.804935, 0.995895>
    rotate <8.308229, 0.0, 140.0>
    translate  <-0.48699, -0.580372, 3.072344>
  }
  object { // FluegelTeil23->FluegelTeil
    FluegelTeil
    scale <1.0, 0.797071, 0.995664>
    rotate <8.694823, 0.0, 130.0>
    translate  <-0.605896, -0.508407, 3.215019>
  }
  object { // FluegelTeil24->FluegelTeil
    FluegelTeil
    scale <1.0, 0.789287, 0.995427>
    rotate <9.082251, 0.0, 120.0>
    translate  <-0.713742, -0.412079, 3.35794>
  }
  object { // FluegelTeil25->FluegelTeil
    FluegelTeil
    scale <1.0, 0.781583, 0.995187>
    rotate <9.470518, 0.0, 110.0>
    translate  <-0.805577, -0.293206, 3.501106>
  }
  object { // FluegelTeil26->FluegelTeil
    FluegelTeil
    scale <1.0, 0.773959, 0.994941>
    rotate <9.859634, 0.0, 100.0>
    translate  <-0.876769, -0.154598, 3.644513>
  }
  object { // FluegelTeil27->FluegelTeil
    FluegelTeil
    scale <1.0, 0.766412, 0.994691>
    rotate <10.249605, 0.0, 90.0>
    translate  <-0.923211, 0.0, 3.788161>
  }
  object { // FluegelTeil28->FluegelTeil
    FluegelTeil
    scale <1.0, 0.758942, 0.994436>
    rotate <10.640438, 0.0, 80.0>
    translate  <-0.941502, 0.166012, 3.932048>
  }
  object { // FluegelTeil29->FluegelTeil
    FluegelTeil
    scale <1.0, 0.75155, 0.994175>
    rotate <11.032143, 0.0, 70.0>
    translate  <-0.929112, 0.338169, 4.076171>
  }
  object { // FluegelTeil30->FluegelTeil
    FluegelTeil
    scale <1.0, 0.744233, 0.99391>
    rotate <11.424724, 0.0, 60.0>
    translate  <-0.884518, 0.510677, 4.220529>
  }
  object { // FluegelTeil31->FluegelTeil
    FluegelTeil
    scale <1.0, 0.736991, 0.99364>
    rotate <11.81819, 0.0, 50.0>
    translate  <-0.807307, 0.677411, 4.36512>
  }
  object { // FluegelTeil32->FluegelTeil
    FluegelTeil
    scale <1.0, 0.729824, 0.993364>
    rotate <12.212547, 0.0, 40.0>
    translate  <-0.698243, 0.832134, 4.509942>
  }
  object { // FluegelTeil33->FluegelTeil
    FluegelTeil
    scale <1.0, 0.72273, 0.993083>
    rotate <12.607805, 0.0, 30.0>
    translate  <-0.55929, 0.968719, 4.654993>
  }
  object { // FluegelTeil34->FluegelTeil
    FluegelTeil
    scale <1.0, 0.715709, 0.992796>
    rotate <13.00397, 0.0, 20.0>
    translate  <-0.393592, 1.081384, 4.800272>
  }
  object { // FluegelTeil35->FluegelTeil
    FluegelTeil
    scale <1.0, 0.70876, 0.992504>
    rotate <13.40105, 0.0, 10.0>
    translate  <-0.205406, 1.164916, 4.945776>
  }
  object { // FluegelTeil36->FluegelTeil
    FluegelTeil
    scale <1.0, 0.701883, 0.992206>
    rotate <13.799052, 0.0, 0.0>
    translate  <0.0, 1.214885, 5.091504>
  }
  object { // FluegelTeil37->FluegelTeil
    FluegelTeil
    scale <1.0, 0.695077, 0.991903>
    rotate <14.197985, 0.0, -10.0>
    translate  <0.216501, 1.22784, 5.237454>
  }
  object { // FluegelTeil38->FluegelTeil
    FluegelTeil
    scale <1.0, 0.688341, 0.991593>
    rotate <14.597854, 0.0, -20.0>
    translate  <0.437298, 1.201466, 5.383625>
  }
  object { // FluegelTeil39->FluegelTeil
    FluegelTeil
    scale <1.0, 0.681675, 0.991278>
    rotate <14.998669, 0.0, -30.0>
    translate  <0.655131, 1.134721, 5.530014>
  }
  object { // FluegelTeil40->FluegelTeil
    FluegelTeil
    scale <1.0, 0.675077, 0.990957>
    rotate <15.400436, 0.0, -40.0>
    translate  <0.862523, 1.027915, 5.67662>
  }
  object { // FluegelTeil41->FluegelTeil
    FluegelTeil
    scale <1.0, 0.668547, 0.990629>
    rotate <15.803164, 0.0, -50.0>
    translate  <1.052032, 0.882759, 5.823442>
  }
  object { // FluegelTeil42->FluegelTeil
    FluegelTeil
    scale <1.0, 0.662085, 0.990295>
    rotate <16.206861, 0.0, -60.0>
    translate  <1.216512, 0.702354, 5.970477>
  }
  object { // FluegelTeil43->FluegelTeil
    FluegelTeil
    scale <1.0, 0.655689, 0.989954>
    rotate <16.611534, 0.0, -70.0>
    translate  <1.349381, 0.491134, 6.117724>
  }
  object { // FluegelTeil44->FluegelTeil
    FluegelTeil
    scale <1.0, 0.64936, 0.989607>
    rotate <17.017191, 0.0, -80.0>
    translate  <1.444861, 0.254768, 6.265181>
  }
  object { // FluegelTeil45->FluegelTeil
    FluegelTeil
    scale <1.0, 0.643096, 0.989254>
    rotate <17.42384, 0.0, -90.0>
    translate  <1.498215, 0.0, 6.412848>
  }
  object { // FluegelTeil46->FluegelTeil
    FluegelTeil
    scale <1.0, 0.636898, 0.988893>
    rotate <17.831488, 0.0, -100.0>
    translate  <1.505944, -0.265539, 6.560721>
  }
  object { // FluegelTeil47->FluegelTeil
    FluegelTeil
    scale <1.0, 0.630763, 0.988526>
    rotate <18.240143, 0.0, -110.0>
    translate  <1.46595, -0.533562, 6.708799>
  }
  object { // FluegelTeil48->FluegelTeil
    FluegelTeil
    scale <1.0, 0.624692, 0.988151>
    rotate <18.649815, 0.0, -120.0>
    translate  <1.377657, -0.795391, 6.857082>
  }
  object { // FluegelTeil49->FluegelTeil
    FluegelTeil
    scale <1.0, 0.618684, 0.98777>
    rotate <19.060507, 0.0, -130.0>
    translate  <1.242085, -1.042233, 7.005566>
  }
  object { // FluegelTeil50->FluegelTeil
    FluegelTeil
    scale <1.0, 0.612738, 0.987381>
    rotate <19.472233, 0.0, -140.0>
    translate  <1.061864, -1.265481, 7.154252>
  }
  object { // FluegelTeil51->FluegelTeil
    FluegelTeil
    scale <1.0, 0.606854, 0.986985>
    rotate <19.884996, 0.0, -150.0>
    translate  <0.841201, -1.457004, 7.303137>
  }
  object { // FluegelTeil52->FluegelTeil
    FluegelTeil
    scale <1.0, 0.601032, 0.986581>
    rotate <20.298807, 0.0, -160.0>
    translate  <0.585789, -1.609442, 7.452219>
  }
  object { // FluegelTeil53->FluegelTeil
    FluegelTeil
    scale <1.0, 0.59527, 0.986169>
    rotate <20.713671, 0.0, -170.0>
    translate  <0.302661, -1.716477, 7.601498>
  }
  object { // FluegelTeil54->FluegelTeil
    FluegelTeil
    scale <1.0, 0.589568, 0.98575>
    rotate <21.129599, 0.0, 180.0>
    translate  <0.0, -1.773075, 7.750971>
  }
  object { // FluegelTeil55->FluegelTeil
    FluegelTeil
    scale <1.0, 0.583925, 0.985323>
    rotate <21.546597, 0.0, 170.0>
    translate  <-0.313103, -1.775695, 7.900637>
  }
  object { // FluegelTeil56->FluegelTeil
    FluegelTeil
    scale <1.0, 0.578342, 0.984887>
    rotate <21.964672, 0.0, 160.0>
    translate  <-0.626921, -1.722452, 8.050495>
  }
  object { // FluegelTeil57->FluegelTeil
    FluegelTeil
    scale <1.0, 0.572816, 0.984444>
    rotate <22.383835, 0.0, 150.0>
    translate  <-0.931398, -1.613228, 8.200544>
  }
  object { // FluegelTeil58->FluegelTeil
    FluegelTeil
    scale <1.0, 0.567349, 0.983991>
    rotate <22.80409, 0.0, 140.0>
    translate  <-1.216469, -1.449732, 8.350781>
  }
  object { // FluegelTeil59->FluegelTeil
    FluegelTeil
    scale <1.0, 0.561938, 0.983531>
    rotate <23.225451, 0.0, 130.0>
    translate  <-1.472398, -1.235488, 8.501206>
  }
  object { // FluegelTeil60->FluegelTeil
    FluegelTeil
    scale <1.0, 0.556584, 0.983062>
    rotate <23.647919, 0.0, 120.0>
    translate  <-1.690101, -0.975781, 8.651816>
  }
  object { // FluegelTeil61->FluegelTeil
    FluegelTeil
    scale <1.0, 0.551287, 0.982583>
    rotate <24.071505, 0.0, 110.0>
    translate  <-1.861472, -0.67752, 8.802611>
  }
  object { // FluegelTeil62->FluegelTeil
    FluegelTeil
    scale <1.0, 0.546044, 0.982096>
    rotate <24.496218, 0.0, 100.0>
    translate  <-1.979667, -0.349069, 8.95359>
  }
  object { // FluegelTeil63->FluegelTeil
    FluegelTeil
    scale <1.0, 0.540857, 0.9816>
    rotate <24.922064, 0.0, 90.0>
    translate  <-2.039369, 0.0, 9.10475>
  }
  object { // FluegelTeil64->FluegelTeil
    FluegelTeil
    scale <1.0, 0.535725, 0.981094>
    rotate <25.349051, 0.0, 80.0>
    translate  <-2.037001, 0.359178, 9.25609>
  }
  object { // FluegelTeil65->FluegelTeil
    FluegelTeil
    scale <1.0, 0.530646, 0.980579>
    rotate <25.777189, 0.0, 70.0>
    translate  <-1.970887, 0.717344, 9.40761>
  }
  object { // FluegelTeil66->FluegelTeil
    FluegelTeil
    scale <1.0, 0.525621, 0.980055>
    rotate <26.206482, 0.0, 60.0>
    translate  <-1.841358, 1.063109, 9.559307>
  }
  object { // FluegelTeil67->FluegelTeil
    FluegelTeil
    scale <1.0, 0.520648, 0.97952>
    rotate <26.636942, 0.0, 50.0>
    translate  <-1.65079, 1.385177, 9.711181>
  }
  object { // FluegelTeil68->FluegelTeil
    FluegelTeil
    scale <1.0, 0.515729, 0.978976>
    rotate <27.068571, 0.0, 40.0>
    translate  <-1.403579, 1.67272, 9.863229>
  }
  object { // FluegelTeil69->FluegelTeil
    FluegelTeil
    scale <1.0, 0.510861, 0.978422>
    rotate <27.501385, 0.0, 30.0>
    translate  <-1.106052, 1.915737, 10.015452>
  }
  object { // FluegelTeil70->FluegelTeil
    FluegelTeil
    scale <1.0, 0.506044, 0.977857>
    rotate <27.935385, 0.0, 20.0>
    translate  <-0.766302, 2.105398, 10.167846>
  }
  rotate 0.0*z
}
#declare Helikopter = union {
  object { Gestaenge }
  object { Seil1 }
  object { // Seil2->Seil1
    Seil1
    scale <1.0, 1.0, 1.05>
    rotate <5.760345, 0.0, -90.0>
    translate  <-1.580162, 0.0, -0.183555>
  }
  object { // Seil3->Seil1
    Seil1
    scale <1.0, 1.0, 1.1>
    rotate <12.845409, 0.0, -180.0>
    translate  <0.0, 2.346617, -0.710725>
  }
  object { // Seil4->Seil1
    Seil1
    scale <1.0, 1.0, 1.2>
    rotate <19.393848, 0.0, 90.0>
    translate  <2.906477, 0.0, -1.046332>
  }
  object { Rotor }
  scale 0.4
  translate  <19.359351, -7.374991, 4.0>
}
union { // HeliGrp
  object { Infohalterheli }
  object { Scheinwerfer1 }
  object { Helikopter }
  translate  <-9.078377, 3.987984, 0.0>
}


#declare TapSwp001 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <4.0, 4.0, 8.0>
  rotate <-180.0, 0.0, 139.713852>
  translate  <-3.490713, 3.45945, 20.338339>
}
#declare TapSwp2 = prism {
  conic_sweep
  linear_spline
  0.0,1.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, -1.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate <90,0,90>
  scale <4.0, 4.0, 8.0>
  rotate <-180.0, 0.0, 139.713852>
  translate  <-3.490713, 3.45945, 20.032426>
}
#declare ParaCsg = difference {
  object { TapSwp001 }
  object { TapSwp2 }
  texture {
    LeatherTex1
  }
  scale 0.5
  rotate <0.0, 0.0, 40.28614>
  translate  <2.449851, -0.19092, -10.16917>
}
#declare ParaTop = union {
  object { ParaRohr }
  object { // ParaRohr1->ParaRohr
    ParaRohr
    rotate <0.0, 0.0, -90.0>
  }
  object { // ParaRohr2->ParaRohr
    ParaRohr
    rotate <0.0, 0.0, 180.0>
  }
  object { // ParaRohr3->ParaRohr
    ParaRohr
    rotate <0.0, 0.0, 90.0>
  }
  object { ParaCsg }
  translate  4.0*z
}
#declare ParaBot = union {
  object { ParaSeil }
  object { // ParaSeil1->ParaSeil
    ParaSeil
    rotate <0.0, 0.0, -90.0>
  }
  object { // ParaSeil2->ParaSeil
    ParaSeil
    rotate <0.0, 0.0, 180.0>
  }
  object { // ParaSeil3->ParaSeil
    ParaSeil
    rotate <0.0, 0.0, 90.0>
  }
  scale <0.95, 0.95, 0.7>
  rotate <180.0, 0.0, 180.0>
  translate  -2.550863*z
}
#declare KopfBasis1 = union {
  sphere { // Sphere2
    <0,0,0>,1
    translate  1.0*z
  }
  cone { // Cone2
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.0, 1.0, 1.5>
    translate  -0.5*z
  }
}
#declare Kopf1 = intersection {
  object { KopfBasis1 }
  plane { // Plane3
    z,0
    rotate 95.0*x
    translate  <0.0, -0.8, 0.7>
  }
  scale <1.2, 0.9, 1.2>
  translate  -3.6*z
}
#declare KopfBasis = union {
  sphere { // Sphere001
    <0,0,0>,1
    translate  1.0*z
  }
  cone { // Cone001
    <0,0,0>, 0.6, <0,0,1>, 1.0
    scale <1.0, 1.0, 1.5>
    translate  -0.5*z
  }
}
#declare Kopf = intersection {
  object { KopfBasis }
  plane { // Plane001
    z,0
    rotate <100.0, 0.0, 20.0>
    translate  <0.4, -0.7, 0.7>
  }
  plane { // Plane2
    z,0
    rotate <100.0, 0.0, -20.0>
    translate  <-0.4, -0.7, 0.7>
  }
  scale 0.9
  rotate 27.745127*x
  translate  <0.0, -0.415794, -0.375599>
}
#declare Becken = difference {
  sphere { // BeckenTeil
    <0,0,0>,1
    scale <1.0, 0.8, 1.0>
  }
  plane { // BeckenOben
    z,0
    rotate <180.0, 0.0, 180.0>
    translate  0.7*z
  }
  plane { // BeckenUnten
    z,0
    translate  -0.7*z
  }
  plane { // BeckenUnten1
    z,0
    rotate -60.0*x
    translate  <0.0, -0.5, -0.5>
  }
  scale <1.0, 0.8, 1.2>
  translate  -5.9*z
}
#declare HuefteRechts = difference {
  sphere { // Hueftkugel
    <0,0,0>,1
  }
  box { // Hueftschnitt
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.3
}
#declare OberschenkelLin = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.408712, -2.495663>,
  <0.500086, -1.715299>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein = union {
  object { HuefteRechts }
  object { OberschenkelLin }
}
#declare HuefteRechts1 = difference {
  sphere { // Hueftkugel1
    <0,0,0>,1
  }
  box { // Hueftschnitt1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.3
}
#declare OberschenkelL1 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.518302, -2.660047>,
  <0.609676, -1.697034>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein1 = union {
  object { HuefteRechts1 }
  object { OberschenkelL1 }
  scale 0.8
  translate  -3.1*z
}
#declare HuefteRechts2 = difference {
  sphere { // Hueftkugel2
    <0,0,0>,1
    translate  0.1*z
  }
  box { // Hueftschnitt2
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.17
  translate  -5.6*z
}
#declare Fussoberteil = union {
  cylinder { // Ferse
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.4, 1.6>
    translate  0.5*z
  }
  sphere { // Zehen
    <0,0,0>,1
    scale <1.0, 0.5, 1.6>
    translate  -0.4*z
  }
  translate  <2.4, -2.5, 0.0>
}
#declare Fuss = difference {
  object { Fussoberteil }
  plane { // Sohle
    z,0
    rotate -90.0*x
    translate  <2.4, -2.5, 0.0>
  }
  scale <0.25, 0.4, 0.3>
  rotate <90.0, 0.0, 180.0>
  translate  <0.6, -0.5, -4.9>
}
#declare Bein = union {
  object { OberesBein }
  object { OberesBein1 }
  object { HuefteRechts2 }
  object { Fuss }
  translate  <-0.4, 0.0, -7.0>
}
#declare HuefteRechts3 = difference {
  sphere { // Hueftkugel3
    <0,0,0>,1
  }
  box { // Hueftschnitt3
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.3
}
#declare OberschenkelL2 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.408712, -2.495663>,
  <0.500086, -1.715299>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein2 = union {
  object { HuefteRechts3 }
  object { OberschenkelL2 }
}
#declare HuefteRechts4 = difference {
  sphere { // Hueftkugel4
    <0,0,0>,1
  }
  box { // Hueftschnitt4
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.3
}
#declare OberschenkelL3 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.518302, -2.660047>,
  <0.609676, -1.697034>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein3 = union {
  object { HuefteRechts4 }
  object { OberschenkelL3 }
  scale 0.8
  translate  -3.1*z
}
#declare HuefteRechts5 = difference {
  sphere { // Hueftkugel5
    <0,0,0>,1
    translate  0.1*z
  }
  box { // Hueftschnitt5
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.17
  translate  -5.6*z
}
#declare Fussoberteil1 = union {
  cylinder { // Ferse1
    <0,0,1>, <0,0,0>, 1
    scale <0.8, 0.4, 1.6>
    translate  0.5*z
  }
  sphere { // Zehen1
    <0,0,0>,1
    scale <1.0, 0.5, 1.6>
    translate  -0.4*z
  }
  translate  <2.4, -2.5, 0.0>
}
#declare Fuss1 = difference {
  object { Fussoberteil1 }
  plane { // Sohle1
    z,0
    rotate -90.0*x
    translate  <2.4, -2.5, 0.0>
  }
  scale <0.25, 0.4, 0.3>
  rotate <90.0, 0.0, 180.0>
  translate  <0.6, -0.5, -4.9>
}
#declare Bein1 = union {
  object { OberesBein2 }
  object { OberesBein3 }
  object { HuefteRechts5 }
  object { Fuss1 }
  translate  <0.5, 0.0, -7.0>
}
#declare Hand = intersection {
  sphere { // Zehen2
    <0,0,0>,1
    scale <1.0, 0.5, 1.6>
    rotate <0.0, 0.0, 0.0>
    translate  <2.4, -2.5, -0.4>
  }
  plane { // Sohle2
    z,0
    rotate <-110.0, 0.0, 180.0>
    translate  <2.4, -2.6, -1.1>
  }
  no_shadow
  scale <0.2, 0.3, 0.3>
  rotate <-25.0, -10.0, 180.0>
  translate  <-1.70158, -0.6, -1.091113>
}
#declare HuefteRechts7 = difference {
  sphere { // Hueftkugel7
    <0,0,0>,1
  }
  box { // Hueftschnitt7
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.3
}
#declare OberschenkelL5 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.518302, -2.660047>,
  <0.609676, -1.697034>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein5 = union {
  object { HuefteRechts7 }
  object { OberschenkelL5 }
  scale 0.8
  rotate 10.0*y
  translate  <-1.638309, 0.0, 2.147096>
}
#declare HuefteRechts8 = difference {
  sphere { // Hueftkugel8
    <0,0,0>,1
    translate  0.1*z
  }
  box { // Hueftschnitt8
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.17
  rotate 10.0*y
  translate  <-2.07243, 0.0, -0.314923>
}
#declare Unterarm = union {
  object { Hand }
  object { OberesBein5 }
  object { HuefteRechts8 }
  rotate -30.0*y
  translate  <0.9, 0.0, 1.1>
}
#declare HuefteRechts6 = difference {
  sphere { // Hueftkugel6
    <0,0,0>,1
  }
  box { // Hueftschnitt6
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.4
}
#declare OberschenkelL4 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.408712, -2.495663>,
  <0.500086, -1.715299>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein4 = union {
  object { HuefteRechts6 }
  object { OberschenkelL4 }
  rotate 10.0*y
  translate  <-1.1, 0.0, 5.2>
}
#declare ArmGanz = union {
  object { Unterarm }
  object { OberesBein4 }
  rotate 5.0*y
  translate  <0.7, 0.0, -5.7>
}
#declare Arm = union {
  object { ArmGanz }
  scale 0.8
  rotate <-137.127396, -25.103058, -7.120403>
  translate  <-1.038355, 0.0, -1.908494>
}
#declare Hand1 = intersection {
  sphere { // Zehen3
    <0,0,0>,1
    scale <1.0, 0.5, 1.6>
    rotate <0.0, 0.0, 0.0>
    translate  <2.4, -2.5, -0.4>
  }
  plane { // Sohle3
    z,0
    rotate <-110.0, 0.0, 180.0>
    translate  <2.4, -2.6, -1.1>
  }
  scale <0.2, 0.3, 0.3>
  rotate <-25.0, -10.0, 180.0>
  translate  <-1.70158, -0.6, -1.091113>
}
#declare HuefteRechts9 = difference {
  sphere { // Hueftkugel9
    <0,0,0>,1
  }
  box { // Hueftschnitt9
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.3
}
#declare OberschenkelL6 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.518302, -2.660047>,
  <0.609676, -1.697034>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein6 = union {
  object { HuefteRechts9 }
  object { OberschenkelL6 }
  scale 0.8
  rotate 10.0*y
  translate  <-1.638309, 0.0, 2.147096>
}
#declare HuefteRechts10 = difference {
  sphere { // Hueftkugel10
    <0,0,0>,1
    translate  0.1*z
  }
  box { // Hueftschnitt10
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.17
  rotate 10.0*y
  translate  <-2.07243, 0.0, -0.314923>
}
#declare Unterarm1 = union {
  object { Hand1 }
  object { OberesBein6 }
  object { HuefteRechts10 }
  rotate 35.0*y
  translate  <-1.6, 0.0, -0.4>
}
#declare HuefteRechts11 = difference {
  sphere { // Hueftkugel11
    <0,0,0>,1
  }
  box { // Hueftschnitt11
    <-1, -1, -1>, <1, 1, 1>
    scale <0.1, 1.0, 1.0>
  }
  scale 0.4
}
#declare OberschenkelL7 = lathe {
  quadratic_spline
  7  // control points
  <0.399065, -3.744743>,
  <0.392064, -3.732807>,
  <0.408712, -2.495663>,
  <0.500086, -1.715299>,
  <0.627616, -0.919735>,
  <0.594722, -0.288939>,
  <0.467972, 0.080254>
  rotate <90,0,90>
  scale <0.6, 0.6, 0.7>
  translate  -0.3*z
}
#declare OberesBein7 = union {
  object { HuefteRechts11 }
  object { OberschenkelL7 }
  rotate 10.0*y
  translate  <-1.1, 0.0, 5.2>
}
#declare ArmGanz1 = union {
  object { Unterarm1 }
  object { OberesBein7 }
  rotate <0.0, -30.0, 0.0>
  translate  <3.5, 0.0, -4.2>
}
#declare Arm1 = union {
  object { ArmGanz1 }
  scale 0.8
  rotate <-140.175308, 27.444653, 0.0>
  translate  <1.255342, 0.0, -2.0>
}
#declare Mann = union {
  object { Kopf1 }
  sphere { // Hals
    <0,0,0>,1
    scale <0.5, 0.5, 0.3>
    translate  -1.0*z
  }
  object { Kopf }
  sphere { // Bauch
    <0,0,0>,1
    scale <0.8, 0.6, 0.5>
    translate  -4.7*z
  }
  object { Becken }
  object { Bein }
  object { Bein1 }
  object { Arm }
  object { Arm1 }
  texture {
    DMFLightOak3
  }
  scale 0.3
  translate  <-0.028232, 0.0, -1.683225>
}
#declare Parachute = union {
  object { ParaTop }
  object { ParaBot }
  object { Mann }
  scale 2.0
  rotate -34.285389*z
  translate  <1.274575, -7.659554, 13.951004>
}
#declare SaeuleCSG1 = difference {
  box { // Saeule1
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 1.0, 20.0>
  }
  plane { // SaeuleCut1
    z,0
    rotate 135.0*y
    translate  19.0*z
  }
}
#declare Infohalterhol1 = union {
  box { // Halter1
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 7.0, 0.3>
    rotate -45.0*y
    translate  <-4.836632, 0.0, 14.794233>
  }
  box { // Platte1
    <-1, -1, -1>, <1, 1, 1>
    scale <7.0, 7.0, 0.2>
    rotate -45.0*y
    translate  19.0*z
  }
  object { SaeuleCSG1 }
  texture {
    EMBWood3
    scale <1.826513, 5.02925, 1.0>
  }
}
#declare ParaSkizze = union {
  box { // Blatt1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      WhiteTex1
    }
    scale <6.0, 3.5, 0.01>
    rotate -45.0*y
    translate  <0.157098, 0.013559, 19.564589>
  }
  box { // Blatt2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      Paraskizze_Tex
      scale <2.0, 2.0, 0.00001>
      rotate -90.0*z
  translate <-0.994886, 0.997559, 3.067971>
    }
    scale <4.8, 2.8, 0.01>
    rotate -45.0*y
    translate  <0.157098, 0.013559, 19.763714>
  }
  translate  <-0.444082, 0.0, -0.409922>
}
#declare InfohalterPara = union {
  object { Infohalterhol1 }
  object { ParaSkizze }
  scale 0.15
  rotate 29.173676*z
  translate  <-4.883217, -10.482748, 2.70567>
}
#declare Scheinwerfer = union {
  cylinder { // SGehaeuse
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse1
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse2
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse3
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse4
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse5
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse6
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse7
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse8
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse9
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse10
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <-3.126728, -21.502975, -30.963379>
  translate  <4.192938, -10.482345, -0.219795>
}
union { // ParaGrp
  object { Parachute }
  object { InfohalterPara }
  object { Scheinwerfer }
  translate  <-8.935279, 2.601343, 0.0>
}


#declare BrickObj = union {
  box { // Brick
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj1 = union {
  box { // Brick1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB1
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj2 = union {
  box { // Brick2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB2
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj3 = union {
  box { // Brick3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB3
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj4 = union {
  box { // Brick4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj5 = union {
  box { // Brick5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.438579>
  }
  translate  16.5*x
}
#declare Layer = union {
  object { BrickObj }
  object { BrickObj1 }
  object { BrickObj2 }
  object { BrickObj3 }
  object { BrickObj4 }
  object { BrickObj5 }
}
#declare BrickObj10 = union {
  box { // Brick10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB10
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj11 = union {
  box { // Brick11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB11
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj12 = union {
  box { // Brick12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB12
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj13 = union {
  box { // Brick13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB13
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj14 = union {
  box { // Brick14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB14
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj15 = union {
  box { // Brick15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA15
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.438579>
  }
  translate  16.5*x
}
#declare Layer1 = union {
  object { BrickObj10 }
  object { BrickObj11 }
  object { BrickObj12 }
  object { BrickObj13 }
  object { BrickObj14 }
  object { BrickObj15 }
  translate  0.9*z
}
#declare BrickObj20 = union {
  box { // Brick20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj21 = union {
  box { // Brick21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj22 = union {
  box { // Brick22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj23 = union {
  box { // Brick23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj24 = union {
  box { // Brick24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj25 = union {
  box { // Brick25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA25
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.438579>
  }
  translate  16.5*x
}
#declare Layer2 = union {
  object { BrickObj20 }
  object { BrickObj21 }
  object { BrickObj22 }
  object { BrickObj23 }
  object { BrickObj24 }
  object { BrickObj25 }
  translate  1.8*z
}
#declare BrickObj30 = union {
  box { // Brick30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj31 = union {
  box { // Brick31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj32 = union {
  box { // Brick32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB32
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj33 = union {
  box { // Brick33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB33
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj34 = union {
  box { // Brick34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB34
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj35 = union {
  box { // Brick35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA35
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.438579>
  }
  translate  16.5*x
}
#declare Layer3 = union {
  object { BrickObj30 }
  object { BrickObj31 }
  object { BrickObj32 }
  object { BrickObj33 }
  object { BrickObj34 }
  object { BrickObj35 }
  translate  2.7*z
}
#declare BrickObj40 = union {
  box { // Brick40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB40
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj41 = union {
  box { // Brick41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB41
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj42 = union {
  box { // Brick42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB42
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj43 = union {
  box { // Brick43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB43
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj44 = union {
  box { // Brick44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB44
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj45 = union {
  box { // Brick45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA45
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.457868>
  }
  translate  16.5*x
}
#declare Layer4 = union {
  object { BrickObj40 }
  object { BrickObj41 }
  object { BrickObj42 }
  object { BrickObj43 }
  object { BrickObj44 }
  object { BrickObj45 }
  translate  3.6*z
}
#declare BrickObj50 = union {
  box { // Brick50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB50
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj51 = union {
  box { // Brick51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB51
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj52 = union {
  box { // Brick52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB52
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj53 = union {
  box { // Brick53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB53
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj54 = union {
  box { // Brick54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj55 = union {
  box { // Brick55
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA55
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.457868>
  }
  translate  16.5*x
}
#declare Layer5 = union {
  object { BrickObj50 }
  object { BrickObj51 }
  object { BrickObj52 }
  object { BrickObj53 }
  object { BrickObj54 }
  object { BrickObj55 }
  translate  4.5*z
}
#declare BrickObj60 = union {
  box { // Brick60
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA60
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB60
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
}
#declare BrickObj61 = union {
  box { // Brick61
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA61
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB61
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj62 = union {
  box { // Brick62
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA62
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB62
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj63 = union {
  box { // Brick63
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA63
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB63
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj64 = union {
  box { // Brick64
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA64
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB64
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj65 = union {
  box { // Brick65
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA65
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.477157>
  }
  translate  16.5*x
}
#declare Layer6 = union {
  object { BrickObj60 }
  object { BrickObj61 }
  object { BrickObj62 }
  object { BrickObj63 }
  object { BrickObj64 }
  object { BrickObj65 }
  translate  5.4*z
}
#declare BrickObj71 = union {
  box { // Brick71
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA71
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB71
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj72 = union {
  box { // Brick72
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA72
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB72
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj73 = union {
  box { // Brick73
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA73
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB73
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj74 = union {
  box { // Brick74
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA74
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB74
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj75 = union {
  box { // Brick75
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA75
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.457868>
  }
  translate  16.5*x
}
#declare Layer7 = union {
  object { BrickObj71 }
  object { BrickObj72 }
  object { BrickObj73 }
  object { BrickObj74 }
  object { BrickObj75 }
  translate  6.3*z
}
#declare BrickObj81 = union {
  box { // Brick81
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA81
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB81
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj82 = union {
  box { // Brick82
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA82
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB82
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj83 = union {
  box { // Brick83
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA83
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB83
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj84 = union {
  box { // Brick84
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA84
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB84
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj85 = union {
  box { // Brick85
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA85
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.438579>
  }
  translate  16.5*x
}
#declare Layer8 = union {
  object { BrickObj81 }
  object { BrickObj82 }
  object { BrickObj83 }
  object { BrickObj84 }
  object { BrickObj85 }
  translate  7.2*z
}
#declare BrickObj91 = union {
  box { // Brick91
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA91
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB91
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj92 = union {
  box { // Brick92
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA92
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB92
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj93 = union {
  box { // Brick93
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA93
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB93
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj94 = union {
  box { // Brick94
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA94
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB94
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  13.2*x
}
#declare BrickObj95 = union {
  box { // Brick95
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  translate  16.5*x
}
#declare Layer9 = union {
  object { BrickObj91 }
  object { BrickObj92 }
  object { BrickObj93 }
  object { BrickObj94 }
  object { BrickObj95 }
  translate  8.1*z
}
#declare BrickObj101 = union {
  box { // Brick101
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA101
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB101
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj102 = union {
  box { // Brick102
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA102
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB102
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj103 = union {
  box { // Brick103
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA103
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB103
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj104 = union {
  box { // Brick104
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA104
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.438579>
  }
  translate  13.2*x
}
#declare Layer10 = union {
  object { BrickObj101 }
  object { BrickObj102 }
  object { BrickObj103 }
  object { BrickObj104 }
  translate  9.0*z
}
#declare BrickObj111 = union {
  box { // Brick111
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelB111
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  3.3*x
}
#declare BrickObj112 = union {
  box { // Brick112
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA112
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB112
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj113 = union {
  box { // Brick113
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA113
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB113
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj114 = union {
  box { // Brick114
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA114
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <-0.092893, 0.0, 0.457868>
  }
  translate  13.2*x
}
#declare Layer11 = union {
  object { BrickObj111 }
  object { BrickObj112 }
  object { BrickObj113 }
  object { BrickObj114 }
  translate  9.9*z
}
#declare BrickObj122 = union {
  box { // Brick122
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA122
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB122
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj123 = union {
  box { // Brick123
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA123
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB123
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj124 = union {
  box { // Brick124
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA124
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.642132, 0.7, 0.1>
    translate  <-0.035025, 0.0, 0.4>
  }
  translate  13.2*x
}
#declare Layer12 = union {
  object { BrickObj122 }
  object { BrickObj123 }
  object { BrickObj124 }
  translate  10.8*z
}
#declare BrickObj132 = union {
  box { // Brick132
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA132
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.7, 0.7, 0.1>
    translate  <0.1, 0.0, 0.4>
  }
  box { // MoertelB132
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj133 = union {
  box { // Brick133
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA133
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.584264, 0.7, 0.1>
    translate  <0.022843, 0.0, 0.4>
  }
  box { // MoertelB133
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  9.9*x
}
#declare BrickObj134 = union {
  box { // Brick134
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  translate  13.2*x
}
#declare Layer13 = union {
  object { BrickObj132 }
  object { BrickObj133 }
  object { BrickObj134 }
  translate  11.7*z
}
#declare BrickObj142 = union {
  box { // Brick142
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelB142
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <0.1, 0.7, 0.4>
    translate  1.7*x
  }
  translate  6.6*x
}
#declare BrickObj143 = union {
  box { // Brick143
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  box { // MoertelA143
    <-1, -1, -1>, <1, 1, 1>
    texture {
      TexMoertel
    }
    scale <1.603554, 0.7, 0.119289>
    translate  <0.003554, 0.0, 0.4>
  }
  translate  9.9*x
}
#declare Layer14 = union {
  object { BrickObj142 }
  object { BrickObj143 }
  translate  12.6*z
}
#declare BrickObj153 = union {
  box { // Brick153
    <-1, -1, -1>, <1, 1, 1>
    texture {
      BrickTex
    }
    scale <1.6, 0.8, 0.4>
  }
  translate  9.9*x
}
#declare Layer15 = union {
  object { BrickObj153 }
  translate  13.5*z
}
#declare Wall = union {
  object { Layer }
  object { Layer1 }
  object { Layer2 }
  object { Layer3 }
  object { Layer4 }
  object { Layer5 }
  object { Layer6 }
  object { Layer7 }
  object { Layer8 }
  object { Layer9 }
  object { Layer10 }
  object { Layer11 }
  object { Layer12 }
  object { Layer13 }
  object { Layer14 }
  object { Layer15 }
}
#declare Rahmen = union {
  box { // Rahmen2
    <-1, -1, -1>, <1, 1, 1>
    scale <4.9, 0.4, 6.9>
    translate  <7.1, -0.2, 4.3>
  }
  box { // Rahmen1
    <-1, -1, -1>, <1, 1, 1>
    scale <5.0, 0.4, 7.0>
    translate  <7.1, 0.0, 4.3>
  }
  translate  <0.1, 3.3, -14.5>
}
#declare R2 = difference {
  object { Rahmen }
  box { // Rahmen3
    <-1, -1, -1>, <1, 1, 1>
    scale <4.4, 0.4, 6.4>
    translate  <7.2, 2.8, -10.2>
  }
  texture {
    DMFLightOak3
  }
}
#declare LeonardoBild = union {
  object { R2 }
  box { // Rahmen4
    <-1, -1, -1>, <1, 1, 1>
    texture {
      LeonardoTex
      scale <2.0, 2.0, 1.0>
      rotate 90.0*x
  translate <-1.000000, 0.000000, -1.000000>
    }
    scale <4.3, 0.1, 6.3>
    translate  <7.2, 2.8, -10.2>
  }
  scale 0.6
  translate  <5.440588, -2.87819, 13.656902>
}
#declare WandMitLeo = union {
  object { Wall }
  object { LeonardoBild }
  scale 0.8
  translate  <0.307291, 11.062486, 0.0>
}
#declare Scheinwerfer5 = union {
  cylinder { // SGehaeuse55
    <0,0,1>, <0,0,0>, 1 open
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // SGehaeuse56
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    translate  0.990831*y
  }
  cylinder { // SGehaeuse57
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -40.0*z
    translate  <0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse58
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -80.0*z
    translate  <0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse59
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -120.0*z
    translate  <0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse60
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate -160.0*z
    translate  <0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse61
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 160.0*z
    translate  <-0.338884, -0.931077, 0.0>
  }
  cylinder { // SGehaeuse62
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 120.0*z
    translate  <-0.858085, -0.495416, 0.0>
  }
  cylinder { // SGehaeuse63
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 80.0*z
    translate  <-0.975778, 0.172056, 0.0>
  }
  cylinder { // SGehaeuse64
    <0,0,1>, <0,0,0>, 1 open
    scale <0.05, 0.05, 2.0>
    rotate 40.0*z
    translate  <-0.636894, 0.759021, 0.0>
  }
  cylinder { // SGehaeuse65
    <0,0,1>, <0,0,0>, 1 open
    scale <1.1, 1.1, 0.4>
    translate  1.6*z
  }
  disc { // Glas5
    <0,0,0>, <0,0,1>, 1.0
    texture {
      Glass1
    }
    translate  1.9*z
  }
  texture {
    Polished_Chro2
  }
  scale <0.4, 0.4, 0.52>
  rotate <-6.406798, -45.687592, -81.774498>
  translate  <8.371781, 4.050509, -0.219795>
}
union { // LeoGrp
  object { WandMitLeo }
  object { Scheinwerfer5 }
  translate  <-4.0, 3.004579, 0.0>
}


union { // Sitzbaenke
  object { Sitzgruppe }
  object { // Sitzgruppe1->Sitzgruppe
    Sitzgruppe
    rotate <0.0, 0.0, 180.0>
    translate  <34.379257, -44.432623, 0.0>
  }
  translate  <-19.968297, 2.524328, -0.2>
}


box { // Ceiling
  <-1, -1, -1>, <1, 1, 1>
  texture {
    WandTex
  }
  scale <40.0, 40.0, 1.0>
  translate  23.737041*z
}


box { // FloorCube
  <-1, -1, -1>, <1, 1, 1>
  scale <33.372864, 32.710152, 1.0>
  translate  <1.325427, -3.976281, -1.0>
  texture {
    FloorTex1
  }
}


