// Common Objects Include file 
// Include file for ICARUS, entry to Dec96 POVRAY Competition
// Copyright The Butter-Fingered Juggler


// ------------------------------------------------------
// Eye balls

#declare Eye = union {

// eyelids
difference {
sphere {<0, 0, 0>, 0.22
	pigment {color Tan} }
cone {<0, 0, 0>, 0
	<0, 0, -0.3>, 0.2
	scale <2, 0.5, 1> 
	pigment {color Black} }
}

// eyeball
sphere {<0, 0, 0>, 0.2
	texture {
		pigment { 
		wood
		color_map {
		[0.0, 0.07 color Black color Black]
		[0.07, 0.16 color SeaGreen color SeaGreen]
		[0.16, 1.0 color White color White]}
		}
		rotate <0, 90, 0>
		scale 0.1
		finish {Shiny}
	}
} 

} // end eye union

//----------------------------------------------------
// Skin Texture

#declare Skin = texture {
	pigment {
	bozo
	turbulence 1.0
	color_map {	
	[0.0, 0.1 color Tan color NewTan]
	}
	}
	normal {wrinkles 0.5}
}


// ---------------------------------------------------
// An Arm

#declare Arm = union {

// chest muscle
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-1, -0.5, 0>, <-1, -1, -0.8>, <-1, -1.5, -0.8>, <-1, -2.1, -0.5>,
   <-0.8, -0.4, -0.2>, <-0.8, -1, -0.8>, <-0.8, -1.5, -0.8>, <-0.8, -2, -0.5>,
   <-0.6, -0.5, -0.5>, <-0.6, -1, -0.7>, <-0.6, -1.5, -0.7>, <-0.6, -1.9, -0.5>,
   <-0.3, -0.6, -0.5>, <0, -1, -0.5>, <0, -1.5, -0.5>, <-0.3, -1.7, -0.5>
}

//chest muscle 2
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-1, -0.5, 0>, <-1, -1, -0.8>, <-1, -1.5, -0.8>, <-1, -2.1, -0.5>,
   <-1.5, -0.6, -0.5>, <-1.5, -1, -0.8>, <-1.6, -1.5, -0.8>, <-1.8, -2, -0.5>,
   <-2, -0.7, -0.5>, <-2.1, -1, -0.6>, <-2.2, -1.3, -0.6>, <-2.3, -1.5, -0.4>,
   <-2.6, -0.8, -0.4>, <-2.7, -0.9, -0.4>, <-2.75, -1, -0.4>, <-2.8, -1.1, -0.4>
}

// shoulder muscle 1
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-2.6, -0.8, -0.4>, <-2.7, -0.9, -0.4>, <-2.75, -1, -0.4>, <-2.8, -1.1, -0.4>,
   <-3, -0.4, -0.1>, <-3.1, -0.5, -0.1>, <-3.2, -0.7, -0.1>, <-3.3, -0.8, -0.1>,
   <-3, -0.4, 0.1>, <-3.1, -0.5, 0.1>, <-3.2, -0.7, 0.1>, <-3.3, -0.8, 0.1>,
   <-2.6, -0.8, 0.4>, <-2.7, -0.9, 0.4>, <-2.75, -1, 0.4>, <-2.8, -1.1, 0.4>
}

// shoulder muscle 2
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-2.9, -0.6, -0.0>, <-2.3, -0.1, 0>, <-1.8, -0.6, 0>, <-1, -0.5, 0>,
   <-2.85, -0.65, -0.2>, <-2.3, -0.4, -0.2>, <-1.8, -0.8, -0.2>, <-1, -0.5, 0>,
   <-2.75, -0.7, -0.3>, <-2.1, -0.6, -0.4>, <-1.6, -0.7, -0.3>, <-1, -0.5, 0>,
   <-2.6, -0.8, -0.4>, <-2, -0.7, -0.5>, <-1.5, -0.6, -0.5>, <-1, -0.5, 0>
}

// top arm "bone"
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.6, -1.6, -0.2>, <-3.8, -1.6, -0.2>, <-3.3, -1.4, -0.2>, <-2.8, -1.1, -0.4>,
   <-4.65, -1.65, -0.2>, <-3.8, -1.7, -0.3>, <-3.2, -1.55, -0.35>, <-2.6, -1.25, -0.4>,
   <-4.75, -1.7, -0.3>, <-3.8, -1.8, -0.2>, <-3.1, -1.7, -0.4>, <-2.4, -1.3, -0.4>,
   <-4.8, -1.75, -0.2>, <-3.8, -1.9, 0>, <-3, -1.8, 0>, <-2, -1.3, 0>
}

// top arm muscle
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.6, -1.6, -0.2>, <-3.8, -1.6, -0.2>, <-3.3, -1.4, -0.2>, <-2.8, -1.1, -0.4>,
   <-4.65, -1.5, -0.2>, <-3.8, -1.7, -0.4>, <-3.4, -1.1, -0.35>, <-3.1, -0.9, -0.3>,
   <-4.8, -1.4, -0.3>, <-4.1, -1, -0.4>, <-3.1, -1.7, -0.3>, <-3.15, -1.1, -0.3>,
   <-4.9, -1.2, -0.2>, <-4.2, -0.8, 0>, <-3.2, -0.6, 0>, <-2.8, -0.7, 0>
}

// elbow
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.6, -1.6, -0.2>, <-4.65, -1.65, -0.2>, <-4.75, -1.7, -0.3>, <-4.9, -1.8, -0.2>,
   <-4.65, -1.5, -0.2>, <-4.75, -1.5, -0.2>, <-4.9, -1.6, -0.2>, <-5.0, -1.7, -0.2>,
   <-4.8, -1.4, -0.3>, <-4.9, -1.4, -0.2>, <-5.1, -1.5, -0.2>, <-5.1, -1.6, -0.2>,
   <-4.9, -1.2, -0.2>, <-5.1, -1.3, -0.2>, <-5.2, -1.4, -0.2>, <-5.3, -1.5, -0.2>
}

// form arm 1
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.9, -1.8, -0.2>, <-5.0, -1.7, -0.2>, <-5.1, -1.6, -0.2>, <-5.3, -1.5, -0.2>,
   <-5.6, -2.1, 0>, <-5.7, -1.9, -0.2>, <-5.8, -1.7, -0.2>, <-5.9, -1.5, -0.2>,
   <-6.2, -2.1, 0>, <-6.1, -1.8, -0.2>, <-6.0, -1.7, -0.2>, <-6.0, -1.5, -0.2>,
   <-7.0, -1.8, 0>, <-7.0, -1.7, -0.2>, <-7.0, -1.6, -0.2>, <-7.0, -1.5, -0.2>
   
}

// form arm 2
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.9, -1.2, -0.2>, <-5.1, -1.3, -0.2>, <-5.2, -1.4, -0.2>, <-5.3, -1.5, -0.2>,
   <-5.4, -1.1, 0>, <-5.6, -1.2, -0.2>, <-5.8, -1.4, -0.2>, <-5.9, -1.5, -0.2>,
   <-6.1, -1.1, 0>, <-6.1, -1.2, -0.2>, <-6.0, -1.4, -0.2>, <-6.0, -1.5, -0.2>,
   <-7.0, -1.4, 0>, <-7.0, -1.45, -0.2>, <-7.0, -1.47, -0.2>, <-7.0, -1.5, -0.2>
  
}

// ----------------------------------------------------------------------
// back view of arm ie left+right are just mirror images

// chest muscle
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-1, -0.5, 0>, <1, -1, 0.8>, <-1, -1.5, 0.8>, <-1, -2.1, 0.5>,
   <-0.8, -0.4, 0.2>, <-0.8, -1, 0.8>, <-0.8, -1.5, 0.8>, <-0.8, -2, 0.5>,
   <-0.6, -0.5, 0.5>, <-0.6, -1, 0.7>, <-0.6, -1.5, 0.7>, <-0.6, -1.9, 0.5>,
   <-0.3, -0.6, 0.5>, <0, -1, 0.5>, <0, -1.5, 0.5>, <-0.3, -1.7, 0.5>
}

//chest muscle 2
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-1, -0.5, 0>, <-1, -1, 0.8>, <-1, -1.5, 0.8>, <-1, -2.1, 0.5>,
   <-1.5, -0.6, 0.5>, <-1.5, -1, 0.8>, <-1.6, -1.5, 0.8>, <-1.8, -2, 0.5>,
   <-2, -0.7, 0.5>, <-2.1, -1, 0.6>, <-2.2, -1.3, 0.6>, <-2.3, -1.5, 0.4>,
   <-2.6, -0.8, 0.4>, <-2.7, -0.9, 0.4>, <-2.75, -1, 0.4>, <-2.8, -1.1, 0.4>
}

// shoulder muscle 2
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-2.9, -0.6, 0.0>, <-2.3, -0.1, 0>, <-1.8, -0.6, 0>, <-1, -0.5, 0>,
   <-2.85, -0.65, 0.2>, <-2.3, -0.4, 0.2>, <-1.8, -0.8, 0.2>, <-1, -0.5, 0>,
   <-2.75, -0.7, 0.3>, <-2.1, -0.6, 0.4>, <-1.6, -0.7, 0.3>, <-1, -0.5, 0>,
   <-2.6, -0.8, 0.4>, <-2, -0.7, 0.5>, <-1.5, -0.6, 0.5>, <-1, -0.5, 0>
}

// top arm "bone"
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.6, -1.6, 0.2>, <-3.8, -1.6, 0.2>, <-3.3, -1.4, 0.2>, <-2.8, -1.1, 0.4>,
   <-4.65, -1.65, 0.2>, <-3.8, -1.7, 0.3>, <-3.2, -1.55, 0.35>, <-2.6, -1.25, 0.4>,
   <-4.75, -1.7, 0.3>, <-3.8, -1.8, 0.2>, <-3.1, -1.7, 0.4>, <-2.4, -1.3, 0.4>,
   <-4.8, -1.75, 0.2>, <-3.8, -1.9, 0>, <-3, -1.8, 0>, <-2, -1.3, 0>
}

// top arm muscle
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.6, -1.6, 0.2>, <-3.8, -1.6, 0.2>, <-3.3, -1.4, 0.2>, <-2.8, -1.1, 0.4>,
   <-4.65, -1.5, 0.2>, <-3.8, -1.7, 0.4>, <-3.4, -1.1, 0.35>, <-3.1, -0.9, 0.3>,
   <-4.8, -1.4, 0.3>, <-4.1, -1, 0.4>, <-3.1, -1.7, 0.3>, <-3.15, -1.1, 0.3>,
   <-4.9, -1.2, 0.2>, <-4.2, -0.8, 0>, <-3.2, -0.6, 0>, <-2.8, -0.7, 0>
}

// elbow
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.6, -1.6, 0.2>, <-4.65, -1.65, 0.2>, <-4.75, -1.7, 0.3>, <-4.9, -1.8, 0.2>,
   <-4.65, -1.5, 0.2>, <-4.75, -1.5, 0.2>, <-4.9, -1.6, 0.2>, <-5.0, -1.7, 0.2>,
   <-4.8, -1.4, 0.3>, <-4.9, -1.4, 0.2>, <-5.1, -1.5, 0.2>, <-5.1, -1.6, 0.2>,
   <-4.9, -1.2, 0.2>, <-5.1, -1.3, 0.2>, <-5.2, -1.4, 0.2>, <-5.3, -1.5, 0.2>
}

// form arm 1
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.9, -1.8, 0.2>, <-5.0, -1.7, 0.2>, <-5.1, -1.6, 0.2>, <-5.3, -1.5, 0.2>,
   <-5.6, -2.1, 0>, <-5.7, -1.9, 0.2>, <-5.8, -1.7, 0.2>, <-5.9, -1.5, 0.2>,
   <-6.2, -2.1, 0>, <-6.1, -1.8, 0.2>, <-6.0, -1.7, 0.2>, <-6.0, -1.5, 0.2>,
   <-7.0, -1.8, 0>, <-7.0, -1.7, 0.2>, <-7.0, -1.6, 0.2>, <-7.0, -1.5, 0.2>
   
}

// form arm 2
bicubic_patch {
   type 1
   flatness 0.01
   u_steps 3
   v_steps 3
   <-4.9, -1.2, 0.2>, <-5.1, -1.3, 0.2>, <-5.2, -1.4, 0.2>, <-5.3, -1.5, 0.2>,
   <-5.4, -1.1, 0>, <-5.6, -1.2, 0.2>, <-5.8, -1.4, 0.2>, <-5.9, -1.5, 0.2>,
   <-6.1, -1.1, 0>, <-6.1, -1.2, 0.2>, <-6.0, -1.4, 0.2>, <-6.0, -1.5, 0.2>,
   <-7.0, -1.4, 0>, <-7.0, -1.45, 0.2>, <-7.0, -1.47, 0.2>, <-7.0, -1.5, 0.2>
}

texture {Skin}

} // end arm union

// -------------------------------------------------------
// tunic creases
#declare Fold = 
	cone {<0, -6, 0>, 0.2	
		<0, -10, -0.5>, 0.26
		open
		clipped_by {plane {z, 0.1}}
}

// -------------------------------------------------------
// Feathers and Wings

#declare Feather =
union {

cone {<0, 0, 0>, 0.05
 	<0, -2.1, 0>, 0
	pigment {color White}
}

cylinder {<0, -0.5, -0.01>, <0, -0.5, 0.01>, 0.3	
		scale <0.8, 2.7, 1>}

texture {
pigment {
	gradient y
	color_map {
	[0.0, 0.7 color Black color White]
	[0.7, 0.8 color Black color Black]
	[0.8, 1.0 color White color White]}
}
}

} // end feather union

#declare mrv = -1	// offset for middle row vertical
#declare mrh = -0.25	// offset for middle row horizontal
#declare brv = -2	// offset for bottom row vertical
#declare brh = -0.5	// offset for bottom row horizontal

#declare Wing_Frame = union {
box {<-5.5, -0.3, -0.1>, <-3.5, -0.5, 0.1>}
box {<-3.5, 0, -0.1>, <0, -0.2, 0.1>
	rotate <0, 0, 5>
}
box {<-5.5, 0, -0.1>, <-3.5, -0.2, 0.1>
	rotate <0, 0, -5>
	translate <0, -2.4, 0>
}
box {<-3.5, 0, -0.1>, <0, -0.2, 0.1>
	rotate <0, 0, 5>
	translate <0, -1.8, 0>
}
cylinder {<-4, -1.8, 0>, <-4.2, -1.8, 0>, 0.5	
	open
}
cylinder {<-2.3, -1.7, 0>, <-2.5, -1.7, 0>, 0.6	
	open
}

pigment {color Brown}
} // end frame union
