#include "metals.inc"
#include "finish.inc"
#include "prop.inc" // contains the propeller

#declare T_Body_Silver = texture { T_Silver_4B }
#declare T_Pin_Brass = texture { T_Brass_2A }
#declare T_Body_Red =
texture {
   pigment { color rgb<1,.3,.3> }
   finish {
      phong 1.0
      phong_size 10
      ambient 0.2
      diffuse 0.8
      brilliance 4
      reflection .2
   }
}

/********************************RIB******************************************/
#declare Rib=union{
torus{6,.1
texture { T_Body_Silver }
}
cylinder{0,
<0,.1,0>,
6
texture { T_Body_Silver }
}}
/*++++++++++++++++++++++++++++CYLINDER+++++++++++++++++++++++++++++++++++++++*/
union{
/*****************************************************************************/
union{cylinder{<0,3,0>,
<0,7,0>,
5.5
texture { T_Body_Silver }
}
object{Rib translate y*3 scale <1.02,1,1.02>}
object{Rib translate y*4 scale <1.04,1,1.04>}
object{Rib translate y*5 scale <1.06,1,1.06>}
object{Rib translate y*6 scale <1.08,1,1.08>}
object{Rib translate y*7 scale <1.1,1,1.1>}
cylinder{0
<0,3,0>,
5
texture { T_Body_Silver }
}
object{Rib scale <.96,1,.96>}
object{Rib translate y*1 scale <.98,1,.98>}
object{Rib translate y*2 }
translate y*7
}
/*****************************************************************************/
difference{union{cylinder{0,<0,7,0>,5.4
texture { T_Body_Silver }}
cylinder{<0,.8,0>,<0,6.7,0>,5.64
texture { T_Body_Silver }}
}
superellipsoid{<.25,.25>
texture { T_Body_Silver }translate <-1,2.7,0>scale <3,1.4,5>}
superellipsoid{<.25,.25>
texture { T_Body_Silver }translate <1,2.7,0>scale <3,1.4,5>}
cylinder{0,<0,7,0>,4.5
texture { T_Body_Silver }}}
/*****************************************************************************/
translate y*8
}

/*++++++++++++++++++++++++++THE PISTON+++++++++++++++++++++++++++++++++++++++*/

cylinder{<0,8,0>,<0,11.5,0>,4.49texture { T_Body_Silver }}
cylinder{<0,8,0>,<0,11.55,0>,3.5texture { T_Body_Silver }}

/***************************CYLINDER HEAD*************************************/

cone{<0,22,0>,4
<0,25.3,0>,2.8
texture { T_Body_Silver }
}
object{Rib translate y*22 scale<1.1,1,1.1>}
object{Rib translate y*23 scale<1.095,1,1.095>}
object{Rib translate y*24 scale<1.02,1,1.02>}
difference{object{Rib translate y*25 scale<.8,1,.8>}
superellipsoid{<.25,.25> scale <1,1,.5> translate <4.8,25,0> rotate y*60
texture { T_Body_Silver }}
superellipsoid{<.25,.25> scale <1,1,.5> translate <4.8,25,0> rotate y*240
texture { T_Body_Silver }}}

object{Rib translate y*25.3 scale<.4666,1,.4666>}
cone{<0,25.5,0>,2.5
<0,26.2,0>,1.7
texture { T_Body_Silver }
}
cone{<0,26.2,0>,.4
<0,26.6,0>,.2
texture { T_Body_Silver }
}
cylinder{<0,26.6,0>,<0,27.2,0>,.2
texture { T_Body_Silver }
}
object{Rib translate y*26.6 scale <0.066666,1,0.066666>}
object{Rib translate y*27.2 scale <0.066666,1,0.066666>}

/********************LOWER SILVERED PART OF CYLINDER**************************/

difference{union{intersection{sphere{<0,-.5,0>,9.2 texture { T_Body_Silver }}
box {<-5.8,0,-5.8>,<5.8,8,5.8>
texture { T_Body_Silver }}
texture { T_Body_Silver }
}
cylinder{<-5.85,0,0>,<5.85,0,0>,5.8
texture { T_Body_Silver }}

cylinder{<-5.9,0,0>,<5.9,0,0>,5.7
texture { T_Body_Silver }}

cylinder{<0,6,0>,<0,8,0>,5.8
texture { T_Body_Silver }}

cylinder{<-6,0,0>,<-6.4,0,0>,5.7
texture { T_Body_Silver }}

cylinder{<-5.8,0,0>,<-7.25,0,0>,5.3
texture { T_Body_Silver }}

difference { union {
box{<-5.8,0,-8.7>,<5.8,1.5,8.7>
texture { T_Body_Silver }}

box{<-3.8,0,-10.7>,<3.8,1.5,10.7>
texture { T_Body_Silver }}

cylinder{<-3.8,0,-8.7>,<-3.8,1.5,-8.7>,2
texture { T_Body_Silver }}

cylinder{<-3.8,0,8.7>,<-3.8,1.5,8.7>,2
texture { T_Body_Silver }}

cylinder{<3.8,0,-8.7>,<3.8,1.5,-8.7>,2
texture { T_Body_Silver }}

cylinder{<3.8,0,8.7>,<3.8,1.5,8.7>,2
texture { T_Body_Silver }}
}
cylinder{<-3.6,-0.1,-8.5>,<-3.6,1.6,-8.5>,1
texture { T_Body_Silver }}
cylinder{<3.6,-0.1,-8.5>,<3.6,1.6,-8.5>,1
texture { T_Body_Silver }}
cylinder{<-3.6,-0.1,8.5>,<-3.6,1.6,8.5>,1
texture { T_Body_Silver }}
cylinder{<3.6,-0.1,8.5>,<3.6,1.6,8.5>,1
texture { T_Body_Silver }}
}}
union{intersection{box{<-7.5,-1.015,-5.7>,<-6.2,1.015,5.7> 
texture {T_Body_Silver}}
cylinder{<-7.2,0,-5.7>,<-7.2,0,5.7>,1 texture { T_Body_Silver}}}
cylinder{<-7.3,0,0>,<-3,0,0>,4.5 texture { T_Body_Silver}
rotate x*-40
}}}

difference{box{<-5.7,1.5,-7.8>,<5.7,3.5,7.8>texture { T_Body_Silver }}
cylinder{<-5.75,3.5,-7.8>,<5.75,3.5,-7.8>,2
texture { T_Body_Silver }}
cylinder{<-5.75,3.5,7.8>,<5.75,3.5,7.8>,2
texture { T_Body_Silver }}}

// Bolt: adapted from Ian Armstrong's Iaclock image
#declare Bolt =
#declare R = 0.7              // Coil radius
#declare W = 0.1           // Wire radius
#declare C = 22             // Distance/Coil ratio
#declare TFirst = 0
#declare TLast = pi/2
#declare T = TFirst
#declare S = 0
#declare Height = 7
#declare Width = 8
#declare X0 =Width*TFirst/(TLast-TFirst)
#declare V0 = <0,Height*cos(TFirst),0>
#declare P1 = V0
union {
  #while (T < TLast)
     #declare Y = Height*cos(T)
     #declare X = Width*T/(TLast-TFirst) - X0
     #declare V1 = <X,Y,0>
     #declare DS = vlength(V1-V0)
     #declare S = S + DS
     #if (DS > 0)
       #declare P1 = vaxis_rotate(<0,0,R>,V1-V0,degrees(S*C)) + V1
       sphere { P1,W }
       cylinder { P0,P1,W }
       sphere { V0,R }
       cylinder { V0,V1,R }
     #end
     #declare V0 = V1
     #declare P0 = P1
     #declare T = T + (TLast-TFirst)/350
   #end
   texture { T_Pin_Brass }
   translate -Height*cos(TFirst)*y
   rotate z*-90
}
object { Bolt translate <3.6,0,-8.5> }
difference {
   superellipsoid { <1,.25> rotate x*90 scale <1.5,1,1.5> }
   superellipsoid { <1,.5> rotate z*90 scale <2,.5,.4> translate y*1 rotate y*40 }
   texture { T_Pin_Brass }
   translate <3.6,1.5,-8.5>
}

/****************************RED CONE*****************************************/

cone{<5.86,0,0>,5.6
<14.56,0,0>,4.76
texture { T_Body_Red }
}

difference{union{cylinder{<10,0,-5>,<10,0,-7.5>,.45
texture { T_Body_Red }}

cone{<10,0,-7.5>,.45
<10,0,-8>,.3
texture { T_Body_Red }}}

cylinder{<10,0,-4>,<10,0,-8.5>,.2
texture { T_Body_Red }}
}
/*****************************************************************************/
union{lathe{
quadratic_spline
11,
<.16791,-1>,
<.26791,0>,
<.27916,.11731>,
<.31292,.22983>,
<.36667,.33359>,
<.43418,.42611>,
<.39168,.46236>,
<.32292,.3636>,
<.26291,.25108>,
<.22665,.12856>,
<.21415,.0>
texture { T_Body_Red }
}
difference{
cylinder{<0,-1,0>,0,.27
texture { T_Body_Red }}
cylinder{<0,-1.1,0>,<0,.1,0>,.21
texture { T_Body_Red }}}

difference{cylinder{<0,-.3,.3>,<0,-.3,-.3>,.19 texture { T_Body_Red }}
box{<-.2,-.5,-.2>,<.2,-.1,.2>texture { T_Body_Red }}}
/*********************RPM PIN************************************************/
union{cylinder{<0,0,-.3>,<0,0,-1.58>,.08 texture { T_Pin_Brass }}
     difference{
                union{cylinder{<0,0,-1.39>,<0,0,-1.57>,.19 texture { T_Pin_Brass }}
                     cone{<0,0,-1.57>,.18
                     <0,0,-1.58>,.17
                     texture { T_Pin_Brass }}
                     cone{<0,0,-1.39>,.18
                     <0,0,-1.38>,.17}
                     }
                #declare A = 0
                #while (A<36)
                box{<-.1,-.1,0>,<.1,.1,.21>rotate z*45 translate<0,.32,-1.58> rotate z*A*10
                texture { T_Pin_Brass }}
                #declare A =A+1
                #end
                texture { T_Pin_Brass }}
                translate y*-.3
                }
     cone{<0,-.3,-.78>,.15<0,-.3,-.77>,.17 texture { T_Pin_Brass }}
     cylinder{<0,-.3,-.77>,<0,-.3,-.73>,.17 texture { T_Pin_Brass }}
     cone{<0,-.3,-.73>,.17<0,-.3,-.72>,.15 texture { T_Pin_Brass }}
     // ******* Spring!!! *****************************************
     #declare R0 = .15   // major radius
     #declare W  = .02   // minor radius
     #declare P0 = <0,0,0>
     #declare P1 = P0
     #declare N  = 16    // how many loops
     #declare PA = 0.001
     #declare PX = PA
     union {
        #while(PX<1)
           #declare R = R0*min(2/3+(PX/0.3)*1/3,1)
           #declare P1 = vaxis_rotate(<0,0,-R>,x,360*N*PX) + PX*x
           cylinder { P0,P1,W texture { T_Pin_Brass }}
           sphere { P1,W texture { T_Pin_Brass }}
           #declare P0 = P1
           #declare PX = PX + PA
        #end
        rotate <0,-90,0>
        scale <1,1,.52>
        translate <0,-.3,-.72>
     }
     scale 7
     translate<5.5,15,0>
     rotate z*-33
     }

/******************SILVERED PART NEXT TO PROP*********************************/
difference{
union{cone{<14.56,0,0>,4.76<19.2,0,0>,4.312texture { T_Body_Silver }}
cylinder{<17.5,0,0>,<19.4,0,0>,4.2 texture { T_Body_Silver }}
     }
union{
      intersection{
                   box{<18,-1,4.5>,<19.2,1,-4.5>texture { T_Body_Silver }}
                   cylinder{<19.2,0,-4.5>,<19.2,0,4.5>,1.16 texture { T_Body_Silver }}
                   }
      box{<19,-1,-4.5>,<19.5,1,4.5>texture { T_Body_Silver }}
      rotate x*-20
      }
}
cylinder{<17.5,0,0>,<19.4,0,0>,3texture { T_Body_Silver }}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<19,0,-2.5>rotate x*-20}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.8,0,-2.5>rotate x*-20}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.6,0,-2.5>rotate x*-20}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.4,0,-2.5>rotate x*-20}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.2,0,-2.5>rotate x*-20}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18,0,-2.5>rotate x*-20}

box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<19,0,-2.5>rotate x*-200}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.8,0,-2.5>rotate x*-200}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.6,0,-2.5>rotate x*-200}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.4,0,-2.5>rotate x*-200}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18.2,0,-2.5>rotate x*-200}
box{-1,1texture { T_Pin_Brass }rotate y*45 scale <.3,1,1> 
translate<18,0,-2.5>rotate x*-200}

cylinder {<19,0,0>,<20,0,0>,2 texture { T_Body_Silver }}
cone{<19.4,0,0>,4.312 <22.3,0,0>,4.032 texture { T_Body_Silver }}
cone{<22.3,0,0>,4.032<22.45,0,0>,4.45 texture { T_Body_Silver }}
cylinder{<22.45,0,0>,<22.83,0,0>,4.45 texture { T_Body_Silver }}
difference{cone{<22.83,0,0>,4.45 <23.21,0,0>,4.07 texture { T_Body_Silver }}
#declare I=0
#while(I<40)
box{<-.5,-.5,-4.5>,<.5,.5,0> texture { T_Body_Silver } rotate z*45
rotate x*I*9 translate x*23.5}
#declare I=I+1
#end
}
difference {
   cylinder{<23.21,0,0>,<27.56,0,0>,4.05 pigment {color rgb .2} finish {Shiny}}
   object { Hf pigment {color rgb .2} finish {Shiny}
      translate z*-.5
      scale <4.35,5,4.05>
      translate <23.21,-5,0>
      rotate x*45
   }
}
cylinder{<27.56,0,0>,<28.13,0,0>,4.05 texture { T_Body_Silver }}
cone{<28.13,0,0>,4.05<29.23,0,0>,1.5 texture { T_Body_Silver }}
/****BOLT AT TIP OF PROP*****/
difference{union{torus{1.4,.1 texture { T_Body_Silver }
rotate z*90 translate x*29.33}
cone{<29.33,0,0>,1.5<29.99,0,0>,1 texture { T_Body_Silver }}
sphere{<59.9,0,0>,1 scale <.5,1,1> texture { T_Body_Silver }}
}
union{box{<29.66,-.2,-1.5>,<30.45,.2,1.5> texture { T_Body_Silver }}
cylinder{<29.66,0,-1.5>,<29.66,0,1.5>,.2 texture { T_Body_Silver }}
rotate x*-30
}
}
