// Shoulders, torso & pelvis areas
//
// this file should be included in a blob statement ONLY
// and only after all the variables have been defined...


// shoulders
cylinder { shoulder1_position, shoulder2_position 0.3, 1}

// upper torso
cylinder { neck_base, ribcage_base 0.8, 1 }
cylinder { shoulder1_position, ribcage_base 0.8, 1 }
cylinder { shoulder2_position, ribcage_base 0.8, 1 }

#declare chest1 = (shoulder1_position * 0.55) + (ribcage_base * 0.55) + <0, 0, -0.2>
#declare chest2 = (shoulder2_position * 0.55) + (ribcage_base * 0.55) + <0, 0, -0.2>

sphere { <0, 0, 0>, 0.6, 1 scale <1.2,1.5,0.8> rotate <20, 0, 0> translate chest1 }
sphere { <0, 0, 0>, 0.6, 1 scale <1.2,1.5,0.8> rotate <20, 0, 0> translate chest2 }


// lower torso
cylinder { ribcage_base, pelvis_position 0.6, 1 }
cylinder { ribcage_base, hip1_position 0.6, 1 }
cylinder { ribcage_base, hip2_position 0.6, 1 }
cylinder { neck_base, hip1_position 0.6, 1 }
cylinder { neck_base, hip2_position 0.6, 1 }

// pelvis
cylinder { hip1_position, hip2_position 0.5, 1 }
sphere { <0,0,0>, 1, 1 scale <1,1.5,1> translate hip1_position + <0,0.2,0.5> }
sphere { <0,0,0>, 1, 1 scale <1,1.5,1> translate hip2_position + <0,0.2,0.5> }
