#declare seat_base = box { <-0.5, 0, -4> < 0.5,  0.5,  2> }

#declare seat_back = object { seat_base
                              scale <2, 1, 1>
                              translate <0, 0, 3>
                              rotate <-65, 0, 0>
                              }

#declare bike_base = box { <-0.7, -3, -5> < 0.7,  0,  2> }

#declare bike_front = difference {
                               object { seat_base }
                               box { <0.4, 0.1, -3> <0.6, 0.4, 1> }
                               box { <-0.6, 0.1, -3> <-0.4, 0.4, 1> }
                               texture {DirtyRustyMetal_2 scale 3}
                               scale <2, 3, 1>
                              }

#declare Console = box { <-0.5, 0.05, 1.7> < 0.5,  2.5,  2.1>
                           texture { Console_Screen } }


#declare handle_bars = union {
                           cylinder {<0,3,1>, <3,0.3,2>, 0.3 }
                           cylinder {<0,3,1>, <-3,0.3,2>, 0.3 }
                           torus { 0.3, 0.2 rotate <0,0,90> translate <0,3,1> }
                           texture { OilyRusty_1 scale 3 }
                           }

#declare weapon1 = sphere { <0,0,0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
                 halo {
                      emitting
                      spherical_mapping
                      linear
                      turbulence 1.5
                      color_map {
                                [ 0 color rgbt <1, 0, 1,  1> ]
                                [ 0.2 color rgbt <1, 0.4, 1,  -1> ]
                                [ 0.7 color rgbt <1, 1, 1, -1> ]
                                [ 1 color rgbt <1, 1, 1, -1> ]
                                }
                      samples 10
                      scale 0.5
                      }
                 hollow
                 scale <3, 3, 3>
                 translate <0,0.7,-9>
                 }

#declare mouldings1 = blob { threshold 0.6
                           cylinder { <0,1,-3>, <0,2,1>, 1, 1 }
                           cylinder { <0.1,2,-3>, <0.3,2,1>, 0.5, 1 }
                           cylinder { <-0.1,2,-3>, <-0.3,2,1>, 0.5, 1 }

                           cylinder { <0.5,1.5,-3>, <0.5,1.5,1>, 0.5, 1 }
                           cylinder { <-0.5,1.5,-3>, <-0.5,1.5,1>, 0.5, 1 }

                           cylinder { <0,2,-3>, <0,2.5,1>, 0.5, -1 }
                           texture { DirtyRustyMetal_2 scale 3 }
                           }

#declare mouldings2 = blob { threshold 0.6
                           cylinder { <0.7,1,-4>, <0.7,1,2>, 0.5, 1 }
                           cylinder { <-0.7,1,-4>, <-0.7,1,2>, 0.5, 1 }
                           cylinder { <0.9,1.3,-3.5>, <0.9,1.3,2>, 0.3, 1 }
                           cylinder { <-0.9,1.3,-3.5>, <-0.9,1.3,2>, 0.3, 1 }
                           cylinder { <0.9,1.6,-3.5>, <0.9,1.6,2>, 0.3, 1 }
                           cylinder { <-0.9,1.6,-3.5>, <-0.9,1.6,2>, 0.25, 1 }

                           texture { OilyRusty_1 scale 3 }
                           }

#declare bike_front = union {
                            object { bike_front }
                            object { mouldings1 }
                            object { mouldings2 }
                            object { handle_bars }
                            object { Console }
                            object { weapon1 }
                            #declare Count = 0
                            #while (Count < 4)
                                   torus { 0.6, 0.3 scale <2 + Count/4, 1, 1> rotate <-90,0,0>
                                           translate <0, 0.3, -3 + Count>
                                           texture { OilyRusty_1 scale 3 }}
                                   #declare Count = Count + 0.5
                            #end
                            cylinder { <0, 0.7, -6> <0, 0.7, 1> 0.7
                                     texture {OilyRusty_1 scale 3}}
                            torus { 0.6, 0.2 rotate <-90, 0,0> translate <0, 0.7, -6>
                                     texture {DirtyRustyMetal_2 scale 3}}
                            torus { 0.6, 0.3 rotate <-90, 0,0> translate <0, 0.7, -4>
                                     texture {DirtyRustyMetal_2 scale 3}}
                            cylinder { <0, 0.7, -9> <0, 0.7, 1> 0.5
                                     texture {OilyRusty_1 scale 3}}

                            // **** Laser Beam
                            cylinder { <0, 0.7, -30> <0, 0.7, 1> 0.3
                                     texture { pigment { color rgbt <1, 0.4, 1, 1> }
                                               finish { ambient 1 } } no_shadow }
                            cylinder { <0, 0.7, -30> <0, 0.7, 1> 0.1
                                     texture { pigment { color rgb 1 }
                                               finish { ambient 1 } } no_shadow }


                            rotate <-35, 0, 0>
                            translate <0, 0, -4.8>
                            }


#declare bike_base2 = difference {
                               cone { <0, -3, -7>, 1, <0, -3, 4>, 3 }
                               box { <-1, -3, -5> < 1,  0,  5> }
                               }

#declare bike_base2 = union {
                            object { bike_base2 }
                            object { bike_base2 scale <1, 1, 0.3>}
                            object { bike_base2 scale <1.8, 0.5, 0.3> translate <0, -2, -6>}
                            }

#declare wings = difference {
                               cone { <0, 0, -7>, 1, <0, 1, 4>, 10
                                      scale <2, 0.1, 1> }
                               box { <-2, -3, -8> < 2,  3,  5> }
                               translate <0, -4, 0>
                            }




#declare flame1 = sphere { <0,0,0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
                 halo {
                      emitting
                      spherical_mapping
                      linear
                      turbulence 1.5
                      color_map {
                                [ 0 color rgbt <1, 0, 0,  1> ]
                                [ 0.4 color rgbt <1, 1, 0,  0.5> ]
                                [ 1 color rgbt <1, 1, 1, -1> ]
                                }
                      samples 10
                      scale 0.5
                      }
                 hollow
                 scale <10, 10, 20>
                 translate <0,-3,16>
                 }

#declare flame2 = sphere { <0,0,0>, 1
             pigment { color rgbt <1, 1, 1, 1> }
                 halo {
                      emitting
                      spherical_mapping
                      linear
                      turbulence 1.5
                      color_map {
                                [ 0 color rgbt <1, 0, 0,  1> ]
                                [ 0.4 color rgbt <1, 1, 0,  0.5> ]
                                [ 1 color rgbt <1, 1, 1, -1> ]
                                }
                      samples 10
                      scale 0.5
                      }
                 hollow
                 scale <10, 10, 10>
                 translate <0,-3,10>
                 }

#declare bike = union {
                      object { seat_base texture {Rusty_Metal_1 scale 3}
                                         texture {Oil} }
                      object { seat_back texture {Rusty_Metal_1 scale 3}
                                         texture {Oil} }
                      object { bike_base texture {Rusty_Metal_1 scale 3}
                                         texture {Oil} }
                      object { bike_front }
                      object { bike_base2 texture {Rusty_Metal_1 scale 3}
                                         texture {Oil} }
                      object { wings texture {DirtyRustyMetal_2 scale 3}}
                      //object { flame1 }
                      object { flame2 }
                      }
