// "A Fine Day"
// August 1996 entry in the POV Internet Ray Tracing Comp
// By The Butter-Fingered Juggler

#include "colors.inc"
#include "shapes.inc"
#include "shapesq.inc"
#include "textures.inc"
#include "afineday.inc"

camera {
   location  <20,10,-30>
   look_at   <20, 5, 3>
}
// Bright light (sun)
light_source {<15, 80, -100> color White}
light_source {<0, 100, -20> color White}

// ---------------------------------------

// Rainbow
difference {
   cylinder { <100, 0, 200>, <100, 0, 300>, 200 open
          texture {
          pigment {
             gradient z
             color_map {
             [0.00, 0.11 color Clear // to blur edges into sky
                         color rgbf <0.50, 0.00, 0.00, 0.0>]
             [0.11, 0.22 color rgbf <0.50, 0.00, 0.00, 0.0>
                         color rgbf <0.50, 0.25, 0.00, 0.0>]
             [0.22, 0.33 color rgbf <0.50, 0.25, 0.00, 0.0>
                         color rgbf <0.50, 0.50, 0.00, 0.0>]
             [0.33, 0.44 color rgbf <0.50, 0.50, 0.00, 0.0>
                         color rgbf <0.00, 0.50, 0.00, 0.0>]
             [0.44, 0.55 color rgbf <0.00, 0.50, 0.00, 0.0>
                         color rgbf <0.00, 0.25, 0.50, 0.0>]
             [0.55, 0.66 color rgbf <0.00, 0.25, 0.50, 0.0>
                         color rgbf <0.00, 0.00, 0.50, 0.0>]
             [0.66, 0.77 color rgbf <0.00, 0.00, 0.50, 0.0>
                         color rgbf <0.25, 0.00, 0.50, 0.0>]
             [0.77, 0.88 color rgbf <0.25, 0.00, 0.50, 0.0>
                         color rgbf <0.50, 0.00, 0.50, 0.0>]
             [0.88, 1.01 color rgbf <0.50, 0.00, 0.50, 0.0>
                         color Clear] // to blur edges into sky
             }
          }
          scale 100
          finish {ambient 0.6}
        }
        no_shadow
      } // end cylinder
   plane { y, 7} // to stop rainbow ending in middle of sea
} // end diff

// Raindrops
object { //front drop
   Raindrop
   translate <24, 13, -20>
}
object {
  Raindrop
   translate <20, 13, 0>
}
object {
   Raindrop
   translate <25, 22, 20>
}
object {
   Raindrop
   translate <35, 30, 40>
}


// Sea
// Sea Base
difference {
   box {<-1000,0.01, 51>, <160, 0, 1000>
       rotate <0, 30, 0> }
   sphere {<40, 0, 50> , 20
        scale <1, 1, 0.7> }
   pigment {color Blue}
}
// Sea behind main waves
difference {
   box {<-1000, 0, 50>, <160, 0.5, 1000>
        rotate <0, 30, 0> }
   sphere {<40, 0, 50> , 20   // wave receding section
        scale <1, 1, 0.7> }
   texture {Ocean normal {waves 2 frequency 1 phase 1 scale 10}}
}
object {Wave
        scale 2
        rotate <0, 30, 0>
        translate <60, 0, 39>
        texture {Ocean scale 2 rotate <0, 10, 0>}}
object {Wave
        scale 2
        rotate <0, 30, 0>
        translate <40, 0, 49>
        texture {Ocean scale 2 rotate <0, 10, 0>}}
object {Wave
        scale 2
        rotate <0, 30, 0>
        translate <15, 0, 49>
        texture {Ocean scale 2 rotate <0, 10, 0>}}
object {Wave
        scale 1.5
        rotate <0, 30, 0>
        translate <57, 0, 69>
        texture {Ocean scale 2 rotate <0, 10, 0>}}
object {Wave
        scale 1.5
        rotate <0, 30, 0>	
        translate <30, 0, 69>
        texture {Ocean scale 2 rotate <0, 10, 0>}}

// The beach
plane { y, 0  
      texture {Sand} }

// Sky Background
sphere { <0, 0, 0>, 1000
       texture {
         pigment
         {marble
         turbulence 0.1
            color_map
              {[0 color LightBlue]
               [0.5 color SummerSky]}
          scale 500}
          rotate <0, 0, 90>
          finish {Luminous}
       }
}
sphere {<0, 0, 0>, 999
        texture {Clouds1} }
sphere {<0, 0, 0>, 990
        texture {Clouds1 rotate <0, 15, 20>} }

// SandCastle
object {SandCastle
        translate <30, 0, -8> }

// Blue Deck Chair
object {Chair
       texture {Faded_Wood}
       }
object {Chair_Material_1
       texture {Blue_Stripe}
       }

// Red Deck Chair
object {Chair
       rotate <0, 30, 0>
       translate <2, 0, 15>
       texture {Faded_Wood}
       }
object {Chair_Material_1
       rotate <0, 30, 0>
       translate <2, 0, 15>
       texture {Red_Stripe}
       }

// drinkies
object {Bottle
        texture {Green_Glass}
        rotate <5, 0, 5>
        scale 0.25
        translate <7, 0, -3>}

// Child's Play
object {Bucket
        scale .8
        rotate <0, 0, 25>
        translate <20, -0.5, -8> }

object {Spade
        pigment {color Cyan}
        rotate <0, -50, 5>
        translate <11, 0, -11> }
