#declare Bee_black = texture {
	pigment {color rgb <0.2 0.2, 0>}
	finish {ambient 0.2 phong 0.4}
}

#declare Eye_color = texture {
	pigment {color rgb <0.5, 0.5, 0.5>}
	finish {ambient 0.2 phong 1 phong_size 60}
}

#declare Wing_color = texture {
	pigment {color rgbf <1, 1, 1, 0.7>}
	finish {ambient 0.25 phong 0.5 phong_size 70}
	normal {bumps 0.3 scale <0.2, 1, 0.025>}
}

#declare Body = union {
	sphere {<0, 0, 0>, 0.5
		pigment {
			gradient x
			color_map {
				[0 0.2 color rgb <0.25, 0.1, 0> color rgb <0.75, 0.6, 0>]
				[0.2 0.5 color rgb <0.75, 0.6, 0> color rgb <0.75, 0.6, 0>]
				[0.5 0.7 color rgb <0.75, 0.6, 0> color rgb <0.25, 0.1, 0>]
				[0.7 1 color rgb <0.25, 0.1, 0> color rgb <0.25, 0.1, 0>]
			}
			frequency 4
			translate x*0.5
		}
		finish {ambient 0.25 phong 0.1 phong_size 20}
		scale <1, 0.5, 0.6>
		translate -x*0.5 rotate z*15 translate x*0.5
	}
	sphere {<0, 0, 0>, 0.25 scale <1.2, 1, 1> translate x*0.7
		pigment {color rgb <0.8 0.7, 0>}
		finish {ambient 0.25 phong 0}
		normal {bumps 0.3 scale 0.04}
	}
}

#declare Head = union {
	sphere {
		<1.15, -0.05, 0>, 0.2
		texture {Bee_black}
	}
	union {
		union {
			sphere {
				<0, 0, 0>, 0.2
				scale <0.1, 1, 0.1>
				translate y*0.2
			}
			sphere {
				<0, 0, 0>, 0.06
				scale <1, 0.4, 0.4>
				translate <0.06, 0.4, 0>
			}
			rotate <-30, 0, -60>
			translate <1, 0.1, -0.05>
		}
		union {
			sphere {
				<0, 0, 0>, 0.2
				scale <0.1, 1, 0.1>
				translate y*0.2
			}
			sphere {
				<0, 0, 0>, 0.06
				scale <1, 0.4, 0.4>
			translate <0.06, 0.4, 0>
			}
			rotate <30, 0, -60>
			translate <1, 0.1, 0.05>
		}
		texture {Bee_black}
	}
	sphere {
		<0, 0, 0>, 0.12	//eye
		scale <1.5, 1, 1> rotate <0, -15, -35>
		translate <1.22, 0, -0.08>
		texture {Eye_color}
	}
	sphere {
		<0, 0, 0>, 0.12	//eye
		scale <1.5, 1, 1> rotate <0, 15, -35>
		translate <1.22, 0, 0.08>
		texture {Eye_color}
	}
	sphere {		//mouth
		<0, 0, 0>, 0.12
		scale <1, 0.35, 0.35>
		rotate -z*60
		translate <1.35, -0.16, 0>
		texture {Bee_black}
	}
	translate -y*0.1
}

#declare Wings = union {
	sphere {<0, 0, 0>, 0.5		//right
		scale <1, 0.01, 0.3>
		rotate <8, -8, 0>
		translate <0, 0.2, -0.04>
		rotate -x*30
		texture {Wing_color}
	}
	sphere {<0, 0, 0>, 0.5		//left
		scale <1, 0.01, 0.3>
		rotate <-10, 8, 0>
		translate <0, 0.2, 0.04>
		rotate x*30
		texture {Wing_color}
	}
}

#declare Leg1 = union {
	sphere {<0, 0, 0>, 0.3
		scale <1, 0.15, 0.15>
	}
	sphere {<0, 0, 0>, 0.3
		scale <1, 0.25, 0.25>
		rotate z*90
		translate <-0.3, -0.3, 0>
	}
	sphere {<0, 0, 0>, 0.1
		scale <1, 0.25, 0.25>
		translate -x*0.1 rotate z*30 translate x*0.1
		translate <-0.4, -0.6, 0>
	}
}

#declare Leg2 = union {
	sphere {<0, 0, 0>, 0.2
		scale <0.2, 0.2, 1>
	}
	sphere {<0, 0, 0>, 0.25
		scale <0.15, 0.15, 1>
		translate -z*0.25
		rotate -x*120
		translate -z*0.2
	}
	sphere {<0, 0, 0>, 0.1
		scale <0.2, 0.2, 1>
		translate -z*0.1 rotate x*70
		translate -z*0.5
		rotate -x*120
		translate -z*0.2
	}
}

#declare Leg3 = union {
	sphere {<0, 0, 0>, 0.15
		scale <0.2, 0.2, 1>
	}
	sphere {<0, 0, 0>, 0.2
		scale <0.15, 0.15, 1>
		translate -z*0.2
		rotate -x*90
		translate -z*0.15
	}
	sphere {<0, 0, 0>, 0.05
		scale <0.2, 0.2, 1>
		translate -z*0.05 rotate x*70
		translate -z*0.4
		rotate -x*90
		translate -z*0.15
	}
}

#declare Legs = union {
	object {
		Leg1
		rotate <0, -40, -30>
		translate <0.34, -0.05, -0.2>
	}
	object {
		Leg1
		rotate <0, 40, -30>
		translate <0.34, -0.05, 0.2>
	}
	object {
		Leg2
		rotate <40, 35, 0>
		translate <0.6, -0.08, -0.3>
	}
	object {
		Leg2
		rotate y*180
		rotate <-40, -35, 0>
		translate <0.6, -0.08, 0.3>
	}
	object {
		Leg3
		rotate <20, -45, 0>
		translate <0.9, -0.15, -0.26>
	}
	object {
		Leg3
		rotate y*180
		rotate <-20, 45, 0>
		translate <0.9, -0.15, 0.26>
	}
	texture {Bee_black}
}

#declare Bee = union {
	object {Body}
	object {Head}
	object {Wings}
	object {Legs}

	rotate y*180
	translate <-0.5, 0.48, 0>
	scale <0.9, 1, 1>
	scale 0.06
}