// Persistence of Vision data file created with GUM 0.91

#include "colors.inc"

#include "textures.inc"


#declare steely_blue = texture {
   finish { Shiny }
   pigment { color LightSteelBlue }
}

#declare white_marble = texture {
      White_Marble 
       finish {
          phong .5 phong_size 300
          reflection 0.35                
       }
}
#declare matte_white = texture {
   pigment { color White }
   ambient .4
   roughness .06
}
#declare element_table  = texture
{
  pigment
  {
    image_map
    {
      gif "elementtable.gif"
//      map_type 1
//      interpolate 2
    }
  }
  finish { ambient .5 }
}

#declare Reflective = 
 finish
  {metallic
   ambient 0.2
   diffuse 0.7
   brilliance 6
   reflection 0.25
   phong 0.75
   phong_size 80
  }
#declare tan_wood = texture { 
      EMBWood1 
      ambient .02
   }
#declare black_granite  = texture {
pigment
 {granite
  turbulence 0.6
  color_map
   {[0.000, 0.104   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.110, 0.082, 0.071, 0.000>]
    [0.104, 0.252   color rgbf <0.110, 0.082, 0.071, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
    [0.252, 0.383   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.000, 0.000, 0.000, 0.000>]
    [0.383, 0.643   color rgbf <0.000, 0.000, 0.000, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
    [0.643, 0.783   color rgbf <0.161, 0.133, 0.118, 0.000>
                    color rgbf <0.220, 0.149, 0.137, 0.000>]
    [0.783, 0.922   color rgbf <0.220, 0.149, 0.137, 0.000>
                    color rgbf <0.000, 0.000, 0.000, 0.000>]
    [0.922, 0.983   color rgbf <0.000, 0.000, 0.000, 0.000>
                    color rgbf <0.220, 0.149, 0.137, 0.000>]
    [0.983, 1.001   color rgbf <0.220, 0.149, 0.137, 0.000>
                    color rgbf <0.161, 0.133, 0.118, 0.000>]
   }
 }
 }
#declare glass = texture { Glass }
#declare clear_red = texture {
  Glass
   pigment { color red 0.90 filter 0.85 }
   finish {
      phong 1 phong_size 300         // Very tight highlights
      reflection 0.15                // Needs a little reflection added
   }
}

#declare clear_yellow = texture {
  Glass
   pigment { Yellow filter 0.85 }
   finish {
      phong 1 phong_size 300         // Very tight highlights
      reflection 0.15                // Needs a little reflection added
   }
}

#declare clear_green = texture {
  Glass
   pigment { color green 0.90 filter 0.85 }
   finish {
      phong 1 phong_size 300         // Very tight highlights
      reflection 0.15                // Needs a little reflection added
   }
}

#declare clear_blue = texture {
  Glass
   pigment { color blue 0.90 filter 0.85 }
   finish {
      phong 1 phong_size 300         // Very tight highlights
      reflection 0.15                // Needs a little reflection added
   }
}

#declare brass = texture { Brass_Texture }

#declare bumpmap_tiles1 = texture
{
   pigment { White }
   normal { bump_map { gif "tiles01.gif" } }
   finish { ambient .4 }
}


#max_trace_level 8
#max_intersections 100

background { color rgb <1, 1, 1> }

// Object type: Camera
// Name: Standard
camera 
{
   right     < 1, 0, 0   >
   up        < 0, 1, 0   >
   direction < 0, 0, 0.5 >
   location  < 0, 0, 0   >
   scale < 22.917, 17.189, 25.687 >
   translate < -5.635, 36, -67 >
}

// Object type: OmniLight
// Name: Omni Light
light_source
{
   < 25, 89.904, -123 >
   color rgb < 1, 1, 1 >
}

// Object type: World
// Name: Root
object
{
   union
   {
      // Object type: Cone
      // Name: Beeker Base
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.3 open }

         scale < 4.1828, 5.9755, 4.1828 >
         translate < -3.2142, 39.956, -20.604 >

         texture
         {
            glass
            scale < 4.1828, 5.9755, 4.1828 >
            translate < -3.2142, 39.956, -20.604 >
         }
      }
      // Object type: Cylinder
      // Name: Beeker Top
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 1.2576, 4.8775, 1.2576 >
         translate < -3.2126, 45.935, -20.576 >

         texture
         {
            glass
            scale < 1.2576, 4.8775, 1.2576 >
            translate < -3.2126, 45.935, -20.576 >
         }
      }
      // Object type: Box
      // Name: Table_Top
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 182, 2, 49 >
         translate < -103.31, 24.586, -44.174 >

         texture
         {
            white_marble
            scale < 182, 2, 49 >
            translate < -103.31, 24.586, -44.174 >
         }
      }
      // Object type: Disc
      // Name: Beeker Bottom
      object
      {
         disc { < 0, 0, 0 >, < 0, 1, 0 >, 1, 0 }

         scale < 4.219, 0.21095, 4.219 >
         translate < -3.1968, 39.868, -20.607 >

         texture
         {
            glass
            scale < 4.219, 0.21095, 4.219 >
            translate < -3.1968, 39.868, -20.607 >
         }
      }
      // Object type: Cylinder
      // Name: Stand_Frame
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.40646, 28.452, 0.40646 >
         translate < 10.066, 28.37, -20.423 >

         texture
         {
            brass
            scale < 0.40646, 28.452, 0.40646 >
            translate < 10.066, 28.37, -20.423 >
         }
      }
      // Object type: Paraboloid
      // Name: Stand_Base
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 8.1292, 2.0323, 8.1292 >
         rotate < -180, 0, 0 >
         translate < 10.066, 28.429, -20.49 >

         texture
         {
            brass
            scale < 8.1292, 2.0323, 8.1292 >
            rotate < -180, 0, 0 >
            translate < 10.066, 28.429, -20.49 >
         }
      }
      // Object type: Paraboloid
      // Name: Burner_Base
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 2.8452, 0.40646, 2.8452 >
         rotate < -180, 0, 0 >
         translate < -3.5863, 26.971, -20.669 >

         texture
         {
            steely_blue
            scale < 2.8452, 0.40646, 2.8452 >
            rotate < -180, 0, 0 >
            translate < -3.5863, 26.971, -20.669 >
         }
      }
      // Object type: Cylinder
      // Name: Burner_Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.40646, 6.0969, 0.40646 >
         translate < -3.6183, 26.768, -20.669 >

         texture
         {
            steely_blue
            scale < 0.40646, 6.0969, 0.40646 >
            translate < -3.6183, 26.768, -20.669 >
         }
      }
      // Object type: Cylinder
      // Name: Burner_Top
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.60969, 2.0323, 0.60969 >
         translate < -3.6124, 32.806, -20.656 >

         texture
         {
            steely_blue
            scale < 0.60969, 2.0323, 0.60969 >
            translate < -3.6124, 32.806, -20.656 >
         }
      }
      // Object type: Cylinder
      // Name: Stand_Clip
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.57209, 1.907, 0.57209 >
         translate < 10.08, 38.559, -20.394 >

         texture
         {
            brass
            scale < 0.57209, 1.907, 0.57209 >
            translate < 10.08, 38.559, -20.394 >
         }
      }
      // Object type: Paraboloid
      // Name: ThumbScrew_Head
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 0.29712, 0.29712, 0.038614 >
         rotate < 0, -43, -90 >
         translate < 11.003, 39.535, -20.468 >

         texture
         {
            brass
            scale < 0.29712, 0.29712, 0.038614 >
            rotate < 0, -43, -90 >
            translate < 11.003, 39.535, -20.468 >
         }
      }
      // Object type: Cylinder
      // Name: Thumbscrew_body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.0659, 0.46517, 0.0659 >
         rotate < 0, 0, 90 >
         translate < 11.065, 39.535, -20.469 >

         texture
         {
            brass
            scale < 0.0659, 0.46517, 0.0659 >
            rotate < 0, 0, 90 >
            translate < 11.065, 39.535, -20.469 >
         }
      }
      // Object type: Cylinder
      // Name: Stand_Arm
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.40646, 8.9422, 0.40646 >
         rotate < 0, 0, 90 >
         translate < 10.267, 39.55, -20.471 >

         texture
         {
            brass
            scale < 0.40646, 8.9422, 0.40646 >
            rotate < 0, 0, 90 >
            translate < 10.267, 39.55, -20.471 >
         }
      }
      // Object type: Torus
      // Name: Stand_Plate
      object
      {
         torus { 30, 5 }

         scale < 0.15446, 0.081292, 0.15446 >
         translate < -3.2067, 39.552, -20.246 >

         texture
         {
            brass
            scale < 0.15446, 0.081292, 0.15446 >
            translate < -3.2067, 39.552, -20.246 >
         }
      }
      // Object type: Box
      // Name: Counter_Face
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 182, 2, 40 >
         rotate < 90, 0, 0 >
         translate < -132, 25, -41.99 >

         texture
         {
            tan_wood
            scale < 182, 2, 40 >
            rotate < 90, 0, 0 >
            translate < -132, 25, -41.99 >
         }
      }
      // Object type: Box
      // Name: Drawr
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 24.388, 12.194, 0.81292 >
         translate < 21.532, 8.2859, -42.591 >

         texture
         {
            tan_wood
            scale < 24.388, 12.194, 0.81292 >
            translate < 21.532, 8.2859, -42.591 >
         }
      }
      // Object type: Box
      // Name: Drawr
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 24.388, 12.194, 0.81292 >
         translate < -5.9138, 8.2859, -42.591 >

         texture
         {
            tan_wood
            scale < 24.388, 12.194, 0.81292 >
            translate < -5.9138, 8.2859, -42.591 >
         }
      }
      // Object type: Box
      // Name: Drawr
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 24.388, 12.194, 0.81292 >
         translate < -33.36, 8.2859, -42.591 >

         texture
         {
            tan_wood
            scale < 24.388, 12.194, 0.81292 >
            translate < -33.36, 8.2859, -42.591 >
         }
      }
      // Object type: Box
      // Name: Drawr
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 24.388, 12.194, 0.81292 >
         translate < -60.806, 8.2859, -42.591 >

         texture
         {
            tan_wood
            scale < 24.388, 12.194, 0.81292 >
            translate < -60.806, 8.2859, -42.591 >
         }
      }
      // Object type: Box
      // Name: Element Plaque
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 59.702, 38.38, 0.66525 >
         translate < -63.862, 43.271, 3.8321 >

         texture
         {
            element_table
            scale < 59.702, 38.38, 0.66525 >
            translate < -63.862, 43.271, 3.8321 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.5284, 5.6905, 0.5284 >
         rotate < 180, 46.025, -180 >
         translate < -21.463, 27.21, -24.079 >

         texture
         {
            clear_red
            scale < 0.5284, 5.6905, 0.5284 >
            rotate < 180, 46.025, -180 >
            translate < -21.463, 27.21, -24.079 >
         }
      }
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 0.65315, 0.40745, 0.65315 >
         rotate < -180, 46.025, 180 >
         translate < -21.473, 26.897, -24.072 >

         texture
         {
            glass
            scale < 0.65315, 0.40745, 0.65315 >
            rotate < -180, 46.025, 180 >
            translate < -21.473, 26.897, -24.072 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.5284, 6.0969, 0.5284 >
         rotate < -180, 46.025, 180 >
         translate < -18.871, 27.272, -21.383 >

         texture
         {
            clear_green
            scale < 0.5284, 6.0969, 0.5284 >
            rotate < -180, 46.025, 180 >
            translate < -18.871, 27.272, -21.383 >
         }
      }
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 0.65315, 0.40745, 0.65315 >
         rotate < -180, 46.025, 180 >
         translate < -18.872, 26.901, -21.377 >

         texture
         {
            glass
            scale < 0.65315, 0.40745, 0.65315 >
            rotate < -180, 46.025, 180 >
            translate < -18.872, 26.901, -21.377 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.5284, 4.0646, 0.5284 >
         rotate < -180, 46.025, 180 >
         translate < -24.088, 27.256, -26.762 >

         texture
         {
            clear_blue
            scale < 0.5284, 4.0646, 0.5284 >
            rotate < -180, 46.025, 180 >
            translate < -24.088, 27.256, -26.762 >
         }
      }
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 0.65315, 0.40745, 0.65315 >
         rotate < -180, 46.025, 180 >
         translate < -24.061, 26.899, -26.755 >

         texture
         {
            glass
            scale < 0.65315, 0.40745, 0.65315 >
            rotate < -180, 46.025, 180 >
            translate < -24.061, 26.899, -26.755 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.5284, 6.0969, 0.5284 >
         rotate < 180, 46.025, -180 >
         translate < -26.736, 27.279, -29.497 >

         texture
         {
            clear_yellow
            scale < 0.5284, 6.0969, 0.5284 >
            rotate < 180, 46.025, -180 >
            translate < -26.736, 27.279, -29.497 >
         }
      }
      // Object type: Paraboloid
      // Name: NoName
      object
      {
         object { quadric {<1,  0,  1>, <0,  0,  0>, <0, -1,  0>, 0 } clipped_by { plane { <0, 1, 0>, 1 } } }

         scale < 0.65315, 0.40745, 0.65315 >
         rotate < -180, 46.025, 180 >
         translate < -26.7, 26.894, -29.491 >

         texture
         {
            glass
            scale < 0.65315, 0.40745, 0.65315 >
            rotate < -180, 46.025, 180 >
            translate < -26.7, 26.894, -29.491 >
         }
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 0.81292, 6.7916, 2.4388 >
         rotate < -180, 46.025, 180 >
         translate < -28.738, 27.21, -30.006 >

         texture
         {
            tan_wood
            scale < 0.81292, 6.7916, 2.4388 >
            rotate < -180, 46.025, 180 >
            translate < -28.738, 27.21, -30.006 >
         }
      }
      // Object type: Box
      // Name: Beeker Holder top-bottom
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 17.071, 0.81292, 2.4388 >
         rotate < -180, 46.025, 180 >
         translate < -17.727, 33.834, -18.593 >

         texture
         {
            tan_wood
            scale < 17.071, 0.81292, 2.4388 >
            rotate < -180, 46.025, 180 >
            translate < -17.727, 33.834, -18.593 >
         }
      }
      // Object type: Box
      // Name: Beeker Holder top-bottom
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 17.071, 0.81292, 2.4388 >
         rotate < -180, 46.025, 180 >
         translate < -17.727, 26.374, -18.593 >

         texture
         {
            tan_wood
            scale < 17.071, 0.81292, 2.4388 >
            rotate < -180, 46.025, 180 >
            translate < -17.727, 26.374, -18.593 >
         }
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 0.81292, 6.7916, 2.4388 >
         rotate < -180, 46.025, 180 >
         translate < -17.959, 27.143, -18.834 >

         texture
         {
            tan_wood
            scale < 0.81292, 6.7916, 2.4388 >
            rotate < -180, 46.025, 180 >
            translate < -17.959, 27.143, -18.834 >
         }
      }
      // Object type: Cone
      // Name: Beeker Contents
      object
      {
         cone { < 0, 0, 0 >, 1, < 0, 1, 0 >, 0.5 open }

         scale < 4.0646, 4.0646, 4.0646 >
         translate < -3.2046, 39.927, -20.604 >

         texture
         {
            clear_blue
            scale < 4.0646, 4.0646, 4.0646 >
            translate < -3.2046, 39.927, -20.604 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.64459, 9.6688, 0.64459 >
         rotate < -180, 46.025, 180 >
         translate < -24.086, 27.302, -26.727 >

         texture
         {
            glass
            scale < 0.64459, 9.6688, 0.64459 >
            rotate < -180, 46.025, 180 >
            translate < -24.086, 27.302, -26.727 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.64459, 9.6688, 0.64459 >
         rotate < -180, 46.025, 180 >
         translate < -21.454, 27.302, -24.044 >

         texture
         {
            glass
            scale < 0.64459, 9.6688, 0.64459 >
            rotate < -180, 46.025, 180 >
            translate < -21.454, 27.302, -24.044 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.64459, 9.6688, 0.64459 >
         rotate < -180, 46.025, 180 >
         translate < -18.872, 27.302, -21.361 >

         texture
         {
            glass
            scale < 0.64459, 9.6688, 0.64459 >
            rotate < -180, 46.025, 180 >
            translate < -18.872, 27.302, -21.361 >
         }
      }
      // Object type: Cylinder
      // Name: Test Tube Body
      object
      {
         cylinder { < 0, 0, 0 >, < 0, 1, 0 >, 1 open }

         scale < 0.64459, 9.6688, 0.64459 >
         rotate < -180, 46.025, 180 >
         translate < -26.736, 27.302, -29.497 >

         texture
         {
            glass
            scale < 0.64459, 9.6688, 0.64459 >
            rotate < -180, 46.025, 180 >
            translate < -26.736, 27.302, -29.497 >
         }
      }
      // Object type: Box
      // Name: NoName
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 300, 200, 2 >
         translate < -134.09, -46.586, 4.243 >

         texture
         {
            matte_white
            scale < 300, 200, 2 >
            translate < -134.09, -46.586, 4.243 >
         }
      }
      // Object type: Box
      // Name: Drawr
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 24.388, 12.194, 0.81292 >
         translate < -88.164, 8.523, -42.591 >

         texture
         {
            tan_wood
            scale < 24.388, 12.194, 0.81292 >
            translate < -88.164, 8.523, -42.591 >
         }
      }
      // Object type: Box
      // Name: Drawr
      object
      {
         box { < 0, 0, 0 >, < 1, 1, 1 > }

         scale < 24.388, 12.194, 0.81292 >
         translate < -115.55, 8.523, -42.591 >

         texture
         {
            tan_wood
            scale < 24.388, 12.194, 0.81292 >
            translate < -115.55, 8.523, -42.591 >
         }
      }
   }
}