:- 
   declare('Eye',
      difference([
         sphere([centre(0,0,0),radius(10),
            texture(['White_Marble',scale(20,20,20)])
         ]),
         intersection([
            plane([vector(-1,0,0),0,
               rotate(0,10,0)
            ]),
            plane([vector(1,0,0),0,
               rotate(0,-10,0)
            ])
            ,texture([
               pigment([colour(rgb(0,0,0))]),
               finish([phong(0.7),phong_size(110),reflection(0.6)])
            ])
         ]),
         translate(0,0,-100),
         rotate(0,-20,0)
      ])
   ).

:- 
   forall( between(-18,20,I), (
      X is 20+2*I,
      Y is (39+I)*(60-I)/15-150,
      Z is 0,
      R is 5*sqrt(22-I),
      accumulate(sphere([centre(X,Y,Z),radius(R),scale(1,0.7,2.5)]))
   )),
   get_and_clear_accumulator(TElements),
   declare('Tongue',
      union([
         union(TElements),
         texture([
            pigment([colour(rgb(1,0,0))])
         ]),
         normal([
            bumps(0.7)
         ]),
         finish([
            crand(0.2),
            phong(0.8),
            phong_size(30),
            reflection(0.2)
         ])
      ])
   ).

:- 
   declare('Tooth',
      intersection([
         difference([
            sphere([centre(0,0,0),radius(93)
            ]),
            sphere([centre(0,0,0),radius(92)
            ])
         ]),
         union([
            box([bc(-110,-24,-18),tc(110,0,18)]),
            box([bc(-110,-28,-14),tc(110,0,14)]),
            cylinder([start(-110,-24,-14),end(110,-24,-14),radius(4)]),
            cylinder([start(-110,-24,14),end(110,-24,14),radius(4)])
         ]),
         texture([
            pigment([colour(rgb(1,1,1))]),
            finish([phong(0.8),phong_size(70),reflection(0.5)])
         ])
      ])
   ).
            
:- 
   GapWidth = 45,   % in degrees
   declare('PacMan',
      union([
         difference([
            union([
               union([
                  difference([
                     sphere([centre(0,0,0),radius(100) ]),
                     plane([vector(0,-1,0),0])
                  ]),
                  torus([maj_rad(95),min_rad(5)]),
                  rotate(0,0,-20)
               ]),
               union([
                  difference([
                     sphere([centre(0,0,0),radius(100) ]),
                     plane([vector(0,1,0),0])
                  ]),
                  torus([maj_rad(95),min_rad(5)]),
                  rotate(0,0,GapWidth)
               ])
            ]),
            sphere([centre(0,0,0),radius(90) ]),
            /*
            sphere([centre(0,0,0),radius(100)
            ]),
            intersection([
               plane([vector(0,1,0),0,
                  rotate(0,0,GapWidth)
               ]),
               plane([vector(0,-1,0),25
               ])
            ]),
            */
            texture(['Jade',scale(111,111,111),
               finish([phong(0.8),phong_size(70)])
            ])
         ]),
         object(['Eye',rotate(130,0,0)]),
         object(['Eye',rotate(50,0,0)]),
         object(['Tongue']),
         object(['Tooth',rotate(0,-13,GapWidth)]),
         object(['Tooth',rotate(0,13,GapWidth)])
      ])
   ).
