:-
   %% generate 10 control points.
   bagof( [X,Y,Z],
      I^(  between(1,10,I),
           X is -9*random(100),
           Y is 230+random(50)-25.0,
           Z is -9*random(100)
      ),
      CPs
   ),
   %% make a tiny box at each control point to show what we're doing.
   %% calculate the bspline points. 300 of them
   spline(b_spline,CPs,300,NPs),
   %% create 200 spheres on the bspline curve. Do it the slow way.
   forall( member(P,NPs), 
      ( [X,Y,Z]=P,
        accumulate(sphere([centre(X,Y,Z),radius(10)]))
      )),
   get_and_clear_accumulator(Spheres),
   nso(object([
         union(Spheres),
         texture([pigment([colour(rgb(1,0.5,1))])])
      ])
   ).
