brick:-
   dont_display,
   brick_wall([12,5,7],[-80,-32,-5],[-3,32,5],12,[-43,1,0],23.0,circle,'Wall1'),
   nso(object(['Wall1'])),
   save('wall1.pov'),
   dad,daso,
   brick_wall([12,5,7],[3,-32,-5],[80,32,5],12,[43,-2,8],23.0,sphere,'Wall2'),
   nso(object(['Wall2',rotate(0,90,0)])),
   save('wall2.pov').
brick_wall([BX,BY,BZ],[SX,SY,SZ],[EX,EY,EZ],Thickness,[_CX,_CY,_CZ],Rad,_Mode,_Name) :-
   ( BX > EX-SX ; BY > EY-SY ; BZ > EZ-SZ
   ; Thickness<1
   ; BX < 0 ; BY < 0 ; BZ < 0
   ; Rad < 0   %% Should be <=, but by specifiying an empty hole, the user
               %% can define a brick wall, for which there is no other
               %% procedure. ('empty hole'??? What kind of English is that?)
   ),
   !,
   writef('IUIQ error in brick_wall\n').
brick_wall([BX,BY,BZ],[SX,SY,SZ],[EX,EY,_EZ],Thickness,CPoint,Rad,Mode,Name) :-
   MaxX is (EX-SX) // BX,
   MaxY is (EY-SY) // BY,
   Mortar is BY / 5.0,
   X3 is SX+MaxX*BX,
   forall( between(1,Thickness,I), (
      Z1 is SZ+(I-1)*(BZ+Mortar),
      Z2 is Z1+BZ,
      nl,
      forall( between(1,MaxY,J), (
         write('.'),flush,
         %Y1 is SY+(J-1)*(BY+Mortar),
         Y1 is SY+(J-1)*BY+Mortar,
         Y2 is SY+J*BY,
         SX1 is SX - ((I+J) mod 2)*BX / 2.0 + Mortar,
         SX2 is SX + (BX + ((I+J+1) mod 2)*BX) / 2.0,
         (((Mode=circle,
            box_circle_intersection([SX,Y1,Z1],[SX2,Y2,Z2],CPoint,Rad) )
         ;( Mode=sphere, 
            box_sphere_intersection([SX,Y1,Z1],[SX2,Y2,Z2],CPoint,Rad) ) )
         -> true
         ;  accumulate(box([bc(SX,Y1,Z1),tc(SX2,Y2,Z2)]))
         ),
         forall( between(1,MaxX,K), (
            X1 is SX1+BX*K,
            X2 is SX1+BX*(K+1)-Mortar,
            (  K=MaxX
            -> X4=X3
            ;  X4=X2
            ),
            (((Mode=circle,
               box_circle_intersection([X1,Y1,Z1],[X4,Y2,Z2],CPoint,Rad) )
            ;( Mode=sphere, 
               box_sphere_intersection([X1,Y1,Z1],[X4,Y2,Z2],CPoint,Rad) ) )
            -> true
            ;  accumulate(box([bc(X1,Y1,Z1),tc(X4,Y2,Z2)]))
            )
         ))
      ))
   )),
   get_and_clear_accumulator(Bricks),
   declare(Name,
             object([union(Bricks),texture([
                                 pigment([colour(rgb(0.8,0.3,0.3))]),
                                 finish([crand(0.4)])
                             ])
             ])
   ),
   true.
box_circle_intersection([Bx,By,_Bz],[Tx,Ty,_Tz],[Cx,Cy,_Cz],Rad) :-
   X is (Tx + Bx)/2.0 - Cx,
   Y is (Ty + By)/2.0 - Cy,
   Rad > sqrt(X*X+Y*Y).
box_sphere_intersection([Bx,By,Bz],[Tx,Ty,Tz],[Cx,Cy,Cz],Rad) :-
   X is (Tx + Bx)/2.0 - Cx,
   Y is (Ty + By)/2.0 - Cy,
   Z is (Tz + Bz)/2.0 - Cz,
   Rad > sqrt(X*X+Y*Y+Z*Z).
point_inside_circle([X1,Y1,_Z1],[Cx,Cy,_Cz],Rad) :-
   Dx is X1-Cx,
   Dy is Y1-Cy,
   Rad > sqrt(Dx*Dx+Dy*Dy).
point_inside_sphere([X1,Y1,Z1],[Cx,Cy,Cz],Rad) :-
   Dx is X1-Cx,
   Dy is Y1-Cy,
   Dz is Z1-Cz,
   Rad > sqrt(Dx*Dx+Dy*Dy+Dz*Dz).

:- 
   brick_wall([16,7,10],[0,0,-20],[600,250,0],2,[-43,1,0],0.0,circle,'Wall1'),
   brick_wall([16,7,10],[-200,0,-118],[0,250,-100],2,[-43,1,0],0.0,circle,'Wall2'),
   true.
