// Persistence of Vision Raytracer Version 2.0
//Created by James Miller

// Colors
//____________________________________________
#declare XWGray15 = color red 0.15 green 0.15 blue 0.15
#declare XWGray20 = color red 0.20 green 0.20 blue 0.20
#declare XWGray25 = color red 0.25 green 0.25 blue 0.25
#declare XWGray30 = color red 0.30 green 0.30 blue 0.30
#declare XWGray35 = color red 0.35 green 0.35 blue 0.35
#declare XWGray40 = color red 0.40 green 0.40 blue 0.40
#declare XWGray45 = color red 0.45 green 0.45 blue 0.45
#declare XWGray50 = color red 0.50 green 0.50 blue 0.50
#declare XWGray55 = color red 0.55 green 0.55 blue 0.55
#declare XWGray60 = color red 0.60 green 0.60 blue 0.60
#declare XWGray65 = color red 0.65 green 0.65 blue 0.65
#declare XWGray70 = color red 0.70 green 0.70 blue 0.70
#declare XWLightGray = color red 0.658824 green 0.658824 blue 0.658824
#declare XWGray = color red 0.752941 green 0.752941 blue 0.752941
#declare XWDimGray = color red 0.329412 green 0.329412 blue 0.329412
#declare XWClear = color red 1.0 green 1.0 blue 1.0 filter 1.0
#declare XWRed = color red 1.0
#declare XWBlack = color red 0.0 green 0.0 blue 0.0
#declare XWSilver = color red 0.90 green 0.91 blue 0.98
#declare XWWhite = color red 1.0 green 1.0 blue 1.0
#declare XWFirebrick = color red 0.556863 green 0.137255 blue 0.137255
// Textures
#declare XWShiny = finish {specular 1 roughness 0.001}

#declare XWGlass_Finish=
	finish
		{XWShiny
		ambient 0
		diffuse 0
		reflection 0.1
		refraction 1
		ior 1.5
		}

#declare XWGlass = 
 texture
	 {pigment
		 {color XWWhite filter 0.7}
		finish
		 {XWGlass_Finish}
	 }


// Shapes
#declare Sphere =
 sphere {<0, 0, 0>,1}

//_____________________________________________________________
// Section A definition - back part of the X-Wing body
#declare XWDirt=
	texture{pigment{granite turbulence 1
		color_map{[0.0 color XWGray45]
			[0.2 color XWGray50]
			[0.3 color XWGray55]
			[1.0 color XWGray55]}
			} //end pigment
		rotate z*90
		scale .5
		} // end texture 1 (dirty surface)

#declare bx=object{box {<0,0,0>,<2.5,1,1>}}//main shape for back of ship
#declare plus_plane=object{plane {y,0}//top right cutting plane (back)
	}
#declare minus_plane=object{plane {y,-0}//top left cutting plane (back)
	}
#declare bot_slant=object {plane {y,0}
	rotate z*14.034
	translate x*1.5
	}
#declare cutting_planes=union{  // union will cut both sides off top of back
	object{plus_plane        // of ship
		rotate x*256  //76
		translate y*.5
		translate z*1
		}
	object{minus_plane
		rotate x*-256
		translate y*.5
		}
	object{minus_plane
		rotate x*277//97
		translate y*.5
		translate z*1
		}
	object{plus_plane
		rotate x*83
		translate y*.5
		}
	object{bot_slant
	}
	object{box{<-.5,.875,.28125>,<1.875,1.1,.71875>}
		texture{XWDirt}} 
	object{plus_plane
		rotate z*225
		translate <-.875,0,0>
		}
	}
#declare sa_back_bx=object{box {<-2,0,0>,<.125,1,1>}}
#declare sa_back_main_shape=object{difference{
	object{sa_back_bx}
	object{union{
		object{cutting_planes}
		object{plane {y,0}
			rotate x*180
			translate y*.8
			}
		}}
	pigment{XWGray15}
	}}
#declare section_a=object{ difference{
	object {bx}
	object{cutting_planes}
	texture{XWDirt}}
	}
#declare section_aa=object{difference{
	object{section_a}
	object{sa_back_main_shape
		scale <1,.97,.95>
		translate <0,.02,.025>
		}
	}}
#declare r2d2=union{
	object{sphere {<0,0,0>,.125}}
	object{cylinder {<0,0,0>,<0,-.25,0>,.125}}
	texture{
		pigment{image_map {gif "r2d2map.gif" 
			map_type 2}
			scale <1,.5,1> 
		translate <0,.125,0>
		} //end image map
	}//end texture
}//end object r2d2
//************************************************
//  mess of stuff on the top of the ship (shield generator ect...)
//************************************************
#declare sa_top_back_boxes=union{
			object{box{<-.5,.875,.5625>,<-.25,1,.4375>}}
			object{box{<-.5,.875,.625>,<-.25,1,.6875>}}
			object{box{<-.5,.875,.375>,<-.25,1,.3125>}}
			object{box{<-.25,.875,.71875>,<-.2,1,.28125>}}
			object{box{<-.15,.875,.71875>,<-.1,1,.28125>}}
			pigment{XWGray50}
			}
#declare sa_top_platform=object{difference{
	object{box{<.53125,.875,.34375>,<1.25,.975,.65625>}}
	object{plane{z,0}
		rotate y*-10
		translate <0,0,.2>
		}
	object{plane{z,0}
		rotate y*190
		translate <0,0,.78>
		}
	pigment{XWDimGray}
	}}
#declare sa_top_stuff=union{
	object{difference{ //cylinder in middle of this thing
		object{cylinder{<.6875,.875,.5>,<.6875,1,.5>,2/16}}
		object{cylinder{<.6875,.875,.5>,<.6875,1.0001,.5>,1/32}}
		pigment{XWGray50}}
		}
	object{difference{ //1/2 circle at back of the cylinder in the middle
		object{difference{
			object{cylinder{<.6875,.875,.5>,<.6875,1,.5>,3/16}}
			object{cylinder{<.6875,.875,.5>,<.6875,1.01,.5>,.15625}}//2/16+1/32
			}
		}
		object{box{<.6875,.875,.28125>,<1,1.0001,.71875>}}
		pigment{XWGray40}
		}}
	object{sa_top_platform}//big platform in middle of this thing
	object{box{<1.25,.875,.5>,<1.45,.92,.7>} //box in front left
		pigment{XWGray70}}
	object{sa_top_platform //front platform behind r2d2
		rotate y*180
		scale <.45,1,.7>
		translate <2.125,.1,.85>
		}
	object{cylinder{<1,.875,.5>,<1,1,.5>,1/16} //cylinder in front of big platform
		pigment {XWGray}}
	object{cylinder{<1,.875,.71875>,<1,1,.71875>,1/16}
		pigment{XWGray30}}//left bolt
	object{cylinder{<1,.875,.28125>,<1,1,.28125>,1/16}
		pigment{XWGray30}}//right bolt
	object{sphere{<1.5,.9,.35>,1/16}
		pigment{XWGray60}}
	object{intersection{
		object{cylinder{<1.75,.875,.5>,<1.75,.94,.5>,.25}}
		object{box{<-.5,.875,.28125>,<1.875,1.1,.71875>}}
		pigment{XWLightGray}}}
	//from here up is the front 1/2 of this thing
	object{box{<-.0625,.875,.5625>,<.5,.94,.4375>}
		pigment{XWGray30}}
	object{difference{
		object{sa_top_back_boxes}
		object{plus_plane
			rotate z*225
			translate <-1.4,0,0>
			}}
		}
	object{box{<-.09,.875,.71375>,<.25,.94,.27625>}
		pigment{XWGray45}}
	object{union{
		object{difference{
			object{cylinder{<.1,.875,.5>,<.1,.9,.5>,1/8}}
			object{cylinder{<.1,.875,.5>,<.1,1,.5>,3/32}}
			}}
		object{sphere{<.1,.88,.5>,2/32}}
		pigment{XWGray40}
		}}
	object{cylinder{<.375,.875,.71875>,<.375,1,.71875>,1/16}
		pigment{XWGray30}}//left bolt
	object{cylinder{<.375,.875,.28125>,<.375,1,.28125>,1/16}
		pigment{XWGray30}}//right bolt
	}
//*********************************************************
//  the very back of the ship
//*********************************************************
#declare sa_back_stuff=union{
	object{box{<0,.125,.28125>,<.25,.8,.71875>}
		pigment{XWGray25} //box down center
		}
	object{sphere{<0,.5625,.5>,.125}
		pigment {XWGray30}}//sphere in the upper middle of the box shape
	object{cylinder{<0,.3125,.5625>,<0,.3125,.4375>,.03}
		pigment {XWGray20}} //cylinder underneath the big sphere
	object{cylinder{<0,.1,.5625>,<0,.1,.4375>,.0325}
		pigment{XWGray30}} //small cylinder in bottom middle
	object{box{<-.03125,.125,.71875>,<.25,.0625,.84375>}
		pigment{XWGray30}} //box at bottom left
	object{box{<-.03125,.125,.28125>,<.25,.0625,.15625>}
		pigment{XWGray30}} //box at bottom right 
	object{cylinder{<0,.09375,.28125>,<0,.09375,.84375>,.03125}
		pigment{XWLightGray}} //small cylinder that runs across the bottom
	object{cylinder{<-.03125,.125,.21875>,<-.03125,.3125,.21875>,.03}
		pigment{XWLightGray}} //small cylinder that runs up on the bottom right side
	object{cylinder{<-.03125,.125,.78125>,<-.03125,.3125,.78125>,.03}
		pigment{XWLightGray}} //small cylinder that runs up on the bottom left side
	object{sphere{<-.03125,.3125,.78125>,.03}
		pigment{XWGray40}} //left side curve at top of cylinder
	object{cylinder{<-.03125,.3125,.78125>,<-.03125,.3125,.71875>,.03}
		pigment{XWGray40}} //left side see above
	object{box{<-.06125,.3425,.71875>,<.25,.2825,.65625>}
		pigment{XWGray40}}
	object{sphere{<-.03125,.3125,.21875>,.03}
		pigment{XWGray40}} //right side curve at top of cylinder
	object{cylinder{<-.03125,.3125,.21875>,<-.03125,.3125,.28125>,.03}
		pigment{XWGray40}} //right side see above
	object{box{<-.06125,.3425,.28125>,<.25,.2825,.34375>}
		pigment{XWGray40}}
	object{intersection{
		object{union{
			object{box{<.001,0,0>,<.5,.03125,1>} //top right slant
				rotate x*-4
				translate <0,.65,-.72>}
			object{box{<.001,0,0>,<.5,.03125,1>} //top left slant
				rotate x*4
				translate <0,.71,.7>} 
			object{box{<.001,0,0>,<.5,.03125,1>} //second from top right slant
				rotate x*-4
				translate <0,.525,-.72>} //z was .75
			object{box{<.001,0,0>,<.5,.03125,1>} //second left slant
				rotate x*4
				translate <0,.578,.7>} 
			object{box{<.001,0,0>,<.5,.03125,1>} //third from top right slant
				rotate x*-8
				translate <0,.3375,-.72>} //z was .75
			object{box{<.001,0,0>,<.5,.03125,1>} //third from top left slant
				rotate x*8
				translate <0,.47,.7>} 
				}}//end union
		object{sa_back_main_shape
			scale <1,.97,.95>
			translate <0,.02,.025>}
		} //end intersection
		pigment {XWGray30}} //end object
	}//end big union
//******************************
//    real declaration
#declare Section_A=union{
	object{difference{
		object{section_aa}
		object{union{
			object{box{<.25,.25,-.5>,<1.5,.625,1.5>}}
			object{plane{y,0} rotate z*149.42 //59.42+90
				translate <2.5,.87,0>
				}
			}}
		}}
	object{box{<1.5,.25,-.03125>,<1.9,.63,0>}
		pigment{XWGray30}} //guards in front of the engine intakes
	object{box{<1.5,.25,1.03125>,<1.9,.63,0>}
		pigment{XWGray30}} // see note above
	object{sa_top_stuff
		scale<.8,1,1>
		translate <.4,0,0>}
	object{r2d2
		translate <2,1.05,.5>
		}
	object{sa_back_stuff}
	}

//_____________________________________________________________
// Section B - front part of the X-Wing body
//
#declare frnt_box=object{box{<0,-.25,-.5>,<3.875,.375,.5>}}    
#declare sb_cutting_planes=union{
	object{minus_plane //actually bottom left side plane
		rotate x*277
		rotate y*4.6 
		translate z*.5}
	object{minus_plane //actually bottom right side plane
		rotate x*83
		rotate y*-4.6
		translate z*-.5}
	object{plus_plane //top right side plane
		rotate x*-256
		rotate y*-4.6
		translate z*-.5}
	object{plus_plane //top left side plane
		rotate x*256
		rotate y*4.6
		translate z*.5}
	object{plane {y,0}
		rotate x*180
		rotate z*-2
		translate y*.4
		}}
#declare Section_b=difference{
	object{frnt_box}
	object{sb_cutting_planes}
	texture{XWDirt}
	texture{
		pigment{image_map {gif "redstrip.gif" 
			interpolate 2
			filter 41, 1}
			scale <4,1,1> 
			translate <0,.3125,0>
		} //end image map
	}//end texture
	texture{pigment{granite turbulence 1
		color_map{[0.0 color XWGray50]
			[0.1 color XWGray55]
			[0.2 color XWClear]
			[1.0 color XWClear]}
		}}
	texture{pigment{image_map {gif "torp.gif"
			once
			interpolate 2
			filter 168,1}
			scale <2.7,.4,1>
			translate<.5,-.3,0>
			}}
}//end object main part of front

//************************************************************************
// cap on front of the nose
//************************************************************************
#declare cap_box=object {box{<0,.5,.5>,<1.5,-.5,-.5>}}
#declare up_cylinder=object{cylinder{<0,0,0>,<0,0,3>,1}}
#declare cap_rear_cylinder=object{cylinder{<0,0,1>,<0,0,-1>,1}}
#declare cap_phase1=difference{ //cut rounded back
	object{cap_box}     
	object{cap_rear_cylinder
		translate y*.3
		translate x*-.7
		}}
#declare cap_phase2=object{up_cylinder  //cylinder used to cut the top
		scale <4,1,1>
		rotate z*-5
		translate z*-.7
		translate y*-.5
		translate x*-1.7}
#declare cap_phase3=intersection{  //cut top off of box
	object{cap_phase1}
	object{cap_phase2}}
#declare cap_phase4=intersection{  //cut bottom off of box
	object{cap_phase3}
	object{up_cylinder
		scale <4,1,1>
		rotate z*3
		translate y*.5 
		translate x*-.5
		}}
#declare Cap=object {cap_phase4
	scale <.7,.85,.75>
	texture{XWDirt scale <2,1,1>}
	} //cap is the nose cone

//********************************************************************************
// cockpit frame and glass
//********************************************************************************
#declare Cockpit=union{
object{difference{
	object {box{<0,0,-.375>,<1.25,.5,.375>}} //main front box
	object{union{
		object{box{<-.1,-.1,-.4>,<1.26,.46875,.4>}}//cut sides
		object{difference{
			object{box{<.03125,0,-.25>,<1.21875,.6,.25>}}
			object{plus_plane //right side plane
				rotate x*-256
				rotate y*-4.6
				translate z*-.4}
			object{plus_plane //left side plane
				rotate x*256
				rotate y*4.6
				translate z*.4}
			}} //cut front
		object{plus_plane //right side plane
			rotate x*-256
			rotate y*-4.6
			translate z*-.46
			}
		object{plus_plane //left side plane
			rotate x*256
			rotate y*4.6
			translate z*.46
			}
		}}
	rotate z*-11.5
	translate<2.5,.62,.5>
	texture{XWDirt}
	}}//front box
object{difference{
	object {box{<-.25,0,-.5>,<0,.5,.5>}}
	object{union{
		object{box{<-.3,-.1,-.6>,<-.03125,.46875,.46875>}}
		object{plus_plane //right side plane
			rotate x*-256
			translate z*-.46
			}
		object{plus_plane //left side plane
			rotate x*256
			translate z*.46}
		}}
	translate<2.6,.61,.5>
	texture{XWDirt} 
	}} //middle frame
object{difference{
	object{box{<-.75,0,-.375>,<-.25,.5,.375>}}
	object{union{
		object{box{<-.8,-.1,-.4>,<-.2,.46875,.4>}}
		object{box{<-.71875,0,-.34375>,<-.28125,.6,.34375>}}
		object{plus_plane //right side plane
			rotate x*-256
			rotate y*-4.6
			translate z*-.46
			}
		object{plus_plane //left side plane
			rotate x*256
			rotate y*4.6
			translate z*.46
			}}}
	rotate z*45
	translate <2.88,.93,.5>
	texture{XWDirt}
	}}// back box
object {difference{
	object{box{<0,0,-.375>,<1.25,.5,.375>}}
	object{union{
		object{plus_plane //right side plane
			rotate x*-256
			rotate y*-4.6
			translate z*-.444375}
		object{plus_plane //left side plane
			rotate x*256
			rotate y*4.6
			translate z*.444375}
		}}    
	pigment{XWBlack}
	texture{XWGlass}
	rotate z*-11.5
	translate<2.5,.604375,.5>
	}} //front & sides glass
object{difference{
	object{box{<-.7,0,-1>,<0,.46875,1>}rotate z*45}
	object{union{
		object{box{<-1,.15625,-.5>,<.5,1.5,.5>}} //cut off top 
		object{box{<-.25,-1,-1>,<1,1,1>}} //cut off front
		object{box{<-1,-1,-1>,<1,-.25,1>}}//cut off bottom
		object{plus_plane //right side plane
			rotate x*-257
			translate z*-.33125
			}
		object{plus_plane //left side plane
			rotate x*256
			translate z*.33125
			}
		}}
	translate <2.88,.93,.5>
	pigment{XWBlack}
	texture{XWGlass}
	}}// back glass
	}//end object cockpit
#declare Section_B=union{
	object {Section_b
		translate x*2.5
		translate z*.5
		translate y*.5}
	object {Cap
		translate<6.1,.62,.225>
		scale <1,1,1.2>}
	object {Cockpit}}
//______________________________________________________________
// Wing - All parts of the wings - surface, engines, lasers
#declare main=object{box{<0,-.1,0>,<-1.25,.25,1>}
	clipped_by{plane{y,0}
		rotate x*180
	}//end clipping
	}
#declare XWDirt=
	texture{pigment{granite turbulence 1
		color_map{[0.0 color XWGray50]
			[0.2 color XWGray55]
			[0.3 color XWGray60]
			[1.0 color XWGray60]}
			} //end pigment
		rotate z*90
		} // end texture 1 (dirty surface)
//********************************
//  engines
// parts are: 
//  Front will be difference of 2 cylinders, a small box,one cone
//  MAIN_BODY  part of Front
//  BACK is 2 cylinders to make the main shape. Will use spheres to round
//    the connection points. The very back will be the diff of 2 cylinders
#declare engine_dirt=texture{pigment{granite
	turbulence 1
	color_map{[0.0 color XWGray50]
		[0.3 color XWGray55]
		[0.5 color XWGray60]
		[1.0 color XWGray60]}
		} //end pigment
	rotate z*90
	normal {dents 1}
	} // end texture 1 (dirty surface)

#declare front_shell=difference{
	object {cylinder{<0,0,0>,<.25,0,0>,.25}}
	object {cylinder{<-.1,0,0>,<.3,0,0>,.1875}}
	}
#declare bfrnt=object{
	cylinder{<0,0,0>,<.125,0,0>,.23}
		pigment{radial
		color_map{[0.0 color XWGray30]
			[0.5 color XWGray30]
			[0.5 color XWGray60]
			[1.0 color XWGray60]}
			frequency 20
			rotate z*90
			}
		}//end object
#declare Front=union{
	object{front_shell texture{engine_dirt}}
	object{box{<0,-.03125,-.19>,<.25,.03125,.19>}pigment{XWGray}}
	object{cone{<0,0,0>,.125,<.25,0,0>,.0325} pigment{XWSilver}}

	object{cylinder{<0,0,0>,<-1,0,0>,.21875}texture{engine_dirt}} //1/2-1/16 for radius
	// above cylinder is the main part of the body

	object{sphere{<-.25,-.125,.08>,.0625}
		scale <1,1,2>
		pigment{XWGray55}}
	object{sphere{<-.35,-.125,.08>,.0625}
		scale <1,1,2>
		pigment{XWGray55}}
	object{sphere{<-.45,-.125,.08>,.0625}
		scale <1,1,2>
		pigment{XWGray55}}
	object{sphere{<-.25,-.125,-.08>,.0625}
		scale<1,1,2>
		pigment{XWGray55}}
	object{sphere{<-.35,-.125,-.08>,.0625}
		scale<1,1,2>
		pigment{XWGray55}}
	object{sphere{<-.45,-.125,-.08>,.0625}
		scale <1,1,2>
		pigment{XWGray55}}
	
	object{bfrnt translate x*-1}
	object {intersection{ // two dark gray boxes on the sides
		union{object{box{<-.375,0,-.5>,<0,.1875,.5>}}
			object{box{<-.4375,0,-.5>,<-.8125,.1875,.5>}}}
		object{cylinder{<0,0,0>,<-1,0,0>,.23}}
		pigment {XWGray35}}
	translate <-.0625,0,0>
	}}
#declare rounder=difference{
	object{sphere{<.1,0,0>,.25}}
	object{sphere{<-.03,0,0>,.25}}
	}
#declare Back_1=difference{
	object{cylinder{<-1,0,0>,<-1.5,0,0>,.15625}} //   1/4-3/32 for radius
	object{rounder translate <-1.2,0,0>}} 
#declare Back_2=difference{
	object{cylinder{<-1,0,0>,<-1.5,0,0>,.1875}} //  1/4-1/16
	object{rounder translate <-1.17,0,0>}}
#declare After_burner=union{
	difference{  
		object {cylinder{<-2,.125,0>,<-2.15625,.125,0>,.21875}}
		object {cylinder{<-1.98,.125,0>,<-2.17,.125,0>,.1875}}
		texture{engine_dirt}}
	object{light_source{<-2.1,.125,0> color XWFirebrick}}
	object{cylinder{<-2.01,.125,0>,<-2.15624,.125,0>,.1875}
			pigment {XWRed}
			texture {XWGlass}
			normal {bumps 1.5}
			finish {XWShiny}}}
#declare Engine=union{
	object {Front}
	object {Back_1 translate <0,.125,0>
		texture{engine_dirt}}
	object {Back_2 translate <-.5,.125,0>
		texture {engine_dirt}}
	object {After_burner}
	object{intersection{
		object{cylinder{<0,0,0>,<-.5,0,0>,.2}
			translate <-.9,0,0>
			texture {engine_dirt}}
		object{box{<.25,-1,-1>,<-1.25,.06,1>}}  
		}} //end object
	}
//**************************
//  platform - mounts engines to wings
//**************************
	
#declare main=object{box{<0,-.1,0>,<-1.25,.25,1>}
	clipped_by{plane{y,0}
		rotate x*180
	}//end clipping
	}
#declare trbl_cutting=object{plane{y,0}
	rotate x*-194 //14 degrees + 180
	translate y*.03125
	translate z*-.5
	//pigment{XWGray} 
	}

#declare trbl_platform=union{
	object{difference{
		object{difference{
			object{main} //main box
			object{trbl_cutting} //cut the slant off main shape
			}}
		object{difference{
			object{box{<-.03125,-.1,.03125>,<-1.21875,.21875,.96875>}}
			object{trbl_cutting
				translate y*-.03125}
			}}
		texture{XWDirt}
	}}
	object{box{<0,0,1>,<-1.25,-.03125,1.5>} // small part that goes in the
		translate <0,.03125,-.03125>   // xwing body
		pigment{XWGray50}}
	bounded_by{box{<1,-1,-1>,<-2,1,2>}}
	}
#declare tlbr_cutting=object{plane{y,0}
	rotate x*194 //14 + 180 degrees
	translate y*.03125
	translate z*1.5
	}
#declare tlbr_platform=union{
	object{difference{
		object{difference{
			object{main}
			object{tlbr_cutting}
			}}
		object{difference{
			object{box{<-.03125,-.1,.03125>,<-1.21875,.21875,.96875>}}
			object{tlbr_cutting
				translate y*-.03125}
			}}
		texture{XWDirt}
		}}
	object{box{<0,0,0>,<-1.25,-.03125,-.5>}
		translate<0,.03125,.03125>
		pigment{XWGray50}}
	bounded_by{box{<1,-1,-1>,<-2,1,2>}} 
	}
//***************************
//  laser weapons
//***************************
#declare Laser=union{
	object{union{
		object{cylinder{<0,0,0>,<-.125,0,0>,.125}
			pigment{radial
			color_map{[0.0 color XWGray30]
				[0.5 color XWGray30]
				[0.5 color XWGray60]
				[1.0 color XWGray60]}
				frequency 20
				rotate z*90
				}} //front of the body
		object{difference{
			object{cylinder{<0,0,0>,<-.125,0,0>,.126}}
			object{cylinder{<.1,0,0>,<-.126,0,0>,.125}}
			texture{XWDirt}}}
		}} // end inside union
	object{cylinder{<-.125,0,0>,<-.1875,0,0>,.109375}
		pigment{radial
		color_map{[0.0 color XWGray30]
			[0.5 color XWGray30]
			[0.5 color XWGray60]
			[1.0 color XWGray60]}
			frequency 20
			rotate z*90
			}}
	object{cylinder{<-.1875,0,0>,<-.25,0,0>,.09375}
		pigment{XWGray50}}
	object{cylinder{<-.25,0,0>,<-.375,0,0>,.078125}
		texture{XWDirt}}
	object{cylinder{<-.375,0,0>,<-1.25,0,0>,.09375}
		texture{XWDirt}}
	object{cylinder{<-1.25,0,0>,<-1.375,0,0>,.078125}
		pigment{radial
		color_map{[0.0 color XWGray40]
			[0.5 color XWGray40]
			[0.5 color XWGray55]
			[1.0 color XWGray55]}
			frequency 15
			rotate z*90
			}}
	object{union{
		object{cylinder{<-1.375,0,0>,<-1.4375,0,0>,.09375}
			pigment{radial
			color_map{[0.0 color XWGray30]
				[0.5 color XWGray30]
				[0.5 color XWGray60]
				[1.0 color XWGray60]}
				frequency 20
				rotate z*90
				}}
		object{difference{
			object{cylinder{<-1.375,0,0>,<-1.4375,0,0>,.09376}}
			object{cylinder{<-1.2,0,0>,<-1.5,0,0>,.09375}}
			texture{XWDirt}
			}}
		}}
	object{cylinder{<0,0,0>,<1.125,0,0>,.03125}
		texture{XWDirt}} // first section of forwrd tube
	object{cylinder{<1.125,0,0>,<2.625,0,0>,.015625}
		texture{XWDirt}}
	object{cylinder{<2,0,0>,<2.0625,0,0>,.05}
		pigment{XWGray45}}//cap behind disc
	object{intersection{ //difference{
		object{box{<-.125,-.03125,.125>,<0,.03125,-.125>}}  
		object{difference{
			object{sphere{<0,0,0>,.125}}
			object{sphere{<0.03125,0,0>,.125}}
			}}
		rotate x*90
		translate x*2.2
		pigment{XWGray45}
		}}
	object{box{<-.4375,-.125,-.09375>,<-.375,0,.09375>}
		pigment{XWGray45}} // front wing mount
	object{box{<-1.1875,-.125,-.09375>,<-1.25,0,.09375>}
		pigment{XWGray45}}
	}

//*****************************
//  wing - flat surface of wing
//*****************************
#declare wing_texture=
	texture{pigment{XWGray65}} //end texture 1 (surface)
	texture{pigment{image_map {gif "wingmap.gif" once
		map_type 0
		interpolate 2
		filter 168, 1} //filter out all the blue
		rotate <-90,-90,0>
		scale <1.4,1,2> 
		translate <-1.1875,.0625,-2.125>} //end image map
	}//end texture 2 (gif file)
	texture{pigment{granite turbulence 1
		color_map{[0.0 color XWGray50]
			[0.2 color XWGray55]
			[0.3 color XWClear]
			[1.0 color XWClear]}
		}
	rotate z*90} // end texture 3 (dirty surface)

#declare wing_box=object{box{<0,0,0>,<-1.375,.0625,-2.25>}}
#declare tlbr_wing_plane2=intersection{
	object{wing_box}
	object{box{<1,.0325,-3>,<-2,.0325000000001,3>}
		texture{wing_texture} //end texture 1 (surface)
		}//end object
	} //end intersection
#declare tlbr_final_wing_box=union{
		object{wing_box}
		object{tlbr_wing_plane2
			translate y*-.032501}
		} //end union
#declare tlbr_Wing=difference{
	object{tlbr_final_wing_box}
	object{plane{x,0}
		rotate y*-11
		translate x*-1.375}
		texture{pigment{granite turbulence 1
			color_map{[0.0 color XWGray50]
				[0.2 color XWGray55]
				[0.3 color XWGray65]
				[1.0 color XWGray65]}
			}} //end texture
	bounded_by{box{<.5,-.5,.5>,<-1.5,.5,-2.5>}}
	} //end difference

#declare trbl_wing_plane2=intersection{
	object{wing_box}
	object{box{<1,.0325,-3>,<-2,.0325000000001,3>}
		texture{wing_texture} //end texture 1 (surface)
		}//end object
	} //end intersection
#declare trbl_final_wing_box=union{
		object{wing_box}
		object{trbl_wing_plane2
			translate y*.03125}  
		}
#declare trbl_Wing=difference{
	object {trbl_final_wing_box}
	object {plane{x,0}
		rotate y*-11
		translate x*-1.375}
		texture{pigment{granite turbulence 1
			color_map{[0.0 color XWGray50]
				[0.2 color XWGray55]
				[0.3 color XWGray65]
				[1.0 color XWGray65]}
			}} // end texture
	bounded_by{box{<.5,-.5,.5>,<-1.5,.5,-2.5>}}
	} // end difference

//**********************************************************************
//trbl = top right and bottom left wings. bottom left wing needs to rotate
//tlbr = top left and bottom right wings.
#declare trbl_wing=union{
	object{Engine}
	object{trbl_platform
		translate <0,-.245,-.6875>}
	object{difference{
		object{trbl_Wing}
		object{box{<0,-1,0>,<-1.25,1,1>} //let you see the inside
			translate <0,-.25,-.45>} //of the platform
		}
		translate <0,-.25,-.21875>}
	object{Laser
		translate <.34125,-.0625,-2.4375>
		pigment {XWGray}}
	}
#declare tlbr_wing=union{
	object{Engine}
	object{tlbr_platform
		translate <0,-.25,-.3125>
		}
	object{difference{
		object{tlbr_Wing}
		object{box{<0,-1,0>,<-1.25,1,-1>} //let you see the inside
			translate <0,-.25,.6>}    //of the platform
		}
		rotate x*180
		translate <0,-.1974,.25>}
	object{Laser
		translate <.34125,-.0625,2.4375>
		pigment {XWGray}
		}}
//*****************
//end definitions

// Objects
// Section_A is the very back of the main body
// Section_B is the body underneath the cockpit to the cap
// Cap is the cap on the nose of the body
// Cockpit is the entire cockpit assembly
// Wings are Top Right/Bottom Left and Top Left/Bottom Right (from inside
//  the cockpit)

#declare xwing=union{
	object {Section_A}
	object {Section_B}
	object {trbl_wing  //top right
		rotate x*15.5
		translate <1.5,1,-.375>}
	object {tlbr_wing //top left
		rotate x*-15.5
		translate <1.5,1,1.375>}
	object {trbl_wing //bottom left
		rotate x*195.5
		translate <1.5,0,1.375>}
	object {tlbr_wing //bottom right
		rotate x*164.5
		translate <1.5,0,-.375>}
}//end xwing object
