static define windshield
   texture {
      special surface {
         color <.1,.1,.1>
         ambient .3
         diffuse .1
         specular 0.3
         reflection white, 0.1
      }
}
static define hulltex
   texture {
      special surface {
         color <1,0,0> * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^9)
         normal N + .125*dnoise(<x/5,y/5,z*5>)
         ambient .3 * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^9)
         diffuse .2
         specular 0.1 * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^7)
         reflection white, 0.1 * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^7)
      }
}
static define wingtex
   texture {
      special surface {
         color <1,1,1> * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^9)
         normal N + .125*dnoise(<x/5,y/5,z*5>)
         ambient .2 * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^9)
         diffuse .1
         specular 0.15 * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^7)
         reflection white, 0.18 * exp(-499*(fnoise(<599+x/5,454+y/5,540+z>))^7)
      }
}
static define glow
   texture {
      special surface {
         color <.5,.5,1>*1.5*(.95^frame)
         ambient 1
         diffuse 1
         specular 0
      }
}

static define foot
   texture {
      special surface {
         color black
         ambient .2
         diffuse .5
      }
}
static define door
   texture {
      special surface {
         color white*.5
         normal N + .25*dnoise(<x/5,y/5,z/5>)
         ambient .2
         diffuse .1
         specular 0.3
         reflection white, 0.2
      }
}
static define stars_tex
   texture {
      special surface {
         color <.5,.5,1>*15*(fnoise(<5.33,1.42,3.323>+<x,y,z>))^5+
               <1,.7,.7>*15*(fnoise(<15.33,-11.42,13.323>+<x,y,z>))^5+
               <.7,1,.7>*15*(fnoise(<x,y,z>))^5+
               <.7,.7,1>*((.03*fnoise(<21234.4,2513.42,1712.5>+P*59))^9+
               (.02*fnoise(<11534.4,-9513.42,-9712.5>+P*41))^9)
         ambient 1
         diffuse 1
         transmission white, 1,1
      }
}
static define rock
   texture {
      special surface {
         color white*.35 +.1*dnoise((500*P+<3000,1234,4321>))
                        +.1*dnoise((250*P+<9000,1734,4321>))
                        +.1*dnoise((125*P+<1000,134,4321>))
                        +.1*dnoise((62.5*P+<1000,134,4321>))
                        +.1*dnoise((31.25*P+<1000,134,4321>))
         normal N + .125*(dnoise(P*100)-.5*white)
                  + .125*(dnoise(P*50)-.5*white)
                  + .125*(dnoise(P*25)-.5*white)
                  + .125*(dnoise(P*12.5)-.5*white)
                  + .125*(dnoise(P*6.125)-.5*white)
                  + .125*(dnoise(P*3.0625)-.5*white)
         ambient 0
         diffuse .5
      }
}
static define ringtex
   texture {
      special surface {
         color <1,.7,.45>*(2*fnoise(<5*(x^2+z^2)^.5,5*(x^2+z^2)^.5,5*(x^2+z^2)^.5>))^(1/3)
                         *(fnoise(<atan(z/x)/10,atan(z/x)/10,atan(z/x)/10>))^(1/20)
         ambient 0
         diffuse 1
         transmission white, 1-(fnoise(<5*(x^2+z^2)^.5,5*(x^2+z^2)^.5,5*(x^2+z^2)^.5>))^(1/10), 1.1
      }
}
static define planettex
   texture {
      special surface {
         color <.95,.75,.40>*(fnoise(<5*y,5*y,5*y>))^(1/10)
                            *(fnoise(<atan(z/x)/10,atan(z/x)/10,atan(z/x)/10>))^(1/20)
         ambient 0
         diffuse 1
      }
}
static define moontex
   texture {
      special surface {
         color <1,.8,.8>*.5*
         ((fnoise(P))^.2+fnoise(P+<25,25,25>)^.111)
         ambient 0
         diffuse 1
      }
}
static define barrier
   texture {
      special surface {
         color <.5,.5,1>*(1.5*fnoise(P*100))^(frame/20)
         ambient .1*(1.5*fnoise(P*100))^(frame/20)
         diffuse 0
         specular white,.1*(1.5*fnoise(P*100))^(frame/20)
         transmission white, 1-(1.5*fnoise(P*100))^(frame/20),1
         reflection white,.1*(1.5*fnoise(P*100))^(frame/20)
      }
}

static define streaky_silver
texture {
   special surface {
      color <.7,.7,.9>
      normal N + 0.2 * (dnoise(5*W) - <0.5,0.5,0.5>)
      ambient 0
      diffuse 0.1
      specular 0.4*white, 0.3
      reflection 0.4
      microfacet Cook 5
      }
      scale <.1,10,10>
   }

static define floor_tex
texture {
   special surface {
      color <.4,.4,.4>
      normal N + 0.1 * (dnoise(500*P) - <0.5,0.5,0.5>)
      ambient 0
      diffuse 0.2
      specular white, 0.1
      reflection 0.4
      microfacet Cook 5
      }
}
static define char_tex
texture {
   special surface {
      color red
      normal N + 0.1 * (dnoise(500*P) - <0.5,0.5,0.5>)
      ambient 0
      diffuse 0.2
      specular white, 0.15
      reflection 0.5
      microfacet Cook 5
      }
}
static define flame
texture {
   special surface {
      color <0,0,1>*(fnoise(<x/5,y,z>*10+frame*<.5,0,0>))
      ambient 1
      diffuse 1
      transmission white,.9,1
      microfacet Cook 5
      }
}
static define earthtex
texture {
   special surface {
      color (  (fnoise(P+<123,432,234>))^2 >.05   ?     <.05,.15,0> : <.15,.15,.4>)
      ambient 0
      diffuse 1
      }
}
static define cloudtex
texture {
   special surface {
      color <1,1,1>*3*((fnoise(<x/2,y*2,z/2>))^1.05)
      ambient 0
      diffuse 1
      transmission white,1-3*((fnoise(<x/2,y*2,z/2>))^1.05),1
      }
}
