#include "colors.inc"
#include "metals.inc"

#declare Squigle = union {
	cylinder { <0.2, 0.0, 0.5>, <0.2, 0.0, 0.8>, 0.02 }
	intersection {
		torus { 0.10, 0.02
			translate <0.3, 0, 0.8>
		}
		box { <0.18, -0.02, 0.8>, <0.3, 0.02, 0.92> }
	}
	sphere { <0.3, 0.0, 0.9>, 0.02 }
	sphere { <0.27, 0.0, 0.83>, 0.02 }
	intersection {
		torus { 0.10, 0.02
			translate <0.1, 0, 0.5>
		}
		box { <0.10, -0.02, 0.38>, <0.22, 0.02, 0.50> }
	}
	sphere { <0.1, 0.0, 0.4>, 0.02 }
	sphere { <0.13, 0.0, 0.47>, 0.02 }
	scale <1, 0.25, 1>
	texture { T_Gold_2A }
}

#declare Head_part = union {
	prism {
		linear_spline
		-0.04, 0.04, 5
		<0, 0>, <0, 0.8>, <0.4, 1.2>, <0.4, 0.4>, <0, 0>
	}
	#ifndef ( Draft )
		object { Squigle
			translate <0.04, 0.04, 0.06>
		}	
		object { Squigle
			translate <0.04, -0.04, 0.06>
		}
	#end	
	rotate x*-90
}

#declare Head = difference {
	union {
		object { Head_part }
		object { Head_part
			rotate y*120
		}
		object { Head_part
			rotate y*240
		}
		torus { 0.147, 0.025
			scale <1, 2, 1>
			translate <0, 0.73, 0>
			texture { T_Gold_2A }
		}
	}
	sphere { <0, 0, 0>, 0.175
		scale <1, 1.5, 1>
		translate <0, 0.8, 0>
		texture { T_Gold_2A }
	}
}	

#declare Staff = union {
	cylinder { <0, 0, 0>, <0, 13.2, 0>, 0.2 }
	#ifndef ( Draft )
		sphere { <0, 0, 0>, 0.2
			scale <1, 0.25, 1>
			translate <0, 13.3, 0>
			texture { T_Gold_2A }
		}
		torus { 0.2, 0.06
			translate <0, 13.24, 0>
		}
		cylinder { <0, 13, 0>, <0, 13.24, 0>, 0.23 }
		torus { 0.23, 0.01
			scale <1, 3, 1>
			translate <0, 13.18, 0>
			texture { T_Gold_2A }
		}
		torus { 0.2, 0.03
			scale <1, 2, 1>
			translate <0, 13, 0>
			texture { T_Gold_2A }
		}
	#end
	#ifdef ( Draft )
		//sphere { <0, 13.2, 0>, 0.2 }
	#end
	object { Head
		rotate y*30
		translate <0, 13, 0>
	}
	sphere { <0, 0, 0>, 0.175
		scale <1, 1.5, 1>
		translate <0, 13.8, 0>
		#ifndef ( Draft )
			material {
				texture {
					pigment { colour rgbf <0.9, 1.2, 1.5, 0.8> }
					finish {
						ambient 0.2
						diffuse 0.1
						reflection 0.05
						specular 1
						roughness 0.001
					}                              
				}
				interior {
					ior 1.8
				}
			} 
		#end
		#ifdef ( Draft )
			pigment { colour rgbt <0.6, 0.6, 1.0, 0.5> }
			finish { ambient 0.8 }
		#end 
	}
	texture { T_Silver_4A }
	normal {
		wrinkles 0.3
	}
}
