// Hybrid of Soft_Silver and Gold_Nugget in textures.inc
#declare Tarnished_Iron = texture {
	pigment { colour rgb <0.94, 0.93, 0.83> }
	finish {
		metallic
		diffuse 0.65
		specular 0.85
		roughness 0.01
		reflection 0.45
		brilliance 1.5
	}
}	

#declare Rust_Layer = texture {
   pigment {
      bozo
      turbulence 0.5
      omega 0.65
      lambda 2.2
		colour_map {
         [ 0.00 colour rgbt <0.36, 0.20, 0.20, 0.00> ]
         [ 0.05 colour rgbt <0.50, 0.30, 0.25, 0.05> ]
         [ 0.15 colour rgbt <0.65, 0.40, 0.35, 0.10> ]
         [ 0.25 colour rgbt <0.65, 0.65, 0.10, 0.50> ]
         [ 0.35 colour rgbt <0.65, 0.65, 0.10, 0.50> ]
         [ 0.65 colour rgbt <0.65, 0.65, 0.10, 0.50> ]
         [ 0.75 colour rgbt <0.65, 0.65, 0.10, 0.50> ]
         [ 0.85 colour rgbt <0.65, 0.40, 0.35, 0.10> ]
         [ 0.95 colour rgbt <0.50, 0.30, 0.25, 0.05> ]
         [ 1.00 colour rgbt <0.36, 0.20, 0.20, 0.00> ]
      }
   }
   scale 0.15
}

#macro Bracket ( rotation, translation )
	union {
		prism {
			linear_spline
			0, 0.1, 5,
			<-0.5, 0>, <-0.25, 0.75>, <0.25, 0.75>, <0.5, 0>, <-0.5, 0>
			rotate -x*90
		}
		intersection {
			difference {
				sphere { <0, 0.4, 0>, 0.3 }
				sphere { <0, 0.4, 0>, 0.25 }
				scale <0.8, 1, 1>
			}
			box { <-0.3, 0.1, 0>, <0.3, 0.4, -0.3> }
			bounded_by { box { <-0.3, 0.1, 0>, <0.3, 0.4, -0.3> } }
		}
		box { <-0.25, 1.25, -0.1>, <0.25, 1.75, 0> }
		torus { 0.4, 0.05
			translate <0, 1.50, -0.5>
		}
		#ifndef ( Draft )
			texture { Tarnished_Iron }
			texture { Rust_Layer
				rotate rotation
				translate translation
			}
		#else
			pigment { colour rgb <0.5, 0.5, 0.5> }
		#end
		scale 2.5
		rotate rotation
		translate translation
	}
#end