// Phase 8 + 7 - Walk forward - 1 seconds (total 13 + 7 seconds)

#include "colors.inc"
//#declare Draft = version;
#include "e:\pc'sjunk\pov\adventure\dungeon.inc"
#include "e:\pc'sjunk\pov\adventure\staff.inc"
#include "e:\pc'sjunk\pov\adventure\light.inc"
#include "e:\pc'sjunk\pov\adventure\grail.inc"

background { colour rgb <1, 1, 1> }

// No identifier means it applies to the camera and light_source translations.
// CL designates camera look_at.
// L  designates light_source translation.
// C  designates camera translation.
// S  designates staff
#declare P1_Motion = <0, 0, 60>;
#declare P1_Rotate_S = <0, 0, 0>;
#declare P1_Motion_S = P1_Motion + <0, 0, 0>;
#declare P2_Motion_CL = <sin(pi/3), 0, cos(pi/3)> - <0, 0, 1>;
#declare P2_Motion_L = vrotate(<-1, 1, 3>, <0, 60, 0>) - <-1, 1, 3>;
#declare P2_Rotate_S = <0, 60, 0>;
#declare P2_Motion_S = vrotate(<1.5, 0, 4>, <0, 60, 0>) - <1.5, 0, 4>;
#declare P3_Motion_CL = <0, 0, 1> - <sin(pi/3), 0, cos(pi/3)>;
#declare P3_Motion_L = <-1, 1, 3> - vrotate(<-1, 1, 3>, <0, 60, 0>);
#declare P3_Rotate_S = <0, -60, 0>;
#declare P3_Motion_S = <1.5, 0, 4> - vrotate(<1.5, 0, 4>, <0, 60, 0>);
#declare P4_Motion_C = <-10, 0, 10>;
#declare P4_Motion_CL = vcross(<0, 0, 1>, <0, 1, 0>) - <0, 0, 1>;
#declare P4_Motion_L = <-12, 0, 6>;
#declare P4_Rotate_S = <2, -90, 0>;
#declare P4_Motion_S = P4_Motion_C + <-4, 0, 1.5> - <1.5, 0, 4> + <0, 0.5, 0>;
#declare P5_Motion = <-20, 0, 0>;
#declare P5_Rotate_S = <0, 0, 2> - <0, 0, 2>;
#declare P5_Motion_S = P5_Motion + <0, 0.5, 0> - <0, 0.5, 0>;
#declare P6_Motion_C = <-15, 0, 15>;
#declare P6_Motion_CL = vcross(<-1, 0, 0>, <0, -1 , 0>) - vcross(<0, 0, 1>, <0, 1, 0>);
#declare P6_Motion_L = <-13, 0, 19>; 
#declare P6_Rotate_S1 = <0, 0, 0> - <0, 0, 2>;
#declare P6_Rotate_S2 = <0, 90, 0>;
#declare P6_Motion_S = P6_Motion_C + <1.5, 0, 4> - <-4, 0, 1.5> - <0, 0.5, 0>;
#declare P7_Motion = <0, -75*tan(10*pi/180), 75>;
#declare P7_Motion_CL = <0, 0, 1> - vcross(<-1, 0, 0>, <0, -1, 0>);
#declare P7_Motion_S = P7_Motion;
#declare P7_Rotate_S = <0, 0, 0>;
#declare P8_Motion = <0, 0, 30>*clock;
#declare P8_Rotate_S = <2*abs(sin(pi*clock)), 0, 0>;
#declare P8_Motion_S = P8_Motion + <0, 0.5*abs(sin(pi*clock)), 0>;

camera {
	location <0, 15, -25>                                                                                                 
	look_at <0, 15, -24> + P2_Motion_CL + P3_Motion_CL + P4_Motion_CL + P6_Motion_CL + P7_Motion_CL
	translate P1_Motion
	translate P4_Motion_C
	translate P5_Motion
	translate P6_Motion_C
	translate P7_Motion
	translate P8_Motion
}

light_source {
	<-1, 16, -22>
	colour White
	fade_distance 25
	fade_power 1.5
	translate P1_Motion
	translate P2_Motion_L
	translate P3_Motion_L
	translate P4_Motion_L
	translate P5_Motion
	translate P6_Motion_L
	translate P7_Motion
	translate P8_Motion
}

#declare Light_markers = union {
	// y-axis
	sphere { <-1, 16.2, -22>, 0.05
		pigment { colour rgbt <1.0, 1.0, 0.0, 0.6> }
	}
	sphere { <-1, 15.8, -22>, 0.05
		pigment { colour rgbt <1.0, 1.0, 0.0, 0.6> }
	}
	// x-axis
	sphere { <-1.2, 16, -22>, 0.05
		pigment { colour rgbt <1.0, 0.0, 1.0, 0.6> }
	}
	sphere { <-0.8, 16, -22>, 0.05
		pigment { colour rgbt <1.0, 0.0, 1.0, 0.6> }
	}
	// z-axis
	sphere { <-1, 16, -22.2>, 0.05
		pigment { colour rgbt <0.0, 1.0, 1.0, 0.6> }
	}
	sphere { <-1, 16, -21.8>, 0.05
		pigment { colour rgbt <0.0, 1.0, 1.0, 0.9> }
	}
	translate P1_Motion
	translate P2_Motion_L
	translate P3_Motion_L
	translate P4_Motion_L
	translate P5_Motion
	translate P6_Motion_L
	translate P7_Motion
	translate P8_Motion
}
//object { Light_markers }
#declare first_1o2_clock = 2*min(0.5, clock);
#declare delay_1o2_clock = 2*( max(0.5, clock) - 0.5 );
object { Light_Sphere
	rotate < 68.96/2.689 + 68.96 - 68.96/1.771, 79.20/2.890 + 79.20 - 79.20/1.238, 23.04/2.478 + 23.04 - 23.04/1.485 >
	rotate < 11.48/2.580, 12.50/2.236, 10.02/2.950 > + < 11.48 - 11.48/1.358, 12.50 - 12.50/1.432, 10.02 - 10.02/1.864 >
	rotate < 25.12/2.533, 38.64/2.281, 29.44/2.475 > + < 25.12 - 25.12/1.936, 38.64 - 38.64/1.530, 29.44 - 29.44/1.210 >
	rotate < 50.36/2.552, 45.10/2.033, 39.56/2.337 > + < 50.36 - 50.36/1.794, 45.10 - 45.10/1.268, 39.56 - 39.56/1.171 >
	rotate < 35.91/2.319, 16.59/2.342, 21.93/2.887 > + < 35.91 - 35.91/1.421, 16.59 - 16.59/1.693, 21.93 - 23.93/1.952 >
	rotate < 42.15/2.609, 39.63/2.019, 41.88/2.444 > + < 42.15 - 42.15/1.859, 39.63 - 39.63/1.759, 41.88 - 41.88/1.471 >
	rotate < 89.43/2.797 + 89.43 - 89.43/1.337, 67.52/2.755 + 67.52 - 67.52/1.378, 53.73/2.713 + 53.73 - 53.73/1.418 >
	rotate < 30.22/2.042*pow(clock, 2.042), 40.61/2.970*pow(clock, 2.970), 34.17/2.327*pow(clock, 2.713) >
	translate <-1, 16, -22>
	translate P1_Motion
	translate P2_Motion_L
	translate P3_Motion_L
	translate P4_Motion_L
	translate P5_Motion
	translate P6_Motion_L
	translate P7_Motion
	translate P8_Motion
}
/*
light_source {
	<90, 17, 45>
	colour White
	fade_distance 25
	fade_power 1.5
}
*/

object { Staff
	rotate P1_Rotate_S
	rotate P2_Rotate_S
	rotate P3_Rotate_S
	rotate P4_Rotate_S
	rotate P5_Rotate_S
	rotate P6_Rotate_S1
	rotate P6_Rotate_S2
	rotate P7_Rotate_S
	rotate P8_Rotate_S
	translate <1.5, 0, -21> // position properly, after rotating
	translate P1_Motion_S
	translate P2_Motion_S
	translate P3_Motion_S
	translate P4_Motion_S
	translate P5_Motion_S
	translate P6_Motion_S
	translate P7_Motion_S
	translate P8_Motion_S
}

object { Dungeon }

// altar light
light_source {
	<-45, 19.25 - 75*tan(10*pi/180), 200>
	colour rgb <1.0, 1.0, 0.8>
	fade_distance 10
	fade_power 2
}

object { Grail
	no_shadow
	scale 1.5
	translate <-45, 8.5 - 75*tan(10*pi/180), 200>
}

difference {
	cylinder { <0, 8.5, 0>, <0, 30, 0>, 3.75 }
	cylinder { <0, 8.4, 0>, <0, 30, 0>, 3.0 }
	pigment {
		radial
		frequency 3.5
		turbulence 0.1
		omega 0.25
		colour_map {
			[ 0.00 colour rgbt <0.7, 0.7, 0.3, 0.65> ]
			[ 0.50 colour rgbt <0.7, 0.7, 0.3, 0.65> ]
			[ 0.50 colour rgbt <0.5, 0.5, 0.2, 0.50> ]
			[ 1.00 colour rgbt <0.5, 0.5, 0.2, 0.50> ]			
		}
	}
	no_shadow
	finish { ambient 1.0 }
	rotate y*45*(1.5 + 3 + 1*clock)
	translate <-45, -75*tan(10*pi/180), 200>
}