// Phase 11 + 7 + 2 - Look up + fade out - 1 seconds (total 17 + 7 + 3 seconds)

#include "colors.inc"
//#declare Draft = version;
#declare Open_SC = version;
#include "e:\pc'sjunk\pov\adventure\dungeon.inc"
#include "e:\pc'sjunk\pov\adventure\staff.inc"
#include "e:\pc'sjunk\pov\adventure\light.inc"
#include "e:\pc'sjunk\pov\adventure\grail.inc"

background { colour rgb <1, 1, 1> }

// No identifier means it applies to the camera and light_source translations.
// CL designates camera look_at.
// L  designates light_source translation.
// C  designates camera translation.
// S  designates staff
#declare P1_Motion = <0, 0, 60>;
#declare P1_Rotate_S = <0, 0, 0>;
#declare P1_Motion_S = P1_Motion + <0, 0, 0>;
#declare P2_Motion_CL = <sin(pi/3), 0, cos(pi/3)> - <0, 0, 1>;
#declare P2_Motion_L = vrotate(<-1, 1, 3>, <0, 60, 0>) - <-1, 1, 3>;
#declare P2_Rotate_S = <0, 60, 0>;
#declare P2_Motion_S = vrotate(<1.5, 0, 4>, <0, 60, 0>) - <1.5, 0, 4>;
#declare P3_Motion_CL = <0, 0, 1> - <sin(pi/3), 0, cos(pi/3)>;
#declare P3_Motion_L = <-1, 1, 3> - vrotate(<-1, 1, 3>, <0, 60, 0>);
#declare P3_Rotate_S = <0, -60, 0>;
#declare P3_Motion_S = <1.5, 0, 4> - vrotate(<1.5, 0, 4>, <0, 60, 0>);
#declare P4_Motion_C = <-10, 0, 10>;
#declare P4_Motion_CL = vcross(<0, 0, 1>, <0, 1, 0>) - <0, 0, 1>;
#declare P4_Motion_L = <-12, 0, 6>;
#declare P4_Rotate_S = <2, -90, 0>;
#declare P4_Motion_S = P4_Motion_C + <-4, 0, 1.5> - <1.5, 0, 4> + <0, 0.5, 0>;
#declare P5_Motion = <-20, 0, 0>;
#declare P5_Rotate_S = <0, 0, 2> - <0, 0, 2>;
#declare P5_Motion_S = P5_Motion + <0, 0.5, 0> - <0, 0.5, 0>;
#declare P6_Motion_C = <-15, 0, 15>;
#declare P6_Motion_CL = vcross(<-1, 0, 0>, <0, -1 , 0>) - vcross(<0, 0, 1>, <0, 1, 0>);
#declare P6_Motion_L = <-13, 0, 19>; 
#declare P6_Rotate_S1 = <0, 0, 0> - <0, 0, 2>;
#declare P6_Rotate_S2 = <0, 90, 0>;
#declare P6_Motion_S = P6_Motion_C + <1.5, 0, 4> - <-4, 0, 1.5> - <0, 0.5, 0>;
#declare P7_Motion = <0, -75*tan(10*pi/180), 75>;
#declare P7_Motion_CL = <0, 0, 1> - vcross(<-1, 0, 0>, <0, -1, 0>);
#declare P7_Motion_S = P7_Motion;
#declare P7_Rotate_S = <0, 0, 0>;
#declare P8_Motion = <0, 0, 30>;
#declare P8_Rotate_S = <0 0, 0>;
#declare P8_Motion_S = P8_Motion;
#declare P9_Motion_CL = <1, 0, 0> - <0, 0, 1>;
#declare P9_Motion_L = <3, 1, 1> - <-1, 1, 3>;
#declare P9_Rotate_S = <0, 90, 0>;
#declare P9_Motion_S = <4, 0, -1.5> - <1.5, 0, 4>;
#declare P10_Motion_CL = <cos(pi/3), 0, -sin(pi/3)> - <1, 0, 0>;
#declare P10_Motion_L = vrotate(<3, 1, 1>, <0, 60, 0>) - <3, 1, 1>;
#declare P10_Rotate_S = <0, 60, 0>;
#declare P10_Motion_S = vrotate(<4, 0, -1.5>, <0, 60, 0>) - <4, 0, -1.5>;
#declare begin_1o2_clock = min(1/2, clock)/(1/2);
#declare P11_Motion_CL = vrotate(<cos(pi/3), 0, -sin(pi/3)>, 90*begin_1o2_clock*vcross(<0, -1, 0>, <cos(pi/3), 0, -sin(pi/3)>)) - <cos(pi/3), 0, -sin(pi/3)>;

camera {
	location <0, 15, -25>                                                                                                 
	look_at <0, 15, -24> + P2_Motion_CL + P3_Motion_CL + P4_Motion_CL + P6_Motion_CL + P7_Motion_CL + P9_Motion_CL + P10_Motion_CL + P11_Motion_CL
	translate P1_Motion
	translate P4_Motion_C
	translate P5_Motion
	translate P6_Motion_C
	translate P7_Motion
	translate P8_Motion
}

light_source {
	<-1, 16, -22>
	colour White
	fade_distance 25
	fade_power 1.5
	translate P1_Motion
	translate P2_Motion_L
	translate P3_Motion_L
	translate P4_Motion_L
	translate P5_Motion
	translate P6_Motion_L
	translate P7_Motion
	translate P8_Motion
	translate P9_Motion_L
	translate P10_Motion_L
}

#declare Light_markers = union {
	// y-axis
	sphere { <-1, 16.2, -22>, 0.05
		pigment { colour rgbt <1.0, 1.0, 0.0, 0.6> }
	}
	sphere { <-1, 15.8, -22>, 0.05
		pigment { colour rgbt <1.0, 1.0, 0.0, 0.6> }
	}
	// x-axis
	sphere { <-1.2, 16, -22>, 0.05
		pigment { colour rgbt <1.0, 0.0, 1.0, 0.6> }
	}
	sphere { <-0.8, 16, -22>, 0.05
		pigment { colour rgbt <1.0, 0.0, 1.0, 0.6> }
	}
	// z-axis
	sphere { <-1, 16, -22.2>, 0.05
		pigment { colour rgbt <0.0, 1.0, 1.0, 0.6> }
	}
	sphere { <-1, 16, -21.8>, 0.05
		pigment { colour rgbt <0.0, 1.0, 1.0, 0.9> }
	}
	translate P1_Motion
	translate P2_Motion_L
	translate P3_Motion_L
	translate P4_Motion_L
	translate P5_Motion
	translate P6_Motion_L
	translate P7_Motion
	translate P8_Motion
	translate P9_Motion_L
	translate P10_Motion_L
}
//object { Light_markers }
#declare first_1o2_clock = 2*min(0.5, clock);
#declare delay_1o2_clock = 2*( max(0.5, clock) - 0.5 );
object { Light_Sphere
	rotate < 68.96/2.689 + 68.96 - 68.96/1.771, 79.20/2.890 + 79.20 - 79.20/1.238, 23.04/2.478 + 23.04 - 23.04/1.485 >
	rotate < 11.48/2.580, 12.50/2.236, 10.02/2.950 > + < 11.48 - 11.48/1.358, 12.50 - 12.50/1.432, 10.02 - 10.02/1.864 >
	rotate < 25.12/2.533, 38.64/2.281, 29.44/2.475 > + < 25.12 - 25.12/1.936, 38.64 - 38.64/1.530, 29.44 - 29.44/1.210 >
	rotate < 50.36/2.552, 45.10/2.033, 39.56/2.337 > + < 50.36 - 50.36/1.794, 45.10 - 45.10/1.268, 39.56 - 39.56/1.171 >
	rotate < 35.91/2.319, 16.59/2.342, 21.93/2.887 > + < 35.91 - 35.91/1.421, 16.59 - 16.59/1.693, 21.93 - 23.93/1.952 >
	rotate < 42.15/2.609, 39.63/2.019, 41.88/2.444 > + < 42.15 - 42.15/1.859, 39.63 - 39.63/1.759, 41.88 - 41.88/1.471 >
	rotate < 89.43/2.797 + 89.43 - 89.43/1.337, 67.52/2.755 + 67.52 - 67.52/1.378, 53.73/2.713 + 53.73 - 53.73/1.418 >
	rotate < 30.22/2.042, 40.61/2.970, 34.17/2.327 > + < 30.22 - 30.22/1.534, 40.61 - 40.61/1.302, 34.17 - 34.17/1.954 >
	rotate < 136.1/2.080, 50.60/2.846, 83.80/2.465 > + < 136.1 - 136.1/1.695, 50.60 - 50.60/1.159, 83.80 - 83.80/1.667 >
	rotate < 37.18/2.710, 25.70/2.345, 41.28/2.935 > + < 37.18*clock - 37.18/1.510*pow(clock, 1.510),
		25.70*clock - 25.70/1.751*pow(clock, 1.751), 41.28*clock - 41.28/1.276*pow(clock, 1.276) >
	translate <-1, 16, -22>
	translate P1_Motion
	translate P2_Motion_L
	translate P3_Motion_L
	translate P4_Motion_L
	translate P5_Motion
	translate P6_Motion_L
	translate P7_Motion
	translate P8_Motion
	translate P9_Motion_L
	translate P10_Motion_L
}
/*
light_source {
	<90, 17, 45>
	colour White
	fade_distance 25
	fade_power 1.5
}
*/

object { Staff
	rotate P1_Rotate_S
	rotate P2_Rotate_S
	rotate P3_Rotate_S
	rotate P4_Rotate_S
	rotate P5_Rotate_S
	rotate P6_Rotate_S1
	rotate P6_Rotate_S2
	rotate P7_Rotate_S
	rotate P8_Rotate_S
	rotate P9_Rotate_S
	rotate P10_Rotate_S
	translate <1.5, 0, -21> // position properly, after rotating
	translate P1_Motion_S
	translate P2_Motion_S
	translate P3_Motion_S
	translate P4_Motion_S
	translate P5_Motion_S
	translate P6_Motion_S
	translate P7_Motion_S
	translate P8_Motion_S
	translate P9_Motion_S
	translate P10_Motion_S
}

object { Dungeon }

object { Grail
	scale 1.5
	translate <-45, 8.5 - 75*tan(10*pi/180), 200>
}

// altar glow
merge {
	torus { 1.5, 0.15
		rotate x*90
		translate <0, 5.25, -4>
	}  
	#declare i = 0;
	#while ( i < 5 )
		merge {
			cylinder { <0, 0, -4>, <0, 0.65, -4>, 0.15 }
			intersection {
				torus { 0.5, 0.15
					rotate x*90
					translate <0.5, 0.65, -4>
				}
				box { <-0.15, 0.65, -4>, <0.5, 1.3, -4.15> }
			}
			sphere { <0.5, 1.15, -4>, 0.15 }
			pigment { colour rgbt <1, 1, 1, 1> }
			hollow
			rotate z*72*i
			translate <0, 5.25, 0>
		}
		#declare i = i + 1;
	#end
	pigment { colour rgbt <1, 1, 1, 1> }
	hollow
	interior {
		media {
			emission 1
			intervals 20
			density {
				agate
				phase clock
				colour_map {
					[ 0.00 colour rgb <0, 0, 0> ]
					[ 0.20 colour rgb <1, 0.2, 0.2>*2 ]
					[ 0.75 colour rgb <1, 0.3, 0.2>*3 ]
					[ 0.90 colour rgb <1, 0.5, 0.2>*3 ]
					[ 1.00 colour rgb <1, 0.8, 0.2>*3 ]
				}
				scale 0.01
			}
		}
	}
	translate <-45, -75*tan(10*pi/180), 200>
}

light_source {
	<-45, 5.25 - 75*tan(10*pi/180), 195>
	colour rgb <1, 0, 0>
	fade_power 2
	fade_distance 1.401
}

// "panel" glow
intersection {
	merge {
		torus { 1.5, 0.15
			rotate x*90
			translate <0, 5.25, -4>
		}  
		#declare i = 0;
		#while ( i < 5 )
			merge {
				cylinder { <0, 0, -4>, <0, 0.65, -4>, 0.15 }
				intersection {
					torus { 0.5, 0.15
						rotate x*90
						translate <0.5, 0.65, -4>
					}
					box { <-0.15, 0.6499, -4>, <0.5, 1.3, -4.15> }
				}
				sphere { <0.5, 1.15, -4>, 0.15 }
				pigment { colour rgbt <1, 1, 1, 1> }
				hollow
				rotate z*72*i
				translate <0, 5.25, 0>
			}
			#declare i = i + 1;
		#end
		pigment { colour rgbt <1, 1, 1, 1> }
		hollow
		interior {
			media {
				emission 1
				intervals 20
				density {
					agate
					phase clock
					colour_map {
						[ 0.00 colour rgb <0, 0, 0> ]
						[ 0.20 colour rgb <1, 0.2, 0.2>*2 ]
						[ 0.75 colour rgb <1, 0.3, 0.3>*3 ]
						[ 0.90 colour rgb <1, 0.5, 0.5>*3 ]
						[ 1.00 colour rgb <1, 0.8, 0.8>*3 ]
					}
					scale 0.01
				}
			}
		}
		translate <0, -5.25, 4>
		rotate y*90
		translate <-1, 15 - 75*tan(10*pi/180), 157.5>
	}
	cylinder { <-0.8, 15 - 75*tan(10*pi/180), 157.5>, <-1.2, 15 - 75*tan(10*pi/180), 157.5>, 0.001 + 1.7 }
}

light_source {
	<-2, 15 - 75*tan(10*pi/180), 157.5>
	colour rgb <1, 0, 0>
	fade_power 2
	fade_distance 1.401 + 1.4
}

#declare Gate = union {
	#declare i = -31;
	#while ( i > -60 )
		cylinder { <i, -60*tan(10*pi/180), 130>, <i, 30, 130>, 0.3 }
		cone { <i, -60*tan(10*pi/180), 130>, 0.5, <i, -70*tan(10*pi/180), 130>, 0 }
		difference {
			sphere { <i, -2*60*tan(10*pi/180), 130>, 0.5
				scale <1, 0.5, 1>			
			}
			plane { y, -60*tan(10*pi/180) }
		}
		#declare i = i - 2;
	#end
	#declare i = 2 - 60*tan(10*pi/180);
	#while ( i < 30 )
		box { <-30.5, i, 129.9>, <-59.5, i + 0.5, 130.1> }
		#declare i = i + 4;
	#end
	object { Decoration_G
		translate <0, -5.25, 4>
		scale <2, 2, 2.5>
		rotate y*180
		translate <-45, 15 - 70*tan(10*pi/180), 130>
	}
	texture { T_Silver_4B }
}

object { Gate }

#declare delay_1o2_clock = ( max(1/2, clock) - 1/2 )/(1/2);

#declare Slime = material {
	texture {
		pigment { colour rgbf <0.5, 1, 0.5, 0.3 - 0.3*delay_1o2_clock> }
		finish {
			ambient 0.4
			diffuse 0.1
			reflection 0.05
			phong 0.3
		}
	}
	interior {
		ior 1.5
	}
}


blob {
	threshold 0.5
	sphere { <-45, 15.5 - 75*tan(10*pi/180), 162.5>, 0.1, 0.8 }
	cylinder { <-45, 15.51 - 75*tan(10*pi/180), 162.5>, <-45, 15.62 - 75*tan(10*pi/180), 162.5>, 0.03, 1 }
	sphere { <-45, 15.65 - 75*tan(10*pi/180), 162.5>, 0.05, 1 }
	material { Slime }
	translate y*15
	translate -y*49.05*pow(clock + 0.55, 2)
}

#declare R = seed(65468);
blob {
	threshold 0.5
	sphere { <-45, 30 - 75*tan(10*pi/180), 165>, 1.5, 1 }
	#local i = 0;
	#while ( i < 10 )
		sphere { <-45, 30 - 75*tan(10*pi/180), 165> + vrotate( <0, 0.25 + 0.75*rand(R), 0>, <200*(rand(R) - 0.5), 0, 200*(rand(R) - 0.5)> ),
			0.2 + 0.8*rand(R), 0.2 + 08*rand(R)
		}
		#local i = i + 1;
	#end
	material { Slime }
	translate -y*49.05*pow(min(0.5, clock) + 0.05, 2)
}
