// Inverse Kinematics gear 1 compensation LScript
// by Aaron Gage
//
// This script is designed to work with the manip.lws scene and objects.
// It compensates for the motion produced through inverse kinematics
// on a manipulator arm by rotating the arm's gears the amount that would
// have produced its current position.  This will produce the illusion that
// the arm's motors, and not Lightwave's inverse kinematics features, are
// causing the arm's movement.  Hopefully.
//
// November 27, 1999

// Global variables for each of the gears being spun

thisobj;
refobj;

create
{
	setdesc("Gear 3 Spinning/Compenation");
	refobj = getfirstitem("Null");
}

process: ma, frame, time
{
  refrot = refobj.getRotation(time);
  thisrot = <0, refrot.y*(236.3/90.0)*180/PI, 0>;
  ma.set(ROTATION, thisrot);
}