//  Persistance of Vision Raytracer V3.0
//  World definition file.
//
//  Contains 2 lights, 28 textures and 247 primitives.
//
//  This file was generated for POV-Ray V3.0 by
//  MORAY.EXE V2.5b.wat(c) 1991-1995 Lutz + Kretzschmar
//

//  Date : 01/07/1998    (07.01.1998)
//

//
//  This is the standard include file for POV-Ray. It is included with
//  every scene that Moray exports for POV-Ray.
//

#declare STARTS1 = 0
#declare ENDS1 = STARTS1 + 75   // 75
#declare STARTS3 = ENDS1+1
#declare ENDS3 = STARTS3+29     // 105
#declare STARTS4 = ENDS3+1
#declare ENDS4 = STARTS4+44     // 150
#declare STARTS5 = ENDS4+1
#declare ENDS5 = STARTS5+14     // 165
#declare STARTS6 = ENDS5+1
#declare ENDS6 = STARTS6+14     // 180
#declare STARTS7 = ENDS6+1
#declare ENDS7 = STARTS7+14     // 195
#declare STARTS8 = ENDS7+1
#declare ENDS8 = STARTS8+29     // 225
#declare STARTS9 = ENDS8+1
#declare ENDS9 = STARTS9+14     // 240
#declare STARTS10 = ENDS9+1
#declare ENDS10 = STARTS10+7    // 248
#declare STARTS11 = ENDS10+1
#declare ENDS11 = STARTS11+11   // 260
#declare STARTS12 = ENDS11+1
#declare ENDS12 = STARTS12+14   // 275

#declare Start    = 0
#declare End      = ENDS12

#declare myclock = Start+(End-Start)*clock

//*******************************
//*******************************
#if(myclock >= STARTS1 & myclock <= ENDS1)
 #declare SCENE1 = 1
#end
#if(myclock > ENDS1 & myclock <= ENDS3)
 #declare SCENE3 = 1
#end
#if (myclock > ENDS3 & myclock <= ENDS4)
 #declare SCENE4 = 1
#end
#if (myclock > ENDS4 & myclock <= ENDS5)
 #declare SCENE5 = 1
#end
#if (myclock > ENDS5 & myclock <= ENDS6)
 #declare SCENE6 = 1
#end
#if (myclock > ENDS6 & myclock <= ENDS7)
 #declare SCENE7 = 1
#end
#if (myclock > ENDS7 & myclock <= ENDS8)
 #declare SCENE8 = 1
#end
#if (myclock > ENDS8 & myclock <= ENDS9)
 #declare SCENE9 = 1
#end
#if (myclock > ENDS9 & myclock <= ENDS10)
 #declare SCENE10 = 1
#end
#if (myclock > ENDS10 & myclock <= ENDS11)
 #declare SCENE11 = 1
#end
#if (myclock > ENDS11 & myclock <= ENDS12)
 #declare SCENE12 = 1
#end

//*******************************
#declare BACK_JET = -0.5
#declare FRONT_JET = -0.5

#declare curclock = mod(int(myclock),2)
#if(curclock = 0)
 #declare JET_TURB = 1
#else
 #declare JET_TURB = 1.2
#end

      /*
        [ 0.0 color rgbt <0, 0, .7,  .7> ]
        [ 0.15 color rgbt <0,0,1, 0> ]
        */
#declare JETCOLOR = color_map{
         [ 0.0 color rgbt <.7, 0, 0,  1> ]
         [ 0.15 color rgbt <1,0,0, 0> ]
         [ 0.20 color rgbt <1,.5,0, 0> ]
         [ 0.3 color rgbt <1, .5, 0, 0> ]
         [ 0.35 color rgbt <1, 1, 0, .5> ]
         [ 0.6 color rgbt <1, 1, 1, -1> ]
         [ 1.0 color rgbt <1, 1, 1,  0> ]
        }
/*
         [ 0.0 color rgbt <.7, 0, 0,  -1> ]
         [ 0.15 color rgbt <1,0,0, -1> ]
         [ 0.20 color rgbt <0,.5,1, -1> ]
         [ 0.3 color rgbt <0, .5, 1, -1> ]
         [ 0.35 color rgbt <1, 1, 0, -1> ]
         [ 0.6 color rgbt <1, 1, 1, -1> ]
         [ 1.0 color rgbt <1, 1, 1,  -1> ]
        }
*/
//*******************************
//*******************************
#ifdef (SCENE1)
 //*******************************
 #declare CAM_X = -20.424
 #declare CAM_Y = 300 - (myclock * 8)
 #declare CAM_Z = 15.3
 #declare FLY_POS = -300 + (myclock * 8)
 #declare CAM_ANGLE = 36.68
 #declare LOOK_Y = FLY_POS
#end // SCENE1
#ifdef (SCENE3)
 #if (myclock < (ENDS3-8))
  #declare CAM_X = -30.58
  #declare CAM_Y = -14.1 + (myclock * 8)
  #declare CAM_Z = 15.3
  #declare FLY_POS = 7.6 + (myclock * 8)
  #declare CAM_ANGLE = 75.25
  #declare LOOK_Y = FLY_POS
 #end
 #if (myclock >= (ENDS3-8))
  #declare CAM_X = -30.58 - ((myclock-(ENDS3-8))*((130-30.58) / 8))
  #declare CAM_Y = -14.1 + (myclock * 8) - ((myclock-(ENDS3-8)) * ((14.1-6)/8))
  #declare CAM_Z = 15.3 + ((myclock-(ENDS3-8))*((30-15.3)/8))
  #declare FLY_POS = 7.6 + (myclock * 8)
  #declare CAM_ANGLE = 75.25 - ((myclock - (ENDS3-8))* ((75.25-36.68)/8))
  #declare LOOK_Y = FLY_POS - ((myclock - (ENDS3-8)) * (20/8))
 #end
#end // SCENE3
#ifdef (SCENE4)
 #declare CAM_X = -130 + ((myclock-ENDS3) * 5.7778)
 #declare CAM_Y = -6 + ((myclock-ENDS3) * 8)
 #declare CAM_Z = /*-*/30
 #declare FLY_POS = 0 + ((myclock-ENDS3) * 8)
 #declare LOOK_Y = FLY_POS - 20
 #declare CAM_ANGLE = 36.68
#end // SCENE4
#ifdef (SCENE5)
 #declare CAM_X = 130 - ((myclock-ENDS4) * (130/(ENDS5-STARTS5)))
 #declare CAM_Y = -6 + ((myclock-ENDS4) * 8) - ((myclock-ENDS4)*(94/(ENDS5-STARTS5)))
 #declare CAM_Z = 30 - ((myclock-ENDS4)*(20/(ENDS5-STARTS5)))
 #declare FLY_POS = 0 + ((myclock-ENDS4)*8)
 #declare LOOK_Y = FLY_POS -20
 #declare CAM_ANGLE = 36.68
/*
 #declare CAM_X = 0
 #declare CAM_Y = -100 + ((myclock-ENDS4) * 8)
 #declare CAM_Z = 10
 #declare FLY_POS = 0 + ((myclock-ENDS4) * 8)
 #declare LOOK_Y = FLY_POS - 20
 #declare CAM_ANGLE = 36.68
*/
#end // SCENE5
#ifdef (SCENE6)
 #declare CAM_X = 0
 #declare CAM_Y = -100 + ((myclock-ENDS5)*8) + ((myclock-ENDS5) * (160/(ENDS6-STARTS6)))
 #declare CAM_Z = 10
 #declare FLY_POS = 0 + ((myclock-ENDS5) * 8)
 #declare LOOK_Y = FLY_POS - 20
 #declare CAM_ANGLE = 36.68
#end // SCENE6
#ifdef (SCENE7)
 #declare CAM_X = 0
 #declare CAM_Y = 60 + ((myclock-ENDS6) * 8)
 #declare CAM_Z = 10
 #declare FLY_POS = 0 + ((myclock-ENDS6) * 8)
 #declare LOOK_Y = FLY_POS - 20
 #declare CAM_ANGLE = 36.68
 #declare POSZ = 100 -(100 * pow((1-((myclock - ENDS6)/(ENDS7-STARTS7))),.4))
#end // SCENE7
#ifdef (SCENE8)
 #declare CAM_X = 250
 #declare CAM_Y = 0
 #declare CAM_Z = 100 + ((myclock - ENDS7) * 8) -20
 #declare FLY_POS = 0
 #declare LOOK_Y = FLY_POS
 #declare CAM_ANGLE = 36.68
 #declare POSZ = 100 + (myclock - ENDS7) * 8
#end // SCENE8
#ifdef (SCENE9)
 #declare CAM_X = 250-((myclock-ENDS8) * (215/(ENDS9-STARTS9)))
 #declare CAM_Y = 0
 #declare CAM_Z = 100 + ((myclock - ENDS8) * 8) -20 + ((myclock-ENDS8)*(20/(ENDS9-STARTS9)))
 #declare FLY_POS = 0
 #declare LOOK_Y = FLY_POS
 #declare CAM_ANGLE = 36.68
 #declare POSZ = 100 + (myclock - ENDS8) * 8
#end
#ifdef (SCENE10)
 #declare CAM_X = 45 + ((myclock-ENDS9) * (105/(ENDS10-STARTS10)))
 #declare CAM_Y = (myclock-ENDS9)* (50/(ENDS10-STARTS10))
 #declare CAM_Z = 100 + ((myclock-ENDS9) * 8) - ((myclock-ENDS9)*(20/(ENDS10-STARTS10)))
 #declare FLY_POS = 0
 #declare LOOK_Y = FLY_POS - ((myclock-ENDS9) * (20/(ENDS10-STARTS10)))
 #declare CAM_ANGLE = 36.68
 #declare POSZ = 100 + ((myclock-ENDS9) * 8)
#end
#ifdef (SCENE11)
 #declare CAM_X = 150 //45 + ((myclock-ENDS9) * (105/(ENDS10-STARTS10)))
 #declare CAM_Y = 50 //(myclock-ENDS9)* (50/(ENDS10-STARTS10))
 #declare CAM_Z = 100 + ((myclock-ENDS9) * 8) - 20 //((myclock-ENDS9)*(20/(ENDS10-STARTS10)))
 #declare FLY_POS = 0
 #declare LOOK_Y = FLY_POS - 20 //((myclock-ENDS9) * (20/(ENDS10-STARTS10)))
 #declare CAM_ANGLE = 36.68
 #declare POSZ = 100 + ((myclock-ENDS9) * 8)
#end
#ifdef (SCENE12)
 #declare CAM_X = 150 -((myclock-ENDS11) * (50/(ENDS12-STARTS12)))
 #declare CAM_Y = 50 //(myclock-ENDS9)* (50/(ENDS10-STARTS10))
 #declare CAM_Z = 100 + ((myclock-ENDS9) * 8) - 20 + ((myclock-ENDS11)* (10/(ENDS12-STARTS12)))//((myclock-ENDS9)*(20/(ENDS10-STARTS10)))
 #declare FLY_POS = 0
 #declare LOOK_Y = FLY_POS - 20  + ((myclock-ENDS11) * (20/(ENDS12-STARTS12)))
 #declare CAM_ANGLE = 36.68
 #declare POSZ = 100 + ((myclock-ENDS9) * 8)
#end
//*******************************
//*******************************
#ifdef (SCENE1)

//*******************************
 #declare LTHUMBMINUS = -90
 #declare LTHUMBPLUS = 90
 #declare RTHUMBMINUS = -90
 #declare RTHUMBPLUS = 90
 #declare HANDPLUS = 90
 #declare HAND2PLUS = 90
 #declare WRIST = 20
 #declare FOREARM = 0
//*******************************
#end // SCENE1
#ifdef (SCENE3)
//*******************************
 #declare LTHUMBMINUS = -90
 #declare LTHUMBPLUS = 90
 #declare RTHUMBMINUS = -90
 #declare RTHUMBPLUS = 90
 #declare HANDPLUS = 90
 #declare HAND2PLUS = 90
 #declare WRIST = 20
 #declare FOREARM = 0
//*******************************
#end // SCENE3
#ifdef (SCENE4)
 #if (myclock < (STARTS4+15))
  #declare LTHUMBMINUS = -90
  #declare LTHUMBPLUS = 90
  #declare RTHUMBMINUS = -90
  #declare RTHUMBPLUS = 90
  #declare HANDPLUS = 90
  #declare HAND2PLUS = 90
  #declare WRIST = 20
  #declare FOREARM = 0
 #end
 #if (myclock >= (STARTS4+15) & myclock <= (STARTS4+30))
  #declare FOREARM = (myclock - (STARTS4+15)) * (19 / 15)
  #declare LTHUMBMINUS = -90
  #declare LTHUMBPLUS = 90
  #declare RTHUMBMINUS = -90
  #declare RTHUMBPLUS = 90
  #declare HANDPLUS = 90
  #declare HAND2PLUS = 90
  #declare WRIST = 20
 #end
 #if (myclock > (STARTS4+30))
  #declare WRIST = 20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = -90 + HANDANGLE
  #declare LTHUMBPLUS = 90 - HANDANGLE
  #declare RTHUMBMINUS = -90 + HANDANGLE
  #declare RTHUMBPLUS = 90 - HANDANGLE
  #declare HANDPLUS = 90 - HANDANGLE
  #declare HAND2PLUS = 90 - HANDANGLE
  #declare FOREARM = 19
 #end
#end // SCENE4
#ifdef (SCENE5)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 60 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = -60 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 60 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 60 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE5
#ifdef (SCENE6)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = 0 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 0 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 10 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE6
#ifdef (SCENE7)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = 0 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 0 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 10 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE7
#ifdef (SCENE8)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = 0 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 0 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 10 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE8
#ifdef (SCENE9)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = 0 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 0 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 10 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE9
#ifdef (SCENE10)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = -90 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 90 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 90 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE10
#ifdef (SCENE11)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = -90 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 90 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 90 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE11
#ifdef (SCENE12)
  #declare WRIST = 30 //20 + (myclock - (STARTS4+30)) * (10/15)
  #declare HANDANGLE = 90 //90 - (( myclock - (STARTS4+30)) * 6)
  #declare LTHUMBMINUS = -90 // -90 + HANDANGLE
  #declare LTHUMBPLUS = 90 //90 - HANDANGLE
  #declare RTHUMBMINUS = -60 //-90 + HANDANGLE
  #declare RTHUMBPLUS = 60 //90 - HANDANGLE
  #declare HANDPLUS = 60 //90 - HANDANGLE
  #declare HAND2PLUS = 90 //90 - HANDANGLE
  #declare FOREARM = 19
#end // SCENE12
//*******************************
//*******************************
#ifdef (SCENE1)
 #declare LEGY = 50
 #declare MACROTY = 0
#end // SCENE1
#ifdef (SCENE3)
 #declare LEGY = 50
 #declare MACROTY = 0
#end // SCENE3
#ifdef (SCENE4)
 #declare LEGY = 50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = 0 - (myclock - ENDS3) * (360/45)
#end // SCENE4
#ifdef (SCENE5)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = 0 //0 - (myclock - ENDS3) * (360/45)
#end // SCENE5
#ifdef (SCENE6)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = 0 //0 - (myclock - ENDS3) * (360/45)
#end // SCENE6
#ifdef (SCENE7)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = 0 //0 - (myclock - ENDS3) * (360/45)
#end // SCENE7
#ifdef (SCENE8)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = -90 + (myclock - ENDS7) * (720/30)
#end // SCENE8
#ifdef (SCENE9)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = -90 //-90 + (myclock - ENDS7) * (720/30)
#end // SCENE9
#ifdef (SCENE10)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = -90 //-90 + (myclock - ENDS7) * (720/30)
#end // SCENE10
#ifdef (SCENE11)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = -90 //-90 + (myclock - ENDS7) * (720/30)
#end // SCENE11
#ifdef (SCENE12)
 #declare LEGY = 20 //50 - (myclock - ENDS3) * (30/45)
 #declare MACROTY = -90 //-90 + (myclock - ENDS7) * (720/30)
#end // SCENE12

//*******************************
//  COCKPIT
//*******************************
#ifdef (SCENE1)
 #declare COCKPITANGLE = 0
 #declare COCKPITPOS = 0
#end // SCENE1
#ifdef (SCENE3)
 #if (myclock < (STARTS3+15))
  #declare COCKPITANGLE = ((myclock-STARTS3)/15)*10
  #declare COCKPITPOS = 0
 #else
  #declare COCKPITANGLE = 10
  #declare COCKPITPOS = 0 - ((myclock -(STARTS3+15))/15)*10
 #end
#end // SCENE3

#if (myclock > ENDS3)
  #declare COCKPITANGLE = 10
  #declare COCKPITPOS = -10
#end

//*******************************
// tail wing
//*******************************
#if (myclock < STARTS5)
  #declare LTWING = -70
  #declare RTWING = 70
  #declare LTANG = 0
  #declare RTANG = 0
#end

#ifdef (SCENE5)
 #if(myclock > ENDS4)
  #declare LTWING = -70 - ((myclock - STARTS5) * (110 / (ENDS5-5-STARTS5)))
  #declare LTANG = ((myclock - STARTS5) * (10 / (ENDS5-5-STARTS5)))
  #declare RTWING = 70
  #declare RTANG = 0
 #end
 #if(myclock > (STARTS5+5))
  #declare LTWING = -180
  #declare LTANG = 10
  #declare RTWING = 70 + ((myclock - STARTS5) * (109 / (ENDS5-5-STARTS5)))
  #declare RTANG = -((myclock - STARTS5) * (10 / (ENDS5-5-STARTS5)))
 #end
#end // SCENE5

#if (myclock > ENDS5)
  #declare LTWING = -180
  #declare RTWING = 179
  #declare LTANG = 10
  #declare RTANG = -10
#end

//*******************************
//*******************************
#if (myclock <= ENDS6)
 #declare MANGX = 0
 #declare POSZ = 0
#end
#ifdef (SCENE7)
 #declare MANGX = ((myclock - ENDS6) * (90 / (ENDS7-STARTS7)))
// #declare POSZ = ((myclock - ENDS6) * (100 / (ENDS7-STARTS7)))
// #declare POSZ = 100 * pow((1-((myclock - ENDS6)/(ENDS7-STARTS7)),5)
#end // SCENE7

#if (myclock >ENDS7)
 #declare MANGX = 90
#end
//*******************************
//*******************************
#if (myclock <= ENDS7)
  #declare TAILANGLE = 0
  #declare BODYANGLE = 0
#end

#ifdef (SCENE8)
  #declare TAILANGLE = -(myclock - ENDS7) * (170 / (ENDS8-STARTS8))
  #declare BODYANGLE = -(myclock -ENDS7) * (175 / (ENDS8-STARTS8))
#end // SCENE8

#if (myclock >ENDS8)
  #declare TAILANGLE = -170
  #declare BODYANGLE = 175
#end

//*******************************
//*******************************
#if (myclock <= ENDS7)
  #declare SHOULDERLEFT = -90
  #declare SLEFT = 0
  #declare SHOULDERRIGHT = 90
  #declare SRIGHT = 0
  #declare BLWING = 35
  #declare BRWING = -35
  #declare GUNROTX = -180
  #declare GUNROTY = 0
  #declare GUNROTZ = 90
  #declare GUNLAT = -17.755951
  #declare LFARMROT = 90
  #declare RFARMROT = -90
  #declare SPADLEFT = 0.0
  #declare SPADRIGHT = 0.0
#end

#ifdef (SCENE8)
  #declare SHOULDERLEFT = -90 + (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SLEFT = -(myclock -ENDS7) * (12/(ENDS8-STARTS8))
  #declare SHOULDERRIGHT = 90 - (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SRIGHT = (myclock -ENDS7) * (12/(ENDS8-STARTS8))
  #declare BLWING = 35 + (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare BRWING = -35 - (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare GUNROTX = -180
  #declare GUNROTY = 180
  #declare GUNROTZ = 90
  #declare GUNLAT = 45
  #declare LFARMROT = 90 - (myclock -ENDS7) * (90/(ENDS8-STARTS8))
  #declare RFARMROT = -180 + (myclock -ENDS7) * (90/(ENDS8-STARTS8))
  #declare SPADLEFT = (myclock - ENDS7) * (10/ (ENDS8-STARTS8))
  #declare SPADRIGHT = (myclock - ENDS7) * (10/ (ENDS8-STARTS8))
#end // SCENE8
#ifdef (SCENE9)
  #declare SHOULDERLEFT = 0 //-90 + (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SLEFT = -12 //-(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare SHOULDERRIGHT = 0 //90 - (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SRIGHT = 12 //(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare BLWING = 90 //35 + (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare BRWING = -90 //-35 - (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare GUNROTX = -180
  #declare GUNROTY = 180
  #declare GUNROTZ = 90
  #declare GUNLAT = 45
  #declare LFARMROT = 0 //90 - (myclock -ENDS7) * (90/(ENDS8-STARTS8))
  #declare RFARMROT = -90 //-180 + (myclock -ENDS7) * (90/(ENDS8-STARTS8))
  #declare SPADLEFT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare SPADRIGHT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
#end // SCENE9
#if (myclock <= ENDS9)
  #declare LFARMROTX = 0
  #declare LFARMROTZ = 0
  #declare RFARMROTX = 0
  #declare RFARMROTZ = 0
  #declare GUNHOR = -8.92208
  #declare GUNVERT = 5.0
#end
#ifdef (SCENE10)
  #declare SHOULDERLEFT = 0 //-90 + (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SLEFT = -12 //-(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare SHOULDERRIGHT = 0 //90 - (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SRIGHT = 12 //(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare BLWING = 90 //35 + (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare BRWING = -90 //-35 - (myclock - ENDS7) * (55/(ENDS8-STARTS8))
/*
  #declare GUNROTX = -180
  #declare GUNROTY = 180
  #declare GUNROTZ = 90
  #declare GUNLAT = 45
*/
  #declare GUNROTX = 0
  #declare GUNROTY = 0
  #declare GUNROTZ = 90
  #declare GUNLAT = 43
  #declare GUNVERT = 0
  #declare GUNHOR = 12
//  rotate <179.373352, -3.635296, 15.918475>
  #declare LUAX = 180 // - ((myclock-ENDS9)* (1/(ENDS10-STARTS10)))
  #declare LUAY =  0 //-((myclock-ENDS9) * (3.635296/(ENDS10-STARTS10)))
  #declare LUAZ = 0 //(myclock-ENDS9)* (15.918475/(ENDS10-STARTS10))
  #declare LFARMROT = 0
  #declare LFARMROTX = (myclock - ENDS9) * (90/(ENDS10-STARTS10))
  #declare LFARMROTZ = 0 // -(myclock - ENDS9) * (22.76/(ENDS10-STARTS10))
/*
  #declare LFARMROT = 0 //90 - (myclock -ENDS7) * (90/(ENDS8-STARTS8))
  #declare LFARMROTX = (myclock - ENDS9) * (25/(ENDS10-STARTS10))
  #declare LFARMROTZ =  -(myclock - ENDS9) * (22.76/(ENDS10-STARTS10))
*/
  #declare SPADLEFT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare SPADRIGHT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare RFARMROTX = 0
  #declare RFARMROTZ = 0
  #declare RFARMROT = 0
  #declare RUAROT = -(myclock - ENDS9) * (20/(ENDS10-STARTS10))
  #declare HEADZ = -(myclock -ENDS9) * (20/(ENDS10-STARTS10))
#end // SCENE10
#ifdef (SCENE11)
  #declare SHOULDERLEFT = 0 //-90 + (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SLEFT = -12 //-(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare SHOULDERRIGHT = 0 //90 - (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SRIGHT = 12 //(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare BLWING = 90 //35 + (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare BRWING = -90 //-35 - (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare GUNROTX = 0
  #declare GUNROTY = 0
  #declare GUNROTZ = 90
  #declare GUNLAT = 43
  #declare GUNVERT = 0
  #declare GUNHOR = 12
  #declare LUAX = 180 // - ((myclock-ENDS9)* (1/(ENDS10-STARTS10)))
  #declare LUAY =  0 //-((myclock-ENDS9) * (3.635296/(ENDS10-STARTS10)))
  #declare LUAZ = 0 //(myclock-ENDS9)* (15.918475/(ENDS10-STARTS10))
  #declare LFARMROT = 0
  #declare LFARMROTX = 90 //(myclock - ENDS9) * (90/(ENDS10-STARTS10))
  #declare LFARMROTZ = 0 // -(myclock - ENDS9) * (22.76/(ENDS10-STARTS10))
  #declare SPADLEFT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare SPADRIGHT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare RFARMROTX = 0
  #declare RFARMROTZ = 0
  #declare RFARMROT = 0
  #declare RUAROT = -20 + ((myclock - ENDS10) * (20/(ENDS11-STARTS11)))
  #declare HEADZ = -20 + ((myclock -ENDS10) * (20/(ENDS11-STARTS11)))
#end // SCENE11
#ifdef (SCENE12)
  #declare SHOULDERLEFT = 0 //-90 + (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SLEFT = -12 //-(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare SHOULDERRIGHT = 0 //90 - (myclock - ENDS7) * (90/(ENDS8-STARTS8))
  #declare SRIGHT = 12 //(myclock -ENDS7) * (13/(ENDS8-STARTS8))
  #declare BLWING = 90 //35 + (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare BRWING = -90 //-35 - (myclock - ENDS7) * (55/(ENDS8-STARTS8))
  #declare GUNROTX = 0
  #declare GUNROTY = 0
  #declare GUNROTZ = 90
  #declare GUNLAT = 43
  #declare GUNVERT = 0
  #declare GUNHOR = 12
  #declare LUAX = 180 // - ((myclock-ENDS9)* (1/(ENDS10-STARTS10)))
  #declare LUAY =  0 //-((myclock-ENDS9) * (3.635296/(ENDS10-STARTS10)))
  #declare LUAZ = 0 //(myclock-ENDS9)* (15.918475/(ENDS10-STARTS10))
  #declare LFARMROT = 0
  #declare LFARMROTX = 90 - ((myclock - ENDS11) * (90/(ENDS12-STARTS12)))
  #declare LFARMROTZ = 0 // -(myclock - ENDS9) * (22.76/(ENDS10-STARTS10))
  #declare SPADLEFT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare SPADRIGHT = 10 //(myclock - ENDS7) * (20/ (ENDS8-STARTS8))
  #declare RFARMROTX = 0
  #declare RFARMROTZ = 0
  #declare RFARMROT = 0
  #declare RUAROT = 0 //-20 + ((myclock - ENDS9) * (20/(ENDS10-STARTS10)))
  #declare HEADZ = ((myclock -ENDS11) * (20/(ENDS12-STARTS12)))
#end // SCENE12

#if (myclock <= ENDS9)
  #declare HEADZ = 0
  #declare LUAX = 180
  #declare LUAY = 0
  #declare LUAZ = 0
  #declare RUAROT = 0
  #declare SRROTX = -180
#end
//*******************************
//*******************************
#if (myclock <= ENDS8)
 #declare HEADANGLE = 0
 #declare EARANGLE = -103.209747
#end
#ifdef (SCENE9)
 #declare HEADANGLE = -(myclock-ENDS8)*(180/(ENDS9-STARTS9))
 #declare EARANGLE = -103.209747 +(myclock-ENDS8) *(103.209747/(ENDS9-STARTS9))
#end
#if (myclock > ENDS9)
 #declare HEADANGLE = -180
 #declare EARANGLE = 0
#end

//*******************************
//*******************************
#ifdef (SCENE10)
  #declare SRROTX = -180 + ((myclock-ENDS9)*(90/(ENDS10-STARTS10)))
//  #declare SRROTX = -90
#end // SCENE10
#ifdef (SCENE11)
 #declare SRROTX = -90
#end
#ifdef (SCENE12)
 #declare SRROTX = -90 - ((myclock-ENDS11)*(90/(ENDS12-STARTS12)))
//  #declare SRROTX = -180
#end
//*******************************
//*******************************

global_settings {
  adc_bailout 0.003922
  ambient_light <1.0,1.0,1.0>
  assumed_gamma 1.8
  hf_gray_16 off
  irid_wavelength <0.25,0.18,0.14>
  max_intersections 64
  max_trace_level 10
  number_of_waves 10
  radiosity {
    brightness       3.3
    count            100
    distance_maximum 0.0
    error_bound      0.4
    gray_threshold   0.5
    low_error_factor 0.8
    minimum_reuse    0.015
    nearest_count    6
    recursion_limit  1
  }
}

background { color <0.000,0.000,0.000> }


camera {  //  Camera Camera01
  //location  <-20.424, 26.526+ CAM_Y, 15.300>
  location  <CAM_X, CAM_Y, CAM_Z>
  direction <0.0,     0.0,  2.1298>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333, 0.0,  0.0>
  //look_at   <0.993, -6.257, -0.088>
  #if (myclock <= ENDS7)
    look_at   <0, LOOK_Y, 0>
  #else
    look_at <0, LOOK_Y, CAM_Z>
  #end
  //look_at <0,-5, 0>
  #ifdef (SCENE3)
  angle CAM_ANGLE
  #end // SCENE3
}

// *******  L I G H T S *******
light_source { // AreaL001
  <-0.019, -4.056, 1.645>
  color  rgb<-0.290, 1.710, 0.000>
  area_light <-2.688, 0.000, 0.000>, <0.000, -1.742, 0.000>, 3, 3
  adaptive 1
  //jitter
  fade_distance  0.01
  fade_power 10.0
}


light_source {   // Light5
  <5752.235, 4968.996, 8907.802>
  color rgb <2.008, 2.008, 2.008>
}


// ********  TEXTURES  *******
//

#include "macross.inc"



// ********  REFERENCED OBJECTS  *******



// ********  OBJECTS  *******

  sky_sphere {
    pigment {
      gradient y
      color_map {
      /*
        [0.000 0.002 color rgb <0.2, 1.0, 0.0>
                     color rgb <0.0, 0.2, 1.0>]
        [0.002 0.200 color rgb <0.3, 0.9, 0.9>
                     color rgb <0.2, 0.2, 0.3>]
      */
        [0 color rgb <0.36,0.12,1>]
        [1 color rgb <0.19,0.68,1>]
      }
      scale 2
      translate -1
    }
    pigment {
      bozo
      turbulence 0.65
      octaves 6
      omega 0.7
      lambda 2
      color_map {
          [0.0 0.1 color rgb <0.85, 0.85, 0.85>
                   color rgb <0.75, 0.75, 0.75>]
          [0.1 0.5 color rgb <0.75, 0.75, 0.75>
                   color rgbt <1, 1, 1, 1>]
          [0.5 1.0 color rgbt <1, 1, 1, 1>
                   color rgbt <1, 1, 1, 1>]
      }
      scale <0.2, 0.5, 0.2>
    }
    rotate -135*x
  }

 /*
sphere { // mysky
  <0,0,0>,1
  texture {
    Blue_Sky4
  }
  scale 1000000.0
  hollow
}
*/

#declare RotSwp005 = lathe {
  linear_spline
  2  // control points
  <3.0, 12.0>,
  <3.3, 15.0>
  rotate <90,0,90>
  texture {
    body_white1
  }
  rotate -94.457359*x
  translate  <0.0, -31.160135, -0.192518>
}
//
// Include file contains 'RotSwp007'
//
#include "macross.in1"
#declare RotSwp007 = object {
  RotSwp007_Raw
  texture {
    cockpit_glass
  }
  scale <1.5, 1.2, 1.01>
  rotate -99.006065*x
  translate  <0.0, -30.979303, 2.855799>
}
//
// Include file contains 'RotSwp006'
//
#include "macross.in2"
#declare RotSwp006 = object {
  RotSwp006_Raw
  texture {
    body_white1
  }
  rotate -97.533653*x
  translate  <0.0, -0.459613, -3.461831>
}
#declare cockpit = union {
  object { RotSwp005 }
  object { RotSwp007 }
  object { RotSwp006 }
  rotate COCKPITANGLE*x
  translate  <0.0, 31.0, 4.4>
}
#declare TraSwp004 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-3.863449, 18.885517>,
  <-3.300185, 15.001484>,
  <3.30144, 15.000684>,
  <3.874549, 18.706295>,
  <4.01479, 22.993342>,
  <3.859074, 27.040458>,
  <3.499418, 30.997198>,
  <-3.504048, 30.995118>,
  <-3.925456, 26.769811>,
  <-3.99701, 23.025694>,
  <-3.863449, 18.885517>
  rotate -x*90
  texture {
    body_white1
  }
  scale <1.0, 1.0, 3.0>
  rotate -7.657374*x
  translate  <0.0, -0.505152, 2.144329>
}
// Include contains 'TraSwp003'
#include "macross.in3"

#declare TraSwp003 = object {
  TraSwp003_Raw
  texture {
    body_white1
  }
  scale <1.0, 1.0, 3.5>
  translate  -2.5*z
}
//
// Include file contains 'RotSwp008'
//
#include "macross.in4"
#declare RotSwp008 = object {
  RotSwp008_Raw
  texture {
    body_white1
  }
  rotate -93.0*x
  translate  2.5*z
}
//
// Include file contains 'RotSwp10'
//
#include "macross.in5"
#declare RotSwp10 = object {
  RotSwp10_Raw
  rotate -90.0*x
  translate  2.5*x
}
//
// Include file contains 'RotSwp009'
//
#include "macross.in6"
#declare RotSwp009 = object {
  RotSwp009_Raw
  rotate -90.0*x
  translate  -2.5*x
}
#declare torso = union {
  object { cockpit }
  object { TraSwp004 }
  object { TraSwp003 }
  object { RotSwp008 }
  object { RotSwp10 }
  object { RotSwp009 }
  texture {
    body_white1
  }
  translate COCKPITPOS*y
}
#declare TraSwp001 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  11  // control points
  <-15.0, 0.0>,
  <-5.0, 0.0>,
  <-3.5, 3.5>,
  <3.5, 3.5>,
  <5.0, 0.0>,
  <15.0, 0.0>,
  <12.0, 12.0>,
  <4.0, 18.0>,
  <-4.0, 18.0>,
  <-12.0, 12.0>,
  <-15.0, 0.0>
  rotate -x*90
  texture {
    body_white1
    scale <30.0, 18.0, 1.0>
    rotate -180.0*z
  translate <15.000000, 18.000000, 0.000000>
  }
  scale <1.0, 1.0, 4.0>
}
#declare CSG002 = union {
  box { // Cube003
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate -7.278104*y
    translate  <-7.952286, 8.838948, 4.0>
  }
  box { // Cube4
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate 7.278104*y
    translate  <7.952286, 8.838948, 4.0>
  }
  box { // Cube002
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 10.0, 1.0>
    rotate -4.790166*x
    translate  <0.0, 8.131006, 4.331022>
  }
  texture {
    chest_decal
    scale <34.0, 24.0, 1.0>
  translate <-17.000000, 0.000000, 0.000000>
  }
}
#declare chestplate = difference {
  object { TraSwp001 }
  box { // Cube2
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 3.0>
    rotate <45.0, 0.0, -36.700001>
    translate  <7.600833, 13.985828, 3.181811>
  }
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 3.0>
    rotate <45.0, 0.0, 36.700001>
    translate  <-7.600833, 13.985828, 3.181811>
  }
  superellipsoid { // SuprQ2
    <0.0001, 0.2>
    texture {
      intake_black
    }
    scale <3.75, 5.0, 0.75>
    rotate -14.0*z
    translate  <7.2, 12.0, 1.25>
  }
  superellipsoid { // SuprQ001
    <0.0001, 0.2>
    texture {
      intake_black
    }
    scale <3.75, 5.0, 0.75>
    rotate 14.0*z
    translate  <-7.2, 12.0, 1.25>
  }
  box { // Cube004
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 7.0, 3.0>
    rotate <0.0, 30.0, -13.954773>
    translate  <-12.834109, 6.084172, 3.094577>
  }
  box { // Cube5
    <-1, -1, -1>, <1, 1, 1>
    texture {
      wakibara_decal
      scale <2.081505, 2.001753, 6.980876>
      rotate <-90.0, -180.0, 90.0>
  translate <0.042210, 0.859655, -1.445363>
    }
    scale <1.0, 7.0, 3.0>
    rotate <0.0, -30.0, 13.954773>
    translate  <12.834109, 6.084172, 3.094577>
  }
  object { CSG002 }
  texture {
    chest_decal
    scale <30.0, 18.0, 1.0>
  translate <-15.000000, 0.000000, 0.000000>
  }
}
//
// Include file contains 'RotSwp003'
//
#include "macross.in7"
#declare RotSwp003 = object {
  RotSwp003_Raw
  texture {
    chest_decal
    scale <34.0, 24.0, 1.0>
    rotate 90.0*x
  translate <-17.000000, 0.000000, 0.000000>
  }
  rotate -90.0*x
  translate  3.3*z
}
#declare TraSwp006 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-3.3, 0.0>,
  <2.5, 0.0>,
  <2.5, 1.0>,
  <-2.5, 1.0>,
  <-2.5, 14.0>,
  <2.5, 14.0>,
  <2.5, 1.0>,
  <-2.5, 1.0>,
  <-2.5, 0.0>,
  <3.3, 0.0>,
  <3.3, 15.3>,
  <-3.3, 15.3>,
  <-3.3, 0.0>
  rotate -x*90
  scale <1.0, 1.0, 3.0>
  translate  -2.5*z
}
#declare TraSwp6 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-15.0, -0.024771>,
  <-10.0, -0.024771>,
  <-10.0, 19.0>,
  <-15.0, -0.024771>
  rotate -x*90
  scale <1.0, 1.0, 2.0>
  rotate <180.0, 0.0, 180.0>
}
#declare TraSwp005 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  4  // control points
  <-15.0, -0.024771>,
  <-10.0, -0.024771>,
  <-10.0, 19.0>,
  <-15.0, -0.024771>
  rotate -x*90
  scale <1.0, 1.0, 2.0>
  translate  -2.0*z
}
#declare CSG001 = union {
  object { TraSwp6 }
  object { TraSwp005 }
}
#declare CSG003 = difference {
  object { CSG001 }
  cylinder { // Cylndr001
    <0,0,1>, <0,0,0>, 1
    scale <1.8, 12.0, 30.0>
    rotate -90.0*y
    translate  <15.0, 19.0, -2.0>
  }
  texture {
    body_white1
  }
}
#declare chest = union {
  object { chestplate }
  object { RotSwp003 }
  object { TraSwp006 }
  object { CSG003 }
  texture {
    body_white1
  }
}
#declare body = union {
  object { torso }
  object { chest }
  rotate BODYANGLE*x
}
#declare TraSwp007 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  13  // control points
  <-5.0, -14.5>,
  <5.0, -14.5>,
  <5.0, 0.0>,
  <3.0, 0.0>,
  <2.75, -1.0>,
  <2.25, -1.0>,
  <2.0, 0.0>,
  <-2.0, 0.0>,
  <-2.25, -1.0>,
  <-2.75, -1.0>,
  <-3.0, 0.0>,
  <-5.0, 0.0>,
  <-5.0, -14.5>
  rotate -x*90
  texture {
    body_white1
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  1.0*y
}
#declare TraSwp8 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-3.5, -14.5>,
  <3.5, -14.5>,
  <5.0, -7.5>,
  <5.0, 0.0>,
  <-5.0, 0.0>,
  <-5.0, -7.5>,
  <-3.5, -14.5>
  rotate -x*90
  texture {
    body_white1
  }
  scale <1.0, 1.0, 0.5>
  rotate <180.0, 0.0, 180.0>
  translate  -13.5*y
}
//
// Include file contains 'RotSwp13'
//
#include "macross.in8"
#declare RotSwp13 = object {
  RotSwp13_Raw
  rotate <-90.0, 0.0, 0.0>
  translate  <-2.5, -4.0, 0.0>
}
//
// Include file contains 'RotSwp12'
//
#include "macross.in9"
#declare RotSwp12 = object {
  RotSwp12_Raw
  rotate <-90.0, 0.0, 0.0>
  translate  <2.5, -4.0, 0.0>
}
//
// Include file contains 'RotSwp11'
//
#include "macross.i10"
#declare RotSwp11 = object {
  RotSwp11_Raw
  rotate -90.0*x
  translate  <-2.5, -28.0, -0.3>
}
//
// Include file contains 'RotSwp010'
//
#include "macross.i11"
#declare RotSwp010 = object {
  RotSwp010_Raw
  rotate -90.0*x
  translate  <2.5, -28.0, -0.3>
}
#declare TraSwp14 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.0, 0.0>,
  <0.0, -18.0>,
  <-7.0, -23.0>,
  <-16.0, -26.0>,
  <-16.0, -20.0>,
  <0.0, 0.0>
  rotate -x*90
  texture {
    tailwing_decal
    scale <26.0, 16.0, 1.0>
    rotate <-180.0, 0.0, -90.0>
  }
  scale <1.0, 1.0, 0.3>
  //rotate <0.0, 70.0, 0.0>
  rotate RTWING * y
  rotate RTANG*z
  //translate  <-4.7, 0.0, -0.3>
  translate  <-4.7, 0.0, 0>
}
#declare TraSwp009 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  6  // control points
  <0.0, 0.0>,
  <0.0, -18.0>,
  <7.0, -23.0>,
  <16.0, -26.0>,
  <16.0, -20.0>,
  <0.0, 0.0>
  rotate -x*90
  texture {
    tailwing_decal
    scale <26.0, 16.0, 1.0>
    rotate -90.0*z
  }
  scale <1.0, 1.0, 0.3>
  //rotate <0.0, -70.0, 0.0>
  rotate LTWING * y
  rotate LTANG*z
  //translate  <4.7, 0.0, -0.3>
  translate  <4.7, 0.0, 0>
}
#declare tail = union {
  object { TraSwp007 }
  object { TraSwp8 }
  object { RotSwp13 }
  object { RotSwp12 }
  object { RotSwp11 }
  object { RotSwp010 }
  object { TraSwp14 }
  object { TraSwp009 }
  texture {
    body_white1
  }
  rotate TAILANGLE*x
  translate  <0.0, -15.0, 2.8>
}
#declare TraSwp2 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  19  // control points
  <-15.0, 0.0>,
  <-5.0, 0.0>,
  <-3.0, 8.5>,
  <3.0, 8.5>,
  <5.0, 0.0>,
  <15.0, 0.0>,
  <12.0, 10.0>,
  <5.0, 14.0>,
  <3.0, 14.0>,
  <2.75, 15.0>,
  <2.25, 15.0>,
  <2.0, 14.0>,
  <-2.0, 14.0>,
  <-2.25, 15.0>,
  <-2.75, 15.0>,
  <-3.0, 14.0>,
  <-5.0, 14.0>,
  <-12.0, 10.0>,
  <-15.0, 0.0>
  rotate -x*90
  texture {
    body_white1
    scale <30.0, 18.0, 1.0>
    rotate -180.0*z
  translate <15.000000, 18.000000, 0.000000>
  }
  scale <1.0, 1.0, 2.5>
  translate  1.5*z
}
#declare CSG3 = union {
  box { // Cube9
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate -7.278104*y
    translate  <-7.952286, 8.838948, 4.0>
  }
  box { // Cube10
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate 7.278104*y
    translate  <7.952286, 8.838948, 4.0>
  }
  box { // Cube11
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 10.0, 1.0>
    rotate -4.790166*x
    translate  <0.0, 8.131006, 4.331022>
  }
  texture {
    back_decal
    scale <40.0, 20.0, 1.0>
    rotate -180.0*z
  translate <20.000000, 20.000000, 0.000000>
  }
}
#declare backplate = difference {
  object { TraSwp2 }
  box { // Cube3
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 3.0>
    rotate <45.17947, 2.610948, -28.837072>
    translate  <7.600833, 13.985828, 3.181811>
  }
  box { // Cube6
    <-1, -1, -1>, <1, 1, 1>
    scale <10.0, 1.5, 3.0>
    rotate <45.143478, -2.335835, 29.670996>
    translate  <-7.600833, 13.985828, 3.181811>
  }
  box { // Cube7
    <-1, -1, -1>, <1, 1, 1>
    scale <1.0, 7.0, 3.0>
    rotate <0.0, 30.0, -16.0>
    translate  <-12.834109, 5.132, 3.094577>
  }
  box { // Cube8
    <-1, -1, -1>, <1, 1, 1>
    texture {
      body_white1
      scale <2.081505, 2.001753, 6.980876>
      rotate <-90.0, -180.0, 90.0>
  translate <0.042210, 0.859655, -1.445363>
    }
    scale <1.0, 7.0, 3.0>
    rotate <0.0, -30.0, 16.0>
    translate  <12.834109, 5.132819, 3.094577>
  }
  object { CSG3 }
  texture {
    body_white1
    scale <30.0, 18.0, 1.0>
  translate <-15.000000, 0.000000, 0.000000>
  }
  rotate <0.0, 0.0, 180.0>
}
//
// Include file contains 'RotSwp001'
//
#include "macross.i12"
#declare RotSwp001 = object {
  RotSwp001_Raw
  rotate -90.0*x
  translate  8.5*y
}
//
// Include file contains 'RotSwp002'
//
#include "macross.i13"
#declare RotSwp002 = object {
  RotSwp002_Raw
  rotate -90.0*x
  translate  <0.0, 10.127075, 1.934936>
}
//
// Include file contains 'RotSwp3'
//
#include "macross.i14"
#declare RotSwp3 = object {
  RotSwp3_Raw
  rotate -90.0*x
  translate  <0.0, 4.184715, 1.368997>
}
#declare TraSwp002 = prism {
  linear_sweep
  linear_spline
  -2.0,0.0
  7  // control points
  <-3.0, -8.5>,
  <3.0, -8.5>,
  <5.0, 0.0>,
  <3.5, 3.5>,
  <-3.5, 3.5>,
  <-5.0, 0.0>,
  <-3.0, -8.5>
  rotate -x*90
  translate  2.0*z
}
#declare CSG4 = union {
  box { // Cube12
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate -7.278104*y
    translate  <-7.952286, 8.838948, 4.0>
  }
  box { // Cube13
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate 7.278104*y
    translate  <7.952286, 8.838948, 4.0>
  }
  box { // Cube14
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 10.0, 1.0>
    rotate -4.790166*x
    translate  <0.0, 8.131006, 4.331022>
  }
  rotate <0.0, 0.0, 180.0>
}
#declare CSG5 = union {
  box { // Cube15
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate -7.278104*y
    translate  <-7.952286, 8.838948, 4.0>
  }
  box { // Cube16
    <-1, -1, -1>, <1, 1, 1>
    scale <8.0, 10.0, 1.0>
    rotate 7.278104*y
    translate  <7.952286, 8.838948, 4.0>
  }
  box { // Cube17
    <-1, -1, -1>, <1, 1, 1>
    scale <15.0, 10.0, 1.0>
    rotate -4.790166*x
    translate  <0.0, 8.131006, 4.331022>
  }
}
#declare csg002 = difference {
  object { TraSwp002 }
  object { CSG4 }
  object { CSG5 }
  texture {
    body_white1
  }
  translate  <0.0, 8.5, -3.3>
}
#declare headcover = union {
  object { RotSwp001 }
  object { RotSwp002 }
  object { RotSwp3 }
  object { csg002 }
  texture {
    body_white1
  }
  translate  <0.0, -8.5, 3.3>
}
//
// Include file contains 'RotSwp5'
//
#include "macross.i15"
#declare RotSwp5 = object {
  RotSwp5_Raw
  texture {
    body_white1
  }
  rotate -90.0*x
  translate  <-8.0, 0.0, 3.0>
}
//
// Include file contains 'RotSwp004'
//
#include "macross.i16"
#declare RotSwp004 = object {
  RotSwp004_Raw
  texture {
    body_white1
  }
  rotate -90.0*x
  translate  <8.0, 0.0, 3.0>
}
// Include contains 'TraSwp11'
#include "macross.i17"

#declare TraSwp11 = object {
  TraSwp11_Raw
  scale <1.0, 1.0, 0.25>
  rotate <180.0, 0.0, 180.0>
  translate  0.25*z
}
// Include contains 'TraSwp12'
#include "macross.i18"

#declare TraSwp12 = object {
  TraSwp12_Raw
  scale <1.0, 1.0, 0.25>
  rotate <179.33197, 0.0, 180.0>
  translate  0.25*z
}
// Include contains 'TraSwp13'
#include "macross.i19"

#declare TraSwp13 = object {
  TraSwp13_Raw
  scale <1.0, 1.0, 0.25>
  rotate <178.402618, 0.0, 180.0>
  translate  0.25*z
}
#declare rightwing = union {
  object { TraSwp11 }
  object { TraSwp12 }
  object { TraSwp13 }
  texture {
    wing_decal
    scale <45.0, 16.0, 1.0>
    rotate <-180.0, 0.0, -180.0>
  translate <45.000000, 0.000000, 0.000000>
  }
  //rotate -35.0*z
  rotate BRWING*z
  translate  <0.0, -9.0, -1.0>
}
// Include contains 'TraSwp008'
#include "macross.i20"

#declare TraSwp008 = object {
  TraSwp008_Raw
  scale <1.0, 1.0, 0.25>
}
// Include contains 'TraSwp9'
#include "macross.i21"

#declare TraSwp9 = object {
  TraSwp9_Raw
  scale <1.0, 1.0, 0.25>
  rotate 0.706379*x
}
// Include contains 'TraSwp10'
#include "macross.i22"

#declare TraSwp10 = object {
  TraSwp10_Raw
  scale <1.0, 1.0, 0.25>
  rotate 1.616275*x
}
#declare leftwing = union {
  object { TraSwp008 }
  object { TraSwp9 }
  object { TraSwp10 }
  texture {
    wing_decal
    scale <45.0, 16.0, 1.0>
  translate <-45.000000, 0.000000, 0.000000>
  }
  //rotate 35.0*z
  rotate BLWING * z
  translate  <0.0, -9.0, -1.0>
}
#declare back = union {
  object { backplate }
  object { headcover }
  object { RotSwp5 }
  object { RotSwp004 }
  object { rightwing }
  object { leftwing }
  texture {
    body_white1
  }
}
// Include contains 'leftfrontlower'
#include "macross.i23"

#declare leftfrontlower = object {
  leftfrontlower_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  <-5.5, -10.0, 0.0>
}

#declare leftfrontjet = object {
  box
  {
    <-1, -1, -1>  // one corner position <X1 Y1 Z1>
    < 1,  1,  1>  // other corner position <X2 Y2 Z2>
    pigment{ color rgbt<1,1,1,1>}
    halo{
       emitting
       cylindrical_mapping
       //box_mapping
       linear
       max_value .6
      turbulence JET_TURB
//      color_map {JETCOLOR}
      color_map {
        [ 0.0 color rgbt <.7, 0, 0,  1> ]
        [ 0.15 color rgbt <1,0,0, 0> ]
        [ 0.20 color rgbt <1,.5,0, 0> ]
        [ 0.3 color rgbt <1, .5, 0, 0> ]
        [ 0.35 color rgbt <1, 1, 0, 1> ]
        [ 0.6 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <1, 1, 1,  0> ]
      }
      rotate 90*z
      //rotate 90*y
      scale 1
    }
   hollow
   //scale <1.8, 3.5, 4.5>
   scale < 2.5,10,2.5>
   translate  <-7.5, -25, FRONT_JET>
  }
}

#declare leftfrontwjet = union {
 object{ leftfrontlower }
 object{ leftfrontjet}
}


// Include contains 'leftfrontupper'
#include "macross.i24"

#declare leftfrontupper = object {
  leftfrontupper_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  -5.5*x
}
#declare leftfootfront = union {
  //object { leftfrontlower }
  object { leftfrontwjet }
  object { leftfrontupper }
  translate  <0.0, -82.0, -3.5>
}
// Include contains 'leftbackupper'
#include "macross.i25"

#declare leftbackupper = object {
  leftbackupper_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  -5.5*x
}
// Include contains 'leftbacklower'
#include "macross.i26"

#declare leftbacklower = object {
  leftbacklower_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  <-5.5, -10.0, 0.0>
}

#declare leftbackjet = object {
  box
  {
    <-1, -1, -1>  // one corner position <X1 Y1 Z1>
    < 1,  1,  1>  // other corner position <X2 Y2 Z2>
    pigment{ color rgbt<1,1,1,1>}
    halo{
       emitting
       cylindrical_mapping
       //box_mapping
       linear
       max_value .6
      turbulence JET_TURB
      color_map {JETCOLOR}
/*
      color_map {
        [ 0.0 color rgbt <0, 0, .7,  .7> ]
        [ 0.15 color rgbt <0,0,1, 0> ]
        [ 0.20 color rgbt <0,.5,1, 0> ]
        [ 0.3 color rgbt <0, .5, 1, 0> ]
        [ 0.35 color rgbt <1, 1, 0, -1> ]
        [ 0.6 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <1, 1, 1,  0> ]
      }
*/
      rotate 90*z
      //rotate 90*y
      //scale 1.3
      scale 1
    }
   hollow
   //scale <1.8, 3.5, 4.5>
   scale < 2.5,10,2.5>
   translate  <-7.5, -25, BACK_JET>
  }
}

#declare leftbackwjet = union {
 object{ leftbacklower }
 object{ leftbackjet}
}

#declare leftfootback = union {
  object { leftbackupper }
  //object { leftbacklower }
  object { leftbackwjet }
  translate  <0.0, -82.0, 0.8>
}
// Include contains 'TraSwp15'
#include "macross.i27"

#declare TraSwp15 = object {
  TraSwp15_Raw
  texture {
    calf_decal
    scale <5.962307, 2.478624, 1.0>
    rotate <0.0, 0.0, -90.0>
  translate <-0.729610, -1.535975, 0.000000>
  }
  scale <3.725184, 5.671744, 3.0>
  rotate -90.0*y
  translate  <-8.85, 12.944886, 0.432374>
}
// Include contains 'TraSwp7'
#include "macross.i28"

#declare TraSwp7 = object {
  TraSwp7_Raw
  texture {
    body_white
  }
  scale <3.725184, 5.671744, 3.0>
  rotate -90.0*y
  translate  <-3.75, 12.944886, 0.432374>
}
// Include contains 'TraSwp16'
#include "macross.i29"

#declare TraSwp16 = object {
  TraSwp16_Raw
  texture {
    body_white
  }
  scale <1.0, 1.0, 5.1>
  rotate -90.0*y
  translate  <-5.25, 6.56, 2.4>
}
// Include contains 'TraSwp17'
#include "macross.i30"

#declare TraSwp17 = object {
  TraSwp17_Raw
  texture {
    legwing_decal
    scale <3.950024, 14.041623, 18.031971>
  translate <-7.492476, -55.420681, -43.257832>
  }
  scale <1.0, 1.0, 0.1>
  rotate -60.0*y
  translate  <-6.986716, 32.56, 4.616316>
}
#declare csg7 = union {
  object { TraSwp15 }
  object { TraSwp7 }
  object { TraSwp16 }
  object { TraSwp17 }
  translate  <0.0, -32.56, -5.6>
}
#declare leftlowerleg = difference {
  object { csg7 }
  box { // Cube24
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.3, 5.0, 5.5>
    translate  <-7.8, -58.1, -3.3>
  }
  translate  -30.0*y
}
// Include contains 'TraSwp3'
#include "macross.i31"

#declare TraSwp3 = object {
  TraSwp3_Raw
  texture {
    body_white
  }
  scale <1.0, 2.5, 7.8>
  translate  <-7.8225, -17.0, -8.0>
}
#declare TraSwp4 = prism {
  linear_sweep
  linear_spline
  -9.0,0.0
  7  // control points
  <14.001433, -8.401631>,
  <13.998231, -7.998185>,
  <12.997847, -6.000544>,
  <2.999736, -0.50055>,
  <-0.412573, -0.500379>,
  <-0.400447, -8.39895>,
  <14.001433, -8.401631>
  rotate -x*90
  rotate <90.0, 0.0, -90.0>
  translate  4.5*x
}
#declare CSG2 = difference {
  box { // Cube18
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 7.25, 4.0>
    translate  <0.0, -10.0, -4.0>
  }
  object { TraSwp4 }
  box { // Cube19
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.0, 7.0, 0.5>
    translate  <0.5, -8.0, -1.25>
  }
  box { // Cube20
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.05, 6.0, 0.5>
    translate  <0.45, -9.0, -2.75>
  }
  box { // Cube21
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.1, 5.0, 0.5>
    translate  <0.38, -10.0, -4.25>
  }
  box { // Cube22
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.2, 4.0, 0.5>
    translate  <0.28, -11.0, -5.75>
  }
  box { // Cube23
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.3, 3.0, 0.5>
    translate  <0.22, -12.0, -7.25>
  }
  texture {
    body_white
  }
  translate  -8.0*x
}
#declare CSG6 = intersection {
  cylinder { // Cylndr2
    <0,0,1>, <0,0,0>, 1
    texture {
      body_white
    }
    scale <7.0, 16.0, 18.0>
    rotate -90.0*x
    translate  <-4.0, -17.75, -6.0>
  }
  object { CSG2 }
}
// Include contains 'TraSwp5'
#include "macross.i32"

#declare TraSwp5 = object {
  TraSwp5_Raw
  texture {
    body_white
  }
  scale <1.0, 1.0, 5.0>
  rotate -90.0*y
  translate  <-5.3, -30.0, -7.549199>
}
#declare CSG004 = difference {
  sphere { // Sphere2
    <0,0,0>,1
    texture {
      body_white
    }
    scale <0.7, 5.0, 1.5>
    translate  <-10.5, -17.0, -2.85>
  }
  sphere { // Sphere3
    <0,0,0>,1
    texture {
      redtexture
    }
    scale <0.242227, 1.0, 0.494818>
    translate  <-11.013095, -14.77253, -2.85>
  }
}
#declare leftupperleg = union {
  object { TraSwp3 }
  object { CSG6 }
  object { TraSwp5 }
  object { CSG004 }
  translate  -30.0*y
}
#declare leftleg = union {
  object { leftfootfront }
  object { leftfootback }
  object { leftlowerleg }
  object { leftupperleg }
//  translate  <1.2, 50.0, 0.0>
  translate  <1.2, LEGY, 0.0>
}
// Include contains 'rightfrontlower'
#include "macross.i33"

#declare rightfrontlower = object {
  rightfrontlower_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate <90.0, -90.0, -90.0>
  translate  <10.0, -10.0, 0.0>
}

#declare rightfrontjet = object {
  box
  {
    <-1, -1, -1>  // one corner position <X1 Y1 Z1>
    < 1,  1,  1>  // other corner position <X2 Y2 Z2>
    pigment{ color rgbt<1,1,1,1>}
    halo{
       emitting
       cylindrical_mapping
       //box_mapping
       linear
       max_value .6
      turbulence JET_TURB
      color_map {JETCOLOR}
/*
      color_map {
        [ 0.0 color rgbt <0, 0, .7,  .7> ]
        [ 0.15 color rgbt <0,0,1, 0> ]
        [ 0.20 color rgbt <0,.5,1, 0> ]
        [ 0.3 color rgbt <0, .5, 1, 0> ]
        [ 0.35 color rgbt <1, 1, 0, -1> ]
        [ 0.6 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <1, 1, 1,  0> ]
      }
*/
      rotate 90*z
      //rotate 90*y
      scale 1
    }
   hollow
   //scale <1.8, 3.5, 4.5>
   scale < 2.5,10,2.5>
   translate  <7.5, -25, FRONT_JET>
  }
}

#declare rightfrontwjet = union {
 object{ rightfrontlower }
 object{ rightfrontjet}
}


// Include contains 'rightfrontupper'
#include "macross.i34"

#declare rightfrontupper = object {
  rightfrontupper_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  10.0*x
}
#declare rightfootfront = union {
  //object { rightfrontlower }
  object { rightfrontwjet}
  object { rightfrontupper }
  translate  <0.0, -82.0, -3.5>
}
// Include contains 'rightbackupper'
#include "macross.i35"

#declare rightbackupper = object {
  rightbackupper_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  10.0*x
}
// Include contains 'rightbacklower'
#include "macross.i36"

#declare rightbacklower = object {
  rightbacklower_Raw
  texture {
    blue_feet
  }
  scale <1.8, 3.5, 4.5>
  rotate -90.0*y
  translate  <10.0, -10.0, 0.0>
}

#declare rightbackjet = object {
  box
  {
    <-1, -1, -1>  // one corner position <X1 Y1 Z1>
    < 1,  1,  1>  // other corner position <X2 Y2 Z2>
    pigment{ color rgbt<1,1,1,1>}
    halo{
       emitting
       cylindrical_mapping
       //box_mapping
       linear
       max_value .6
      turbulence JET_TURB
      color_map {JETCOLOR}
/*
      color_map {
        [ 0.0 color rgbt <0, 0, .7,  .7> ]
        [ 0.15 color rgbt <0,0,1, 0> ]
        [ 0.20 color rgbt <0,.5,1, 0> ]
        [ 0.3 color rgbt <0, .5, 1, 0> ]
        [ 0.35 color rgbt <1, 1, 0, -1> ]
        [ 0.6 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <1, 1, 1,  0> ]
      }
*/
      rotate 90*z
      //rotate 90*y
      scale 1
    }
   hollow
   //scale <1.8, 3.5, 4.5>
   scale < 2.5,10,2.5>
   translate  <7.5, -25, BACK_JET>
  }
}

#declare rightbackwjet = union {
 object{ rightbacklower }
 object{ rightbackjet}
}

#declare rightfootback = union {
  object { rightbackupper }
  //object { rightbacklower }
  object { rightbackwjet }
  translate  <0.0, -82.0, 0.8>
}
// Include contains 'TraSwp21'
#include "macross.i37"

#declare TraSwp21 = object {
  TraSwp21_Raw
  texture {
    body_white
  }
  scale <1.0, 1.0, 5.1>
  rotate -90.0*y
  translate  <10.35, 6.56, 2.4>
}
// Include contains 'TraSwp22'
#include "macross.i38"

#declare TraSwp22 = object {
  TraSwp22_Raw
  texture {
    rightcalfdecal
    scale <5.962005, 2.480619, 1.0>
    rotate <180.0, 0.0, 90.0>
  translate <-0.731416, -7.498305, 0.000000>
  }
  scale <3.725184, 5.671744, 3.0>
  rotate -90.0*y
  translate  <11.85, 12.944886, 0.432374>
}
// Include contains 'TraSwp23'
#include "macross.i39"

#declare TraSwp23 = object {
  TraSwp23_Raw
  texture {
    body_white
  }
  scale <3.725184, 5.671744, 3.0>
  rotate -90.0*y
  translate  <6.75, 12.944886, 0.432374>
}
// Include contains 'TraSwp24'
#include "macross.i40"

#declare TraSwp24 = object {
  TraSwp24_Raw
  texture {
    legwing_decal
    scale <3.969074, 14.010307, -16.141958>
  translate <-7.556519, -55.398663, 43.627579>
  }
  scale <1.0, 1.0, 0.1>
  rotate <-180.0, -60.0, 180.0>
  translate  <6.872468, 32.56, 4.723031>
}
#declare csg6 = union {
  object { TraSwp21 }
  object { TraSwp22 }
  object { TraSwp23 }
  object { TraSwp24 }
  translate  <0.0, -32.56, -5.6>
}
#declare rightlowerleg = difference {
  object { csg6 }
  box { // Cube31
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.3, 5.0, 5.5>
    translate  <7.8, -58.1, -3.3>
  }
  translate  -30.0*y
}
#declare TraSwp18 = prism {
  linear_sweep
  linear_spline
  -9.0,0.0
  7  // control points
  <14.001433, -8.401631>,
  <13.998231, -7.998185>,
  <12.997847, -6.000544>,
  <2.999736, -0.50055>,
  <-0.412573, -0.500379>,
  <-0.400447, -8.39895>,
  <14.001433, -8.401631>
  rotate -x*90
  rotate <90.0, 0.0, -90.0>
  translate  4.5*x
}
#declare CSG7 = difference {
  box { // Cube25
    <-1, -1, -1>, <1, 1, 1>
    scale <3.0, 7.25, 4.0>
    translate  <0.0, -10.0, -4.0>
  }
  object { TraSwp18 }
  box { // Cube26
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.0, 7.0, 0.5>
    translate  <-0.5, -8.0, -1.25>
  }
  box { // Cube27
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.05, 6.0, 0.5>
    translate  <-0.45, -9.0, -2.75>
  }
  box { // Cube28
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.1, 5.0, 0.5>
    translate  <-0.38, -10.0, -4.25>
  }
  box { // Cube29
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.2, 4.0, 0.5>
    translate  <-0.28, -11.0, -5.75>
  }
  box { // Cube30
    <-1, -1, -1>, <1, 1, 1>
    texture {
      intakeblack
    }
    scale <2.3, 3.0, 0.5>
    translate  <-0.22, -12.0, -7.25>
  }
  texture {
    body_white
  }
  translate  8.0*x
}
#declare CSG8 = intersection {
  cylinder { // Cylndr3
    <0,0,1>, <0,0,0>, 1
    texture {
      body_white
    }
    scale <7.0, 16.0, 18.0>
    rotate -90.0*x
    translate  <4.0, -17.75, -6.0>
  }
  object { CSG7 }
}
#declare CSG005 = difference {
  sphere { // Sphere001
    <0,0,0>,1
    texture {
      body_white
    }
    scale <0.7, 5.0, 1.5>
    translate  <10.5, -17.0, -2.85>
  }
  sphere { // Sphere002
    <0,0,0>,1
    texture {
      redtexture
    }
    scale <0.242227, 1.0, 0.494818>
    translate  <11.013095, -14.77253, -2.85>
  }
}
// Include contains 'TraSwp19'
#include "macross.i41"

#declare TraSwp19 = object {
  TraSwp19_Raw
  texture {
    body_white
  }
  scale <1.0, 1.0, 5.0>
  rotate -90.0*y
  translate  <10.3, -30.0, -7.549199>
}
// Include contains 'TraSwp20'
#include "macross.i42"

#declare TraSwp20 = object {
  TraSwp20_Raw
  texture {
    body_white
  }
  scale <1.0, 2.5, 7.8>
  translate  <7.8225, -17.0, -8.0>
}
#declare rightupperleg = union {
  object { CSG8 }
  object { CSG005 }
  object { TraSwp19 }
  object { TraSwp20 }
  translate  -30.0*y
}
#declare rightleg = union {
  object { rightfootfront }
  object { rightfootback }
  object { rightlowerleg }
  object { rightupperleg }
//  translate  <-1.2, 50.0, 0.0>
  translate  <-1.2, LEGY, 0.0>
}
#declare TraSwp25 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -0.8>,
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.0, -0.8>,
  <1.0, 0.9>,
  <0.9, 1.0>,
  <-0.2, 1.0>,
  <-1.0, -0.8>
  rotate -x*90
  texture {
    Whitepaint
    scale <2.083177, 2.065707, 1.0>
  translate <-1.013295, -1.030766, 0.000000>
  }
  scale <6.0, 6.0, 0.5>
  rotate -180.0*z
  translate  <1.44, -1.944861, -5.0>
}
#declare TraSwp26 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -0.8>,
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.0, -0.8>,
  <1.0, 0.9>,
  <0.9, 1.0>,
  <-0.2, 1.0>,
  <-1.0, -0.8>
  rotate -x*90
  texture {
    shoulder_decal
    scale <2.092054, 2.002907, 1.0>
  translate <-1.025194, -0.980620, 0.000000>
  }
  scale <6.0, 6.0, 0.5>
  rotate -180.0*z
  translate  <1.44, -1.944861, 4.5>
}
#declare shoulderpadleft = union {
  box { // Cube008
    <-1, -1, -1>, <1, 1, 1>
    scale <3.326225, 0.304013, 5.0>
    translate  <-0.644588, -7.637227, 0.0>
  }
  box { // Cube007
    <-1, -1, -1>, <1, 1, 1>
    scale <0.302781, 0.425482, 5.0>
    rotate 45.0*z
    translate  <-4.045892, -7.426018, 0.0>
  }
  box { // Cube006
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.5, 5.0>
    translate  <-4.254652, -5.849616, 0.0>
  }
  object { TraSwp25 }
  object { TraSwp26 }
  box { // Cube009
    <-1, -1, -1>, <1, 1, 1>
    scale <0.297, 5.934546, 5.0>
    rotate -23.777008*z
    translate  <4.800177, -2.390923, 0.0>
  }
  box { // Cube010
    <-1, -1, -1>, <1, 1, 1>
    scale <0.253249, 0.84653, 5.0>
    rotate 44.864548*z
    translate  <6.694427, 3.253576, 0.0>
  }
  //rotate <180.0, 0.0, 0.0>
  rotate <180.0, SPADLEFT, 0.0 >
  translate  <-7.41415, -16.040389, 5.0>
}
#declare TraSwp27 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-4.851966, -0.596591>,
  <-4.651966, -0.796591>,
  <1.848034, -0.796591>,
  <2.148034, -0.296591>,
  <-0.051966, 0.003409>,
  <-0.851966, 1.003409>,
  <-4.651966, 1.203409>,
  <-4.851966, 1.003409>,
  <-4.851966, -0.596591>
  rotate -x*90
  texture {
    forearmdecal
    scale <7.548159, 3.003382, 1.0>
  translate <-5.380620, -1.615103, 0.000000>
  }
  scale <6.0, 6.0, 0.6>
  rotate <90.0, 0.0, -90.0>
  translate  <-3.6, 2.737365, -0.529408>
}
#declare TraSwp28 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-4.851966, -0.596591>,
  <-4.651966, -0.796591>,
  <1.848034, -0.796591>,
  <2.148034, -0.296591>,
  <-0.051966, 0.003409>,
  <-0.851966, 1.003409>,
  <-4.651966, 1.203409>,
  <-4.851966, 1.003409>,
  <-4.851966, -0.596591>
  rotate -x*90
  scale <6.0, 6.0, 0.6>
  rotate <90.0, 0.0, -90.0>
  translate  <4.2, 2.737365, -0.529408>
}
#declare TraSwp29 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.75, 1.5>,
  <0.0, 0.0>,
  <0.0, 2.0>,
  <0.5, 2.5>,
  <0.5, 4.0>,
  <-0.3, 4.15>,
  <-0.75, 4.0>,
  <-0.75, 1.5>
  rotate -x*90
  scale <2.0, 2.0, 0.25>
  rotate <90.0, 0.0, -90.0>
  translate  <4.5, -0.219096, -3.5>
}
#declare TraSwp30 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.75, 1.5>,
  <0.0, 0.0>,
  <0.0, 2.0>,
  <0.5, 2.5>,
  <0.5, 4.0>,
  <-0.3, 4.15>,
  <-0.75, 4.0>,
  <-0.75, 1.5>
  rotate -x*90
  scale <2.0, 2.0, 0.25>
  rotate <90.0, 0.0, -90.0>
  translate  <-4.25, -0.219096, -3.5>
}
#declare index12 = union {
  sphere { // Sphere8
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr27
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere9
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  2.5*z
}
#declare index13 = union {
  cylinder { // Cylndr26
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index12 }
  sphere { // Sphere10
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  3.0*z
}
#declare pinkyleft = union {
  cylinder { // Cylndr23
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr25
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index13 }
  texture {
    Whitepaint
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  <-3.1, 0.0, 3.5>
}
#declare index9 = union {
  sphere { // Sphere11
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr29
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere12
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  2.5*z
}
#declare index14 = union {
  cylinder { // Cylndr28
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index9 }
  sphere { // Sphere13
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  3.0*z
}
#declare fourthleft = union {
  cylinder { // Cylndr17
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr19
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index14 }
  texture {
    Whitepaint
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  <-1.05, 0.0, 3.5>
}
#declare index6 = union {
  sphere { // Sphere14
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr33
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere15
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  2.5*z
}
#declare index15 = union {
  cylinder { // Cylndr32
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index6 }
  sphere { // Sphere16
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  3.0*z
}
#declare middleleft = union {
  cylinder { // Cylndr30
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr31
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index15 }
  texture {
    Whitepaint
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  <1.05, 0.0, 3.5>
}
#declare index3 = union {
  sphere { // Sphere17
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr37
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere18
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  2.5*z
}
#declare index16 = union {
  cylinder { // Cylndr36
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index3 }
  sphere { // Sphere19
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  3.0*z
}
#declare indexleft = union {
  cylinder { // Cylndr34
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr35
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index16 }
  texture {
    Whitepaint
  }
//  rotate 44.444*x
  rotate HAND2PLUS*x
  translate  <3.1, 0.0, 3.5>
}
#declare TraSwp31 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.75, 1.5>,
  <0.0, 0.0>,
  <1.0, 0.0>,
  <1.0, 2.0>,
  <0.25, 2.5>,
  <0.3, 3.2>,
  <-0.75, 4.0>,
  <-0.75, 1.5>
  rotate -x*90
  scale <2.0, 2.0, 9.0>
  rotate <90.0, 0.0, -90.0>
  translate  <4.5, -0.219096, -3.532518>
}
#declare backhandleft = union {
  box { // Cube37
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.1, 2.5>
    translate  <0.0, 1.180904, 2.0>
  }
  object { TraSwp29 }
  object { TraSwp30 }
  box { // Cube38
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.02, 1.0>
    rotate 44.833515*x
    translate  <0.0, -0.4963, 0.8168>
  }
  box { // Cube39
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.01, 2.0>
    translate  <0.0, -0.208445, -1.457978>
  }
  box { // Cube40
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.01, 1.66>
    rotate -26.657505*x
    translate  <0.0, 0.525662, -1.976613>
  }
  object { pinkyleft }
  object { fourthleft }
  object { middleleft }
  object { indexleft }
  object { TraSwp31 }
  rotate -0.416274*y
}
#declare thumb_index3 = union {
  sphere { // Sphere6
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr13
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere7
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
  //rotate -33.333*x
  rotate LTHUMBMINUS*x
  translate  2.0*z
}
#declare thumb_index4 = union {
  cylinder { // Cylndr5
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // Cylndr11
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  -1.0*y
  }
  object { thumb_index3 }
  texture {
    Whitepaint
  }
//  rotate <0.0, 33.333, -180.0>
  rotate <0.0, LTHUMBPLUS, -180.0>
  translate  <-3.0, 0.0, 1.0>
}
#declare TraSwp32 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    blackpaint
  }
  scale 2.0
  rotate <-90.0, -180.0, 0.0>
  translate  <-2.0, -1.0, 0.0>
}
#declare thumbleft = union {
  object { thumb_index4 }
  cylinder { // Cylndr7
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 3.5>
    translate  -1.5*z
  }
  object { TraSwp32 }
//  rotate 33.333*z
  rotate LTHUMBPLUS*z
  translate  <-2.968991, -1.35, -1.621626>
}
#declare left_hand = union {
  box { // Cube36
    <-1, -1, -1>, <1, 1, 1>
    scale <4.25, 1.0, 2.0>
    translate  <0.0, -1.253075, -1.547916>
  }
  object { backhandleft }
  object { thumbleft }
  texture {
    Whitepaint
  }
  /*
  #if (myclock > ENDS9)
    rotate -90.0*z
  #end
  */
  translate  <-1.15, 1.8, 6.0>
}
#declare left_wrist = union {
  object { left_hand }
  superellipsoid { // SuprQ3
    <0.3, 0.1>
    texture {
      Whitepaint
    }
    scale <4.5, 3.5, 3.0>
    translate  -1.15*x
  }
  rotate <-90.0, 90.0, 0.0>
  //translate  <0.0, 20.0, -0.4>
  translate <0.0, WRIST, -0.4>
}
#declare forearmleft = union {
  box { // Cube32
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 1.05>
    rotate <-180.0, -45.0, 90.0>
    translate  <0.0, 31.164318, 6.305369>
  }
  box { // Cube33
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 1.05>
    rotate <0.0, -45.0, -90.0>
    translate  <0.0, 31.164318, -4.870661>
  }
  object { TraSwp27 }
  object { TraSwp28 }
  box { // Cube34
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 19.5>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.0, 11.137365, -5.529408>
  }
  box { // Cube35
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 11.5>
    rotate <0.0, -87.0, -90.0>
    translate  <0.0, 19.162119, 6.357124>
  }
  superellipsoid { // SuprQ002
    <0.4, 0.4>
    scale <4.0, 3.5, 10.0>
    rotate <-90.0, 90.0, 0.0>
    translate  <0.0, 7.737365, -0.029408>
  }
  object { left_wrist }
  cylinder { // Cylndr002
    <0,0,1>, <0,0,0>, 1
    scale <4.5, 4.5, 8.0>
    rotate <0.0, 90.0, 0.0>
    translate  <-4.0, 0.027427, 0.0>
  }
  texture {
    Whitepaint
  }
  //rotate <0.0, 90.0, 0.0>
  //rotate <0.0, LFARMROT, 0.0>
  rotate <LFARMROTX, LFARMROT, LFARMROTZ>
// #ifdef (SCENE4)
  translate FOREARM*y
// #end // SCENE4
}
#declare upperarmleft = union {
  superellipsoid { // SuprQ003
    <0.4, 0.4>
    texture {
      Whitepaint
    }
    scale <4.0, 5.0, 4.0>
    translate  11.047939*y
  }
  superellipsoid { // SuprQ004
    <0.4, 0.4>
    scale <4.5, 3.0, 4.5>
    translate  4.047939*y
  }
  cylinder { // Cylndr38
    <0,0,1>, <0,0,0>, 1
    scale <5.0, 5.0, 8.0>
    translate  -4.0*z
  }
  object { forearmleft }
  //rotate <180.0, 0.0, 0.0>
//  rotate <180.0, 0.0, 0.0>
  rotate <LUAX,LUAY,LUAZ>
  translate  <-7.5, -16.25, 5.0>
}
#declare shoulderleft = union {
  object { shoulderpadleft }
  object { upperarmleft }
  texture {
    Whitepaint
  }
  scale 0.4
  //rotate -90.0*y
  rotate SHOULDERLEFT*y
  translate SLEFT*x
  #if (myclock > ENDS7)
    translate -2*z
  #end
}
#declare TraSwp35 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  5  // control points
  <-1.0, -1.0>,
  <1.0, 0.0>,
  <1.0, 1.0>,
  <-1.0, 1.0>,
  <-1.0, -1.0>
  rotate -x*90
  texture {
    blackpaint
  }
  scale 2.0
  rotate <-90.0, -180.0, -180.0>
  translate  <2.0, 1.0, 0.0>
}
#declare thumb_index1 = union {
  sphere { // Sphere4
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr8
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere5
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 22.222*x
  rotate RTHUMBPLUS*x
  translate  2.0*z
}
#declare thumb_index2 = union {
  cylinder { // Cylndr4
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  cylinder { // Cylndr6
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 2.0>
    rotate -90.0*x
    translate  -1.0*y
  }
  object { thumb_index1 }
  texture {
    Whitepaint
  }
//  rotate 22.222*x
  rotate RTHUMBPLUS*x
  translate  <3.0, 0.0, 1.0>
}
#declare thumbright = union {
  object { TraSwp35 }
  cylinder { // Cylndr005
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 3.5>
    translate  -1.5*z
  }
  object { thumb_index2 }
//  rotate -22.222*z
  rotate RTHUMBMINUS*z
  translate  <2.968991, -1.35, -1.621626>
}
#declare TraSwp36 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.75, 1.5>,
  <0.0, 0.0>,
  <0.0, 2.0>,
  <0.5, 2.5>,
  <0.5, 4.0>,
  <-0.3, 4.15>,
  <-0.75, 4.0>,
  <-0.75, 1.5>
  rotate -x*90
  scale <2.0, 2.0, 0.25>
  rotate <90.0, 0.0, -90.0>
  translate  <4.5, -0.219096, -3.5>
}
#declare TraSwp37 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.75, 1.5>,
  <0.0, 0.0>,
  <0.0, 2.0>,
  <0.5, 2.5>,
  <0.5, 4.0>,
  <-0.3, 4.15>,
  <-0.75, 4.0>,
  <-0.75, 1.5>
  rotate -x*90
  scale <2.0, 2.0, 0.25>
  rotate <90.0, 0.0, -90.0>
  translate  <-4.25, -0.219096, -3.5>
}
#declare index10 = union {
  sphere { // Sphere20
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr24
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere004
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  2.5*z
}
#declare index11 = union {
  cylinder { // Cylndr22
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index10 }
  sphere { // Sphere003
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  3.0*z
}
#declare pinkyright = union {
  cylinder { // Cylndr20
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr21
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index11 }
  texture {
    Whitepaint
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  <-3.1, 0.0, 3.5>
}
#declare index7 = union {
  sphere { // Sphere21
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr18
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere006
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  2.5*z
}
#declare index8 = union {
  cylinder { // Cylndr16
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index7 }
  sphere { // Sphere007
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  3.0*z
}
#declare fourthright = union {
  cylinder { // Cylndr14
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr15
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index8 }
  texture {
    Whitepaint
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  <-1.05, 0.0, 3.5>
}
#declare index4 = union {
  sphere { // Sphere22
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr39
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere005
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  2.5*z
}
#declare index5 = union {
  cylinder { // Cylndr12
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index4 }
  sphere { // Sphere008
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  3.0*z
}
#declare middleright = union {
  cylinder { // Cylndr9
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr10
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index5 }
  texture {
    Whitepaint
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  <1.05, 0.0, 3.5>
}
#declare index1 = union {
  sphere { // Sphere23
    <0,0,0>,1
    texture {
      Whitepaint
    }
    translate  2.0*z
  }
  cylinder { // Cylndr42
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.0>
  }
  sphere { // Sphere009
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  2.5*z
}
#declare index2 = union {
  cylinder { // Cylndr41
    <0,0,1>, <0,0,0>, 1
    texture {
      Whitepaint
    }
    scale <1.0, 1.0, 2.5>
  }
  object { index1 }
  sphere { // Sphere010
    <0,0,0>,1
    texture {
      blackpaint
    }
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  3.0*z
}
#declare indexright = union {
  cylinder { // Cylndr004
    <0,0,1>, <0,0,0>, 1
    texture {
      blackpaint
    }
    scale <1.0, 1.0, 2.0>
    rotate -90.0*y
    translate  1.0*x
  }
  cylinder { // Cylndr003
    <0,0,1>, <0,0,0>, 1
    scale <1.0, 1.0, 3.0>
  }
  object { index2 }
  texture {
    Whitepaint
  }
//  rotate 11.111*x
  rotate HANDPLUS*x
  translate  <3.1, 0.0, 3.5>
}
#declare TraSwp38 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-0.75, 1.5>,
  <0.0, 0.0>,
  <1.0, 0.0>,
  <1.0, 2.0>,
  <0.25, 2.5>,
  <0.3, 3.2>,
  <-0.75, 4.0>,
  <-0.75, 1.5>
  rotate -x*90
  scale <2.0, 2.0, 9.0>
  rotate <90.0, 0.0, -90.0>
  translate  <4.5, -0.219096, -3.532518>
}
#declare backhandright = union {
  box { // Cube47
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.1, 2.5>
    translate  <0.0, 1.180904, 2.0>
  }
  object { TraSwp36 }
  object { TraSwp37 }
  box { // Cube48
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.02, 1.0>
    rotate 44.833515*x
    translate  <0.0, -0.4963, 0.8168>
  }
  box { // Cube49
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.01, 2.0>
    translate  <0.0, -0.208445, -1.457978>
  }
  box { // Cube50
    <-1, -1, -1>, <1, 1, 1>
    scale <4.5, 0.01, 1.66>
    rotate -26.657505*x
    translate  <0.0, 0.525662, -1.976613>
  }
  object { pinkyright }
  object { fourthright }
  object { middleright }
  object { indexright }
  object { TraSwp38 }
  rotate -0.416274*y
}
#declare right_hand = union {
  box { // Cube46
    <-1, -1, -1>, <1, 1, 1>
    scale <4.25, 1.0, 2.0>
    translate  <0.0, -1.253075, -1.547916>
  }
  object { thumbright }
  object { backhandright }
  texture {
    Whitepaint
  }
  translate  <1.15, 1.8, 6.0>
}
//
// Include file contains 'RotSwp2'
//
#include "macross.i43"
#declare RotSwp2 = object {
  RotSwp2_Raw
  texture {
    gunblack
  }
}
// Include contains 'TraSwp41'
#include "macross.i44"

#declare TraSwp41 = object {
  TraSwp41_Raw
  texture {
    gunblack
  }
  scale <1.0, 1.0, 0.2>
  rotate <90.0, 0.0, -90.0>
  translate  <0.1, 1.396121, -4.127123>
}
// Include contains 'TraSwp42'
#include "macross.i45"

#declare TraSwp42 = object {
  TraSwp42_Raw
  texture {
    gunblack
  }
  scale <0.8, 1.0, 0.3>
  rotate <-180.0, 90.0, 0.0>
  translate  <0.15, 1.695043, -5.117779>
}
#declare TraSwp43 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.2, -0.6>,
  <1.2, -0.6>,
  <1.2, -0.4>,
  <0.5, 0.0>,
  <-0.5, 0.0>,
  <-1.2, -0.4>,
  <-1.2, -0.6>
  rotate -x*90
  texture {
    gunblack
  }
  scale <1.0, 1.0, 0.3>
  rotate <90.0, 0.0, -90.0>
  translate  <0.15, 0.0, -8.0>
}
#declare CSG9 = difference {
  cone { // Cone001
    <0,0,0>, 0.0, <0,0,1>, 1.0
    scale <0.7, 0.7, 1.5>
    translate  -9.5*z
  }
  cylinder { // Cylndr44
    <0,0,1>, <0,0,0>, 1
    translate  -9.6059*z
  }
  texture {
    gunblack
  }
}
#declare gun = union {
  object { RotSwp2 }
/*  plane { // Plane2
    z,0
    texture {
      justaplane2
    }
    translate  <-0.031905, 0.0, -47.393853>
  }
*/
  object { TraSwp41 }
  object { TraSwp42 }
  object { TraSwp43 }
  object { CSG9 }
  #if ((myclock > ENDS10) & (myclock <= ENDS11))
  #if (curclock > 0)
  sphere { // fire1
    <0,0,0>,1
    pigment{ color rgbt<1,1,1,1>}
    halo{
       emitting
       cylindrical_mapping
       //box_mapping
       linear
       max_value .6
      turbulence JET_TURB
      color_map {
        [ 0.0 color rgbt <.7, 0, 0,  1> ]
        [ 0.15 color rgbt <1,0,0, 0> ]
        [ 0.20 color rgbt <1,.5,0, 0> ]
        [ 0.3 color rgbt <1, .5, 0, 0> ]
        [ 0.35 color rgbt <1, 1, 0, 1> ]
        [ 0.6 color rgbt <1, 1, 1, -1> ]
        [ 1.0 color rgbt <1, 1, 1,  0> ]
      }
      rotate 90*z
      //rotate 90*y
      scale 1
    }
    hollow
    scale <4.0, 0.8, 0.8>
//    rotate <-132.709167, 84.325111, 134.05957>
    rotate <-180, 90, 180>
//    translate  <0.251114, -0.229769, 5.023122>
    translate  <0, 0, 5.0>
  }
  #end
  #end
  scale 6.25
  //rotate <-180.0, 0.0, 90.0>
  rotate <GUNROTX, GUNROTY, GUNROTZ>
  //translate  <-8.92208, 5.0, -17.755951>
  //translate  <-8.92208, 5.0, GUNLAT>
  translate <GUNHOR, GUNVERT, GUNLAT>
}
#declare right_wrist = union {
  object { right_hand }
  superellipsoid { // SuprQ6
    <0.3, 0.1>
    texture {
      Whitepaint
    }
    scale <4.5, 3.5, 3.0>
    translate  1.15*x
  }
  object { gun }
  rotate <-90.0, -90.0, 0.0>
  //translate  <0.0, 20.0, -0.4>
  translate <0.0, WRIST, -0.4>
}

#declare TraSwp39 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-4.851966, -0.596591>,
  <-4.651966, -0.796591>,
  <1.848034, -0.796591>,
  <2.148034, -0.296591>,
  <-0.051966, 0.003409>,
  <-0.851966, 1.003409>,
  <-4.651966, 1.203409>,
  <-4.851966, 1.003409>,
  <-4.851966, -0.596591>
  rotate -x*90
  scale <6.0, 6.0, 0.6>
  rotate <90.0, 0.0, -90.0>
  translate  <-3.6, 2.579441, -0.503228>
}
#declare TraSwp40 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  9  // control points
  <-4.851966, -0.596591>,
  <-4.651966, -0.796591>,
  <1.848034, -0.796591>,
  <2.148034, -0.296591>,
  <-0.051966, 0.003409>,
  <-0.851966, 1.003409>,
  <-4.651966, 1.203409>,
  <-4.851966, 1.003409>,
  <-4.851966, -0.596591>
  rotate -x*90
  texture {
    forearmdecal
    scale <7.548159, 3.002032, 1.0>
  translate <-5.380620, -1.615103, 0.000000>
  }
  scale <6.0, 6.0, 0.6>
  rotate <90.0, 0.0, -90.0>
  translate  <4.2, 2.579441, -0.503228>
}
#declare forearmright = union {
  object { right_wrist }
  superellipsoid { // SuprQ7
    <0.4, 0.4>
    scale <4.0, 3.5, 10.0>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.0, 7.579441, -0.003228>
  }
  box { // Cube005
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 1.05>
    rotate <-180.0, -45.0, 90.0>
    translate  <0.0, 31.006394, 6.331548>
  }
  box { // Cube51
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 1.05>
    rotate <0.0, -45.0, -90.0>
    translate  <0.0, 31.006394, -4.844481>
  }
  object { TraSwp39 }
  object { TraSwp40 }
  box { // Cube52
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 19.5>
    rotate <-90.0, -90.0, 0.0>
    translate  <0.0, 10.979441, -5.503228>
  }
  box { // Cube53
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 4.2, 11.5>
    rotate <0.0, -87.0, -90.0>
    translate  <0.0, 19.004195, 6.383303>
  }
  cylinder { // Cylndr43
    <0,0,1>, <0,0,0>, 1
    scale <4.5, 4.5, 8.0>
    rotate <0.0, 90.0, 0.0>
    translate  -4.0*x
  }
  texture {
    Whitepaint
  }
  rotate RFARMROT*y
  rotate RFARMROTX * x
  rotate RFARMROTZ * z
  translate FOREARM*y
}

#declare upperarmright = union {
  superellipsoid { // SuprQ4
    <0.4, 0.4>
    texture {
      Whitepaint
    }
    scale <4.0, 5.0, 4.0>
    translate  11.047939*y
  }
  superellipsoid { // SuprQ5
    <0.4, 0.4>
    scale <4.5, 3.0, 4.5>
    translate  4.047939*y
  }
  cylinder { // Cylndr40
    <0,0,1>, <0,0,0>, 1
    scale <5.0, 5.0, 8.0>
    translate  -4.0*z
  }
  object { forearmright }
//  rotate <0.0, 0.0, 0.0>
  rotate RUAROT*z
  translate  <7.522674, 16.4055, -5.0>
}
#declare TraSwp33 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -0.8>,
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.0, -0.8>,
  <1.0, 0.9>,
  <0.9, 1.0>,
  <-0.2, 1.0>,
  <-1.0, -0.8>
  rotate -x*90
  texture {
    shoulder_decal
    scale <2.083177, 2.065707, 1.0>
  translate <-1.013295, -1.030766, 0.000000>
  }
  scale <6.0, 6.0, 0.5>
  rotate -180.0*z
  translate  <1.44, -1.944861, -5.0>
}
#declare TraSwp34 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  8  // control points
  <-1.0, -0.8>,
  <-0.8, -1.0>,
  <0.8, -1.0>,
  <1.0, -0.8>,
  <1.0, 0.9>,
  <0.9, 1.0>,
  <-0.2, 1.0>,
  <-1.0, -0.8>
  rotate -x*90
  texture {
    Whitepaint
    scale <2.092054, 2.002907, 1.0>
  translate <-1.025194, -0.980620, 0.000000>
  }
  scale <6.0, 6.0, 0.5>
  rotate -180.0*z
  translate  <1.44, -1.944861, 4.5>
}
#declare shoulderpadright = union {
  box { // Cube41
    <-1, -1, -1>, <1, 1, 1>
    scale <3.326225, 0.304013, 5.0>
    translate  <-0.644588, -7.637227, 0.0>
  }
  box { // Cube42
    <-1, -1, -1>, <1, 1, 1>
    scale <0.302781, 0.425482, 5.0>
    rotate 45.0*z
    translate  <-4.045892, -7.426018, 0.0>
  }
  box { // Cube43
    <-1, -1, -1>, <1, 1, 1>
    scale <0.3, 1.5, 5.0>
    translate  <-4.254652, -5.849616, 0.0>
  }
  object { TraSwp33 }
  object { TraSwp34 }
  box { // Cube44
    <-1, -1, -1>, <1, 1, 1>
    scale <0.297, 5.934546, 5.0>
    rotate -23.777008*z
    translate  <4.800177, -2.390923, 0.0>
  }
  box { // Cube45
    <-1, -1, -1>, <1, 1, 1>
    scale <0.253249, 0.84653, 5.0>
    rotate 44.864548*z
    translate  <6.694427, 3.253576, 0.0>
  }
  //rotate <180.0, 0.0, -180.0>
  rotate <180.0, SPADRIGHT, -180.0>
  translate  <7.413548, 16.04242, -5.0>
}
#declare shoulderright = union {
  object { upperarmright }
  object { shoulderpadright }
  texture {
    Whitepaint
  }
  scale 0.4
  //rotate <180.0, 90.0, 0.0>
  //rotate <180.0, SHOULDERRIGHT, 0.0>
  rotate <SRROTX, SHOULDERRIGHT, 0.0>
  translate SRIGHT*x
  #if (myclock > ENDS7)
    translate 0*z
  #end
}
// Include contains 'TraSwp44'
#include "macross.i46"

#declare TraSwp44 = object {
  TraSwp44_Raw
  texture {
    headwhite
  }
  scale <1.4, 0.717642, 2.009153>
  rotate -7.64739*x
  translate  <-0.083571, 3.574887, -0.827002>
}
// Include contains 'TraSwp45'
#include "macross.i47"

#declare TraSwp45 = object {
  TraSwp45_Raw
  texture {
    headwhite
  }
  scale <2.0, 2.0, 3.0>
  rotate 82.641121*x
  translate  <0.009371, 5.734883, -1.53038>
}
// Include contains 'TraSwp46'
#include "macross.i48"

#declare TraSwp46 = object {
  TraSwp46_Raw
  texture {
    headwhite
  }
  scale <2.0, 2.0, 3.5>
  rotate -11.595524*x
  translate  <0.0, 0.272263, -2.900446>
}
// Include contains 'TraSwp47'
#include "macross.i49"

#declare TraSwp47 = object {
  TraSwp47_Raw
  texture {
    headwhite
  }
  scale <1.0, 1.0, 2.0>
  translate  -0.790525*z
}
#declare TraSwp48 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.5, -0.5>,
  <1.5, -0.5>,
  <1.5, 0.5>,
  <0.5, 1.0>,
  <-1.0, 1.0>,
  <-1.5, 0.5>,
  <-1.5, -0.5>
  rotate -x*90
  rotate <-90.0, 0.0, -82.0>
  translate  <-3.326251, 3.066424, -1.035943>
}
#declare right_ear = union {
  cylinder { // Cylndr45
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 6.0>
    rotate <39.416084, 0.0, 8.0>
    translate  <-3.413404, 6.671189, -6.108145>
  }
  cylinder { // Cylndr46
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 6.0>
    rotate <39.416084, 0.0, 8.0>
    translate  <-3.583855, 7.884014, -5.979224>
  }
  object { TraSwp48 }
  texture {
    headwhite
  }
  translate  <0.0, -3.2, 1.168425>
}
#declare TraSwp49 = prism {
  linear_sweep
  linear_spline
  -1.0,0.0
  7  // control points
  <-1.5, -0.5>,
  <1.5, -0.5>,
  <1.5, 0.5>,
  <0.5, 1.0>,
  <-1.0, 1.0>,
  <-1.5, 0.5>,
  <-1.5, -0.5>
  rotate -x*90
  rotate <-90.0, 0.0, -99.615463>
  translate  <2.425215, 3.123526, -1.035943>
}
#declare left_ear = union {
  object { TraSwp49 }
  cylinder { // Cylndr47
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 6.0>
    rotate <39.416084, 0.0, -9.615466>
    translate  <3.804482, 7.764905, -5.979224>
  }
  cylinder { // Cylndr48
    <0,0,1>, <0,0,0>, 1
    scale <0.25, 0.25, 6.0>
    rotate <39.416084, 0.0, -9.615466>
    translate  <3.599907, 6.557368, -6.108145>
  }
  texture {
    headwhite
  }
  translate  <0.0, -3.2, 1.168425>
}
#declare ears = union {
  object { right_ear }
  object { left_ear }
  //rotate <-103.209747, 0.0, 0.0>
  rotate <EARANGLE, 0.0, 0.0>
  translate  <0.0, 3.2, -1.6>
}
#declare csg = union {
  box { // Cube54
    <-1, -1, -1>, <1, 1, 1>
    texture {
      headwhite
    }
    rotate 12.527259*x
    translate  <0.0, -0.075188, 0.150075>
  }
  box { // Cube55
    <-1, -1, -1>, <1, 1, 1>
    texture {
      green_eyes
    }
    scale <1.27451, 0.786427, 0.35614>
    translate  <-0.02149, 2.283589, 0.648451>
  }
  object { TraSwp44 }
  object { TraSwp45 }
  object { TraSwp46 }
  object { TraSwp47 }
  object { ears }
  translate  <0.0, 1.869968, 1.0>
}
#declare head = union {
  object { csg }
  cylinder { // Cylndr49
    <0,0,1>, <0,0,0>, 1
    texture {
      body_white1
    }
    scale <1.0, 1.0, 4.0>
    rotate 90.0*x
    translate  <0.0, 2.263646, 0.0>
  }
  rotate 180.0*z
  rotate HEADANGLE*x
  rotate HEADZ*y
  #if (myclock >ENDS8)
   translate -2*y
  #end
}
union { // macross
  object { body }
  object { tail }
  object { back }
  object { leftleg }
  object { rightleg }
  object { shoulderleft }
  object { shoulderright }
  object { head }

  rotate MACROTY*y
  rotate MANGX*x
  translate FLY_POS*y
  translate POSZ * z
}

#include "colors.inc"

plane { z,0
 texture{
  pigment{SeaGreen}
  finish{reflection .3 specular 1}
  normal{ripples .95 turbulence .35 scale .25}
 }
 translate -500*z
}
/*
plane { // Plane002
  z,0
  texture {
    justaplane2
  }
  translate  -500.0*z
}
*/



