/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.base.Objects;
import javax.annotation.Nullable;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.AbstractExpression;

public class SimpleExpression
extends AbstractExpression {
    public static final Expression EMPTY_EXPRESSIONS = new SimpleExpression(null, IncludeType.EXPRESSIONS);
    static final Expression EMPTY_ARGS = new SimpleExpression(null, IncludeType.ARGS_LIST);
    static final Expression LEFT_PAREN = new SimpleExpression("(", IncludeType.TOKEN);
    static final Expression COMMA = new SimpleExpression(",", IncludeType.TOKEN);
    static final Expression RIGHT_PAREN = new SimpleExpression(")", IncludeType.TOKEN);
    private final String value;
    private final IncludeType type;

    public SimpleExpression(@Nullable String value, IncludeType type) {
        this.value = value;
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public IncludeType getType() {
        return this.type;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleExpression other = (SimpleExpression)obj;
        return Objects.equal((Object)this.value, (Object)other.value) && this.type.equals((Object)other.type);
    }

    public int hashCode() {
        return (this.value == null ? 0 : this.value.hashCode()) ^ this.type.hashCode();
    }
}

