/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.ArtifactCacheLockingAccessCoordinator;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.AbstractModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCacheEntry;
import org.gradle.cache.IndexedCache;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.util.internal.BuildCommencedTimeProvider;

public class DefaultModuleVersionsCache
extends AbstractModuleVersionsCache {
    private final ArtifactCacheLockingAccessCoordinator artifactCacheLockingManager;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private IndexedCache<ModuleAtRepositoryKey, ModuleVersionsCacheEntry> cache;

    public DefaultModuleVersionsCache(BuildCommencedTimeProvider timeProvider, ArtifactCacheLockingAccessCoordinator cacheAccessCoordinator, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        super(timeProvider);
        this.artifactCacheLockingManager = cacheAccessCoordinator;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
    }

    private IndexedCache<ModuleAtRepositoryKey, ModuleVersionsCacheEntry> getCache() {
        if (this.cache == null) {
            this.cache = this.initCache();
        }
        return this.cache;
    }

    private IndexedCache<ModuleAtRepositoryKey, ModuleVersionsCacheEntry> initCache() {
        return this.artifactCacheLockingManager.createCache("module-versions", new ModuleKeySerializer(this.moduleIdentifierFactory), new ModuleVersionsCacheEntrySerializer());
    }

    @Override
    protected void store(ModuleAtRepositoryKey key, ModuleVersionsCacheEntry entry) {
        this.getCache().put((Object)key, (Object)entry);
    }

    @Override
    protected ModuleVersionsCacheEntry get(ModuleAtRepositoryKey key) {
        return (ModuleVersionsCacheEntry)this.getCache().getIfPresent((Object)key);
    }

    private static class ModuleKeySerializer
    extends AbstractSerializer<ModuleAtRepositoryKey> {
        private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

        private ModuleKeySerializer(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
            this.moduleIdentifierFactory = moduleIdentifierFactory;
        }

        public void write(Encoder encoder, ModuleAtRepositoryKey value) throws Exception {
            encoder.writeString((CharSequence)value.repositoryId);
            encoder.writeString((CharSequence)value.moduleId.getGroup());
            encoder.writeString((CharSequence)value.moduleId.getName());
        }

        public ModuleAtRepositoryKey read(Decoder decoder) throws Exception {
            String resolverId = decoder.readString();
            String group = decoder.readString();
            String module = decoder.readString();
            return new ModuleAtRepositoryKey(resolverId, this.moduleIdentifierFactory.module(group, module));
        }
    }

    private static class ModuleVersionsCacheEntrySerializer
    extends AbstractSerializer<ModuleVersionsCacheEntry> {
        private ModuleVersionsCacheEntrySerializer() {
        }

        public void write(Encoder encoder, ModuleVersionsCacheEntry value) throws Exception {
            Set<String> versions = value.moduleVersionListing;
            encoder.writeInt(versions.size());
            for (String version : versions) {
                encoder.writeString((CharSequence)version);
            }
            encoder.writeLong(value.createTimestamp);
        }

        public ModuleVersionsCacheEntry read(Decoder decoder) throws Exception {
            int size = decoder.readInt();
            LinkedHashSet<String> versions = new LinkedHashSet<String>();
            for (int i = 0; i < size; ++i) {
                versions.add(decoder.readString());
            }
            long createTimestamp = decoder.readLong();
            return new ModuleVersionsCacheEntry(versions, createTimestamp);
        }
    }
}

