/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.session.helpers;

import java.util.Objects;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.AbstractIoWriteFuture;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.buffer.Buffer;

public class PendingWriteFuture
extends AbstractIoWriteFuture
implements SshFutureListener<IoWriteFuture> {
    private final Buffer buffer;

    public PendingWriteFuture(Object id, Buffer buffer) {
        super(id, null);
        this.buffer = Objects.requireNonNull(buffer, "No buffer provided");
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setWritten() {
        this.setValue(Boolean.TRUE);
    }

    public void setException(Throwable cause) {
        Objects.requireNonNull(cause, "No cause specified");
        this.setValue(cause);
    }

    public void operationComplete(IoWriteFuture future) {
        if (future.isWritten()) {
            this.setWritten();
        } else {
            this.setException(future.getException());
        }
    }
}

