/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Collections;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;
import org.gradle.internal.deprecation.DeprecatableConfiguration;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.exceptions.ResolutionProvider;

public interface RoleBasedConfigurationCreationRequest {
    public static String getDefaultReservedNameAdvice(String configurationName) {
        return String.format("Do not create a configuration with the name %s.", configurationName);
    }

    public String getConfigurationName();

    public ConfigurationRole getRole();

    default public void warnAboutReservedName() {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateBehaviour)DeprecationLogger.deprecateBehaviour((String)("The configuration " + this.getConfigurationName() + " was created explicitly. This configuration name is reserved for creation by Gradle.")).withAdvice(RoleBasedConfigurationCreationRequest.getDefaultReservedNameAdvice(this.getConfigurationName()))).willBeRemovedInGradle9().withUpgradeGuideSection(8, "configurations_allowed_usage")).nagUser();
    }

    public void warnAboutNeedToMutateUsage(DeprecatableConfiguration var1);

    public void failOnInabilityToMutateUsage();

    public Configuration verifyExistingConfigurationUsage(Configuration var1);

    public static final class UnmodifiableUsageException
    extends GradleException
    implements ResolutionProvider {
        private final List<String> resolutions;

        public UnmodifiableUsageException(String configurationName, List<String> resolutions) {
            super(String.format("Gradle cannot mutate the usage of configuration '%s' because it is locked.", configurationName));
            this.resolutions = resolutions;
        }

        public List<String> getResolutions() {
            return Collections.unmodifiableList(this.resolutions);
        }
    }
}

