/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatisticsEventAdapter;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.LoggingConfiguration;
import org.gradle.api.problems.internal.ExceptionProblemRegistry;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.BuildLoggerFactory;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.buildevents.TaskExecutionStatisticsReporter;
import org.gradle.internal.buildtree.BuildActionRunner;
import org.gradle.internal.buildtree.BuildTreeLifecycleController;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.invocation.BuildAction;
import org.gradle.internal.logging.text.StyledTextOutputFactory;

public class BuildOutcomeReportingBuildActionRunner
implements BuildActionRunner {
    private final ListenerManager listenerManager;
    private final BuildActionRunner delegate;
    private final BuildStartedTime buildStartedTime;
    private final BuildRequestMetaData buildRequestMetaData;
    private final StyledTextOutputFactory styledTextOutputFactory;
    private final BuildLoggerFactory buildLoggerFactory;
    private final ExceptionProblemRegistry registry;

    public BuildOutcomeReportingBuildActionRunner(StyledTextOutputFactory styledTextOutputFactory, ListenerManager listenerManager, BuildActionRunner delegate, BuildStartedTime buildStartedTime, BuildRequestMetaData buildRequestMetaData, BuildLoggerFactory buildLoggerFactory, ExceptionProblemRegistry registry) {
        this.styledTextOutputFactory = styledTextOutputFactory;
        this.listenerManager = listenerManager;
        this.delegate = delegate;
        this.buildStartedTime = buildStartedTime;
        this.buildRequestMetaData = buildRequestMetaData;
        this.buildLoggerFactory = buildLoggerFactory;
        this.registry = registry;
    }

    public BuildActionRunner.Result run(BuildAction action, BuildTreeLifecycleController buildController) {
        StartParameterInternal startParameter = action.getStartParameter();
        TaskExecutionStatisticsEventAdapter taskStatisticsCollector = new TaskExecutionStatisticsEventAdapter();
        this.listenerManager.addListener((Object)taskStatisticsCollector);
        BuildLogger buildLogger = this.buildLoggerFactory.create(Logging.getLogger(BuildLogger.class), (LoggingConfiguration)startParameter, this.buildStartedTime, this.buildRequestMetaData);
        buildController.beforeBuild(gradle -> BuildOutcomeReportingBuildActionRunner.callUseLogger(gradle, buildLogger));
        BuildActionRunner.Result result = this.delegate.run(action, buildController);
        buildLogger.logResult(result.getBuildFailure(), this.registry.getProblemLocator());
        new TaskExecutionStatisticsReporter(this.styledTextOutputFactory).buildFinished(taskStatisticsCollector.getStatistics());
        return result;
    }

    private static void callUseLogger(GradleInternal gradle, BuildLogger logger) {
        gradle.useLogger((Object)logger);
    }
}

