/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import org.gradle.api.NonNullApi;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.vfs.VirtualFileSystem;
import org.gradle.internal.watch.vfs.BuildLifecycleAwareVirtualFileSystem;
import org.gradle.launcher.daemon.protocol.Build;
import org.gradle.launcher.daemon.server.api.DaemonCommandExecution;
import org.gradle.launcher.daemon.server.exec.BuildCommandOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class CleanUpVirtualFileSystemAfterBuild
extends BuildCommandOnly
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpVirtualFileSystemAfterBuild.class);
    private final GradleUserHomeScopeServiceRegistry userHomeServiceRegistry;
    private final ManagedExecutor executor;
    private CompletableFuture<Void> pendingCleanup = CompletableFuture.completedFuture(null);

    public CleanUpVirtualFileSystemAfterBuild(ExecutorFactory executorFactory, GradleUserHomeScopeServiceRegistry userHomeServiceRegistry) {
        this.executor = executorFactory.create("VFS cleanup");
        this.userHomeServiceRegistry = userHomeServiceRegistry;
    }

    @Override
    protected void doBuild(DaemonCommandExecution execution, Build build) {
        this.waitForPendingCleanupToFinish(this.pendingCleanup);
        try {
            execution.proceed();
        }
        finally {
            this.pendingCleanup = this.startAsyncCleanupAfterBuild();
        }
    }

    private CompletableFuture<Void> startAsyncCleanupAfterBuild() {
        return this.userHomeServiceRegistry.getCurrentServices().map(serviceRegistry -> CompletableFuture.runAsync(() -> {
            LOGGER.debug("Cleaning virtual file system after build finished");
            BuildLifecycleAwareVirtualFileSystem virtualFileSystem = (BuildLifecycleAwareVirtualFileSystem)serviceRegistry.get(BuildLifecycleAwareVirtualFileSystem.class);
            virtualFileSystem.afterBuildFinished();
        }, (Executor)this.executor)).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    private void waitForPendingCleanupToFinish(CompletableFuture<Void> pendingCleanup) {
        if (!pendingCleanup.isDone()) {
            LOGGER.debug("Waiting for pending virtual file system cleanup to be finished");
            try {
                pendingCleanup.get();
            }
            catch (InterruptedException | ExecutionException e) {
                LOGGER.error("Couldn't clean up VFS between builds, dropping content", (Throwable)e);
                this.userHomeServiceRegistry.getCurrentServices().ifPresent(serviceRegistry -> {
                    VirtualFileSystem virtualFileSystem = (VirtualFileSystem)serviceRegistry.get(VirtualFileSystem.class);
                    virtualFileSystem.invalidateAll();
                });
            }
        }
    }

    public void stop() {
        this.executor.shutdownNow();
    }
}

