/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (uvec3(36u, 32u, 88u) * uvec3(36u, 32u, 88u)) => uvec3(1296u, 1024u, 7744u)
 * (uvec3(36u, 32u, 88u) * uvec3(59u, 77u, 68u)) => uvec3(2124u, 2464u, 5984u)
 * (uvec3(59u, 77u, 68u) * uvec3(36u, 32u, 88u)) => uvec3(2124u, 2464u, 5984u)
 * (uvec3(59u, 77u, 68u) * uvec3(59u, 77u, 68u)) => uvec3(3481u, 5929u, 4624u)
 */
#version 130

void main()
{
  float[all(equal((uvec3(36u, 32u, 88u) * uvec3(36u, 32u, 88u)), uvec3(1296u, 1024u, 7744u))) ? 1 : -1] array0;
  float[all(equal((uvec3(36u, 32u, 88u) * uvec3(59u, 77u, 68u)), uvec3(2124u, 2464u, 5984u))) ? 1 : -1] array1;
  float[all(equal((uvec3(59u, 77u, 68u) * uvec3(36u, 32u, 88u)), uvec3(2124u, 2464u, 5984u))) ? 1 : -1] array2;
  float[all(equal((uvec3(59u, 77u, 68u) * uvec3(59u, 77u, 68u)), uvec3(3481u, 5929u, 4624u))) ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
