/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.spi.model;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.ops4j.pax.web.service.spi.model.Identity;
import org.ops4j.pax.web.service.spi.model.elements.ErrorPageModel;
import org.ops4j.pax.web.service.spi.model.elements.FilterModel;
import org.ops4j.pax.web.service.spi.model.elements.ServletModel;
import org.ops4j.pax.web.service.spi.model.elements.WebSocketModel;

public final class ServletContextModel
extends Identity {
    private final String contextPath;
    private final Map<String, ServletModel> servletNameMapping = new HashMap<String, ServletModel>();
    private final Map<String, ServletModel> aliasMapping = new HashMap<String, ServletModel>();
    private final Map<String, ServletModel> servletUrlPatternMapping = new HashMap<String, ServletModel>();
    private final Map<String, FilterModel> filterNameMapping = new HashMap<String, FilterModel>();
    private final Map<String, WebSocketModel> webSocketUrlPathMapping = new HashMap<String, WebSocketModel>();
    private final Map<String, ErrorPageModel> errorPageMapping = new HashMap<String, ErrorPageModel>();

    public ServletContextModel(String contextPath) {
        this.contextPath = contextPath;
    }

    public void enableServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.aliasMapping.put(model.getAlias(), model);
        }
        Arrays.stream(model.getUrlPatterns()).forEach(p -> this.servletUrlPatternMapping.put((String)p, model));
        this.servletNameMapping.put(model.getName(), model);
    }

    public void disableServletModel(ServletModel model) {
        if (model.getAlias() != null) {
            this.aliasMapping.remove(model.getAlias());
        }
        this.servletUrlPatternMapping.entrySet().removeIf(e -> ((ServletModel)e.getValue()).equals(model));
        this.servletNameMapping.remove(model.getName());
    }

    public void enableFilterModel(FilterModel model) {
        this.filterNameMapping.put(model.getName(), model);
    }

    public void disableFilterModel(FilterModel model) {
        this.filterNameMapping.remove(model.getName());
    }

    public void enableErrorPageModel(ErrorPageModel model) {
        for (String page : model.getErrorPages()) {
            this.errorPageMapping.put(page, model);
        }
    }

    public void disableErrorPageModel(ErrorPageModel model) {
        for (String page : model.getErrorPages()) {
            this.errorPageMapping.remove(page);
        }
    }

    public void enableWebSocketModel(WebSocketModel model) {
        this.webSocketUrlPathMapping.put(model.getMappedPath(), model);
    }

    public void disableWebSocketModel(WebSocketModel model) {
        this.webSocketUrlPathMapping.remove(model.getMappedPath());
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public Map<String, ServletModel> getServletNameMapping() {
        return this.servletNameMapping;
    }

    public Map<String, FilterModel> getFilterNameMapping() {
        return this.filterNameMapping;
    }

    public Map<String, ServletModel> getAliasMapping() {
        return this.aliasMapping;
    }

    public Map<String, ServletModel> getServletUrlPatternMapping() {
        return this.servletUrlPatternMapping;
    }

    public Map<String, ErrorPageModel> getErrorPageMapping() {
        return this.errorPageMapping;
    }

    public Map<String, WebSocketModel> getWebSocketUrlPathMapping() {
        return this.webSocketUrlPathMapping;
    }

    @Override
    public String toString() {
        return "ServletContextModel{id=" + this.getId() + ",contextPath='" + this.contextPath + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServletContextModel that = (ServletContextModel)o;
        return this.contextPath.equals(that.contextPath);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.contextPath);
    }
}

