/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.xml;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.jupnp.xml.CatalogResourceResolver;
import org.jupnp.xml.DOM;
import org.jupnp.xml.DOMElement;
import org.jupnp.xml.ParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class DOMParser<D extends DOM>
implements ErrorHandler,
EntityResolver {
    private final Logger logger = LoggerFactory.getLogger(DOMParser.class);
    public static final URL XML_SCHEMA_RESOURCE = Thread.currentThread().getContextClassLoader().getResource("org.jupnp/schemas/xml.xsd");
    protected Source[] schemaSources;
    protected Schema schema;

    protected DOMParser() {
        this(null);
    }

    protected DOMParser(Source[] schemaSources) {
        this.schemaSources = schemaSources;
    }

    public Schema getSchema() {
        if (this.schema == null) {
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                schemaFactory.setResourceResolver(new CatalogResourceResolver((Map<URI, URL>)new HashMap<URI, URL>(){
                    {
                        this.put(DOM.XML_SCHEMA_NAMESPACE, XML_SCHEMA_RESOURCE);
                    }
                }));
                this.schema = this.schemaSources != null ? schemaFactory.newSchema(this.schemaSources) : schemaFactory.newSchema();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.schema;
    }

    protected abstract D createDOM(Document var1);

    public DocumentBuilderFactory createFactory(boolean validating) throws ParserException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setNamespaceAware(true);
            if (validating) {
                factory.setXIncludeAware(true);
                factory.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", false);
                factory.setFeature("http://apache.org/xml/features/xinclude/fixup-language", false);
                factory.setSchema(this.getSchema());
                factory.setFeature("http://apache.org/xml/features/validation/dynamic", true);
            }
        }
        catch (ParserConfigurationException e) {
            throw new ParserException(e);
        }
        return factory;
    }

    public Transformer createTransformer(String method, int indent, boolean standalone) throws ParserException {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            if (indent > 0) {
                try {
                    transFactory.setAttribute("indent-number", indent);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            Transformer transformer = transFactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", standalone ? "no" : "yes");
            if (standalone) {
                try {
                    transformer.setOutputProperty("http://www.oracle.com/xml/is-standalone", "yes");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            transformer.setOutputProperty("indent", indent > 0 ? "yes" : "no");
            if (indent > 0) {
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
            }
            transformer.setOutputProperty("method", method);
            return transformer;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public D createDocument() {
        try {
            return this.createDOM(this.createFactory(false).newDocumentBuilder().newDocument());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public D parse(URL url) throws ParserException {
        return this.parse(url, true);
    }

    public D parse(String string) throws ParserException {
        return this.parse(string, true);
    }

    public D parse(File file) throws ParserException {
        return this.parse(file, true);
    }

    public D parse(InputStream stream) throws ParserException {
        return this.parse(stream, true);
    }

    public D parse(URL url, boolean validate) throws ParserException {
        if (url == null) {
            throw new IllegalArgumentException("Can't parse null URL");
        }
        try {
            return this.parse(url.openStream(), validate);
        }
        catch (Exception e) {
            throw new ParserException("Parsing URL failed: " + String.valueOf(url), e);
        }
    }

    public D parse(String string, boolean validate) throws ParserException {
        if (string == null) {
            throw new IllegalArgumentException("Can't parse null string");
        }
        return this.parse(new InputSource(new StringReader(string)), validate);
    }

    public D parse(File file, boolean validate) throws ParserException {
        if (file == null) {
            throw new IllegalArgumentException("Can't parse null file");
        }
        try {
            return this.parse(file.toURI().toURL(), validate);
        }
        catch (Exception e) {
            throw new ParserException("Parsing file failed: " + String.valueOf(file), e);
        }
    }

    public D parse(InputStream stream, boolean validate) throws ParserException {
        return this.parse(new InputSource(stream), validate);
    }

    public D parse(InputSource source, boolean validate) throws ParserException {
        try {
            DocumentBuilder parser = this.createFactory(validate).newDocumentBuilder();
            parser.setEntityResolver(this);
            parser.setErrorHandler(this);
            Document dom = parser.parse(source);
            dom.normalizeDocument();
            return this.createDOM(dom);
        }
        catch (Exception e) {
            throw this.unwrapException(e);
        }
    }

    public void validate(URL url) throws ParserException {
        if (url == null) {
            throw new IllegalArgumentException("Can't validate null URL");
        }
        this.logger.trace("Validating XML of URL: {}", (Object)url);
        this.validate(new StreamSource(url.toString()));
    }

    public void validate(String string) throws ParserException {
        if (string == null) {
            throw new IllegalArgumentException("Can't validate null string");
        }
        this.logger.trace("Validating XML string characters: {}", (Object)string.length());
        this.validate(new SAXSource(new InputSource(new StringReader(string))));
    }

    public void validate(Document document) throws ParserException {
        this.validate(new DOMSource(document));
    }

    public void validate(DOM dom) throws ParserException {
        this.validate(new DOMSource(dom.getW3CDocument()));
    }

    public void validate(Source source) throws ParserException {
        try {
            Validator validator = this.getSchema().newValidator();
            validator.setErrorHandler(this);
            validator.validate(source);
        }
        catch (Exception e) {
            throw this.unwrapException(e);
        }
    }

    public XPathFactory createXPathFactory() {
        return XPathFactory.newInstance();
    }

    public XPath createXPath(NamespaceContext nsContext) {
        XPath xpath = this.createXPathFactory().newXPath();
        xpath.setNamespaceContext(nsContext);
        return xpath;
    }

    public XPath createXPath(XPathFactory factory, NamespaceContext nsContext) {
        XPath xpath = factory.newXPath();
        xpath.setNamespaceContext(nsContext);
        return xpath;
    }

    public Object getXPathResult(DOM dom, XPath xpath, String expr, QName result) {
        return this.getXPathResult(dom.getW3CDocument(), xpath, expr, result);
    }

    public Object getXPathResult(DOMElement element, XPath xpath, String expr, QName result) {
        return this.getXPathResult(element.getW3CElement(), xpath, expr, result);
    }

    public Object getXPathResult(Node context, XPath xpath, String expr, QName result) {
        try {
            this.logger.trace("Evaluating xpath query: {}", (Object)expr);
            return xpath.evaluate(expr, context, result);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String print(DOM dom) throws ParserException {
        return this.print(dom, 4, true);
    }

    public String print(DOM dom, int indent) throws ParserException {
        return this.print(dom, indent, true);
    }

    public String print(DOM dom, boolean standalone) throws ParserException {
        return this.print(dom, 4, standalone);
    }

    public String print(DOM dom, int indent, boolean standalone) throws ParserException {
        return this.print(dom.getW3CDocument(), indent, standalone);
    }

    public String print(Document document, int indent, boolean standalone) throws ParserException {
        this.removeIgnorableWSNodes(document.getDocumentElement());
        return this.print(new DOMSource(document.getDocumentElement()), indent, standalone);
    }

    public String print(String string, int indent, boolean standalone) throws ParserException {
        return this.print(new StreamSource(new StringReader(string)), indent, standalone);
    }

    public String print(Source source, int indent, boolean standalone) throws ParserException {
        try {
            Transformer transformer = this.createTransformer("xml", indent, standalone);
            transformer.setOutputProperty("encoding", "utf-8");
            StringWriter out = new StringWriter();
            transformer.transform(source, new StreamResult(out));
            out.flush();
            return out.toString();
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public String printHTML(Document dom) throws ParserException {
        return this.printHTML(dom, 4, true, true);
    }

    public String printHTML(Document dom, int indent, boolean standalone, boolean doctype) throws ParserException {
        dom = (Document)dom.cloneNode(true);
        DOMParser.accept(dom.getDocumentElement(), new NodeVisitor(4){

            @Override
            public void visit(Node node) {
                CDATASection cdata = (CDATASection)node;
                cdata.getParentNode().setTextContent(cdata.getData());
            }
        });
        this.removeIgnorableWSNodes(dom.getDocumentElement());
        try {
            Transformer transformer = this.createTransformer("html", indent, standalone);
            if (doctype) {
                transformer.setOutputProperty("doctype-public", "-//W3C//DTD HTML 4.01 Transitional//EN");
                transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/html4/loose.dtd");
            }
            StringWriter out = new StringWriter();
            transformer.transform(new DOMSource(dom), new StreamResult(out));
            out.flush();
            String output = out.toString();
            String meta = "\\s*<META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">";
            output = output.replaceFirst(meta, "");
            String xmlns = "<html xmlns=\"http://www.w3.org/1999/xhtml\">";
            output = output.replaceFirst(xmlns, "<html>");
            return output;
        }
        catch (Exception e) {
            throw new ParserException(e);
        }
    }

    public void removeIgnorableWSNodes(Element element) {
        Node nextNode = element.getFirstChild();
        while (nextNode != null) {
            Node child = nextNode;
            nextNode = child.getNextSibling();
            if (this.isIgnorableWSNode(child)) {
                element.removeChild(child);
                continue;
            }
            if (child.getNodeType() != 1) continue;
            this.removeIgnorableWSNodes((Element)child);
        }
    }

    public boolean isIgnorableWSNode(Node node) {
        return node.getNodeType() == 3 && node.getTextContent().matches("[\\t\\n\\x0B\\f\\r\\s]+");
    }

    @Override
    public void warning(SAXParseException e) throws SAXException {
        this.logger.warn(e.toString());
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw new SAXException(new ParserException(e));
    }

    @Override
    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException(new ParserException(e));
    }

    protected ParserException unwrapException(Exception e) {
        if (e.getCause() != null && e.getCause() instanceof ParserException) {
            return (ParserException)e.getCause();
        }
        return new ParserException(e);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource is = systemId.startsWith("file://") ? new InputSource(new FileInputStream(new File(URI.create(systemId)))) : new InputSource(new ByteArrayInputStream(new byte[0]));
        is.setPublicId(publicId);
        is.setSystemId(systemId);
        return is;
    }

    public static String escape(String string) {
        return DOMParser.escape(string, false, false);
    }

    public static String escape(String string, boolean convertNewlines, boolean convertSpaces) {
        if (string == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            String entity = null;
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    entity = "&#60;";
                    break;
                }
                case '>': {
                    entity = "&#62;";
                    break;
                }
                case '&': {
                    entity = "&#38;";
                    break;
                }
                case '\"': {
                    entity = "&#34;";
                }
            }
            if (entity != null) {
                sb.append(entity);
                continue;
            }
            sb.append(c);
        }
        String result = sb.toString();
        if (convertSpaces) {
            Matcher matcher = Pattern.compile("(\\n+)(\\s*)(.*)").matcher(result);
            StringBuilder temp = new StringBuilder();
            while (matcher.find()) {
                String group = matcher.group(2);
                StringBuilder spaces = new StringBuilder();
                spaces.append("&#160;".repeat(group.length()));
                matcher.appendReplacement(temp, "$1" + String.valueOf(spaces) + "$3");
            }
            matcher.appendTail(temp);
            result = temp.toString();
        }
        if (convertNewlines) {
            result = result.replaceAll("\n", "<br/>");
        }
        return result;
    }

    public static String stripElements(String xml) {
        if (xml == null) {
            return null;
        }
        return xml.replaceAll("<([a-zA-Z]|/).*?>", "");
    }

    public static void accept(Node node, NodeVisitor visitor) {
        if (node == null) {
            return;
        }
        if (visitor.isHalted()) {
            return;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            boolean cont = true;
            if (child.getNodeType() == visitor.nodeType) {
                visitor.visit(child);
                if (visitor.isHalted()) break;
            }
            DOMParser.accept(child, visitor);
        }
    }

    public static String wrap(String wrapperName, String fragment) {
        return DOMParser.wrap(wrapperName, null, fragment);
    }

    public static String wrap(String wrapperName, String xmlns, String fragment) {
        StringBuilder wrapper = new StringBuilder();
        wrapper.append("<").append(wrapperName);
        if (xmlns != null) {
            wrapper.append(" xmlns=\"").append(xmlns).append("\"");
        }
        wrapper.append(">");
        wrapper.append(fragment);
        wrapper.append("</").append(wrapperName).append(">");
        return wrapper.toString();
    }

    public static abstract class NodeVisitor {
        private short nodeType;

        protected NodeVisitor(short nodeType) {
            assert (nodeType < 12);
            this.nodeType = nodeType;
        }

        public boolean isHalted() {
            return false;
        }

        public abstract void visit(Node var1);
    }
}

