/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.network.MessageIdTracker;
import org.eclipse.californium.core.network.config.NetworkConfig;
import org.eclipse.californium.elements.util.ClockUtil;

public class MapBasedMessageIdTracker
implements MessageIdTracker {
    private final Map<Integer, Long> messageIds;
    private final long exchangeLifetimeNanos;
    private final int min;
    private final int range;
    private int counter;

    public MapBasedMessageIdTracker(int initialMid, int minMid, int maxMid, NetworkConfig config) {
        if (minMid >= maxMid) {
            throw new IllegalArgumentException("max. MID " + maxMid + " must be larger than min. MID " + minMid + "!");
        }
        if (initialMid < minMid || maxMid <= initialMid) {
            throw new IllegalArgumentException("initial MID " + initialMid + " must be in range [" + minMid + "-" + maxMid + ")!");
        }
        this.exchangeLifetimeNanos = TimeUnit.MILLISECONDS.toNanos(config.getLong("EXCHANGE_LIFETIME"));
        this.counter = initialMid - minMid;
        this.min = minMid;
        this.range = maxMid - minMid;
        this.messageIds = new HashMap<Integer, Long>(this.range);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNextMessageId() {
        int result = -1;
        boolean wrapped = false;
        long now = ClockUtil.nanoRealtime();
        Map<Integer, Long> map = this.messageIds;
        synchronized (map) {
            int startIdx = this.counter = (this.counter & 0xFFFF) % this.range;
            while (result < 0 && !wrapped) {
                int idx;
                Long earliestUsage;
                if ((earliestUsage = this.messageIds.get(idx = this.counter++ % this.range)) == null || earliestUsage - now <= 0L) {
                    result = idx + this.min;
                    this.messageIds.put(idx, now + this.exchangeLifetimeNanos);
                }
                wrapped = this.counter % this.range == startIdx;
            }
        }
        return result;
    }
}

