/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.core.Inets;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.NativePacketDllMappings;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapIpV4Address;
import org.pcap4j.core.PcapIpV6Address;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcapNetworkInterface {
    private static final Logger logger = LoggerFactory.getLogger(PcapNetworkInterface.class);
    private static final int PCAP_IF_LOOPBACK = 1;
    private static final int PCAP_IF_UP = 2;
    private static final int PCAP_IF_RUNNING = 4;
    private final String name;
    private final String description;
    private final List<PcapAddress> addresses = new ArrayList<PcapAddress>();
    private final List<LinkLayerAddress> linkLayerAddresses = new ArrayList<LinkLayerAddress>();
    private final boolean loopBack;
    private final boolean up;
    private final boolean running;
    private final boolean local;

    private PcapNetworkInterface(NativeMappings.pcap_if pif, boolean local) {
        MacAddress mac;
        this.name = pif.name;
        this.description = pif.description;
        NativeMappings.pcap_addr.ByReference pcapAddr = pif.addresses;
        while (pcapAddr != null) {
            if (pcapAddr.addr == null && pcapAddr.netmask == null && pcapAddr.broadaddr == null && pcapAddr.dstaddr == null) {
                logger.warn("Empty pcap_addr on {} ({}). Ignore it.", (Object)this.name, (Object)this.description);
            } else {
                byte[] addr;
                short sa_family;
                short s2 = pcapAddr.addr != null ? pcapAddr.addr.getSaFamily() : (pcapAddr.netmask != null ? pcapAddr.netmask.getSaFamily() : (pcapAddr.broadaddr != null ? pcapAddr.broadaddr.getSaFamily() : (sa_family = pcapAddr.dstaddr != null ? pcapAddr.dstaddr.getSaFamily() : (short)0)));
                if (sa_family == Inets.AF_INET) {
                    this.addresses.add(PcapIpV4Address.newInstance(pcapAddr, sa_family, this.name));
                } else if (sa_family == Inets.AF_INET6) {
                    this.addresses.add(PcapIpV6Address.newInstance(pcapAddr, sa_family, this.name));
                } else if (Platform.isLinux() && sa_family == Inets.AF_PACKET) {
                    NativeMappings.sockaddr_ll sll = new NativeMappings.sockaddr_ll(pcapAddr.addr.getPointer());
                    addr = sll.sll_addr;
                    int addrLength = sll.sll_halen & 0xFF;
                    if (addrLength == 6) {
                        this.linkLayerAddresses.add(ByteArrays.getMacAddress(addr, 0));
                    } else if (addr.length != 0) {
                        addrLength = addrLength <= addr.length ? addrLength : addr.length;
                        this.linkLayerAddresses.add(LinkLayerAddress.getByAddress(ByteArrays.getSubArray(addr, 0, addrLength)));
                    }
                } else if (Platform.isMac() || Platform.isFreeBSD() || Platform.isOpenBSD() || Platform.iskFreeBSD() && sa_family == Inets.AF_LINK) {
                    NativeMappings.sockaddr_dl sdl = new NativeMappings.sockaddr_dl(pcapAddr.addr.getPointer());
                    addr = sdl.getAddress();
                    if (addr.length == 6) {
                        this.linkLayerAddresses.add(MacAddress.getByAddress(addr));
                    } else if (addr.length != 0) {
                        this.linkLayerAddresses.add(LinkLayerAddress.getByAddress(addr));
                    }
                } else {
                    logger.warn("{} is not supported address family. Ignore it.", (Object)sa_family);
                }
            }
            pcapAddr = pcapAddr.next;
        }
        if (Platform.isWindows() && (mac = this.getMacAddress(this.name)) != null) {
            this.linkLayerAddresses.add(mac);
        }
        this.loopBack = (pif.flags & 1) != 0;
        this.up = (pif.flags & 2) != 0;
        this.running = (pif.flags & 4) != 0;
        this.local = local;
    }

    static PcapNetworkInterface newInstance(NativeMappings.pcap_if pif, boolean local) {
        return new PcapNetworkInterface(pif, local);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PcapAddress> getAddresses() {
        return new ArrayList<PcapAddress>(this.addresses);
    }

    public ArrayList<LinkLayerAddress> getLinkLayerAddresses() {
        return new ArrayList<LinkLayerAddress>(this.linkLayerAddresses);
    }

    public boolean isLoopBack() {
        return this.loopBack;
    }

    public boolean isUp() {
        return this.up;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isLocal() {
        return this.local;
    }

    public PcapHandle openLive(int snaplen, PromiscuousMode mode, int timeoutMillis) throws PcapNativeException {
        if (mode == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("mode: ").append((Object)mode);
            throw new NullPointerException(sb.toString());
        }
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Pointer handle = NativeMappings.pcap_open_live(this.name, snaplen, mode.getValue(), timeoutMillis, errbuf);
        if (handle == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        if (timeoutMillis == 0 && Platform.isSolaris()) {
            NativeMappings.timeval to = new NativeMappings.timeval();
            to.tv_sec = new NativeLong(0L);
            to.tv_usec = new NativeLong(0L);
            int rc = NativeMappings.PcapLibrary.INSTANCE.strioctl(NativeMappings.getFdFromPcapT(handle), 16897, to.size(), to.getPointer());
            if (rc < 0) {
                throw new PcapNativeException("SBIOCSTIME: " + NativeMappings.pcap_strerror(NativeMappings.ERRNO_P.getInt(0L)).getString(0L));
            }
        }
        return new PcapHandle(handle, PcapHandle.TimestampPrecision.MICRO);
    }

    private MacAddress getMacAddress(String nifName) {
        Pointer lpAdapter = NativePacketDllMappings.PacketOpenAdapter(nifName);
        long hFile = -1L;
        if (lpAdapter != null) {
            hFile = Native.POINTER_SIZE == 4 ? (long)lpAdapter.getInt(0L) : lpAdapter.getLong(0L);
        }
        if (hFile == -1L) {
            int err = Native.getLastError();
            logger.error("Unable to open the NIF {}, Error Code: {}", (Object)nifName, (Object)err);
            return null;
        }
        Memory mem = new Memory(NativePacketDllMappings.PACKET_OID_DATA_SIZE);
        mem.clear();
        NativePacketDllMappings.PACKET_OID_DATA oidData = new NativePacketDllMappings.PACKET_OID_DATA(mem);
        oidData.Length = new NativeLong(6L);
        oidData.Oid = new NativeLong(0x1010102L);
        int status = NativePacketDllMappings.PacketRequest(lpAdapter, 0, oidData);
        NativePacketDllMappings.PacketCloseAdapter(lpAdapter);
        if (status == 0) {
            logger.error("Failed to retrieve the link layer address of the NIF: {}", (Object)nifName);
            return null;
        }
        return MacAddress.getByAddress(oidData.Data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(250);
        sb.append("name: [").append(this.name).append("] description: [").append(this.description);
        for (PcapAddress pcapAddress : this.addresses) {
            sb.append("] address: [").append(pcapAddress.getAddress());
        }
        for (LinkLayerAddress linkLayerAddress : this.linkLayerAddresses) {
            sb.append("] link layer address: [").append(linkLayerAddress.getAddress());
        }
        sb.append("] loopBack: [").append(this.loopBack).append("]");
        sb.append("] up: [").append(this.up).append("]");
        sb.append("] running: [").append(this.running).append("]");
        sb.append("] local: [").append(this.local).append("]");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.addresses.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + this.linkLayerAddresses.hashCode();
        result = 31 * result + (this.local ? 1231 : 1237);
        result = 31 * result + (this.loopBack ? 1231 : 1237);
        result = 31 * result + (this.up ? 1231 : 1237);
        result = 31 * result + (this.running ? 1231 : 1237);
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PcapNetworkInterface)) {
            return false;
        }
        PcapNetworkInterface other = (PcapNetworkInterface)obj;
        if (!this.addresses.equals(other.addresses)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (!this.linkLayerAddresses.equals(other.linkLayerAddresses)) {
            return false;
        }
        if (this.local != other.local) {
            return false;
        }
        if (this.loopBack != other.loopBack) {
            return false;
        }
        if (this.up != other.up) {
            return false;
        }
        if (this.running != other.running) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public static enum PromiscuousMode {
        PROMISCUOUS(1),
        NONPROMISCUOUS(0);

        private final int value;

        private PromiscuousMode(int value2) {
            this.value = value2;
        }

        public int getValue() {
            return this.value;
        }
    }
}

