/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.CSSUnit;
import io.sf.carte.doc.style.css.CSSValueSyntax;

class Dimension {
    CSSValueSyntax.Category category;
    int exponent = 0;
    private Dimension prevDimension = null;
    private Dimension nextDimension = null;
    transient boolean lengthProcessed;
    transient boolean percentageProcessed;
    transient short exponentAccuracy;

    Dimension() {
    }

    public Dimension getFirst() {
        Dimension lastNonNull = this;
        Dimension next = this.prevDimension;
        while (next != null) {
            lastNonNull = next;
            next = next.prevDimension;
        }
        return lastNonNull;
    }

    public Dimension getNext() {
        return this.nextDimension;
    }

    public boolean isLengthProcessed() {
        return this.lengthProcessed;
    }

    public boolean isPercentageProcessed() {
        return this.percentageProcessed;
    }

    public Dimension incrExponent() {
        ++this.exponent;
        if (this.exponent == 0) {
            return this.remove();
        }
        return this.getFirst();
    }

    public Dimension decrExponent() {
        --this.exponent;
        if (this.exponent == 0) {
            return this.remove();
        }
        return this.getFirst();
    }

    public boolean sum(Dimension otherdim) {
        Dimension dim = this;
        do {
            if (!dim.sumDimension(otherdim)) {
                return false;
            }
            dim = dim.getNext();
            otherdim = otherdim.getNext();
            if (dim != null) continue;
            return otherdim == null;
        } while (otherdim != null);
        return false;
    }

    public boolean sumDimension(Dimension newdim) {
        if (this.category == newdim.category) {
            if (this.category == CSSValueSyntax.Category.lengthPercentage) {
                this.lengthProcessed = this.lengthProcessed || newdim.lengthProcessed;
                this.percentageProcessed = this.percentageProcessed || newdim.percentageProcessed;
            }
            return this.checkExponent(newdim);
        }
        switch (this.category) {
            case length: {
                if (newdim.category == CSSValueSyntax.Category.lengthPercentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.percentageProcessed = this.percentageProcessed || newdim.percentageProcessed;
                    break;
                }
                if (newdim.category == CSSValueSyntax.Category.percentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case percentage: {
                if (newdim.category == CSSValueSyntax.Category.lengthPercentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.lengthProcessed = this.lengthProcessed || newdim.lengthProcessed;
                    break;
                }
                if (newdim.category == CSSValueSyntax.Category.length) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.lengthProcessed = true;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (newdim.category == CSSValueSyntax.Category.length) {
                    this.lengthProcessed = true;
                    break;
                }
                if (newdim.category == CSSValueSyntax.Category.percentage) {
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case number: {
                if (newdim.category == CSSValueSyntax.Category.integer) break;
                return false;
            }
            case integer: {
                if (newdim.category == CSSValueSyntax.Category.number) {
                    this.category = CSSValueSyntax.Category.number;
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return this.checkExponent(newdim);
    }

    private boolean checkExponent(Dimension newdim) {
        if (this.exponent != newdim.exponent) {
            if (this.exponentAccuracy == 0) {
                if (newdim.exponentAccuracy == 0) {
                    return false;
                }
            } else if (newdim.exponentAccuracy == 0) {
                this.exponent = newdim.exponent;
            }
        }
        return true;
    }

    public Dimension multiply(Dimension otherdim) {
        block0: do {
            Dimension dim = this;
            do {
                if (!dim.multiplyDimension(otherdim)) continue;
                if (this.exponent != 0) continue block0;
                return this.remove();
            } while ((dim = dim.getNext()) != null);
            this.append(otherdim);
        } while ((otherdim = otherdim.getNext()) != null);
        return this;
    }

    private boolean multiplyDimension(Dimension otherdim) {
        if (this.category == otherdim.category) {
            this.exponent += otherdim.exponent;
            return true;
        }
        if (otherdim.category == CSSValueSyntax.Category.number || otherdim.category == CSSValueSyntax.Category.integer) {
            return true;
        }
        Dimension dim = this;
        switch (dim.category) {
            case number: 
            case integer: {
                this.category = otherdim.category;
                this.exponent = otherdim.exponent;
                break;
            }
            case length: {
                if (otherdim.category == CSSValueSyntax.Category.lengthPercentage || otherdim.category == CSSValueSyntax.Category.percentage) {
                    dim.category = CSSValueSyntax.Category.lengthPercentage;
                    dim.exponent += otherdim.exponent;
                    break;
                }
                return false;
            }
            case percentage: {
                if (otherdim.category == CSSValueSyntax.Category.lengthPercentage || otherdim.category == CSSValueSyntax.Category.length) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.exponent += otherdim.exponent;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (otherdim.category == CSSValueSyntax.Category.length) {
                    this.exponent += otherdim.exponent;
                    this.lengthProcessed = true;
                    break;
                }
                if (otherdim.category == CSSValueSyntax.Category.percentage) {
                    this.exponent += otherdim.exponent;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case frequency: {
                if (otherdim.category == CSSValueSyntax.Category.time) {
                    this.exponent -= otherdim.exponent;
                    break;
                }
                return false;
            }
            case time: {
                if (otherdim.category == CSSValueSyntax.Category.frequency) {
                    this.exponent -= otherdim.exponent;
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Dimension divide(Dimension otherdim) {
        block0: do {
            Dimension dim = this;
            do {
                if (!dim.divideDimension(otherdim)) continue;
                if (this.exponent != 0) continue block0;
                return this.remove();
            } while ((dim = dim.getNext()) != null);
            this.append(otherdim);
        } while ((otherdim = otherdim.getNext()) != null);
        return this;
    }

    private boolean divideDimension(Dimension otherdim) {
        if (this.category == otherdim.category) {
            this.exponent -= otherdim.exponent;
            return true;
        }
        if (otherdim.category == CSSValueSyntax.Category.number || otherdim.category == CSSValueSyntax.Category.integer) {
            return true;
        }
        switch (this.category) {
            case number: 
            case integer: {
                this.category = otherdim.category;
                this.exponent = -otherdim.exponent;
                if (this.exponent != -1) break;
                if (this.category == CSSValueSyntax.Category.time) {
                    this.category = CSSValueSyntax.Category.frequency;
                    this.exponent = 1;
                    break;
                }
                if (this.category != CSSValueSyntax.Category.frequency) break;
                this.category = CSSValueSyntax.Category.time;
                this.exponent = 1;
                break;
            }
            case length: {
                if (otherdim.category == CSSValueSyntax.Category.lengthPercentage || otherdim.category == CSSValueSyntax.Category.percentage) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.exponent -= otherdim.exponent;
                    break;
                }
                return false;
            }
            case percentage: {
                if (otherdim.category == CSSValueSyntax.Category.lengthPercentage || otherdim.category == CSSValueSyntax.Category.length) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.exponent -= otherdim.exponent;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (otherdim.category == CSSValueSyntax.Category.length) {
                    this.exponent -= otherdim.exponent;
                    this.lengthProcessed = true;
                    break;
                }
                if (otherdim.category == CSSValueSyntax.Category.percentage) {
                    this.exponent -= otherdim.exponent;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case frequency: {
                if (otherdim.category == CSSValueSyntax.Category.time) {
                    this.exponent += otherdim.exponent;
                    break;
                }
                return false;
            }
            case time: {
                if (otherdim.category == CSSValueSyntax.Category.frequency) {
                    this.exponent += otherdim.exponent;
                    break;
                }
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean sumUnit(short unit) {
        switch (this.category) {
            case number: 
            case integer: {
                return unit == 0;
            }
            case length: {
                if (CSSUnit.isLengthUnitType(unit)) {
                    this.lengthProcessed = true;
                    break;
                }
                if (unit == 2) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.percentageProcessed = true;
                    break;
                }
                return false;
            }
            case percentage: {
                if (unit == 2) {
                    this.percentageProcessed = true;
                    break;
                }
                if (CSSUnit.isLengthUnitType(unit)) {
                    this.category = CSSValueSyntax.Category.lengthPercentage;
                    this.lengthProcessed = true;
                    break;
                }
                return false;
            }
            case lengthPercentage: {
                if (unit == 2) {
                    this.percentageProcessed = true;
                    return true;
                }
                if (CSSUnit.isLengthUnitType(unit)) {
                    this.lengthProcessed = true;
                    return true;
                }
            }
            case angle: {
                return CSSUnit.isAngleUnitType(unit);
            }
            case time: {
                return CSSUnit.isTimeUnitType(unit);
            }
            case frequency: {
                return unit == 100 || unit == 101;
            }
            case flex: {
                return unit == 70;
            }
            case resolution: {
                return CSSUnit.isResolutionUnitType(unit);
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public Dimension multiplyByUnit(short unit) {
        Dimension dim;
        block40: {
            if (unit == 0) {
                return this;
            }
            dim = this;
            if (CSSUnit.isLengthUnitType(unit)) {
                while (true) {
                    if (this.category == CSSValueSyntax.Category.length) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.percentage) {
                        dim.category = CSSValueSyntax.Category.lengthPercentage;
                        dim = dim.incrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.lengthPercentage) {
                        dim = dim.incrExponent();
                        this.lengthProcessed = true;
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.length;
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.length;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (unit == 2) {
                while (true) {
                    switch (dim.category) {
                        case lengthPercentage: {
                            this.percentageProcessed = true;
                        }
                        case percentage: {
                            dim = dim.incrExponent();
                            break block40;
                        }
                        case length: {
                            dim.category = CSSValueSyntax.Category.lengthPercentage;
                            dim = dim.incrExponent();
                            break block40;
                        }
                        case number: 
                        case integer: {
                            dim.exponent = 1;
                            dim.category = CSSValueSyntax.Category.percentage;
                            break block40;
                        }
                        default: {
                            Dimension nextdim = dim.getNext();
                            if (nextdim == null) {
                                Dimension newdim = new Dimension();
                                newdim.category = CSSValueSyntax.Category.percentage;
                                newdim.exponent = 1;
                                dim.append(newdim);
                                break block40;
                            }
                            dim = nextdim;
                            break;
                        }
                    }
                }
            }
            if (CSSUnit.isAngleUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.angle) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.angle;
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.angle;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (CSSUnit.isTimeUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.time) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.time;
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.frequency) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.time;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (unit == 100 || unit == 101) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.frequency) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.frequency;
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.time) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.frequency;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (CSSUnit.isResolutionUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.resolution) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.resolution;
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.resolution;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            throw new IllegalStateException("Do not know how to handle unit " + unit);
        }
        if (this.exponent == 0) {
            return this.remove();
        }
        return dim;
    }

    public Dimension divideByUnit(short unit) {
        Dimension dim;
        block40: {
            if (unit == 0) {
                return this;
            }
            dim = this;
            if (CSSUnit.isLengthUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.length) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.percentage) {
                        dim.category = CSSValueSyntax.Category.lengthPercentage;
                        dim = dim.decrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.lengthPercentage) {
                        dim = dim.decrExponent();
                        this.lengthProcessed = true;
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = -1;
                        dim.category = CSSValueSyntax.Category.length;
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.length;
                        newdim.exponent = -1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (unit == 2) {
                while (true) {
                    switch (dim.category) {
                        case length: {
                            dim.category = CSSValueSyntax.Category.lengthPercentage;
                        }
                        case lengthPercentage: {
                            this.percentageProcessed = true;
                        }
                        case percentage: {
                            dim = dim.decrExponent();
                            break block40;
                        }
                        case number: 
                        case integer: {
                            dim.exponent = -1;
                            dim.category = CSSValueSyntax.Category.percentage;
                            break block40;
                        }
                        default: {
                            Dimension nextdim = dim.getNext();
                            if (nextdim == null) {
                                Dimension newdim = new Dimension();
                                newdim.category = CSSValueSyntax.Category.percentage;
                                newdim.exponent = -1;
                                dim.append(newdim);
                                break block40;
                            }
                            dim = nextdim;
                            break;
                        }
                    }
                }
            }
            if (CSSUnit.isAngleUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.angle) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = -1;
                        dim.category = CSSValueSyntax.Category.angle;
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.angle;
                        newdim.exponent = -1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (CSSUnit.isTimeUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.time) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.frequency;
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.frequency) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.frequency;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (unit == 100 || unit == 101) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.frequency) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = 1;
                        dim.category = CSSValueSyntax.Category.time;
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.time) {
                        dim = dim.incrExponent();
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.time;
                        newdim.exponent = 1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            if (CSSUnit.isResolutionUnitType(unit)) {
                while (true) {
                    if (dim.category == CSSValueSyntax.Category.resolution) {
                        dim = dim.decrExponent();
                        break block40;
                    }
                    if (dim.category == CSSValueSyntax.Category.number || dim.category == CSSValueSyntax.Category.integer) {
                        dim.exponent = -1;
                        dim.category = CSSValueSyntax.Category.resolution;
                        break block40;
                    }
                    Dimension nextdim = dim.getNext();
                    if (nextdim == null) {
                        Dimension newdim = new Dimension();
                        newdim.category = CSSValueSyntax.Category.resolution;
                        newdim.exponent = -1;
                        dim.append(newdim);
                        break block40;
                    }
                    dim = nextdim;
                }
            }
            throw new IllegalStateException("Do not know how to handle unit " + unit);
        }
        if (this.exponent == 0) {
            return this.remove();
        }
        return dim;
    }

    public Dimension remove() {
        if (this.nextDimension == null) {
            if (this.prevDimension == null) {
                this.category = CSSValueSyntax.Category.number;
                this.exponent = 0;
                return this;
            }
            return this.prevDimension.getFirst();
        }
        this.nextDimension.prevDimension = this.prevDimension;
        if (this.prevDimension != null) {
            this.prevDimension.nextDimension = this.nextDimension;
            return this.prevDimension.getFirst();
        }
        return this.nextDimension;
    }

    public void append(Dimension dim) {
        if (this.nextDimension != null) {
            this.nextDimension.prevDimension = dim;
        }
        dim.nextDimension = this.nextDimension;
        this.nextDimension = dim;
        dim.prevDimension = this;
    }

    public boolean isCSS() {
        return this.nextDimension == null && (this.exponent == 1 || this.exponent == 0 || this.exponentAccuracy != 0);
    }

    public CSSValueSyntax.Match matches(CSSValueSyntax syntax) {
        CSSValueSyntax.Category cat;
        if (this.nextDimension == null && (this.category == (cat = syntax.getCategory()) || this.category == CSSValueSyntax.Category.length && cat == CSSValueSyntax.Category.lengthPercentage || this.category == CSSValueSyntax.Category.percentage && cat == CSSValueSyntax.Category.lengthPercentage || this.category == CSSValueSyntax.Category.integer && cat == CSSValueSyntax.Category.number || this.category == CSSValueSyntax.Category.number && cat == CSSValueSyntax.Category.integer) && this.nextDimension == null) {
            if (this.exponentAccuracy == 2) {
                return CSSValueSyntax.Match.PENDING;
            }
            if (this.exponent == 1 || this.exponent == 0 || this.exponentAccuracy == 1) {
                return CSSValueSyntax.Match.TRUE;
            }
        }
        return CSSValueSyntax.Match.FALSE;
    }

    public String toString() {
        return this.category.name() + '^' + Integer.toString(this.exponent);
    }
}

