/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.critic;

import ca.sqlpower.architect.ddl.critic.CriticAndSettings;
import ca.sqlpower.architect.ddl.critic.CriticFix;
import ca.sqlpower.architect.ddl.critic.CriticismBucket;
import ca.sqlpower.architect.diff.SQLObjectComparator;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.critic.CriticismObjectRenderer;
import ca.sqlpower.architect.swingui.critic.CriticismTableModel;
import ca.sqlpower.architect.swingui.critic.QuickFixListCellRenderer;
import ca.sqlpower.architect.swingui.critic.SeverityTableCellRenderer;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.table.FancyExportableJTable;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.Document;

public class CriticSwingUtil {
    public static final ImageIcon ERROR_ICON = SPSUtils.createIcon((String)"error", (String)"error badge");
    public static final ImageIcon WARNING_ICON = SPSUtils.createIcon((String)"warning", (String)"warning badge");

    private CriticSwingUtil() {
    }

    public static FancyExportableJTable createCriticTable(ArchitectSwingSession session, CriticismBucket bucket) {
        return CriticSwingUtil.createCriticTable(session, bucket, null);
    }

    public static FancyExportableJTable createCriticTable(ArchitectSwingSession session, CriticismBucket bucket, Document searchDoc) {
        final CriticismTableModel tableModel = new CriticismTableModel(session, bucket);
        final FancyExportableJTable errorTable = new FancyExportableJTable((TableModel)tableModel, searchDoc);
        errorTable.setDefaultRenderer(CriticAndSettings.Severity.class, (TableCellRenderer)new SeverityTableCellRenderer());
        QuickFixListCellRenderer renderer = new QuickFixListCellRenderer();
        errorTable.setDefaultRenderer(List.class, (TableCellRenderer)renderer);
        errorTable.setDefaultRenderer(Object.class, (TableCellRenderer)new CriticismObjectRenderer());
        errorTable.setAlignmentX(0.0f);
        errorTable.getTableModelSortDecorator().setColumnComparator(SPObject.class, (Comparator)new SQLObjectComparator());
        errorTable.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int col;
                Point point = e.getPoint();
                int row = errorTable.rowAtPoint(point);
                Object clickedVal = tableModel.getValueAt(row, col = errorTable.columnAtPoint(point));
                if (clickedVal instanceof List) {
                    List list = (List)clickedVal;
                    JPopupMenu menu = new JPopupMenu();
                    for (Object o : list) {
                        final CriticFix fix = (CriticFix)o;
                        menu.add(new AbstractAction(fix.getDescription()){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                fix.apply();
                            }
                        });
                    }
                    menu.show((Component)errorTable, point.x, point.y);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        return errorTable;
    }
}

